/*
 * Decompiled with CFR 0.152.
 */
package gplx.core.btries;

import gplx.Bry_;
import gplx.Err_;
import gplx.String_;
import gplx.core.btries.Btrie_mgr;
import gplx.core.btries.Btrie_rv;
import gplx.core.btries.Btrie_u8_itm;
import gplx.core.intls.Gfo_case_mgr;
import gplx.core.intls.Utf8_;

public class Btrie_u8_mgr
implements Btrie_mgr {
    private Btrie_u8_itm root;
    private Gfo_case_mgr case_mgr;
    private int count;
    private int match_pos;

    Btrie_u8_mgr(Gfo_case_mgr case_mgr) {
        this.case_mgr = case_mgr;
        this.root = new Btrie_u8_itm(Bry_.Empty, null);
    }

    public int Count() {
        return this.count;
    }

    @Override
    public Object Match_at(Btrie_rv rv, byte[] src, int bgn_pos, int end_pos) {
        return this.Match_at_w_b0(rv, src[bgn_pos], src, bgn_pos, end_pos);
    }

    public Object Match_at_w_b0(Btrie_rv rv, byte b, byte[] src, int bgn_pos, int end_pos) {
        Object rv_obj = null;
        int rv_pos = bgn_pos;
        int cur_pos = bgn_pos;
        Btrie_u8_itm cur = this.root;
        while (true) {
            int c_len;
            int c_end;
            Btrie_u8_itm nxt;
            if ((nxt = cur.Nxts_find(src, cur_pos, c_end = cur_pos + (c_len = Utf8_.Len_of_char_by_1st_byte(b)), true)) == null) {
                rv.Init(rv_pos, rv_obj);
                return rv_obj;
            }
            cur_pos = c_end;
            if (nxt.Nxts_is_empty()) {
                rv_obj = nxt.Val();
                rv.Init(cur_pos, rv_obj);
                return rv_obj;
            }
            Object nxt_val = nxt.Val();
            if (nxt_val != null) {
                rv_pos = cur_pos;
                rv_obj = nxt_val;
            }
            if (cur_pos == end_pos) {
                rv.Init(rv_pos, rv_obj);
                return rv_obj;
            }
            b = src[cur_pos];
            cur = nxt;
        }
    }

    @Override
    public int Match_pos() {
        return this.match_pos;
    }

    @Override
    public Object Match_bgn(byte[] src, int bgn_pos, int end_pos) {
        return this.Match_bgn_w_byte(src[bgn_pos], src, bgn_pos, end_pos);
    }

    public Object Match_bgn_w_byte(byte b, byte[] src, int bgn_pos, int end_pos) {
        Object rv = null;
        int cur_pos = this.match_pos = bgn_pos;
        Btrie_u8_itm cur = this.root;
        int c_len;
        int c_end;
        Btrie_u8_itm nxt;
        while ((nxt = cur.Nxts_find(src, cur_pos, c_end = cur_pos + (c_len = Utf8_.Len_of_char_by_1st_byte(b)), true)) != null) {
            cur_pos = c_end;
            if (nxt.Nxts_is_empty()) {
                this.match_pos = cur_pos;
                return nxt.Val();
            }
            Object nxt_val = nxt.Val();
            if (nxt_val != null) {
                this.match_pos = cur_pos;
                rv = nxt_val;
            }
            if (cur_pos == end_pos) {
                return rv;
            }
            b = src[cur_pos];
            cur = nxt;
        }
        return rv;
    }

    public void Clear() {
        this.root.Clear();
        this.count = 0;
    }

    @Override
    public Btrie_mgr Add_obj(String key, Object val) {
        return this.Add_obj(Bry_.new_u8(key), val);
    }

    @Override
    public Btrie_mgr Add_obj(byte[] key, Object val) {
        if (val == null) {
            throw Err_.new_wo_type("null objects cannot be registered", "key", String_.new_u8(key));
        }
        int key_len = key.length;
        Btrie_u8_itm cur = this.root;
        int c_bgn = 0;
        while (c_bgn < key_len) {
            byte c = key[c_bgn];
            int c_len = Utf8_.Len_of_char_by_1st_byte(c);
            int c_end = c_bgn + c_len;
            Btrie_u8_itm nxt = cur.Nxts_find(key, c_bgn, c_end, false);
            if (nxt == null) {
                nxt = cur.Nxts_add(this.case_mgr, Bry_.Mid(key, c_bgn, c_end), null);
            }
            if ((c_bgn = c_end) == key_len) {
                nxt.Val_set(val);
            }
            cur = nxt;
        }
        ++this.count;
        return this;
    }

    public static Btrie_u8_mgr new_(Gfo_case_mgr case_mgr) {
        return new Btrie_u8_mgr(case_mgr);
    }
}

