/*
 * Decompiled with CFR 0.152.
 */
package gplx.core.btries;

import gplx.Bry_;
import gplx.Bry_bfr;
import gplx.Err_;
import gplx.String_;
import gplx.core.btries.Btrie_itm_stub;
import gplx.core.btries.Btrie_mgr;
import gplx.core.btries.Btrie_rv;
import gplx.core.btries.Btrie_slim_itm;
import gplx.core.primitives.Byte_obj_val;
import gplx.core.primitives.Int_obj_val;

public class Btrie_slim_mgr
implements Btrie_mgr {
    private Btrie_slim_itm root;
    private int count;
    private int match_pos;

    Btrie_slim_mgr(boolean case_match) {
        this.root = new Btrie_slim_itm(0, null, !case_match);
    }

    public int Count() {
        return this.count;
    }

    @Override
    public int Match_pos() {
        return this.match_pos;
    }

    @Override
    public Object Match_at(Btrie_rv rv, byte[] src, int bgn_pos, int end_pos) {
        return bgn_pos < end_pos ? this.Match_at_w_b0(rv, src[bgn_pos], src, bgn_pos, end_pos) : null;
    }

    public Object Match_at_w_b0(Btrie_rv rv, byte b, byte[] src, int bgn_pos, int src_end) {
        Object rv_obj = null;
        int rv_pos = bgn_pos;
        int cur_pos = bgn_pos;
        Btrie_slim_itm cur = this.root;
        while (true) {
            Btrie_slim_itm nxt;
            if ((nxt = cur.Ary_find(b)) == null) {
                rv.Init(rv_pos, rv_obj);
                return rv_obj;
            }
            ++cur_pos;
            if (nxt.Ary_is_empty()) {
                rv_obj = nxt.Val();
                rv.Init(cur_pos, rv_obj);
                return rv_obj;
            }
            Object nxt_val = nxt.Val();
            if (nxt_val != null) {
                rv_pos = cur_pos;
                rv_obj = nxt_val;
            }
            if (cur_pos == src_end) {
                rv.Init(rv_pos, rv_obj);
                return rv_obj;
            }
            b = src[cur_pos];
            cur = nxt;
        }
    }

    public Object Match_exact(byte[] src) {
        return src == null ? null : this.Match_exact(src, 0, src.length);
    }

    public Object Match_exact(byte[] src, int bgn_pos, int end_pos) {
        if (bgn_pos == end_pos) {
            return null;
        }
        Object rv = this.Match_bgn_w_byte(src[bgn_pos], src, bgn_pos, end_pos);
        return rv == null ? null : (this.match_pos - bgn_pos == end_pos - bgn_pos ? rv : null);
    }

    @Override
    public Object Match_bgn(byte[] src, int bgn_pos, int end_pos) {
        return bgn_pos < end_pos ? this.Match_bgn_w_byte(src[bgn_pos], src, bgn_pos, end_pos) : null;
    }

    public Object Match_bgn_w_byte(byte b, byte[] src, int bgn_pos, int src_end) {
        Object rv = null;
        int cur_pos = this.match_pos = bgn_pos;
        Btrie_slim_itm cur = this.root;
        Btrie_slim_itm nxt;
        while ((nxt = cur.Ary_find(b)) != null) {
            ++cur_pos;
            if (nxt.Ary_is_empty()) {
                this.match_pos = cur_pos;
                return nxt.Val();
            }
            Object nxt_val = nxt.Val();
            if (nxt_val != null) {
                this.match_pos = cur_pos;
                rv = nxt_val;
            }
            if (cur_pos == src_end) {
                return rv;
            }
            b = src[cur_pos];
            cur = nxt;
        }
        return rv;
    }

    public byte Match_byte_or(byte b, byte[] src, int bgn, int end, byte or) {
        Object rv_obj = this.Match_bgn_w_byte(b, src, bgn, end);
        return rv_obj == null ? or : ((Byte_obj_val)rv_obj).Val();
    }

    public byte Match_byte_or(byte[] src, int bgn, int end, byte or) {
        Object rv_obj = this.Match_bgn(src, bgn, end);
        return rv_obj == null ? or : ((Byte_obj_val)rv_obj).Val();
    }

    public byte Match_byte_or(Btrie_rv trv, byte b, byte[] src, int bgn, int end, byte or) {
        Object rv_obj = this.Match_at_w_b0(trv, b, src, bgn, end);
        return rv_obj == null ? or : ((Byte_obj_val)rv_obj).Val();
    }

    public byte Match_byte_or(Btrie_rv trv, byte[] src, int bgn, int end, byte or) {
        Object rv_obj = this.Match_at(trv, src, bgn, end);
        return rv_obj == null ? or : ((Byte_obj_val)rv_obj).Val();
    }

    public byte Match_byte_or(Btrie_rv trv, byte[] src, byte or) {
        Object rv_obj = this.Match_at(trv, src, 0, src.length);
        return rv_obj == null ? or : ((Byte_obj_val)rv_obj).Val();
    }

    public Btrie_slim_mgr Add_bry_tid(byte[] bry, byte tid) {
        return (Btrie_slim_mgr)this.Add_obj(bry, (Object)Byte_obj_val.new_(tid));
    }

    public Btrie_slim_mgr Add_bry_int(byte[] key, int val) {
        return (Btrie_slim_mgr)this.Add_obj(key, (Object)new Int_obj_val(val));
    }

    public Btrie_slim_mgr Add_str_byte(String key, byte val) {
        return (Btrie_slim_mgr)this.Add_obj(Bry_.new_u8(key), (Object)Byte_obj_val.new_(val));
    }

    public Btrie_slim_mgr Add_str_int(String key, int val) {
        return (Btrie_slim_mgr)this.Add_obj(Bry_.new_u8(key), (Object)new Int_obj_val(val));
    }

    public Btrie_slim_mgr Add_bry(String key, String val) {
        return (Btrie_slim_mgr)this.Add_obj(Bry_.new_u8(key), (Object)Bry_.new_u8(val));
    }

    public Btrie_slim_mgr Add_bry(String key, byte[] val) {
        return (Btrie_slim_mgr)this.Add_obj(Bry_.new_u8(key), (Object)val);
    }

    public Btrie_slim_mgr Add_bry(byte[] v) {
        return (Btrie_slim_mgr)this.Add_obj(v, (Object)v);
    }

    public Btrie_slim_mgr Add_str_str(String key, String val) {
        return (Btrie_slim_mgr)this.Add_obj(Bry_.new_u8(key), (Object)Bry_.new_u8(val));
    }

    public Btrie_slim_mgr Add_bry_bry(byte[] key, byte[] val) {
        return (Btrie_slim_mgr)this.Add_obj(key, (Object)val);
    }

    public Btrie_slim_mgr Add_bry_byte(byte b, byte val) {
        return (Btrie_slim_mgr)this.Add_obj(new byte[]{b}, (Object)Byte_obj_val.new_(val));
    }

    public Btrie_slim_mgr Add_bry_byte(byte[] bry, byte val) {
        return (Btrie_slim_mgr)this.Add_obj(bry, (Object)Byte_obj_val.new_(val));
    }

    public Btrie_slim_mgr Add_str_byte__many(byte val, String ... ary) {
        int ary_len = ary.length;
        Byte_obj_val bval = Byte_obj_val.new_(val);
        int i = 0;
        while (i < ary_len) {
            this.Add_obj(Bry_.new_u8(ary[i]), (Object)bval);
            ++i;
        }
        return this;
    }

    public Btrie_slim_mgr Add_many_str(String ... ary) {
        int len = ary.length;
        int i = 0;
        while (i < len) {
            byte[] itm = Bry_.new_u8(ary[i]);
            this.Add_obj(itm, (Object)itm);
            ++i;
        }
        return this;
    }

    public Btrie_slim_mgr Add_many_bry(byte[] ... ary) {
        int len = ary.length;
        int i = 0;
        while (i < len) {
            byte[] itm = ary[i];
            this.Add_obj(itm, (Object)itm);
            ++i;
        }
        return this;
    }

    public Btrie_slim_mgr Add_many_int(int val, String ... ary) {
        return this.Add_many_int(val, Bry_.Ary(ary));
    }

    public Btrie_slim_mgr Add_many_int(int val, byte[] ... ary) {
        int len = ary.length;
        Int_obj_val obj = new Int_obj_val(val);
        int i = 0;
        while (i < len) {
            this.Add_obj(ary[i], (Object)obj);
            ++i;
        }
        return this;
    }

    public Btrie_slim_mgr Add_ary_byte(byte ... ary) {
        int len = ary.length;
        int i = 0;
        while (i < len) {
            byte b = ary[i];
            Byte_obj_val bval = Byte_obj_val.new_(b);
            this.Add_obj(Bry_.New_by_byte(b), (Object)bval);
            ++i;
        }
        return this;
    }

    public Btrie_slim_mgr Add_replace_many(String trg_str, String ... src_ary) {
        return this.Add_replace_many(Bry_.new_u8(trg_str), src_ary);
    }

    public Btrie_slim_mgr Add_replace_many(byte[] trg_bry, String ... src_ary) {
        int len = src_ary.length;
        int i = 0;
        while (i < len) {
            this.Add_obj(Bry_.new_u8(src_ary[i]), (Object)trg_bry);
            ++i;
        }
        return this;
    }

    public Btrie_slim_mgr Add_stub(String key, byte val) {
        byte[] bry = Bry_.new_u8(key);
        return (Btrie_slim_mgr)this.Add_obj(bry, (Object)new Btrie_itm_stub(val, bry));
    }

    public Btrie_slim_mgr Add_stubs(byte[][] ary) {
        return this.Add_stubs(ary, ary.length);
    }

    public Btrie_slim_mgr Add_stubs(byte[][] ary, int ary_len) {
        byte i = 0;
        while (i < ary_len) {
            byte[] bry = ary[i];
            this.Add_obj(bry, (Object)new Btrie_itm_stub(i, bry));
            i = (byte)(i + 1);
        }
        return this;
    }

    @Override
    public Btrie_mgr Add_obj(String key, Object val) {
        return this.Add_obj(Bry_.new_u8(key), val);
    }

    @Override
    public Btrie_mgr Add_obj(byte[] key, Object val) {
        if (val == null) {
            throw Err_.new_wo_type("null objects cannot be registered", "key", String_.new_u8(key));
        }
        int key_len = key.length;
        int key_end = key_len - 1;
        Btrie_slim_itm cur = this.root;
        int i = 0;
        while (i < key_len) {
            Btrie_slim_itm nxt;
            byte b = key[i];
            if (this.root.Case_any() && b > 64 && b < 91) {
                b = (byte)(b + 32);
            }
            if ((nxt = cur.Ary_find(b)) == null) {
                nxt = cur.Ary_add(b, null);
            }
            if (i == key_end) {
                nxt.Val_set(val);
            }
            cur = nxt;
            ++i;
        }
        ++this.count;
        return this;
    }

    public void Del(byte[] key) {
        int key_len = key.length;
        Btrie_slim_itm cur = this.root;
        int i = 0;
        while (i < key_len) {
            byte b = key[i];
            Btrie_slim_itm nxt = cur.Ary_find(b);
            if (nxt == null) break;
            Object nxt_val = nxt.Val();
            if (nxt_val == null) {
                cur.Ary_del(b);
            } else {
                nxt.Val_set(null);
            }
            cur = nxt;
            ++i;
        }
        --this.count;
    }

    public byte[] Replace(Bry_bfr tmp_bfr, byte[] src, int bgn, int end) {
        int pos = bgn;
        boolean dirty = false;
        while (pos < end) {
            byte b = src[pos];
            Object o = this.Match_bgn_w_byte(b, src, pos, end);
            if (o == null) {
                if (dirty) {
                    tmp_bfr.Add_byte(b);
                }
                ++pos;
                continue;
            }
            if (!dirty) {
                tmp_bfr.Add_mid(src, bgn, pos);
                dirty = true;
            }
            tmp_bfr.Add((byte[])o);
            pos = this.match_pos;
        }
        return dirty ? tmp_bfr.To_bry_and_clear() : src;
    }

    public void Clear() {
        this.root.Clear();
        this.count = 0;
    }

    public static Btrie_slim_mgr cs() {
        return new Btrie_slim_mgr(true);
    }

    public static Btrie_slim_mgr ci_a7() {
        return new Btrie_slim_mgr(false);
    }

    public static Btrie_slim_mgr ci_u8() {
        return new Btrie_slim_mgr(false);
    }

    public static Btrie_slim_mgr new_(boolean v) {
        return new Btrie_slim_mgr(v);
    }
}

