/*
 * Decompiled with CFR 0.152.
 */
package gplx.core.btries;

import gplx.Array_;
import gplx.core.btries.ByteHashItm_sorter;

public class Btrie_slim_itm {
    private Btrie_slim_itm[] ary = Ary_empty;
    private byte key_byte;
    private Object val;
    private boolean case_any;
    public static final Btrie_slim_itm[] Ary_empty = new Btrie_slim_itm[0];
    int ary_len = 0;
    int ary_max = 0;

    public Btrie_slim_itm(byte key_byte, Object val, boolean case_any) {
        this.key_byte = key_byte;
        this.val = val;
        this.case_any = case_any;
    }

    public byte Key_byte() {
        return this.key_byte;
    }

    public Object Val() {
        return this.val;
    }

    public void Val_set(Object val) {
        this.val = val;
    }

    public boolean Case_any() {
        return this.case_any;
    }

    public boolean Ary_is_empty() {
        return this.ary == Ary_empty;
    }

    public void Clear() {
        this.val = null;
        int i = 0;
        while (i < this.ary_len) {
            this.ary[i].Clear();
            ++i;
        }
        this.ary = Ary_empty;
        this.ary_max = 0;
        this.ary_len = 0;
    }

    public Btrie_slim_itm Ary_find(byte b) {
        int find_val = (this.case_any && b > 64 && b < 91 ? b + 32 : b) & 0xFF;
        int key_val = 0;
        switch (this.ary_len) {
            case 0: {
                return null;
            }
            case 1: {
                Btrie_slim_itm rv = this.ary[0];
                key_val = rv.Key_byte() & 0xFF;
                key_val = this.case_any && key_val > 64 && key_val < 91 ? key_val + 32 : key_val;
                return key_val == find_val ? rv : null;
            }
        }
        int adj = 1;
        int prv_pos = 0;
        int prv_len = this.ary_len;
        int cur_len = 0;
        int cur_idx = 0;
        Btrie_slim_itm itm = null;
        while (true) {
            cur_len = prv_len / 2;
            if (prv_len % 2 == 1) {
                ++cur_len;
            }
            if ((cur_idx = prv_pos + cur_len * adj) < 0) {
                cur_idx = 0;
            } else if (cur_idx >= this.ary_len) {
                cur_idx = this.ary_len - 1;
            }
            itm = this.ary[cur_idx];
            key_val = itm.Key_byte() & 0xFF;
            int n = key_val = this.case_any && key_val > 64 && key_val < 91 ? key_val + 32 : key_val;
            if (find_val < key_val) {
                adj = -1;
            } else if (find_val > key_val) {
                adj = 1;
            } else {
                return itm;
            }
            if (cur_len == 1) {
                if ((cur_idx += adj) < 0 || cur_idx >= this.ary_len) {
                    return null;
                }
                itm = this.ary[cur_idx];
                return (itm.Key_byte() & 0xFF) == find_val ? itm : null;
            }
            prv_len = cur_len;
            prv_pos = cur_idx;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Btrie_slim_itm Ary_add(byte b, Object val) {
        Btrie_slim_itm rv;
        int new_len = this.ary_len + 1;
        if (new_len > this.ary_max) {
            this.ary_max += 4;
            this.ary = (Btrie_slim_itm[])Array_.Resize(this.ary, this.ary_max);
        }
        this.ary[this.ary_len] = rv = new Btrie_slim_itm(b, val, this.case_any);
        this.ary_len = new_len;
        ByteHashItm_sorter byteHashItm_sorter = ByteHashItm_sorter.Instance;
        synchronized (byteHashItm_sorter) {
            ByteHashItm_sorter.Instance.Sort(this.ary, this.ary_len);
        }
        return rv;
    }

    public void Ary_del(byte b) {
        boolean found = false;
        int i = 0;
        while (i < this.ary_len) {
            if (found) {
                if (i < this.ary_len - 1) {
                    this.ary[i] = this.ary[i + 1];
                }
            } else if (b == this.ary[i].Key_byte()) {
                found = true;
            }
            ++i;
        }
        if (found) {
            --this.ary_len;
        }
    }
}

