/*
 * Decompiled with CFR 0.152.
 */
package gplx.core.btries;

import gplx.Bry_;
import gplx.Err_;
import gplx.String_;
import gplx.core.btries.Btrie_rv;
import gplx.core.btries.Btrie_slim_itm;
import gplx.core.primitives.Byte_obj_val;

public class Btrie_bwd_mgr {
    private int match_pos;
    private int count;
    private Btrie_slim_itm root;

    public int Match_pos() {
        return this.match_pos;
    }

    public Object Match_exact(byte[] src, int bgn_pos, int end_pos) {
        Object rv = this.Match(src[bgn_pos], src, bgn_pos, end_pos);
        return rv == null ? null : (this.match_pos - bgn_pos == end_pos - bgn_pos ? rv : null);
    }

    public Object Match_at(Btrie_rv rv, byte[] src, int bgn_pos, int end_pos) {
        return this.Match_at_w_b0(rv, src[bgn_pos], src, bgn_pos, end_pos);
    }

    public Object Match_at_w_b0(Btrie_rv rv, byte b, byte[] src, int bgn_pos, int end_pos) {
        Object rv_obj = null;
        int rv_pos = bgn_pos;
        int cur_pos = bgn_pos;
        Btrie_slim_itm cur = this.root;
        while (true) {
            Btrie_slim_itm nxt;
            if ((nxt = cur.Ary_find(b)) == null) {
                rv.Init(rv_pos, rv_obj);
                return rv_obj;
            }
            --cur_pos;
            if (nxt.Ary_is_empty()) {
                rv_obj = nxt.Val();
                rv.Init(cur_pos, rv_obj);
                return rv_obj;
            }
            Object nxt_val = nxt.Val();
            if (nxt_val != null) {
                rv_pos = cur_pos;
                rv_obj = nxt_val;
            }
            if (cur_pos == end_pos) {
                rv.Init(rv_pos, rv_obj);
                return rv_obj;
            }
            b = src[cur_pos];
            cur = nxt;
        }
    }

    public Object Match_bgn(byte[] src, int bgn_pos, int end_pos) {
        return this.Match(src[bgn_pos], src, bgn_pos, end_pos);
    }

    public Object Match(byte b, byte[] src, int bgn_pos, int end_pos) {
        Object rv = null;
        int cur_pos = this.match_pos = bgn_pos;
        Btrie_slim_itm cur = this.root;
        Btrie_slim_itm nxt;
        while ((nxt = cur.Ary_find(b)) != null) {
            --cur_pos;
            if (nxt.Ary_is_empty()) {
                this.match_pos = cur_pos;
                return nxt.Val();
            }
            Object nxt_val = nxt.Val();
            if (nxt_val != null) {
                this.match_pos = cur_pos;
                rv = nxt_val;
            }
            if (cur_pos == end_pos) {
                return rv;
            }
            b = src[cur_pos];
            cur = nxt;
        }
        return rv;
    }

    public Btrie_bwd_mgr Add_str_byte(String key, byte val) {
        return this.Add(Bry_.new_u8(key), (Object)Byte_obj_val.new_(val));
    }

    public Btrie_bwd_mgr Add_byteVal_strAry(byte val, String ... ary) {
        int ary_len = ary.length;
        Byte_obj_val byteVal = Byte_obj_val.new_(val);
        int i = 0;
        while (i < ary_len) {
            String itm = ary[i];
            this.Add(Bry_.new_u8(itm), (Object)byteVal);
            ++i;
        }
        return this;
    }

    public Btrie_bwd_mgr Add(String key, Object val) {
        return this.Add(Bry_.new_u8(key), val);
    }

    public Btrie_bwd_mgr Add(byte[] key, Object val) {
        if (val == null) {
            throw Err_.new_wo_type("null objects cannot be registered", "key", String_.new_u8(key));
        }
        int key_len = key.length;
        Btrie_slim_itm cur = this.root;
        int i = key_len - 1;
        while (i > -1) {
            Btrie_slim_itm nxt;
            byte b = key[i];
            if (this.root.Case_any() && b > 64 && b < 91) {
                b = (byte)(b + 32);
            }
            if ((nxt = cur.Ary_find(b)) == null) {
                nxt = cur.Ary_add(b, null);
            }
            if (i == 0) {
                nxt.Val_set(val);
            }
            cur = nxt;
            --i;
        }
        ++this.count;
        return this;
    }

    public int Count() {
        return this.count;
    }

    public void Del(byte[] key) {
        int key_len = key.length;
        Btrie_slim_itm cur = this.root;
        int i = 0;
        while (i < key_len) {
            byte b = key[i];
            if ((cur = cur.Ary_find(b)) == null) break;
            cur.Ary_del(b);
            ++i;
        }
        --this.count;
    }

    public void Clear() {
        this.root.Clear();
        this.count = 0;
    }

    public static Btrie_bwd_mgr cs_() {
        return new Btrie_bwd_mgr(false);
    }

    public static Btrie_bwd_mgr ci_() {
        return new Btrie_bwd_mgr(true);
    }

    public Btrie_bwd_mgr(boolean caseAny) {
        this.root = new Btrie_slim_itm(0, null, caseAny);
    }
}

