/*
 * Decompiled with CFR 0.152.
 */
package gplx.core.brys;

import gplx.Array_;
import gplx.Bry_bfr;
import gplx.Bry_bfr_;
import gplx.Err_;
import gplx.Int_;
import gplx.Internal;

public class Bry_bfr_mkr_mgr {
    private final Object thread_lock = new Object();
    private final byte mgr_id;
    private final int reset;
    private Bry_bfr[] used = Bry_bfr_.Ary_empty;
    private int used_len = 0;
    private int used_max = 0;
    private int[] free;
    private int free_len;

    public Bry_bfr_mkr_mgr(byte mgr_id, int reset) {
        this.mgr_id = mgr_id;
        this.reset = reset;
        this.free = Int_.Ary_empty;
        this.free_len = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Bry_bfr Get() {
        Object object = this.thread_lock;
        synchronized (object) {
            Bry_bfr rv = null;
            int rv_idx = -1;
            if (this.free_len > 0) {
                try {
                    rv_idx = this.free[--this.free_len];
                }
                catch (Exception e) {
                    throw Err_.new_exc(e, "core", "failed to get free", "idx", this.free_len, "free_len", this.free.length);
                }
                try {
                    rv = this.used[rv_idx];
                }
                catch (Exception e) {
                    throw Err_.new_exc(e, "core", "failed to get used", "idx", rv_idx, "used_len", this.used.length);
                }
            }
            if (this.used_len == this.used_max) {
                this.Expand();
            }
            if ((rv = this.used[rv_idx = this.used_len++]) == null) {
                this.used[rv_idx] = rv = Bry_bfr_.Reset(this.reset);
            }
            rv.Mkr_init(this, rv_idx);
            return rv.Clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void Rls(int idx) {
        Object object = this.thread_lock;
        synchronized (object) {
            if (idx == -1) {
                throw Err_.new_wo_type("rls called on bfr that was not created by factory", new Object[0]);
            }
            int new_used_len = this.used_len - 1;
            if (idx == new_used_len) {
                this.used_len = new_used_len;
            } else {
                this.free[this.free_len++] = idx;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void Clear_fail_check() {
        Object object = this.thread_lock;
        synchronized (object) {
            int i = 0;
            while (i < this.used_max) {
                Bry_bfr itm = this.used[i];
                if (itm != null) {
                    if (!itm.Mkr_idx_is_null()) {
                        throw Err_.new_wo_type("failed to clear bfr", "mgr_id", this.mgr_id, "idx", Int_.To_str(i));
                    }
                    itm.Clear();
                }
                this.used[i] = null;
                ++i;
            }
            this.used = Bry_bfr_.Ary_empty;
            this.free = Int_.Ary_empty;
            this.used_max = 0;
            this.used_len = 0;
            this.free_len = 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void Clear() {
        Object object = this.thread_lock;
        synchronized (object) {
            int i = 0;
            while (i < this.used_max) {
                Bry_bfr itm = this.used[i];
                if (itm != null) {
                    itm.Clear();
                }
                this.used[i] = null;
                ++i;
            }
            this.used = Bry_bfr_.Ary_empty;
            this.free = Int_.Ary_empty;
            this.free_len = 0;
            this.used_max = 0;
            this.used_len = 0;
        }
    }

    @Internal
    protected Bry_bfr[] Used() {
        return this.used;
    }

    @Internal
    protected int Used_len() {
        return this.used_len;
    }

    private void Expand() {
        int new_max = this.used_max == 0 ? 2 : this.used_max * 2;
        Bry_bfr[] new_ary = new Bry_bfr[new_max];
        Array_.Copy_to(this.used, 0, new_ary, 0, this.used_max);
        this.used = new_ary;
        this.used_max = new_max;
        int[] new_free = new int[this.used_max];
        Array_.Copy_to(this.free, 0, new_free, 0, this.free_len);
        this.free = new_free;
    }
}

