/*
 * Decompiled with CFR 0.152.
 */
package gplx;

import gplx.Array_;
import gplx.Bry_;
import gplx.Byte_ascii;
import gplx.Decimal_adp;
import gplx.Err_;
import gplx.Int_;
import gplx.Internal;
import gplx.Math_;
import gplx.String_;
import gplx.Time_span;
import gplx.core.envs.System_;
import gplx.core.strings.String_bldr;
import gplx.core.strings.String_bldr_;

public class Time_span_ {
    public static final Time_span Zero = new Time_span(0L);
    public static final Time_span Null = new Time_span(-1L);
    public static final long parse_null = Long.MIN_VALUE;
    public static final String Fmt_PadZeros = "00:00:00.000";
    public static final String Fmt_Short = "short";
    public static final String Fmt_Default = "0.000";
    public static final String Fmt_NoFractionals = "0";
    @Internal
    protected static final int[] Divisors = new int[]{1, 1000, 60000, 3600000};
    public static final String MajorDelimiter = ":";
    public static final int Idx_Frac = 0;
    public static final int Idx_Sec = 1;
    public static final int Idx_Min = 2;
    public static final int Idx_Hour = 3;
    static int[] ZeroPadding = new int[]{3, 2, 2, 2};
    static String[] Sprs = new String[]{".", ":", ":", ""};
    public static final double Ratio_f_to_s = 1000.0;

    public static Time_span fracs_(long val) {
        return new Time_span(val);
    }

    public static Time_span seconds_(double seconds) {
        long fracs = (long)(seconds * (double)Divisors[1]);
        return new Time_span(fracs);
    }

    public static Time_span decimal_(Decimal_adp seconds) {
        return new Time_span(seconds.To_long_mult_1000());
    }

    public static Time_span units_(int frc, int sec, int min, int hour) {
        int[] units = new int[]{frc, sec, min, hour};
        long fracs = Time_span_.Merge_long(units, Divisors);
        return Time_span_.fracs_(fracs);
    }

    public static Time_span from_(long bgn) {
        return Time_span_.fracs_(System_.Ticks() - bgn);
    }

    public static Time_span parse(String raw) {
        byte[] bry = Bry_.new_u8(raw);
        long fracs = Time_span_.parse_to_fracs(bry, 0, bry.length, false);
        return fracs == Long.MIN_VALUE ? null : Time_span_.fracs_(fracs);
    }

    public static long parse_to_fracs(byte[] raw, int bgn, int end, boolean fail_if_ws) {
        int sign = 1;
        int val_f = 0;
        int val_s = 0;
        int val_m = 0;
        int val_h = 0;
        int colon_pos = 0;
        int unit_val = 0;
        int unit_multiple = 1;
        int i = end - 1;
        while (i >= bgn) {
            byte b = raw[i];
            switch (b) {
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: {
                    int unit_digit = Byte_ascii.To_a7_int(b);
                    unit_val = unit_multiple == 1 ? unit_digit : unit_val + unit_digit * unit_multiple;
                    switch (colon_pos) {
                        case 0: {
                            val_s = unit_val;
                            break;
                        }
                        case 1: {
                            val_m = unit_val;
                            break;
                        }
                        case 2: {
                            val_h = unit_val;
                            break;
                        }
                        default: {
                            return Long.MIN_VALUE;
                        }
                    }
                    unit_multiple *= 10;
                    break;
                }
                case 46: {
                    double factor = 1000.0 / (double)unit_multiple;
                    val_f = (int)((double)val_s * factor);
                    val_s = 0;
                    unit_multiple = 1;
                    break;
                }
                case 58: {
                    ++colon_pos;
                    unit_multiple = 1;
                    break;
                }
                case 45: {
                    if (i != 0 || unit_val <= 0) break;
                    sign = -1;
                    break;
                }
                case 9: 
                case 10: 
                case 13: 
                case 32: {
                    if (!fail_if_ws) break;
                    return Long.MIN_VALUE;
                }
                default: {
                    return Long.MIN_VALUE;
                }
            }
            --i;
        }
        return sign * (val_f + val_s * Divisors[1] + val_m * Divisors[2] + val_h * Divisors[3]);
    }

    public static String To_str(long frc, String fmt) {
        String_bldr sb = String_bldr_.new_();
        int[] units = Time_span_.Split_long(frc, Divisors);
        if (String_.Eq(fmt, Fmt_Short)) {
            int i = 3;
            while (i > -1) {
                int val = units[i];
                if ((val != 0 || i != 3) && i != 0) {
                    if (sb.Count() > 0) {
                        sb.Add(Sprs[i]);
                    }
                    if (val < 10) {
                        sb.Add(Fmt_NoFractionals);
                    }
                    sb.Add(Int_.To_str(val));
                }
                --i;
            }
            return sb.To_str_and_clear();
        }
        boolean fmt_fracs = !String_.Eq(fmt, Fmt_NoFractionals);
        boolean fmt_padZeros = String_.Eq(fmt, Fmt_PadZeros);
        if (frc == 0L) {
            return fmt_padZeros ? Fmt_PadZeros : Fmt_NoFractionals;
        }
        int[] padZerosAry = ZeroPadding;
        boolean first = true;
        String dlm = "";
        int zeros = 0;
        if (frc < 0L) {
            sb.Add("-");
        }
        int i = 3;
        while (i > -1) {
            int val = units[i];
            if ((i != 0 || val == 0 && fmt_padZeros || val != 0 && fmt_fracs) && (!first || val != 0 || fmt_padZeros)) {
                zeros = first && !fmt_padZeros ? 1 : padZerosAry[i];
                dlm = first ? "" : Sprs[i];
                sb.Add(dlm);
                sb.Add(Int_.To_str_pad_bgn_zero(val, zeros));
                first = false;
            }
            --i;
        }
        return sb.To_str();
    }

    @Internal
    protected static int[] Split_long(long fracs, int[] divisors) {
        int divLength = Array_.Len(divisors);
        int[] rv = new int[divLength];
        long cur = Math_.Abs(fracs);
        int i = divLength - 1;
        while (i > -1) {
            int divisor = divisors[i];
            long factor = cur / (long)divisor;
            rv[i] = (int)factor;
            cur -= factor * (long)divisor;
            --i;
        }
        return rv;
    }

    @Internal
    protected static long Merge_long(int[] vals, int[] divisors) {
        long rv = 0L;
        int valLength = Array_.Len(vals);
        int i = 0;
        while (i < valLength) {
            rv += (long)(vals[i] * divisors[i]);
            ++i;
        }
        return rv;
    }

    public static Time_span cast(Object arg) {
        try {
            return (Time_span)arg;
        }
        catch (Exception exc) {
            throw Err_.new_type_mismatch_w_exc(exc, Time_span.class, arg);
        }
    }
}

