/*
 * Decompiled with CFR 0.152.
 */
package gplx;

import gplx.Err;
import gplx.Object_;
import gplx.String_;
import gplx.Tfds;
import org.junit.Test;

public class String__tst {
    @Test
    public void Len() {
        this.tst_Len("", 0);
        this.tst_Len("abc", 3);
    }

    void tst_Len(String v, int expd) {
        Tfds.Eq(expd, String_.Len(v), "Len", new Object[0]);
    }

    @Test
    public void LimitToFirst() {
        this.tst_LimitToFirst("abc", 0, "");
        this.tst_LimitToFirst("abc", 1, "a");
        this.tst_LimitToFirst("abc", 2, "ab");
        this.tst_LimitToFirst("abc", 3, "abc");
        this.tst_LimitToFirst("abc", 4, "abc");
        this.err_LimitToFirst("abc", -1);
    }

    void tst_LimitToFirst(String s, int v, String expd) {
        Tfds.Eq(expd, String_.LimitToFirst(s, v));
    }

    void err_LimitToFirst(String s, int v) {
        try {
            String_.LimitToFirst(s, v);
        }
        catch (Exception exc) {
            Tfds.Err_classMatch(exc, Err.class);
            return;
        }
        Tfds.Fail_expdError();
    }

    @Test
    public void LimitToLast() {
        this.tst_LimitToLast("abc", 0, "");
        this.tst_LimitToLast("abc", 1, "c");
        this.tst_LimitToLast("abc", 2, "bc");
        this.tst_LimitToLast("abc", 3, "abc");
        this.tst_LimitToLast("abc", 4, "abc");
        this.err_LimitToLast("abc", -1);
    }

    void tst_LimitToLast(String s, int v, String expd) {
        Tfds.Eq(expd, String_.LimitToLast(s, v));
    }

    void err_LimitToLast(String s, int v) {
        try {
            String_.LimitToLast(s, v);
        }
        catch (Exception exc) {
            Tfds.Err_classMatch(exc, Err.class);
            return;
        }
        Tfds.Fail_expdError();
    }

    @Test
    public void DelBgn() {
        this.tst_DelBgn("abc", 0, "abc");
        this.tst_DelBgn("abc", 1, "bc");
        this.tst_DelBgn("abc", 2, "c");
        this.tst_DelBgn("abc", 3, "");
        this.err_DelBgn(null, 0);
        this.err_DelBgn("abc", 4);
    }

    void tst_DelBgn(String s, int v, String expd) {
        Tfds.Eq(expd, String_.DelBgn(s, v));
    }

    void err_DelBgn(String s, int v) {
        try {
            String_.DelBgn(s, v);
        }
        catch (Exception exc) {
            Tfds.Err_classMatch(exc, Err.class);
            return;
        }
        Tfds.Fail_expdError();
    }

    @Test
    public void DelBgnIf() {
        this.tst_DelBgnIf("abc", "", "abc");
        this.tst_DelBgnIf("abc", "a", "bc");
        this.tst_DelBgnIf("abc", "ab", "c");
        this.tst_DelBgnIf("abc", "abc", "");
        this.tst_DelBgnIf("abc", "abcd", "abc");
        this.tst_DelBgnIf("abc", "bcd", "abc");
        this.err_DelBgnIf(null, "abc");
        this.err_DelBgnIf("abc", null);
    }

    void tst_DelBgnIf(String s, String v, String expd) {
        Tfds.Eq(expd, String_.DelBgnIf(s, v));
    }

    void err_DelBgnIf(String s, String v) {
        try {
            String_.DelBgnIf(s, v);
        }
        catch (Exception exc) {
            Tfds.Err_classMatch(exc, Err.class);
            return;
        }
        Tfds.Fail_expdError();
    }

    @Test
    public void DelEnd() {
        this.tst_DelEnd("abc", 0, "abc");
        this.tst_DelEnd("abc", 1, "ab");
        this.tst_DelEnd("abc", 2, "a");
        this.tst_DelEnd("abc", 3, "");
        this.err_DelEnd(null, 0);
        this.err_DelEnd("abc", 4);
    }

    void tst_DelEnd(String s, int v, String expd) {
        Tfds.Eq(expd, String_.DelEnd(s, v));
    }

    void err_DelEnd(String s, int v) {
        try {
            String_.DelEnd(s, v);
        }
        catch (Exception exc) {
            Tfds.Err_classMatch(exc, Err.class);
            return;
        }
        Tfds.Fail_expdError();
    }

    @Test
    public void DelEndIf() {
        this.tst_DelEndIf("abc", "", "abc");
        this.tst_DelEndIf("abc", "c", "ab");
        this.tst_DelEndIf("abc", "bc", "a");
        this.tst_DelEndIf("abc", "abc", "");
        this.tst_DelEndIf("abc", "abcd", "abc");
        this.tst_DelEndIf("abc", "ab", "abc");
        this.err_DelEndIf(null, "");
        this.err_DelEndIf("", null);
    }

    void tst_DelEndIf(String s, String v, String expd) {
        Tfds.Eq(expd, String_.DelEndIf(s, v));
    }

    void err_DelEndIf(String s, String v) {
        try {
            String_.DelEndIf(s, v);
        }
        catch (Exception exc) {
            Tfds.Err_classMatch(exc, Err.class);
            return;
        }
        Tfds.Fail_expdError();
    }

    @Test
    public void MidByPos() {
        this.tst_MidByPos("abc", 0, 0, "");
        this.tst_MidByPos("abc", 0, 1, "a");
        this.tst_MidByPos("abc", 0, 2, "ab");
        this.tst_MidByPos("abc", 0, 3, "abc");
        this.tst_MidByPos("abc", 2, 3, "c");
        this.err_MidByPos("abc", 1, 5);
    }

    void tst_MidByPos(String s, int bgn, int end, String expd) {
        Tfds.Eq(expd, String_.Mid(s, bgn, end));
    }

    void err_MidByPos(String s, int bgn, int end) {
        try {
            String_.Mid(s, bgn, end);
        }
        catch (Exception e) {
            Tfds.Err_classMatch(e, Err.class);
            return;
        }
        Tfds.Fail_expdError();
    }

    @Test
    public void TrimEnd() {
        this.tst_TrimEnd("a", "a");
        this.tst_TrimEnd("a ", "a");
        this.tst_TrimEnd("a\t", "a");
        this.tst_TrimEnd("a\n", "a");
        this.tst_TrimEnd("a\r", "a");
        this.tst_TrimEnd("a\r\n \t", "a");
        this.tst_TrimEnd(" a", " a");
        this.tst_TrimEnd(null, null);
    }

    void tst_TrimEnd(String s, String expd) {
        Tfds.Eq(expd, String_.TrimEnd(s));
    }

    @Test
    public void Count() {
        String text = "0 0 0";
        Tfds.Eq(3, String_.Count(text, "0"));
    }

    @Test
    public void Has() {
        String text = "find word";
        Tfds.Eq_true(String_.Has(text, "word"));
        Tfds.Eq_false(String_.Has(text, "nothing"));
    }

    @Test
    public void Repeat() {
        Tfds.Eq("333", String_.Repeat("3", 3));
    }

    @Test
    public void Format() {
        this.tst_Format("", "", new Object[0]);
        this.tst_Format("no args", "no args", new Object[0]);
        this.tst_Format("0", "{0}", 0);
        this.tst_Format("0 and 1", "{0} and {1}", 0, 1);
        this.tst_Format("{", "{{", 0);
        this.tst_Format("}", "}}", 0);
        this.tst_Format("{a0c}", "{a{0}c}", 0);
        this.tst_Format("{a{b}c}", "{a{b}c}", 0);
        this.tst_Format("{1}", "{1}", 1);
        this.tst_Format("{a} {b}", "{a} {b}", 0);
        this.tst_Format("{a}0{b}1", "{a}{0}{b}{1}", 0, 1);
        this.tst_Format("{0", "{0", 0);
    }

    void tst_Format(String expd, String fmt, Object ... ary) {
        Tfds.Eq(expd, String_.Format(fmt, ary));
    }

    @Test
    public void Split() {
        this.tst_Split("ab", " ", "ab");
        this.tst_Split("ab cd", " ", "ab", "cd");
        this.tst_Split("ab+!cd", "+!", "ab", "cd");
        this.tst_Split("ab+!cd+!ef", "+!", "ab", "cd", "ef");
        this.tst_Split("ab+!cd+!", "+!", "ab", "cd", "");
        this.tst_Split("+!ab", "+!", "", "ab");
        this.tst_Split("ab+cd+!ef", "+!", "ab+cd", "ef");
        this.tst_Split("ab+!cd+", "+!", "ab", "cd+");
        this.tst_Split("ab", "", "ab");
        this.tst_Split("", " ", "");
        this.tst_Split("this\r\nis\na\rtest\r\n.", "\r\n", "this", "is\na\rtest", ".");
    }

    void tst_Split(String text, String separator, String ... expd) {
        Tfds.Eq_ary(expd, String_.Split(text, separator));
    }

    @Test
    public void Concat_with_obj() {
        this.tst_ConcatWith_any("a|b", "|", "a", "b");
        this.tst_ConcatWith_any("a||c", "|", "a", null, "c");
        this.tst_ConcatWith_any("a|b", "|", Object_.Ary("a", "b"));
    }

    void tst_ConcatWith_any(String expd, String delimiter, Object ... array) {
        Tfds.Eq(expd, String_.Concat_with_obj(delimiter, array));
    }

    @Test
    public void Compare_byteAry() {
        this.tst_Compare_byteAry("a", "a", 0);
        this.tst_Compare_byteAry("a", "b", -1);
        this.tst_Compare_byteAry("b", "a", 1);
        this.tst_Compare_byteAry("ab", "ac", -1);
        this.tst_Compare_byteAry("ac", "ab", 1);
        this.tst_Compare_byteAry("a", "ab", -1);
        this.tst_Compare_byteAry("ab", "a", 1);
        this.tst_Compare_byteAry("101", "1-0-1", 1);
        this.tst_Compare_byteAry("1-0-1", "101 (album)", -1);
    }

    void tst_Compare_byteAry(String lhs, String rhs, int expd) {
        Tfds.Eq(expd, String_.Compare_byteAry(lhs, rhs));
    }

    @Test
    public void FindBwd() {
        this.tst_FindRev("abc", "a", 0, 0);
        this.tst_FindRev("abc", "ab", 0, 0);
        this.tst_FindRev("abc", "abc", 0, 0);
        this.tst_FindRev("ab", "abc", 0, -1);
        this.tst_FindRev("ababab", "ab", 2, 2);
    }

    void tst_FindRev(String s, String find, int pos, int expd) {
        Tfds.Eq(expd, String_.FindBwd(s, find, pos));
    }

    @Test
    public void Extract_after_bwd() {
        this.Extract_after_bwd_tst("a/b", "/", "b");
        this.Extract_after_bwd_tst("a/", "/", "");
        this.Extract_after_bwd_tst("a", "/", "");
    }

    void Extract_after_bwd_tst(String src, String dlm, String expd) {
        Tfds.Eq(expd, String_.Extract_after_bwd(src, dlm));
    }
}

