/*
 * Decompiled with CFR 0.152.
 */
package gplx;

import gplx.Array_;
import gplx.Bry_;
import gplx.Bry_bfr;
import gplx.Bry_bfr_;
import gplx.Err_;
import gplx.Hash_adp;
import gplx.Hash_adp_;
import gplx.Int_;
import gplx.Internal;
import gplx.List_adp;
import gplx.List_adp_;
import gplx.Object_;
import gplx.core.envs.Op_sys;
import gplx.core.strings.String_bldr;
import gplx.core.strings.String_bldr_;

public class String_ {
    public static final Class<?> Cls_ref_type = String.class;
    public static final String Cls_val_name = "string";
    public static final int Find_none = -1;
    public static final int Pos_neg1 = -1;
    public static final String Null = null;
    public static final String Empty = "";
    public static final String Null_mark = "<<NULL>>";
    public static final String Tab = "\t";
    public static final String Lf = "\n";
    public static final String CrLf = "\r\n";
    public static final String[] Ary_empty = new String[0];

    public static int Len(String s) {
        return s.length();
    }

    public static char CharAt(String s, int i) {
        return s.charAt(i);
    }

    public static String new_u8(byte[] v, int bgn, int end) {
        try {
            return v == null ? null : new String(v, bgn, end - bgn, "UTF-8");
        }
        catch (Exception e) {
            Err_.Noop(e);
            throw Err_.new_("core", "unsupported encoding", "bgn", bgn, "end", end);
        }
    }

    public static String cast(Object v) {
        return (String)v;
    }

    public static String as_(Object obj) {
        return obj instanceof String ? (String)obj : null;
    }

    public static String new_a7(byte[] v) {
        return v == null ? null : String_.new_a7(v, 0, v.length);
    }

    public static String new_a7(byte[] v, int bgn, int end) {
        try {
            return v == null ? null : new String(v, bgn, end - bgn, "ASCII");
        }
        catch (Exception e) {
            throw Err_.new_exc(e, "core", "unsupported encoding", new Object[0]);
        }
    }

    public static String new_u8(byte[] v) {
        return v == null ? null : String_.new_u8(v, 0, v.length);
    }

    public static String new_u8__by_len(byte[] v, int bgn, int len) {
        int v_len = v.length;
        if (bgn + len > v_len) {
            len = v_len - bgn;
        }
        return String_.new_u8(v, bgn, bgn + len);
    }

    public static String[] Ary_add(String[] ... arys) {
        if (arys == null) {
            return Ary_empty;
        }
        int arys_len = arys.length;
        int rv_len = 0;
        int i = 0;
        while (i < arys_len) {
            String[] ary = arys[i];
            rv_len += ary.length;
            ++i;
        }
        int rv_idx = 0;
        String[] rv = new String[rv_len];
        int i2 = 0;
        while (i2 < arys_len) {
            String[] ary = arys[i2];
            int ary_len = ary.length;
            int j = 0;
            while (j < ary_len) {
                rv[rv_idx++] = ary[j];
                ++j;
            }
            ++i2;
        }
        return rv;
    }

    public static boolean Len_gt_0(String s) {
        return s != null && s.length() > 0;
    }

    public static boolean Len_eq_0(String s) {
        return s == null || s.length() == 0;
    }

    public static String Lower(String s) {
        return s.toLowerCase();
    }

    public static String Upper(String s) {
        return s.toUpperCase();
    }

    public static String CaseNormalize(boolean caseSensitive, String s) {
        return caseSensitive ? s : String_.Lower(s);
    }

    public static String Trim(String s) {
        return s.trim();
    }

    public static String Mid(String s, int bgn) {
        return s.substring(bgn);
    }

    public static String Replace(String s, String find, String replace) {
        return s.replace(find, replace);
    }

    public static char[] XtoCharAry(String s) {
        return s.toCharArray();
    }

    public static int CodePointAt(String s, int i) {
        return s.codePointAt(i);
    }

    public static boolean Has(String s, String find) {
        return s.indexOf(find) != -1;
    }

    public static boolean Has_at_bgn(String s, String v) {
        return s.startsWith(v);
    }

    public static boolean Has_at_end(String s, String v) {
        return s.endsWith(v);
    }

    public static int FindFwd(String s, String find) {
        return s.indexOf(find);
    }

    public static int FindFwd(String s, String find, int pos) {
        return s.indexOf(find, pos);
    }

    public static int FindBwd(String s, String find) {
        return s.lastIndexOf(find);
    }

    public static int FindBwd(String s, String find, int pos) {
        return s.lastIndexOf(find, pos);
    }

    public static int FindBetween(String s, String find, int bgn, int end) {
        int rv = String_.FindFwd(s, find, bgn);
        return rv > end ? -1 : rv;
    }

    public static int FindAfter(String s, String find, int bgn) {
        int rv = String_.FindFwd(s, find, bgn);
        return rv == -1 ? -1 : rv + String_.Len(find);
    }

    public static int FindAfterRev(String s, String find, int pos) {
        int rv = String_.FindBwd(s, find, pos);
        return rv == -1 ? -1 : rv + String_.Len(find);
    }

    public static int Count(String s, String part) {
        int count = 0;
        int pos = -1;
        while ((pos = String_.FindFwd(s, part, pos + 1)) != -1) {
            ++count;
        }
        return count;
    }

    public static boolean Eq(String lhs, String rhs) {
        return lhs == null ? rhs == null : lhs.equals(rhs);
    }

    public static boolean EqAny(String lhs, String ... rhsAry) {
        int i = 0;
        while (i < rhsAry.length) {
            if (String_.Eq(lhs, rhsAry[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean EqNot(String lhs, String rhs) {
        return !Object_.Eq(lhs, rhs);
    }

    public static boolean EqEmpty(String lhs) {
        return lhs.equals(Empty);
    }

    public static String IfNullOrEmpty(String s, String or) {
        return s == null || s.length() == 0 ? or : s;
    }

    public static int Compare_as_ordinals(String lhs, String rhs) {
        return lhs.compareTo(rhs);
    }

    public static int Compare_ignoreCase(String lhs, String rhs) {
        if (lhs == null && rhs != null) {
            return -1;
        }
        if (lhs != null && rhs == null) {
            return 1;
        }
        if (lhs == null && rhs == null) {
            return 0;
        }
        return lhs.compareToIgnoreCase(rhs);
    }

    public static int Compare(String lhs, String rhs) {
        int compare = lhs.compareTo(rhs);
        if (compare == 0) {
            return 0;
        }
        if (compare < 0) {
            return -1;
        }
        return 1;
    }

    public static int Compare_byteAry(String lhs, String rhs) {
        int rhsLen;
        int lhsLen = lhs.length();
        int aryLen = lhsLen < (rhsLen = rhs.length()) ? lhsLen : rhsLen;
        int[] lhsAry = String_.XtoIntAry(lhs, aryLen);
        int[] rhsAry = String_.XtoIntAry(rhs, aryLen);
        int i = 0;
        while (i < aryLen) {
            int comp = Int_.Compare(lhsAry[i], rhsAry[i]);
            if (comp != 0) {
                return comp;
            }
            ++i;
        }
        return Int_.Compare(lhsLen, rhsLen);
    }

    public static int[] XtoIntAry(String s, int len) {
        int[] rv = new int[len];
        int i = 0;
        while (i < len) {
            rv[i] = s.charAt(i);
            ++i;
        }
        return rv;
    }

    public static String Coalesce(String s, String alt) {
        return String_.Len_eq_0(s) ? alt : s;
    }

    public static boolean In(String s, String ... ary) {
        String[] stringArray = ary;
        int n = ary.length;
        int n2 = 0;
        while (n2 < n) {
            String itm = stringArray[n2];
            if (String_.Eq(s, itm)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static String new_charAry_(char[] ary, int bgn, int len) {
        return new String(ary, bgn, len);
    }

    public static String Mid(String s, int bgn, int end) {
        try {
            return String_.Mid_lang(s, bgn, end - bgn);
        }
        catch (Exception e) {
            int len = s == null ? 0 : String_.Len(s);
            String msg = Empty;
            if (s == null) {
                msg = "s is null";
            } else if (bgn > end) {
                msg = "@bgn > @end";
            } else if (bgn < 0 || bgn >= len) {
                msg = "@bgn is invalid";
            } else if (end < 0 || end > len) {
                msg = "@end is invalid";
            }
            throw Err_.new_exc(e, "core", msg, "s", s, "bgn", bgn, "end", end, "len", len);
        }
    }

    public static String MidByLenSafe(String s, int bgn, int len) {
        if (bgn + len >= String_.Len(s)) {
            len = String_.Len(s) - bgn;
        }
        return String_.Mid_lang(s, bgn, len);
    }

    public static String MidByLen(String s, int bgn, int len) {
        return String_.Mid_lang(s, bgn, len);
    }

    public static String GetStrBefore(String s, String spr) {
        int sprPos = String_.FindFwd(s, spr);
        if (sprPos == -1) {
            throw Err_.new_wo_type("could not find spr", "s", s, "spr", spr);
        }
        return String_.Mid(s, 0, sprPos);
    }

    public static String GetStrAfter(String s, String spr) {
        int sprPos = String_.FindFwd(s, spr);
        if (sprPos == -1) {
            throw Err_.new_wo_type("could not find spr", "s", s, "spr", spr);
        }
        return String_.Mid(s, sprPos + 1);
    }

    public static String LimitToFirst(String s, int len) {
        if (len < 0) {
            throw Err_.new_invalid_arg("< 0", "len", len);
        }
        int sLen = String_.Len(s);
        if (len > sLen) {
            return s;
        }
        return String_.Mid_lang(s, 0, len);
    }

    public static String LimitToLast(String s, int len) {
        if (len < 0) {
            throw Err_.new_invalid_arg("< 0", "len", len);
        }
        int sLen = String_.Len(s);
        if (len > sLen) {
            return s;
        }
        return String_.Mid_lang(s, sLen - len, len);
    }

    public static String DelBgn(String s, int count) {
        if (count < 0) {
            throw Err_.new_invalid_arg("< 0", "count", count);
        }
        if (s == null) {
            throw Err_.new_null();
        }
        int len = String_.Len(s);
        if (count > len) {
            throw Err_.new_invalid_arg("> @len", "count", count, "len", len);
        }
        return String_.Mid(s, count);
    }

    public static String DelBgnIf(String s, String find) {
        if (s == null) {
            throw Err_.new_null();
        }
        if (find == null) {
            throw Err_.new_null();
        }
        return String_.Has_at_bgn(s, find) ? String_.Mid(s, String_.Len(find)) : s;
    }

    public static String DelEnd(String s, int count) {
        if (count < 0) {
            throw Err_.new_invalid_arg("< 0", "count", count);
        }
        if (s == null) {
            throw Err_.new_null();
        }
        int len = String_.Len(s);
        if (count > len) {
            throw Err_.new_invalid_arg("> len", "count", count, "len", len);
        }
        return String_.Mid_lang(s, 0, len + -count);
    }

    public static String DelEndIf(String s, String find) {
        if (s == null) {
            throw Err_.new_null();
        }
        if (find == null) {
            throw Err_.new_null();
        }
        return String_.Has_at_end(s, find) ? String_.Mid_lang(s, 0, String_.Len(s) - String_.Len(find)) : s;
    }

    public static String LowerFirst(String s) {
        int len = String_.Len(s);
        if (len == 0) {
            return Empty;
        }
        String char0 = String_.Lower(String_.Mid_lang(s, 0, 1));
        return len == 1 ? char0 : String.valueOf(char0) + String_.Mid(s, 1);
    }

    public static String UpperFirst(String s) {
        int len = String_.Len(s);
        if (len == 0) {
            return Empty;
        }
        String char0 = String_.Upper(String_.Mid_lang(s, 0, 1));
        return len == 1 ? char0 : String.valueOf(char0) + String_.Mid(s, 1);
    }

    public static String PadBgn(String s, int totalLen, String pad) {
        return String_.Pad(s, totalLen, pad, true);
    }

    public static String PadEnd(String s, int totalLen, String pad) {
        return String_.Pad(s, totalLen, pad, false);
    }

    @Internal
    protected static String Pad(String s, int totalLen, String pad, boolean bgn) {
        int sLen = String_.Len(s);
        int padLen = totalLen - sLen;
        if (padLen < 0) {
            return s;
        }
        String_bldr sb = String_bldr_.new_();
        if (!bgn) {
            sb.Add(s);
        }
        int i = 0;
        while (i < padLen) {
            sb.Add(pad);
            ++i;
        }
        if (bgn) {
            sb.Add(s);
        }
        return sb.To_str();
    }

    public static String TrimEnd(String s) {
        if (s == null) {
            return null;
        }
        int len = String_.Len(s);
        if (len == 0) {
            return s;
        }
        int last = len;
        int i = len;
        while (i > 0) {
            char c = s.charAt(i - 1);
            last = i;
            if (c != ' ' && c != '\t' && c != '\r' && c != '\n') break;
            --i;
        }
        return last == len ? s : String_.Mid_lang(s, 0, last);
    }

    public static String Repeat(String s, int count) {
        if (count < 0) {
            throw Err_.new_wo_type("count cannot be negative", "count", count, "s", s);
        }
        String_bldr sb = String_bldr_.new_();
        int i = 0;
        while (i < count) {
            sb.Add(s);
            ++i;
        }
        return sb.To_str();
    }

    public static String Insert(String s, int pos, String toInsert) {
        if (pos < 0 || pos >= String_.Len(s)) {
            throw Err_.new_wo_type("String_.Insert failed; pos invalid", "pos", pos, "s", s, "toInsert", toInsert);
        }
        return String.valueOf(s.substring(0, pos)) + toInsert + s.substring(pos);
    }

    public static String Format(String fmt, Object ... args) {
        return String_.Format_do(fmt, args);
    }

    public static String FormatOrEmptyStrIfNull(String fmt, Object arg) {
        return arg == null ? Empty : String_.Format(fmt, arg);
    }

    public static String Concat(char ... ary) {
        return new String(ary);
    }

    public static String Concat(String s1, String s2, String s3) {
        return String.valueOf(s1) + s2 + s3;
    }

    public static String Concat(String ... ary) {
        String_bldr sb = String_bldr_.new_();
        String[] stringArray = ary;
        int n = ary.length;
        int n2 = 0;
        while (n2 < n) {
            String val = stringArray[n2];
            sb.Add(val);
            ++n2;
        }
        return sb.To_str();
    }

    public static String Concat_any(Object ... ary) {
        String_bldr sb = String_bldr_.new_();
        Object[] objectArray = ary;
        int n = ary.length;
        int n2 = 0;
        while (n2 < n) {
            Object val = objectArray[n2];
            sb.Add_obj(val);
            ++n2;
        }
        return sb.To_str();
    }

    public static String Concat_with_obj(String separator, Object ... ary) {
        String_bldr sb = String_bldr_.new_();
        int aryLen = Array_.Len(ary);
        int i = 0;
        while (i < aryLen) {
            if (i != 0) {
                sb.Add(separator);
            }
            Object val = ary[i];
            sb.Add_obj(Object_.Xto_str_strict_or_empty(val));
            ++i;
        }
        return sb.To_str();
    }

    public static String Concat_with_str(String spr, String ... ary) {
        String_bldr sb = String_bldr_.new_();
        int len = ary.length;
        int i = 0;
        while (i < len) {
            if (i != 0) {
                sb.Add(spr);
            }
            sb.Add_obj(ary[i]);
            ++i;
        }
        return sb.To_str();
    }

    public static String Concat_lines_crlf(String ... values) {
        String_bldr sb = String_bldr_.new_();
        String[] stringArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            String val = stringArray[n2];
            sb.Add(val).Add(CrLf);
            ++n2;
        }
        return sb.To_str();
    }

    public static String Concat_lines_crlf_skipLast(String ... values) {
        String_bldr sb = String_bldr_.new_();
        String[] stringArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            String val = stringArray[n2];
            if (sb.Count() != 0) {
                sb.Add(CrLf);
            }
            sb.Add(val);
            ++n2;
        }
        return sb.To_str();
    }

    public static String Concat_lines_nl(String ... values) {
        String_bldr sb = String_bldr_.new_();
        String[] stringArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            String val = stringArray[n2];
            sb.Add(val).Add(Lf);
            ++n2;
        }
        return sb.To_str();
    }

    public static String Concat_lines_nl_apos_skip_last(String ... lines) {
        Bry_bfr bfr = Bry_bfr_.Get();
        try {
            Bry_.New_u8_nl_apos(bfr, lines);
            String string = bfr.To_str_and_clear();
            return string;
        }
        finally {
            bfr.Mkr_rls();
        }
    }

    public static String Concat_lines_nl_skip_last(String ... ary) {
        String_bldr sb = String_bldr_.new_();
        int ary_len = ary.length;
        int ary_end = ary_len - 1;
        int i = 0;
        while (i < ary_len) {
            sb.Add(ary[i]);
            if (i != ary_end) {
                sb.Add(Lf);
            }
            ++i;
        }
        return sb.To_str();
    }

    public static String[] Ary(String ... ary) {
        return ary;
    }

    public static String[] Ary_wo_null(String ... ary) {
        List_adp list = List_adp_.New();
        int len = ary.length;
        int i = 0;
        while (i < len) {
            String itm = ary[i];
            if (itm != null) {
                list.Add(itm);
            }
            ++i;
        }
        return list.To_str_ary();
    }

    public static String AryXtoStr(String ... ary) {
        String_bldr sb = String_bldr_.new_();
        String[] stringArray = ary;
        int n = ary.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            sb.Add(s).Add(";");
            ++n2;
        }
        return sb.To_str();
    }

    public static String[] Split(String raw, char dlm) {
        return String_.Split(raw, dlm, false);
    }

    public static String[] Split(String raw, char dlm, boolean addEmptyIfDlmIsLast) {
        List_adp list = List_adp_.New();
        String_bldr sb = String_bldr_.new_();
        int rawLen = String_.Len(raw);
        char c = '\u0000';
        int i = 0;
        while (i < rawLen) {
            c = String_.CharAt(raw, i);
            if (c == dlm) {
                if (addEmptyIfDlmIsLast || sb.Count() != 0 || i != rawLen - 1) {
                    list.Add(sb.To_str_and_clear());
                }
            } else {
                sb.Add(c);
            }
            ++i;
        }
        if (sb.Count() > 0) {
            list.Add(sb.To_str_and_clear());
        }
        return list.To_str_ary();
    }

    public static String[] Split(String s, String separator) {
        return String_.Split_do(s, separator, false);
    }

    public static String[] SplitLines_crlf(String s) {
        return String_.Split(s, Op_sys.Wnt.Nl_str());
    }

    public static String[] SplitLines_nl(String s) {
        return String_.Split(s, Op_sys.Lnx.Nl_str());
    }

    public static String[] SplitLines_any(String s) {
        return String_.Split_do(s, Op_sys.Lnx.Nl_str(), true);
    }

    public static String[] Split_lang(String s, char c) {
        return s.split(Character.toString(c));
    }

    static String Format_do(String s, Object[] ary) {
        int aryLength = Array_.Len_obj(ary);
        if (aryLength == 0) {
            return s;
        }
        String_bldr sb = String_bldr_.new_();
        char bracketBgn = '{';
        char bracketEnd = '}';
        String aryVal = null;
        int textLength = String_.Len(s);
        String numberStr = Empty;
        boolean bracketsOn = false;
        for (int pos = 0; pos != textLength; ++pos) {
            char c = String_.CharAt(s, pos);
            if (bracketsOn) {
                if (c == bracketBgn) {
                    sb.Add(bracketBgn).Add(numberStr);
                    numberStr = Empty;
                    continue;
                }
                if (c == bracketEnd) {
                    int aryIdx = Int_.parse_or(numberStr, Integer.MIN_VALUE);
                    aryVal = aryIdx != Integer.MIN_VALUE && Int_.Between(aryIdx, 0, aryLength - 1) ? Object_.Xto_str_strict_or_empty(ary[aryIdx]) : String_.Concat_any(Character.valueOf(bracketBgn), numberStr, Character.valueOf(bracketEnd));
                    sb.Add(aryVal);
                    bracketsOn = false;
                    numberStr = Empty;
                    continue;
                }
                numberStr = String.valueOf(numberStr) + c;
                continue;
            }
            if (c == bracketBgn || c == bracketEnd) {
                boolean isEnd;
                boolean bl = isEnd = pos == textLength - 1;
                if (isEnd) {
                    sb.Add(c);
                    continue;
                }
                char next = String_.CharAt(s, pos + 1);
                if (next == c) {
                    sb.Add(c);
                    ++pos;
                    continue;
                }
                bracketsOn = true;
                continue;
            }
            sb.Add(c);
        }
        if (String_.Len(numberStr) > 0) {
            sb.Add(bracketBgn).Add(numberStr);
        }
        return sb.To_str();
    }

    static String[] Split_do(String s, String spr, boolean skipChar13) {
        if (String_.Eq(s, Empty) || String_.Eq(spr, Empty)) {
            return new String[]{s};
        }
        List_adp list = List_adp_.New();
        String_bldr sb = String_bldr_.new_();
        int i = 0;
        int sprPos = 0;
        boolean sprMatched = false;
        char spr0 = String_.CharAt(spr, 0);
        int textLength = String_.Len(s);
        int sprLength = String_.Len(spr);
        while (true) {
            if (sprMatched || i == textLength) {
                list.Add(sb.To_str_and_clear());
                if (sprMatched && i == textLength) {
                    list.Add(Empty);
                }
                sprMatched = false;
            }
            if (i == textLength) break;
            char c = String_.CharAt(s, i);
            if (skipChar13 && c == '\r') {
                ++i;
                continue;
            }
            if (c == spr0) {
                sprPos = 1;
                while (true) {
                    if (sprPos == sprLength) {
                        sprMatched = true;
                        break;
                    }
                    if (i + sprPos == textLength || String_.CharAt(s, i + sprPos) != String_.CharAt(spr, sprPos)) break;
                    ++sprPos;
                }
                if (!sprMatched) {
                    sb.Add(String_.Mid_lang(s, i, sprPos));
                }
                i += sprPos;
                continue;
            }
            sb.Add(c);
            ++i;
        }
        return (String[])list.To_ary(String.class);
    }

    static String Mid_lang(String s, int bgn, int len) {
        return s.substring(bgn, bgn + len);
    }

    public static String Extract_after_bwd(String src, String dlm) {
        int dlm_pos = String_.FindBwd(src, dlm);
        if (dlm_pos == -1) {
            return Empty;
        }
        int src_len = String_.Len(src);
        if (dlm_pos == src_len - 1) {
            return Empty;
        }
        return String_.Mid(src, dlm_pos + 1, src_len);
    }

    public static String Replace_by_pos(String v, int del_bgn, int del_end, String repl) {
        return String.valueOf(String_.Mid(v, 0, del_bgn)) + repl + String_.Mid(v, del_end, String_.Len(v));
    }

    public static String read_(Object obj) {
        String rv = String_.as_(obj);
        if (rv == null && obj != null) {
            throw Err_.new_type_mismatch(String.class, obj);
        }
        return rv;
    }

    public static String[] Ary_parse(String raw, String dlm) {
        return String_.Split(raw, dlm);
    }

    public static String[] Ary(byte[] ... ary) {
        if (ary == null) {
            return Ary_empty;
        }
        int ary_len = ary.length;
        String[] rv = new String[ary_len];
        int i = 0;
        while (i < ary_len) {
            byte[] itm = ary[i];
            rv[i] = itm == null ? null : String_.new_u8(itm);
            ++i;
        }
        return rv;
    }

    public static String[] Ary_filter(String[] src, String[] filter) {
        Hash_adp hash = Hash_adp_.New();
        int len = filter.length;
        int i = 0;
        while (i < len) {
            String itm = filter[i];
            hash.Add_if_dupe_use_nth(itm, itm);
            ++i;
        }
        List_adp rv = List_adp_.New();
        len = src.length;
        int i2 = 0;
        while (i2 < len) {
            String itm = src[i2];
            if (hash.Has(itm)) {
                rv.Add(itm);
            }
            ++i2;
        }
        return rv.To_str_ary();
    }

    public static String[] Ary_flatten(String[][] src_ary) {
        int trg_len = 0;
        int src_len = Array_.Len(src_ary);
        int i = 0;
        while (i < src_len) {
            String[] itm = src_ary[i];
            if (itm != null) {
                trg_len += Array_.Len(itm);
            }
            ++i;
        }
        String[] trg_ary = new String[trg_len];
        trg_len = 0;
        int i2 = 0;
        while (i2 < src_len) {
            String[] itm = src_ary[i2];
            if (itm != null) {
                int itm_len = Array_.Len(itm);
                int j = 0;
                while (j < itm_len) {
                    trg_ary[trg_len++] = itm[j];
                    ++j;
                }
            }
            ++i2;
        }
        return trg_ary;
    }

    public static boolean Ary_eq(String[] lhs, String[] rhs) {
        int lhs_len = lhs.length;
        int rhs_len = rhs.length;
        if (lhs_len != rhs_len) {
            return false;
        }
        int i = 0;
        while (i < lhs_len) {
            if (!String_.Eq(lhs[i], rhs[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static String To_str__as_kv_ary(String ... ary) {
        int len = ary.length;
        Bry_bfr bfr = Bry_bfr_.New();
        int i = 0;
        while (i < len) {
            String val;
            bfr.Add_str_u8(ary[i]).Add_byte_eq();
            String string = val = i + 1 < len ? ary[i + 1] : null;
            if (val != null) {
                bfr.Add_str_u8(val);
            }
            bfr.Add_byte_nl();
            i += 2;
        }
        return bfr.To_str_and_clear();
    }
}

