/*
 * Decompiled with CFR 0.152.
 */
package gplx;

import gplx.Bry_;
import gplx.Err_;
import gplx.GfoMsg;
import gplx.Gfo_invk;
import gplx.Gfo_invk_;
import gplx.GfsCtx;
import gplx.Int_;
import gplx.List_adp;
import gplx.List_adp_;
import gplx.Ordered_hash;
import gplx.String_;
import gplx.Virtual;
import gplx.core.envs.Op_sys;
import gplx.core.lists.ComparerAble;
import gplx.core.lists.Hash_adp_base;
import gplx.core.strings.String_bldr;
import gplx.core.strings.String_bldr_;
import java.util.Iterator;

public class Ordered_hash_base
extends Hash_adp_base
implements Ordered_hash,
Gfo_invk {
    private final List_adp ordered = List_adp_.New();
    private boolean locked = false;
    static final String GRP_KEY = "gplx.core.lists.ordered_hash";
    static final String Invk_SetKeyOnly = "SetKeyOnly";
    static final String Invk_Print = "Print";

    @Override
    protected void Add_base(Object key, Object val) {
        super.Add_base(key, val);
        this.ordered.Add(val);
        this.AssertCounts();
    }

    @Override
    public void Del(Object key) {
        if (!this.Has_base(key)) {
            return;
        }
        Object val = this.Fetch_base(key);
        this.Del_base(key);
        this.ordered.Del(val);
        this.AssertCounts();
    }

    protected Object Get_at_base(int index) {
        return this.ordered.Get_at(index);
    }

    protected int IndexOf_base(Object obj) {
        return this.ordered.Idx_of(obj);
    }

    @Override
    public void Clear() {
        if (this.locked) {
            this.Lock_fail();
        }
        super.Clear();
        this.ordered.Clear();
    }

    @Override
    public Object To_ary(Class<?> type) {
        return this.ordered.To_ary(type);
    }

    @Override
    public Object To_ary_and_clear(Class<?> t) {
        Object rv = this.To_ary(t);
        this.Clear();
        return rv;
    }

    @Override
    @Virtual
    public void Sort() {
        if (this.locked) {
            this.Lock_fail();
        }
        this.ordered.Sort();
    }

    @Override
    public void Sort_by(ComparerAble comparer) {
        if (this.locked) {
            this.Lock_fail();
        }
        this.ordered.Sort_by(comparer);
    }

    @Override
    public Iterator iterator() {
        return this.ordered.iterator();
    }

    public void Add_at(int i, Object key, Object val) {
        if (this.locked) {
            this.Lock_fail();
        }
        super.Add_base(key, val);
        this.ordered.Add_at(i, val);
        this.AssertCounts();
    }

    @Override
    public Ordered_hash Add_many_str(String ... ary) {
        int ary_len = ary.length;
        int i = 0;
        while (i < ary_len) {
            String itm = ary[i];
            byte[] bry = Bry_.new_u8(itm);
            this.Add(bry, bry);
            ++i;
        }
        return this;
    }

    void AssertCounts() {
        if (super.Count() != this.ordered.Count()) {
            throw Err_.new_wo_type("counts do not match", "hash", super.Count(), "list", this.ordered.Count());
        }
    }

    @Override
    public void Resize_bounds(int i) {
        if (this.locked) {
            this.Lock_fail();
        }
        this.ordered.Resize_bounds(i);
    }

    @Override
    public void Lock() {
        this.locked = true;
    }

    void Lock_fail() {
        throw Err_.new_wo_type("collection is locked", new Object[0]);
    }

    @Override
    public void Add_at(int i, Object o) {
        if (this.locked) {
            this.Lock_fail();
        }
        this.ordered.Add_at(i, o);
    }

    @Override
    public Object Get_at(int i) {
        return this.Get_at_base(i);
    }

    @Override
    public int Idx_of(Object obj) {
        return this.IndexOf_base(obj);
    }

    @Override
    public void Move_to(int src, int trg) {
        if (this.locked) {
            this.Lock_fail();
        }
        this.ordered.Move_to(src, trg);
    }

    private String To_str_ui() {
        String_bldr sb = String_bldr_.new_();
        int count = this.ordered.Count();
        int pad = String_.Len(Int_.To_str(count));
        int i = 0;
        while (i < count) {
            sb.Add(Int_.To_str_pad_bgn_zero(i, pad)).Add(":").Add(this.ordered.Get_at(i).toString()).Add(Op_sys.Cur().Nl_str());
            ++i;
        }
        return sb.To_str();
    }

    @Override
    public Object Invk(GfsCtx ctx, int ikey, String k, GfoMsg m) {
        String s;
        if (ctx.Match(k, Invk_SetKeyOnly)) {
            s = m.ReadStr("v");
            if (ctx.Deny()) {
                return this;
            }
        } else {
            if (ctx.Match(k, Invk_Print)) {
                if (ctx.Deny()) {
                    return this;
                }
                return this.To_str_ui();
            }
            return Gfo_invk_.Rv_unhandled;
        }
        this.Add(s, s);
        return this;
    }

    @Override
    public int Count() {
        return this.ordered.Count();
    }
}

