/*
 * Decompiled with CFR 0.152.
 */
package gplx;

import gplx.Array_;
import gplx.Bry_bfr;
import gplx.Bry_bfr_;
import gplx.Err_;
import gplx.GfoMsg;
import gplx.Gfo_invk;
import gplx.Gfo_invk_;
import gplx.GfsCtx;
import gplx.Internal;
import gplx.List_adp;
import gplx.Object_;
import gplx.RandomAdp;
import gplx.RandomAdp_;
import gplx.Virtual;
import gplx.core.lists.ComparerAble;
import gplx.core.lists.Iterator_null;
import gplx.core.lists.Iterator_objAry;
import gplx.core.lists.List_adp_sorter;
import java.util.Iterator;

public abstract class List_adp_base
implements List_adp,
Gfo_invk {
    private Object[] list;
    private int count;
    private static final int Len_initial = 8;
    private static final String Invk_len = "len";
    private static final String Invk_get_at = "get_at";

    public List_adp_base(int capacity) {
        this.list = new Object[capacity];
    }

    public Iterator iterator() {
        if (this.count == 0) {
            return Iterator_null.Instance;
        }
        return new Iterator_objAry(this.list, this.count);
    }

    @Override
    public void Add_many(Object ... ary) {
        Object[] objectArray = ary;
        int n = ary.length;
        int n2 = 0;
        while (n2 < n) {
            Object o = objectArray[n2];
            this.Add_base(o);
            ++n2;
        }
    }

    @Override
    public int Len() {
        return this.count;
    }

    @Override
    public int Count() {
        return this.count;
    }

    @Override
    public int Idx_last() {
        return this.count - 1;
    }

    protected Object Get_at_base(int index) {
        if (index >= this.count || index < 0) {
            throw Err_.new_missing_idx(index, this.count);
        }
        return this.list[index];
    }

    protected void Add_base(Object o) {
        if (this.count == Array_.Len_obj(this.list)) {
            this.Resize_expand();
        }
        this.list[this.count] = o;
        ++this.count;
    }

    protected int Del_base(Object o) {
        int index = this.IndexOf_base(o);
        if (index == -1) {
            return -1;
        }
        this.Del_at(index);
        return index;
    }

    @Override
    public void Del_range(int delBgn, int delEnd) {
        this.BoundsChk(delBgn, delEnd, this.count);
        if (delBgn == 0 && delEnd == this.count - 1) {
            this.Clear();
            return;
        }
        int delLen = delEnd - delBgn + 1;
        int newLen = this.count - delLen;
        Object[] newList = new Object[newLen];
        if (delBgn != 0) {
            Array_.Copy_to(this.list, 0, newList, 0, delBgn);
        }
        if (delEnd != this.count - 1) {
            Array_.Copy_to(this.list, delEnd + 1, newList, delBgn, newLen - delBgn);
        }
        this.list = newList;
        this.count = this.list.length;
    }

    protected int IndexOf_base(Object o) {
        int i = 0;
        while (i < this.count) {
            if (Object_.Eq(this.list[i], o)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    @Override
    @Virtual
    public void Clear() {
        int i = 0;
        while (i < this.count) {
            this.list[i] = null;
            ++i;
        }
        this.count = 0;
    }

    @Override
    @Virtual
    public void Del_at(int index) {
        if (index >= this.count || index < 0) {
            throw Err_.new_missing_idx(index, this.count);
        }
        this.Collapse(index);
        --this.count;
    }

    @Override
    public void Move_to(int src, int trg) {
        if (src >= this.count || src < 0) {
            throw Err_.new_missing_idx(src, this.count);
        }
        if (trg >= this.count || trg < 0) {
            throw Err_.new_missing_idx(trg, this.count);
        }
        if (src == trg) {
            return;
        }
        Object o = this.list[src];
        int dif = trg > src ? 1 : -1;
        int i = src;
        while (i != trg) {
            this.list[i] = this.list[i + dif];
            i += dif;
        }
        this.list[trg] = o;
    }

    protected void AddAt_base(int pos, Object o) {
        if (this.count + 1 >= Array_.Len_obj(this.list)) {
            this.Resize_expand();
        }
        int i = this.count;
        while (i > pos) {
            this.list[i] = this.list[i - 1];
            --i;
        }
        this.list[pos] = o;
        ++this.count;
    }

    @Override
    public void Resize_bounds(int i) {
        this.Resize_expand(i);
    }

    @Override
    public void Sort() {
        this.Sort_by(null);
    }

    @Override
    public void Sort_by(ComparerAble comparer) {
        List_adp_sorter.new_().Sort(this.list, this.count, true, comparer);
    }

    @Override
    public void Reverse() {
        int mid = this.count / 2;
        int lhs = 0;
        while (lhs < mid) {
            int rhs = this.count - lhs - 1;
            Object temp = this.list[lhs];
            this.list[lhs] = this.list[rhs];
            this.list[rhs] = temp;
            ++lhs;
        }
    }

    @Override
    @Virtual
    public void Shuffle() {
        RandomAdp random = RandomAdp_.new_();
        int i = this.count;
        while (i > 1) {
            int rndIdx = random.Next(i);
            Object tmp = this.list[rndIdx];
            this.list[rndIdx] = this.list[i - 1];
            this.list[i - 1] = tmp;
            --i;
        }
    }

    @Override
    public Object Get_at(int i) {
        return this.Get_at_base(i);
    }

    @Override
    public Object Get_at_last() {
        if (this.count == 0) {
            throw Err_.new_invalid_op("cannot call Get_at_last on empty list");
        }
        return this.Get_at_base(this.count - 1);
    }

    @Override
    public void Add(Object item) {
        this.Add_base(item);
    }

    @Override
    public void Add_at(int i, Object o) {
        this.AddAt_base(i, o);
    }

    @Override
    public void Del(Object item) {
        this.Del_base(item);
    }

    @Override
    public int Idx_of(Object o) {
        return this.IndexOf_base(o);
    }

    public List_adp_base() {
        this.list = new Object[8];
    }

    @Override
    public Object To_ary_and_clear(Class<?> memberType) {
        Object rv = this.To_ary(memberType);
        this.Clear();
        return rv;
    }

    @Override
    public Object To_ary(Class<?> memberType) {
        Object rv = Array_.Create(memberType, this.count);
        int i = 0;
        while (i < this.count) {
            Array_.Set_at(rv, i, this.list[i]);
            ++i;
        }
        return rv;
    }

    @Override
    public String[] To_str_ary_and_clear() {
        String[] rv = this.To_str_ary();
        this.Clear();
        return rv;
    }

    @Override
    public String[] To_str_ary() {
        return (String[])this.To_ary(String.class);
    }

    @Override
    public Object[] To_obj_ary() {
        Object[] rv = new Object[this.count];
        int i = 0;
        while (i < this.count) {
            rv[i] = this.list[i];
            ++i;
        }
        return rv;
    }

    @Override
    public String To_str() {
        Bry_bfr bfr = Bry_bfr_.New();
        int i = 0;
        while (i < this.count) {
            bfr.Add_str_u8(Object_.Xto_str_strict_or_null_mark(this.list[i])).Add_byte_nl();
            ++i;
        }
        return bfr.To_str_and_clear();
    }

    private void BoundsChk(int bgn, int end, int len) {
        if (bgn >= 0 && bgn < len && end >= 0 && end < len && bgn <= end) {
            return;
        }
        throw Err_.new_wo_type("bounds check failed", "bgn", bgn, "end", end, Invk_len, len);
    }

    void Resize_expand() {
        this.Resize_expand(this.count * 2);
    }

    void Resize_expand(int newCount) {
        Object[] trg = new Object[newCount];
        int i = 0;
        while (i < this.count) {
            trg[i] = this.list[i];
            this.list[i] = null;
            ++i;
        }
        this.list = trg;
    }

    void Collapse(int index) {
        int i = index;
        while (i < this.count) {
            this.list[i] = i == this.count - 1 ? null : this.list[i + 1];
            ++i;
        }
    }

    @Internal
    protected int Capacity() {
        return Array_.Len_obj(this.list);
    }

    @Override
    public Object Invk(GfsCtx ctx, int ikey, String k, GfoMsg m) {
        if (ctx.Match(k, Invk_len)) {
            return this.count;
        }
        if (ctx.Match(k, Invk_get_at)) {
            return this.Get_at(m.ReadInt("v"));
        }
        return Gfo_invk_.Rv_unhandled;
    }
}

