/*
 * Decompiled with CFR 0.152.
 */
package gplx;

import gplx.Bry_;
import gplx.Err_;
import gplx.Hash_adp_bry_itm_base;
import gplx.core.intls.Gfo_case_itm;
import gplx.core.intls.Gfo_case_mgr;
import gplx.core.intls.Utf8_;

class Hash_adp_bry_itm_ci_u8
extends Hash_adp_bry_itm_base {
    private final Gfo_case_mgr case_mgr;
    private byte[] src;
    int src_bgn;
    int src_end;
    private static Hash_adp_bry_itm_ci_u8 Itm_a7;
    private static Hash_adp_bry_itm_ci_u8 Itm_u8;

    Hash_adp_bry_itm_ci_u8(Gfo_case_mgr case_mgr) {
        this.case_mgr = case_mgr;
    }

    @Override
    public Hash_adp_bry_itm_base New() {
        return new Hash_adp_bry_itm_ci_u8(this.case_mgr);
    }

    @Override
    public Hash_adp_bry_itm_base Init(byte[] src, int src_bgn, int src_end) {
        this.src = src;
        this.src_bgn = src_bgn;
        this.src_end = src_end;
        return this;
    }

    public int hashCode() {
        int rv = 0;
        int i = this.src_bgn;
        while (i < this.src_end) {
            byte b = this.src[i];
            int b_int = b & 0xFF;
            Gfo_case_itm itm = this.case_mgr.Get_or_null(b, this.src, i, this.src_end);
            if (itm != null) {
                b_int = itm.Hashcode_lo();
                int b_len = Utf8_.Len_of_char_by_1st_byte(b);
                i += b_len - 1;
            }
            rv = 31 * rv + b_int;
            ++i;
        }
        return rv;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        Hash_adp_bry_itm_ci_u8 trg_itm = (Hash_adp_bry_itm_ci_u8)obj;
        byte[] trg = trg_itm.src;
        int trg_bgn = trg_itm.src_bgn;
        int trg_end = trg_itm.src_end;
        int src_c_bgn = this.src_bgn;
        int trg_c_bgn = trg_bgn;
        while (src_c_bgn < this.src_end && trg_c_bgn < trg_end) {
            byte src_c = this.src[src_c_bgn];
            byte trg_c = trg[trg_c_bgn];
            int src_c_len = Utf8_.Len_of_char_by_1st_byte(src_c);
            int trg_c_len = Utf8_.Len_of_char_by_1st_byte(trg_c);
            int src_c_end = src_c_bgn + src_c_len;
            int trg_c_end = trg_c_bgn + trg_c_len;
            Gfo_case_itm src_c_itm = this.case_mgr.Get_or_null(src_c, this.src, src_c_bgn, src_c_end);
            Gfo_case_itm trg_c_itm = this.case_mgr.Get_or_null(trg_c, trg, trg_c_bgn, trg_c_end);
            if (src_c_itm != null && trg_c_itm == null) {
                return false;
            }
            if (src_c_itm == null && trg_c_itm != null) {
                return false;
            }
            if (src_c_itm == null && trg_c_itm == null ? !Bry_.Match(this.src, src_c_bgn, src_c_end, trg, trg_c_bgn, trg_c_end) : src_c_itm.Utf8_id_lo() != trg_c_itm.Utf8_id_lo()) {
                return false;
            }
            src_c_bgn = src_c_end;
            trg_c_bgn = trg_c_end;
        }
        return src_c_bgn == this.src_end && trg_c_bgn == trg_end;
    }

    public static Hash_adp_bry_itm_ci_u8 get_or_new(Gfo_case_mgr case_mgr) {
        switch (case_mgr.Tid()) {
            case 0: {
                if (Itm_a7 == null) {
                    Itm_a7 = new Hash_adp_bry_itm_ci_u8(case_mgr);
                }
                return Itm_a7;
            }
            case 1: {
                if (Itm_u8 == null) {
                    Itm_u8 = new Hash_adp_bry_itm_ci_u8(case_mgr);
                }
                return Itm_u8;
            }
            case 2: {
                return new Hash_adp_bry_itm_ci_u8(case_mgr);
            }
        }
        throw Err_.new_unhandled(case_mgr.Tid());
    }
}

