/*
 * Decompiled with CFR 0.152.
 */
package gplx;

import gplx.Decimal_adp;
import gplx.Err_;
import gplx.Float_;
import gplx.Math_;
import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Locale;

public class Decimal_adp_ {
    public static final String Cls_val_name = "decimal";
    public static final Class<?> Cls_ref_type = Decimal_adp.class;
    public static final Decimal_adp Zero = new Decimal_adp(0);
    public static final Decimal_adp One = new Decimal_adp(1);
    public static final Decimal_adp Neg1 = new Decimal_adp(-1);
    public static final Decimal_adp Const_e = Decimal_adp_.double_(Math_.E);
    public static final Decimal_adp Const_pi = Decimal_adp_.double_(Math_.Pi);
    public static final MathContext RoundDownContext = new MathContext(0, RoundingMode.DOWN);
    public static final MathContext Gplx_rounding_context = new MathContext(14, RoundingMode.HALF_UP);

    public static Decimal_adp as_(Object obj) {
        return obj instanceof Decimal_adp ? (Decimal_adp)obj : null;
    }

    public static Decimal_adp base1000_(long v) {
        return Decimal_adp_.divide_(v, 1000L);
    }

    public static Decimal_adp parts_1000_(long num, int frc) {
        return Decimal_adp_.divide_(num * 1000L + (long)frc, 1000L);
    }

    public static Decimal_adp parts_(long num, int frc) {
        int pow10 = Decimal_adp_.XtoPow10(frc);
        return Decimal_adp_.divide_(num * (long)pow10 + (long)frc, pow10);
    }

    public static Decimal_adp cast(Object obj) {
        return (Decimal_adp)obj;
    }

    static int XtoPow10(int v) {
        if (v > -1 && v < 10) {
            return 10;
        }
        if (v > 9 && v < 100) {
            return 100;
        }
        if (v > 99 && v < 1000) {
            return 1000;
        }
        if (v > 999 && v < 10000) {
            return 10000;
        }
        if (v > 9999 && v < 100000) {
            return 100000;
        }
        if (v > 99999 && v < 1000000) {
            return 1000000;
        }
        if (v > 999999 && v < 10000000) {
            return 10000000;
        }
        if (v > 9999999 && v < 100000000) {
            return 100000000;
        }
        if (v > 99999999 && v < 1000000000) {
            return 1000000000;
        }
        throw Err_.new_wo_type("value must be between 0 and 1 billion", "v", v);
    }

    public static String CalcPctStr(long dividend, long divisor, String fmt) {
        if (divisor == 0L) {
            return "%ERR";
        }
        return String.valueOf(Decimal_adp_.float_(Float_.Div(dividend, divisor) * 100.0f).To_str(fmt)) + "%";
    }

    public static Decimal_adp divide_safe_(long lhs, long rhs) {
        return rhs == 0L ? Zero : Decimal_adp_.divide_(lhs, rhs);
    }

    public static Decimal_adp divide_(long lhs, long rhs) {
        return new Decimal_adp(new BigDecimal(lhs).divide(new BigDecimal(rhs), Gplx_rounding_context));
    }

    public static Decimal_adp int_(int v) {
        return new Decimal_adp(new BigDecimal(v));
    }

    public static Decimal_adp long_(long v) {
        return new Decimal_adp(new BigDecimal(v));
    }

    public static Decimal_adp float_(float v) {
        return new Decimal_adp(new BigDecimal(v));
    }

    public static Decimal_adp double_(double v) {
        return new Decimal_adp(new BigDecimal(v));
    }

    public static Decimal_adp double_thru_str_(double v) {
        return new Decimal_adp(BigDecimal.valueOf(v));
    }

    public static Decimal_adp db_(Object v) {
        return new Decimal_adp((BigDecimal)v);
    }

    public static Decimal_adp parse(String raw) {
        try {
            DecimalFormat nf = (DecimalFormat)NumberFormat.getInstance(Locale.US);
            nf.setParseBigDecimal(true);
            BigDecimal bd = (BigDecimal)nf.parse(raw);
            return new Decimal_adp(bd);
        }
        catch (ParseException e) {
            throw Err_.new_("Decimal_adp_", "parse to decimal failed", "raw", raw);
        }
    }

    public static Decimal_adp pow_10_(int v) {
        return new Decimal_adp(new BigDecimal(1).scaleByPowerOfTen(v));
    }
}

