/*
 * Decompiled with CFR 0.152.
 */
package gplx;

import gplx.CompareAble;
import gplx.Decimal_adp_;
import gplx.Math_;
import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import java.text.DecimalFormat;

public class Decimal_adp
implements CompareAble {
    private final BigDecimal under;

    public int compareTo(Object obj) {
        Decimal_adp comp = (Decimal_adp)obj;
        return this.under.compareTo(comp.under);
    }

    protected Decimal_adp(BigDecimal v) {
        this.under = v;
    }

    protected Decimal_adp(int v) {
        this.under = new BigDecimal(v);
    }

    public Object Under() {
        return this.under;
    }

    public BigDecimal Under_as_native() {
        return this.under;
    }

    public int Precision() {
        return this.under.precision();
    }

    public int Frac_1000() {
        return (int)(this.under.movePointRight(3).floatValue() % 1000.0f);
    }

    public boolean Eq(Decimal_adp v) {
        return v.under.doubleValue() == this.under.doubleValue();
    }

    public boolean Eq(int v) {
        return this.under.doubleValue() == (double)v;
    }

    public String To_str() {
        BigDecimal tmp = this.under;
        int tmp_scale = tmp.scale();
        if (tmp_scale <= -14) {
            return tmp.toString();
        }
        if (tmp_scale > 14) {
            tmp = tmp.setScale(14, RoundingMode.DOWN);
        }
        return tmp.stripTrailingZeros().toPlainString();
    }

    public String To_str(String fmt) {
        return new DecimalFormat(fmt).format(this.under);
    }

    public String toString() {
        return this.under.toString();
    }

    public int To_int() {
        return (int)this.under.doubleValue();
    }

    public long To_long() {
        return (long)this.under.doubleValue();
    }

    public long To_long_mult_1000() {
        return this.under.movePointRight(3).longValue();
    }

    public double To_double() {
        return this.under.doubleValue();
    }

    public Decimal_adp Add(Decimal_adp v) {
        return new Decimal_adp(this.under.add(v.under, Decimal_adp_.Gplx_rounding_context));
    }

    public Decimal_adp Subtract(Decimal_adp v) {
        return new Decimal_adp(this.under.subtract(v.under, Decimal_adp_.Gplx_rounding_context));
    }

    public Decimal_adp Multiply(Decimal_adp v) {
        return new Decimal_adp(this.under.multiply(v.under));
    }

    public Decimal_adp Multiply(double v) {
        return new Decimal_adp(this.under.multiply(new BigDecimal(v, Decimal_adp_.Gplx_rounding_context)));
    }

    public Decimal_adp Multiply(long v) {
        return new Decimal_adp(this.under.multiply(new BigDecimal(v)));
    }

    public Decimal_adp Divide(Decimal_adp v) {
        return new Decimal_adp(this.under.divide(v.under, Decimal_adp_.Gplx_rounding_context));
    }

    public Decimal_adp Mod(Decimal_adp v) {
        return new Decimal_adp(this.under.remainder(v.under, Decimal_adp_.Gplx_rounding_context));
    }

    public Decimal_adp Abs() {
        return new Decimal_adp(this.under.abs(Decimal_adp_.Gplx_rounding_context));
    }

    public Decimal_adp Pow(int v) {
        return new Decimal_adp(this.under.pow(v, Decimal_adp_.Gplx_rounding_context));
    }

    public Decimal_adp Sqrt() {
        return new Decimal_adp(new BigDecimal(Math_.Sqrt(this.under.doubleValue())));
    }

    public Decimal_adp Truncate() {
        return new Decimal_adp(this.under.intValue());
    }

    public Decimal_adp Round_old(int v) {
        return new Decimal_adp(this.under.setScale(v, RoundingMode.HALF_UP));
    }

    public Decimal_adp Round(int v) {
        BigDecimal new_val = null;
        if (v > 0) {
            new_val = this.under.setScale(v, RoundingMode.HALF_UP);
        } else {
            int reqd_places = -v;
            int actl_places = this.under.precision() - this.under.scale();
            if (reqd_places < actl_places) {
                new_val = this.under.round(new MathContext(actl_places - reqd_places, RoundingMode.HALF_UP));
            } else if (reqd_places == actl_places) {
                int base_10 = (int)Math_.Pow(10.0, reqd_places - 1);
                new_val = this.under.intValue() / base_10 < 5 ? BigDecimal.ZERO : new BigDecimal(Math_.Pow(10.0, reqd_places));
            } else {
                new_val = BigDecimal.ZERO;
            }
        }
        return new Decimal_adp(new_val);
    }

    public boolean Comp_gte(Decimal_adp v) {
        return this.under.doubleValue() >= v.under.doubleValue();
    }

    public boolean Comp_gte(int v) {
        return this.under.doubleValue() >= (double)v;
    }

    public boolean Comp_lte(Decimal_adp v) {
        return this.under.doubleValue() <= v.under.doubleValue();
    }

    public boolean Comp_lte(int v) {
        return this.under.doubleValue() <= (double)v;
    }

    public boolean Comp_gt(Decimal_adp v) {
        return this.under.doubleValue() > v.under.doubleValue();
    }

    public boolean Comp_gt(int v) {
        return this.under.doubleValue() > (double)v;
    }

    public boolean Comp_lt(Decimal_adp v) {
        return this.under.doubleValue() < v.under.doubleValue();
    }

    public boolean Comp_lt(int v) {
        return this.under.doubleValue() < (double)v;
    }
}

