/*
 * Decompiled with CFR 0.152.
 */
package gplx;

import gplx.CompareAble;
import gplx.Err_;
import gplx.GfoMsg;
import gplx.Gfo_invk;
import gplx.Gfo_invk_;
import gplx.GfsCtx;
import gplx.Object_;
import gplx.String_;
import gplx.Time_span;
import gplx.Time_span_;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;

public class DateAdp
implements CompareAble,
Gfo_invk {
    public static final String Invk_XtoStr_fmt = "XtoStr_fmt";
    public static final String Invk_AddDays = "Add_day";
    public static int Timezone_offset_test = Integer.MIN_VALUE;
    Calendar under;
    public static final int Month_base0adj = 1;

    public int compareTo(Object obj) {
        DateAdp comp = (DateAdp)obj;
        return this.under.compareTo(comp.under);
    }

    public String toString() {
        return this.XtoStr_gplx_long();
    }

    @Override
    public Object Invk(GfsCtx ctx, int ikey, String k, GfoMsg m) {
        if (ctx.Match(k, Invk_XtoStr_fmt)) {
            return this.XtoStr_fmt("yyyy-MM-dd HH:mm:ss");
        }
        if (ctx.Match(k, Invk_AddDays)) {
            int days = m.ReadInt("days");
            if (ctx.Deny()) {
                return this;
            }
            return this.Add_day(days);
        }
        return Gfo_invk_.Rv_unhandled;
    }

    public int Segment(int segmentIdx) {
        switch (segmentIdx) {
            case 0: {
                return this.Year();
            }
            case 1: {
                return this.Month();
            }
            case 2: {
                return this.Day();
            }
            case 3: {
                return this.Hour();
            }
            case 4: {
                return this.Minute();
            }
            case 5: {
                return this.Second();
            }
            case 6: {
                return this.Frac();
            }
            case 7: {
                return this.DayOfWeek();
            }
            case 8: {
                return this.WeekOfYear();
            }
            case 9: {
                return this.DayOfYear();
            }
        }
        throw Err_.new_unhandled(segmentIdx);
    }

    public int[] XtoSegAry() {
        int[] rv = new int[]{this.Year(), this.Month(), this.Day(), this.Hour(), this.Minute(), this.Second(), this.Frac()};
        return rv;
    }

    public String XtoStr_gplx() {
        return this.XtoStr_fmt("yyyyMMdd_HHmmss.fff");
    }

    public String XtoStr_gplx_long() {
        return this.XtoStr_fmt("yyyy-MM-dd HH:mm:ss.fff");
    }

    public String XtoStr_fmt_HHmmss() {
        return this.XtoStr_fmt("HH:mm:ss");
    }

    public String XtoStr_fmt_HHmm() {
        return this.XtoStr_fmt("HH:mm");
    }

    public String XtoStr_fmt_yyyy_MM_dd() {
        return this.XtoStr_fmt("yyyy-MM-dd");
    }

    public String XtoStr_fmt_yyyyMMdd_HHmmss() {
        return this.XtoStr_fmt("yyyyMMdd_HHmmss");
    }

    public String XtoStr_fmt_yyyyMMdd_HHmmss_fff() {
        return this.XtoStr_fmt("yyyyMMdd_HHmmss.fff");
    }

    public String XtoStr_fmt_yyyyMMdd_HHmm() {
        return this.XtoStr_fmt("yyyyMMdd_HHmm");
    }

    public String XtoStr_fmt_yyyy_MM_dd_HH_mm() {
        return this.XtoStr_fmt("yyyy-MM-dd HH:mm");
    }

    public String XtoStr_fmt_yyyy_MM_dd_HH_mm_ss() {
        return this.XtoStr_fmt("yyyy-MM-dd HH:mm:ss");
    }

    public String XtoStr_fmt_iso_8561() {
        return this.XtoStr_fmt("yyyy-MM-dd HH:mm:ss");
    }

    public String XtoStr_fmt_iso_8561_w_tz() {
        return this.XtoStr_fmt("yyyy-MM-dd'T'HH:mm:ss'Z'");
    }

    public Calendar UnderDateTime() {
        return this.under;
    }

    public int Year() {
        return this.under.get(1);
    }

    public int Month() {
        return this.under.get(2) + 1;
    }

    public int Day() {
        return this.under.get(5);
    }

    public int Hour() {
        return this.under.get(11);
    }

    public int Minute() {
        return this.under.get(12);
    }

    public int Second() {
        return this.under.get(13);
    }

    public int DayOfWeek() {
        return this.under.get(7) - 1;
    }

    public int DayOfYear() {
        return this.under.get(6);
    }

    public int Timezone_offset() {
        return Timezone_offset_test == Integer.MIN_VALUE ? 0 : Timezone_offset_test;
    }

    public DateAdp XtoUtc() {
        Date date = this.under.getTime();
        TimeZone tz = this.under.getTimeZone();
        long msFromEpochGmt = date.getTime();
        int offsetFromUTC = tz.getOffset(msFromEpochGmt);
        Calendar gmtCal = Calendar.getInstance();
        gmtCal.setTimeInMillis(msFromEpochGmt + (long)(-offsetFromUTC));
        return new DateAdp(gmtCal);
    }

    public DateAdp XtoLocal() {
        Date date = this.under.getTime();
        TimeZone tz = this.under.getTimeZone();
        long msFromEpochGmt = date.getTime();
        int offsetFromUTC = tz.getOffset(msFromEpochGmt);
        Calendar gmtCal = Calendar.getInstance();
        gmtCal.setTimeInMillis(msFromEpochGmt + (long)offsetFromUTC);
        return new DateAdp(gmtCal);
    }

    public long Timestamp_unix() {
        long offsetFromUTC = this.under.getTimeZone().getOffset(0L);
        boolean dst = TimeZone.getDefault().inDaylightTime(this.under.getTime());
        long dst_adj = dst ? 3600000 : 0;
        return (this.under.getTimeInMillis() + offsetFromUTC + dst_adj) / 1000L;
    }

    public int WeekOfYear() {
        return this.under.get(3);
    }

    public int Frac() {
        return this.under.get(14);
    }

    public DateAdp Add_frac(int val) {
        return this.CloneAndAdd(14, val);
    }

    public DateAdp Add_second(int val) {
        return this.CloneAndAdd(13, val);
    }

    public DateAdp Add_minute(int val) {
        return this.CloneAndAdd(12, val);
    }

    public DateAdp Add_hour(int val) {
        return this.CloneAndAdd(10, val);
    }

    public DateAdp Add_day(int val) {
        return this.CloneAndAdd(5, val);
    }

    public DateAdp Add_month(int val) {
        return this.CloneAndAdd(2, val);
    }

    public DateAdp Add_year(int val) {
        return this.CloneAndAdd(1, val);
    }

    DateAdp CloneAndAdd(int field, int val) {
        Calendar clone = (Calendar)this.under.clone();
        clone.add(field, val);
        return new DateAdp(clone);
    }

    public String XtoStr_fmt(String fmt) {
        fmt = fmt.replace("f", "S");
        SimpleDateFormat sdf = new SimpleDateFormat(fmt);
        return sdf.format(this.under.getTime());
    }

    public String XtoStr_tz() {
        SimpleDateFormat sdf = new SimpleDateFormat("Z");
        String time_zone = sdf.format(this.under.getTime());
        return String.valueOf(String_.Mid(time_zone, 0, 3)) + ":" + String_.Mid(time_zone, 3, String_.Len(time_zone));
    }

    public boolean Eq(DateAdp v) {
        DateAdp comp = v;
        return Object_.Eq(this.under.getTimeInMillis(), comp.under.getTimeInMillis());
    }

    public int Diff_days(DateAdp prev) {
        long diff = this.under.getTimeInMillis() - prev.under.getTimeInMillis();
        return (int)(diff / 86400000L);
    }

    public Time_span Diff(DateAdp earlier) {
        long diff = this.under.getTimeInMillis() - earlier.under.getTimeInMillis();
        return Time_span_.fracs_(diff);
    }

    protected DateAdp(Calendar under) {
        this.under = under;
    }

    protected DateAdp(int year, int month, int day, int hour, int minute, int second, int frac) {
        this.under = new GregorianCalendar(year, month - 1, day, hour, minute, second);
        this.under.set(14, frac);
    }
}

