/*
 * Decompiled with CFR 0.152.
 */
package gplx;

import gplx.Bry_;
import gplx.Bry_bfr;
import gplx.Bry_bfr_;
import gplx.ByteAryBfr_fxt;
import gplx.DateAdp;
import gplx.DateAdp_;
import gplx.Float_;
import gplx.Int_;
import gplx.String_;
import gplx.Tfds;
import org.junit.Before;
import org.junit.Test;

public class Bry_bfr_tst {
    private Bry_bfr bb = Bry_bfr_.New();
    private ByteAryBfr_fxt fxt = new ByteAryBfr_fxt();

    @Before
    public void setup() {
        this.bb.Clear();
    }

    @Test
    public void AddByte() {
        this.bb = Bry_bfr_.New_w_size(2);
        this.tst_AddByte("a", "a", 2);
        this.tst_AddByte("b", "ab", 2);
        this.tst_AddByte("c", "abc", 4);
    }

    @Test
    public void AddAry() {
        this.bb = Bry_bfr_.New_w_size(2);
        this.tst_AddByte("abcd", "abcd", 12);
    }

    @Test
    public void Add_byte_repeat() {
        this.bb = Bry_bfr_.New_w_size(2);
        this.tst_Add_byte_repeat((byte)32, 12, String_.Repeat(" ", 12));
    }

    void tst_Add_byte_repeat(byte b, int len, String expd) {
        Tfds.Eq(expd, this.bb.Add_byte_repeat(b, len).To_str_and_clear());
    }

    void tst_AddByte(String s, String expdStr, int expdLen) {
        if (String_.Len(s) == 1) {
            this.bb.Add_byte((byte)String_.CharAt(s, 0));
        } else {
            this.bb.Add(Bry_.new_u8(s));
        }
        Tfds.Eq(expdStr, String_.new_u8(this.bb.To_bry()));
        Tfds.Eq(expdLen, this.bb.Bfr_max());
    }

    @Test
    public void Add_dte() {
        this.tst_AddDte("20110801 221435.987");
    }

    void tst_AddDte(String raw) {
        this.bb.Add_dte(DateAdp_.parse_fmt(raw, "yyyyMMdd HHmmss.fff"));
        Tfds.Eq(raw, String_.new_u8(this.bb.To_bry()));
    }

    @Test
    public void Add_int_variable() {
        this.Add_int_variable(-1);
        this.Add_int_variable(-12);
        this.Add_int_variable(-1234);
        this.Add_int_variable(2);
        this.Add_int_variable(12);
        this.Add_int_variable(1234);
        this.Add_int_variable(123456789);
    }

    @Test
    public void Add_float() {
        this.tst_Add_float(0.0f);
        this.tst_Add_float(0.0f);
    }

    void tst_Add_float(float v) {
        this.bb.Add_float(v);
        Tfds.Eq(Float.valueOf(v), Float.valueOf(Float_.parse(String_.new_u8(this.bb.To_bry()))));
    }

    void Add_int_variable(int val) {
        this.bb.Clear();
        this.bb.Add_int_variable(val);
        Tfds.Eq(val, Int_.parse(String_.new_u8(this.bb.To_bry())));
    }

    @Test
    public void Add_int_fixed_len3() {
        this.tst_Add_int_fixed(123, 3, "123");
    }

    @Test
    public void Add_int_fixed_pad_1() {
        this.tst_Add_int_fixed(2, 1, "2");
    }

    @Test
    public void Add_int_fixed_pad_2() {
        this.tst_Add_int_fixed(2, 2, "02");
    }

    @Test
    public void Add_int_fixed_pad_16() {
        this.tst_Add_int_fixed(2, 16, "0000000000000002");
    }

    @Test
    public void Add_int_fixed_neg() {
        this.tst_Add_int_fixed(-2, 2, "-2");
    }

    @Test
    public void Add_int_fixed_neg_pad1() {
        this.tst_Add_int_fixed(-2, 1, "-");
    }

    @Test
    public void Add_int_fixed_chop_1() {
        this.tst_Add_int_fixed(123, 1, "3");
    }

    @Test
    public void Add_int_fixed_chop_neg() {
        this.tst_Add_int_fixed(-21, 2, "-1");
    }

    void tst_Add_int_fixed(int val, int digits, String expd) {
        Tfds.Eq(expd, String_.new_u8(this.bb.Add_int_fixed(val, digits).To_bry()));
    }

    @Test
    public void Add_long_fixed_len3() {
        this.tst_Add_long_fixed(123L, 3, "123");
    }

    @Test
    public void Add_long_fixed_pad_1() {
        this.tst_Add_long_fixed(2L, 1, "2");
    }

    @Test
    public void Add_long_fixed_pad_2() {
        this.tst_Add_long_fixed(2L, 2, "02");
    }

    @Test
    public void Add_long_fixed_pad_16() {
        this.tst_Add_long_fixed(2L, 16, "0000000000000002");
    }

    @Test
    public void Add_long_fixed_neg() {
        this.tst_Add_long_fixed(-2L, 2, "-2");
    }

    @Test
    public void Add_long_fixed_neg_pad1() {
        this.tst_Add_long_fixed(-2L, 1, "-");
    }

    @Test
    public void Add_long_fixed_chop_1() {
        this.tst_Add_long_fixed(123L, 1, "3");
    }

    @Test
    public void Add_long_fixed_chop_neg() {
        this.tst_Add_long_fixed(-21L, 2, "-1");
    }

    @Test
    public void Add_long_fixed_large() {
        this.tst_Add_long_fixed(123456789012345L, 15, "123456789012345");
    }

    void tst_Add_long_fixed(long val, int digits, String expd) {
        Tfds.Eq(expd, String_.new_u8(this.bb.Add_long_fixed(val, digits).To_bry()));
    }

    @Test
    public void AddDte_short() {
        this.tst_AddDte_short("2010-08-26T22:38:36Z");
    }

    void tst_AddDte_short(String raw) {
    }

    @Test
    public void To_bry_and_clear_and_trim() {
        this.tst_XtoAryAndClearAndTrim("a", "a");
        this.tst_XtoAryAndClearAndTrim(" a ", "a");
        this.tst_XtoAryAndClearAndTrim(" a b ", "a b");
        this.tst_XtoAryAndClearAndTrim("  ", "");
    }

    void tst_XtoAryAndClearAndTrim(String raw, String expd) {
        this.bb.Add_str_u8(raw);
        Tfds.Eq(expd, String_.new_u8(this.bb.To_bry_and_clear_and_trim()));
    }

    @Test
    public void XtoInt() {
        this.tst_XtoInt("123", 123);
        this.tst_XtoInt("a", Integer.MIN_VALUE);
        this.tst_XtoInt("9999999999", Integer.MIN_VALUE);
    }

    void tst_XtoInt(String raw, int expd) {
        this.bb.Add_str_u8(raw);
        Tfds.Eq(expd, this.bb.To_int_and_clear(Integer.MIN_VALUE));
    }

    static long Pow38_to(int year, int month, int day, int hour, int minute, int second, int frac) {
        return (long)year << 26 | ((long)month & 0xFL) << 22 | ((long)day & 0x1FL) << 17 | ((long)hour & 0x1FL) << 12 | ((long)minute & 0x3FL) << 6 | (long)second & 0x3FL;
    }

    static DateAdp Pow38_by(long v) {
        int year = (int)(v >> 26);
        int month = (int)(v >> 22 & 0xFL);
        int day = (int)(v >> 17 & 0x1FL);
        int hour = (int)(v >> 12 & 0x1FL);
        int minute = (int)(v >> 6 & 0x3FL);
        int second = (int)(v & 0x3FL);
        return DateAdp_.new_(year, month, day, hour, minute, second, 0);
    }

    @Test
    public void Add_bfr_trimEnd_and_clear() {
        this.tst_Add_bfr_trimEnd_and_clear("a ", "a");
    }

    void tst_Add_bfr_trimEnd_and_clear(String raw, String expd) {
        Bry_bfr tmp = Bry_bfr_.New().Add_str_u8(raw);
        Tfds.Eq(expd, this.bb.Add_bfr_trim_and_clear(tmp, false, true).To_str_and_clear());
    }

    @Test
    public void Add_bfr_trimAll_and_clear() {
        this.tst_Add_bfr_trimAll_and_clear(" a ", "a");
        this.tst_Add_bfr_trimAll_and_clear(" a b ", "a b");
        this.tst_Add_bfr_trimAll_and_clear("a", "a");
        this.tst_Add_bfr_trimAll_and_clear("", "");
    }

    void tst_Add_bfr_trimAll_and_clear(String raw, String expd) {
        Bry_bfr tmp = Bry_bfr_.New().Add_str_u8(raw);
        Tfds.Eq(expd, this.bb.Add_bfr_trim_and_clear(tmp, true, true).To_str_and_clear());
    }

    @Test
    public void Add_int_pad_bgn() {
        this.fxt.Test_Add_int_pad_bgn((byte)48, 3, 0, "000");
        this.fxt.Test_Add_int_pad_bgn((byte)48, 3, 1, "001");
        this.fxt.Test_Add_int_pad_bgn((byte)48, 3, 10, "010");
        this.fxt.Test_Add_int_pad_bgn((byte)48, 3, 100, "100");
        this.fxt.Test_Add_int_pad_bgn((byte)48, 3, 1000, "1000");
    }

    @Test
    public void Add_bry_escape() {
        this.fxt.Test__add_bry_escape("abc", "abc");
        this.fxt.Test__add_bry_escape("a'bc", "a''bc");
        this.fxt.Test__add_bry_escape("a'b'c", "a''b''c");
        this.fxt.Test__add_bry_escape("abc", 1, 2, "b");
    }

    @Test
    public void Add_bry_escape_html() {
        this.fxt.Test__add_bry_escape_html("abc", "abc");
        this.fxt.Test__add_bry_escape_html("a&\"'<>b", "a&amp;&quot;&#39;&lt;&gt;b");
        this.fxt.Test__add_bry_escape_html("a&b&c", "a&amp;b&amp;c");
        this.fxt.Test__add_bry_escape_html("abc", 1, 2, "b");
    }

    @Test
    public void Insert_at() {
        this.fxt.Test_Insert_at("abcd", 0, "xyz", "xyzabcd");
        this.fxt.Test_Insert_at("abcd", 4, "xyz", "abcdxyz");
        this.fxt.Test_Insert_at("abcd", 2, "xyz", "abxyzcd");
        this.fxt.Test_Insert_at("abcd", 2, "xyz", 1, 2, "abycd");
    }

    @Test
    public void Delete_rng() {
        this.fxt.Test_Delete_rng("abcd", 0, 2, "cd");
        this.fxt.Test_Delete_rng("abcd", 2, 4, "ab");
        this.fxt.Test_Delete_rng("abcd", 1, 3, "ad");
    }

    @Test
    public void Delete_rng_to_bgn() {
        this.fxt.Test_Delete_rng_to_bgn("abcd", 2, "cd");
    }

    @Test
    public void Delete_rng_to_end() {
        this.fxt.Test_Delete_rng_to_end("abcd", 2, "ab");
    }

    @Test
    public void To_bry_ary_and_clear() {
        this.fxt.Test__to_bry_ary_and_clear("", new String[0]);
        this.fxt.Test__to_bry_ary_and_clear("a", "a");
        this.fxt.Test__to_bry_ary_and_clear("a\nb\nc", "a", "b", "c");
        this.fxt.Test__to_bry_ary_and_clear("a\n", "a");
    }
}

