/*
 * Decompiled with CFR 0.152.
 */
package gplx;

import gplx.Bool_;
import gplx.Bry_;
import gplx.Bry_find_;
import gplx.Byte_;
import gplx.Byte_ascii;
import gplx.DateAdp;
import gplx.Double_;
import gplx.Err_;
import gplx.Float_;
import gplx.Int_;
import gplx.Io_url;
import gplx.Long_;
import gplx.Object_;
import gplx.String_;
import gplx.core.brys.Bfr_arg;
import gplx.core.brys.Bry_bfr_mkr_mgr;
import gplx.core.encoders.Base85_;
import gplx.core.intls.Utf16_;
import gplx.core.primitives.Bry_obj_ref;
import gplx.core.primitives.Int_list;

public class Bry_bfr {
    private Bry_bfr_mkr_mgr mkr_mgr;
    private int reset;
    private byte[] bfr;
    private int bfr_len;
    private static final boolean[] Trim_end_ws_ary = Bry_bfr.Trim_end_ws_new();
    private int mkr_idx = -1;
    private int bfr_max;

    public byte[] Bfr() {
        return this.bfr;
    }

    public int Len() {
        return this.bfr_len;
    }

    public boolean Len_eq_0() {
        return this.bfr_len == 0;
    }

    public boolean Len_gt_0() {
        return this.bfr_len > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void Bfr_init(byte[] bfr, int bfr_len) {
        Bry_bfr bry_bfr = this;
        synchronized (bry_bfr) {
            this.bfr = bfr;
            this.bfr_len = bfr_len;
            this.bfr_max = bfr.length;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Bry_bfr Mkr_rls() {
        if (this.mkr_mgr != null) {
            Bry_bfr bry_bfr = this;
            synchronized (bry_bfr) {
                this.mkr_mgr.Rls(this.mkr_idx);
                this.mkr_mgr = null;
                this.mkr_idx = -1;
            }
        }
        return this;
    }

    public void Clear_and_rls() {
        this.Clear();
        this.Mkr_rls();
    }

    public String To_str_and_rls() {
        return String_.new_u8(this.To_bry_and_rls());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] To_bry_and_rls() {
        byte[] rv = null;
        byte[] byArray = this.bfr;
        synchronized (this.bfr) {
            rv = this.To_bry();
            this.Clear();
            if (this.reset > 0) {
                this.Reset_if_gt(this.reset);
            }
            Bry_bfr bry_bfr = this;
            synchronized (bry_bfr) {
                this.mkr_mgr.Rls(this.mkr_idx);
                this.mkr_idx = -1;
                this.mkr_mgr = null;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return rv;
        }
    }

    public Bry_bfr Reset_(int v) {
        this.reset = v;
        return this;
    }

    public Bry_bfr Reset_if_gt(int limit) {
        if (this.bfr_max > limit) {
            this.bfr_max = limit;
            this.bfr = new byte[limit];
        }
        this.bfr_len = 0;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Bry_bfr Clear() {
        Bry_bfr bry_bfr = this;
        synchronized (bry_bfr) {
            this.bfr_len = 0;
        }
        return this;
    }

    public Bry_bfr ClearAndReset() {
        this.bfr_len = 0;
        if (this.reset > 0) {
            this.Reset_if_gt(this.reset);
        }
        return this;
    }

    public byte Get_at_last_or_nil_if_empty() {
        return this.bfr_len == 0 ? (byte)0 : this.bfr[this.bfr_len - 1];
    }

    public Bry_bfr Add_safe(byte[] val) {
        return val == null ? this : this.Add(val);
    }

    public Bry_bfr Add(byte[] val) {
        int val_len = val.length;
        if (this.bfr_len + val_len > this.bfr_max) {
            this.Resize((this.bfr_max + val_len) * 2);
        }
        Bry_.Copy_by_pos(val, 0, val_len, this.bfr, this.bfr_len);
        this.bfr_len += val_len;
        return this;
    }

    public Bry_bfr Add_mid(byte[] val, int bgn, int end) {
        int len = end - bgn;
        if (len < 0) {
            throw Err_.new_wo_type("negative len", "bgn", bgn, "end", end, "excerpt", String_.new_u8__by_len(val, bgn, bgn + 16));
        }
        if (this.bfr_len + len > this.bfr_max) {
            this.Resize((this.bfr_max + len) * 2);
        }
        Bry_.Copy_by_pos(val, bgn, end, this.bfr, this.bfr_len);
        this.bfr_len += len;
        return this;
    }

    public Bry_bfr Add_mid_w_swap(byte[] val, int bgn, int end, byte swap_src, byte swap_trg) {
        int len = end - bgn;
        if (len < 0) {
            throw Err_.new_wo_type("negative len", "bgn", bgn, "end", end, "excerpt", String_.new_u8__by_len(val, bgn, bgn + 16));
        }
        if (this.bfr_len + len > this.bfr_max) {
            this.Resize((this.bfr_max + len) * 2);
        }
        int val_len = end - bgn;
        int i = 0;
        while (i < val_len) {
            byte b = val[i + bgn];
            if (b == swap_src) {
                b = swap_trg;
            }
            this.bfr[i + this.bfr_len] = b;
            ++i;
        }
        this.bfr_len += len;
        return this;
    }

    public Bry_bfr Add_bry_ref_obj(Bry_obj_ref v) {
        v.Bfr_arg__add(this);
        return this;
    }

    public Bry_bfr Add_bfr_and_preserve(Bry_bfr src) {
        int len = src.bfr_len;
        if (this.bfr_len + len > this.bfr_max) {
            this.Resize((this.bfr_max + len) * 2);
        }
        Bry_.Copy_by_pos(src.bfr, 0, len, this.bfr, this.bfr_len);
        this.bfr_len += len;
        return this;
    }

    public Bry_bfr Add_bfr_and_clear(Bry_bfr src) {
        this.Add_bfr_and_preserve(src);
        src.ClearAndReset();
        return this;
    }

    public Bry_bfr Add_bfr_or_mid(boolean escaped, Bry_bfr tmp_bfr, byte[] src, int src_bgn, int src_end) {
        return escaped ? this.Add_bfr_and_clear(tmp_bfr) : this.Add_mid(src, src_bgn, src_end);
    }

    public Bry_bfr Add_bfr_trim_and_clear(Bry_bfr src, boolean trim_bgn, boolean trim_end) {
        return this.Add_bfr_trim_and_clear(src, trim_bgn, trim_end, Bry_.Trim_ary_ws);
    }

    public Bry_bfr Add_bfr_trim_and_clear(Bry_bfr src, boolean trim_bgn, boolean trim_end, byte[] trim_ary) {
        byte b;
        int i;
        int src_len = src.bfr_len;
        if (this.bfr_len + src_len > this.bfr_max) {
            this.Resize((this.bfr_max + src_len) * 2);
        }
        byte[] src_bry = src.Bfr();
        int src_bgn = 0;
        int src_end = src_len;
        boolean all_ws = true;
        if (trim_bgn) {
            i = 0;
            while (i < src_len) {
                b = src_bry[i];
                if (trim_ary[b & 0xFF] == 0) {
                    src_bgn = i;
                    i = src_len;
                    all_ws = false;
                }
                ++i;
            }
            if (all_ws) {
                return this;
            }
        }
        if (trim_end) {
            i = src_len - 1;
            while (i > -1) {
                b = src_bry[i];
                if (trim_ary[b & 0xFF] == 0) {
                    src_end = i + 1;
                    i = -1;
                    all_ws = false;
                }
                --i;
            }
            if (all_ws) {
                return this;
            }
        }
        src_len = src_end - src_bgn;
        Bry_.Copy_by_pos(src.bfr, src_bgn, src_end, this.bfr, this.bfr_len);
        this.bfr_len += src_len;
        src.Clear();
        return this;
    }

    public Bry_bfr Add_byte_as_a7(byte v) {
        return this.Add_byte((byte)(v + 48));
    }

    public Bry_bfr Add_byte_eq() {
        return this.Add_byte((byte)61);
    }

    public Bry_bfr Add_byte_pipe() {
        return this.Add_byte((byte)124);
    }

    public Bry_bfr Add_byte_comma() {
        return this.Add_byte((byte)44);
    }

    public Bry_bfr Add_byte_semic() {
        return this.Add_byte((byte)59);
    }

    public Bry_bfr Add_byte_apos() {
        return this.Add_byte((byte)39);
    }

    public Bry_bfr Add_byte_slash() {
        return this.Add_byte((byte)47);
    }

    public Bry_bfr Add_byte_backslash() {
        return this.Add_byte((byte)92);
    }

    public Bry_bfr Add_byte_quote() {
        return this.Add_byte((byte)34);
    }

    public Bry_bfr Add_byte_space() {
        return this.Add_byte((byte)32);
    }

    public Bry_bfr Add_byte_nl() {
        return this.Add_byte((byte)10);
    }

    public Bry_bfr Add_byte_dot() {
        return this.Add_byte((byte)46);
    }

    public Bry_bfr Add_byte_colon() {
        return this.Add_byte((byte)58);
    }

    public Bry_bfr Add_byte(byte val) {
        int new_pos = this.bfr_len + 1;
        if (new_pos > this.bfr_max) {
            this.Resize(this.bfr_len * 2);
        }
        this.bfr[this.bfr_len] = val;
        this.bfr_len = new_pos;
        return this;
    }

    public Bry_bfr Add_byte_repeat(byte b, int len) {
        if (this.bfr_len + len > this.bfr_max) {
            this.Resize((this.bfr_max + len) * 2);
        }
        int i = 0;
        while (i < len) {
            this.bfr[i + this.bfr_len] = b;
            ++i;
        }
        this.bfr_len += len;
        return this;
    }

    public Bry_bfr Add_byte_if_not_last(byte b) {
        if (this.bfr_len == 0 || this.bfr_len > 0 && this.bfr[this.bfr_len - 1] == b) {
            return this;
        }
        this.Add_byte(b);
        return this;
    }

    public Bry_bfr Add_byte_variable(byte v) {
        return this.Add_int_variable(v);
    }

    public Bry_bfr Add_short_variable(short v) {
        return this.Add_int_variable(v);
    }

    public Bry_bfr Add_u8_int(int val) {
        if (this.bfr_len + 4 > this.bfr_max) {
            this.Resize((this.bfr_max + 4) * 2);
        }
        int utf8_len = Utf16_.Encode_int(val, this.bfr, this.bfr_len);
        this.bfr_len += utf8_len;
        return this;
    }

    public Bry_bfr Add_bool(boolean v) {
        return this.Add(v ? Bool_.True_bry : Bool_.False_bry);
    }

    public Bry_bfr Add_int_bool(boolean v) {
        return this.Add_int_fixed(v ? 1 : 0, 1);
    }

    public Bry_bfr Add_int_variable(int val) {
        if (val < 0) {
            this.Add(Int_.To_bry(val));
            return this;
        }
        int log10 = Int_.Log10(val);
        int slots = val > -1 ? log10 + 1 : log10 * -1 + 2;
        return this.Add_int(val, log10, slots);
    }

    public Bry_bfr Add_int_pad_bgn(byte pad_byte, int str_len, int val) {
        int digit_len = Int_.DigitCount(val);
        int pad_len = str_len - digit_len;
        if (pad_len > 0) {
            this.Add_byte_repeat(pad_byte, pad_len);
        }
        this.Add_int_fixed(val, digit_len);
        return this;
    }

    public Bry_bfr Add_int_digits(int digits, int val) {
        return this.Add_int(val, Int_.Log10(val), digits);
    }

    public Bry_bfr Add_int_fixed(int val, int digits) {
        return this.Add_int(val, Int_.Log10(val), digits);
    }

    public Bry_bfr Add_int(int val, int valLog, int arySlots) {
        int aryBgn = this.bfr_len;
        int aryEnd = this.bfr_len + arySlots;
        if (aryEnd > this.bfr_max) {
            this.Resize(aryEnd * 2);
        }
        if (val < 0) {
            this.bfr[aryBgn++] = 45;
            val *= -1;
            valLog *= -1;
            --arySlots;
        }
        if (valLog >= arySlots) {
            val %= Int_.Log10Ary[arySlots];
        }
        int i = 0;
        while (i < arySlots) {
            int logIdx = arySlots - i - 1;
            int div = logIdx < Int_.Log10AryLen ? Int_.Log10Ary[logIdx] : Integer.MAX_VALUE;
            this.bfr[aryBgn + i] = (byte)(val / div + 48);
            val %= div;
            ++i;
        }
        this.bfr_len = aryEnd;
        return this;
    }

    public Bry_bfr Add_long_variable(long v) {
        int digitCount = Long_.DigitCount(v);
        return this.Add_long(v, digitCount, digitCount);
    }

    public Bry_bfr Add_long_fixed(long val, int digits) {
        return this.Add_long(val, Long_.DigitCount(val), digits);
    }

    protected Bry_bfr Add_long(long val, int digitCount, int arySlots) {
        int aryBgn = this.bfr_len;
        int aryEnd = this.bfr_len + arySlots;
        if (aryEnd > this.bfr_max) {
            this.Resize(aryEnd * 2);
        }
        if (val < 0L) {
            this.bfr[aryBgn++] = 45;
            val *= -1L;
            --arySlots;
        }
        if (digitCount >= arySlots) {
            val %= Long_.Log10Ary[arySlots];
        }
        int i = 0;
        while (i < arySlots) {
            int logIdx = arySlots - i - 1;
            long div = logIdx < 21 ? Long_.Log10Ary[logIdx] : Long.MAX_VALUE;
            this.bfr[aryBgn + i] = (byte)(val / div + 48L);
            val %= div;
            ++i;
        }
        this.bfr_len = aryEnd;
        return this;
    }

    public Bry_bfr Add_bry_comma(byte[] v) {
        return this.Add_bry((byte)44, v);
    }

    public Bry_bfr Add_bry(byte dlm, byte[] v) {
        if (v == null) {
            return this;
        }
        int v_len = v.length;
        int i = 0;
        while (i < v_len) {
            if (i != 0) {
                this.Add_byte(dlm);
            }
            this.Add_int_variable(v[i]);
            ++i;
        }
        return this;
    }

    public Bry_bfr Add_bry_escape(byte quote_byte, byte[] escape, byte[] val, int bgn, int end) {
        boolean clean = true;
        int i = bgn;
        while (i < end) {
            byte b = val[i];
            if (clean) {
                if (b == quote_byte) {
                    clean = false;
                    this.Add_mid(val, bgn, i);
                    this.Add(escape);
                }
            } else if (b == quote_byte) {
                this.Add(escape);
            } else {
                this.Add_byte(b);
            }
            ++i;
        }
        if (clean) {
            this.Add_mid(val, bgn, end);
        }
        return this;
    }

    public Bry_bfr Add_bry_many(byte[] ... ary) {
        int len = ary.length;
        int i = 0;
        while (i < len) {
            byte[] bry = ary[i];
            if (bry != null && bry.length > 0) {
                this.Add(bry);
            }
            ++i;
        }
        return this;
    }

    public Bry_bfr Add_bry_escape_html(byte[] val) {
        if (val == null) {
            return this;
        }
        return this.Add_bry_escape_html(val, 0, val.length);
    }

    public Bry_bfr Add_bry_escape_html(byte[] val, int bgn, int end) {
        Bry_.Escape_html(this, false, val, bgn, end);
        return this;
    }

    public Bry_bfr Add_bry_escape_xml(byte[] val, int bgn, int end) {
        Bry_.Escape_html(this, true, val, bgn, end);
        return this;
    }

    public Bry_bfr Add_str_u8_w_nl(String s) {
        this.Add_str_u8(s);
        return this.Add_byte_nl();
    }

    public Bry_bfr Add_str_u8_null(String s) {
        return this.Add_str_u8(s == null ? "<<NULL>>" : s);
    }

    public Bry_bfr Add_str_u8(String str) {
        try {
            int str_len = str.length();
            int bry_len = Bry_.new_u8__by_len(str, str_len);
            if (this.bfr_len + bry_len > this.bfr_max) {
                this.Resize((this.bfr_max + bry_len) * 2);
            }
            Bry_.new_u8__write(str, str_len, this.bfr, this.bfr_len);
            this.bfr_len += bry_len;
            return this;
        }
        catch (Exception e) {
            throw Err_.new_exc(e, "core", "invalid UTF-8 sequence", "s", str);
        }
    }

    public Bry_bfr Add_str_u8_many(String ... ary) {
        int len = ary.length;
        int i = 0;
        while (i < len) {
            this.Add_str_u8(ary[i]);
            ++i;
        }
        return this;
    }

    public Bry_bfr Add_str_u8_fmt(String fmt, Object ... args) {
        this.Add_str_u8(String_.Format(fmt, args));
        return this;
    }

    public Bry_bfr Add_str_a7_null(String s) {
        return this.Add_str_a7(s == null ? "<<NULL>>" : s);
    }

    public Bry_bfr Add_str_a7_w_nl(String s) {
        this.Add_str_a7(s);
        return this.Add_byte_nl();
    }

    public Bry_bfr Add_str_a7(String str) {
        try {
            int bry_len = str.length();
            if (this.bfr_len + bry_len > this.bfr_max) {
                this.Resize((this.bfr_max + bry_len) * 2);
            }
            int i = 0;
            while (i < bry_len) {
                int c = str.charAt(i);
                if (c > 128) {
                    c = 63;
                }
                this.bfr[i + this.bfr_len] = (byte)c;
                ++i;
            }
            this.bfr_len += bry_len;
            return this;
        }
        catch (Exception e) {
            throw Err_.new_exc(e, "core", "invalid UTF-8 sequence", "s", str);
        }
    }

    public Bry_bfr Add_kv_dlm(boolean line, String key, Object val) {
        this.Add_str_a7(key).Add_byte_colon().Add_byte_space();
        this.Add(Bry_.new_u8(Object_.Xto_str_strict_or_null_mark(val)));
        this.Add_byte(line ? (byte)10 : 9);
        return this;
    }

    public Bry_bfr Add_float(float f) {
        this.Add_str_a7(Float_.To_str(f));
        return this;
    }

    public Bry_bfr Add_double(double v) {
        this.Add_str_a7(Double_.To_str(v));
        return this;
    }

    public Bry_bfr Add_dte(DateAdp val) {
        return this.Add_dte_segs(val.Year(), val.Month(), val.Day(), val.Hour(), val.Minute(), val.Second(), val.Frac());
    }

    public Bry_bfr Add_dte_segs(int y, int M, int d, int H, int m, int s, int f) {
        if (this.bfr_len + 19 > this.bfr_max) {
            this.Resize((this.bfr_len + 19) * 2);
        }
        this.bfr[this.bfr_len + 0] = (byte)(y / 1000 + 48);
        this.bfr[this.bfr_len + 1] = (byte)((y %= 1000) / 100 + 48);
        this.bfr[this.bfr_len + 2] = (byte)((y %= 100) / 10 + 48);
        this.bfr[this.bfr_len + 3] = (byte)((y %= 10) + 48);
        this.bfr[this.bfr_len + 4] = (byte)(M / 10 + 48);
        this.bfr[this.bfr_len + 5] = (byte)((M %= 10) + 48);
        this.bfr[this.bfr_len + 6] = (byte)(d / 10 + 48);
        this.bfr[this.bfr_len + 7] = (byte)((d %= 10) + 48);
        this.bfr[this.bfr_len + 8] = 32;
        this.bfr[this.bfr_len + 9] = (byte)(H / 10 + 48);
        this.bfr[this.bfr_len + 10] = (byte)((H %= 10) + 48);
        this.bfr[this.bfr_len + 11] = (byte)(m / 10 + 48);
        this.bfr[this.bfr_len + 12] = (byte)((m %= 10) + 48);
        this.bfr[this.bfr_len + 13] = (byte)(s / 10 + 48);
        this.bfr[this.bfr_len + 14] = (byte)((s %= 10) + 48);
        this.bfr[this.bfr_len + 15] = 46;
        this.bfr[this.bfr_len + 16] = (byte)(f / 100 + 48);
        this.bfr[this.bfr_len + 17] = (byte)((f %= 100) / 10 + 48);
        this.bfr[this.bfr_len + 18] = (byte)((f %= 10) + 48);
        this.bfr_len += 19;
        return this;
    }

    public Bry_bfr Add_dte_utc(int y, int M, int d, int H, int m, int s, int f) {
        if (this.bfr_len + 20 > this.bfr_max) {
            this.Resize((this.bfr_len + 20) * 2);
        }
        this.bfr[this.bfr_len + 0] = (byte)(y / 1000 + 48);
        this.bfr[this.bfr_len + 1] = (byte)((y %= 1000) / 100 + 48);
        this.bfr[this.bfr_len + 2] = (byte)((y %= 100) / 10 + 48);
        this.bfr[this.bfr_len + 3] = (byte)((y %= 10) + 48);
        this.bfr[this.bfr_len + 4] = 45;
        this.bfr[this.bfr_len + 5] = (byte)(M / 10 + 48);
        this.bfr[this.bfr_len + 6] = (byte)((M %= 10) + 48);
        this.bfr[this.bfr_len + 7] = 45;
        this.bfr[this.bfr_len + 8] = (byte)(d / 10 + 48);
        this.bfr[this.bfr_len + 9] = (byte)((d %= 10) + 48);
        this.bfr[this.bfr_len + 10] = 84;
        this.bfr[this.bfr_len + 11] = (byte)(H / 10 + 48);
        this.bfr[this.bfr_len + 12] = (byte)((H %= 10) + 48);
        this.bfr[this.bfr_len + 13] = 58;
        this.bfr[this.bfr_len + 14] = (byte)(m / 10 + 48);
        this.bfr[this.bfr_len + 15] = (byte)((m %= 10) + 48);
        this.bfr[this.bfr_len + 16] = 58;
        this.bfr[this.bfr_len + 17] = (byte)(s / 10 + 48);
        this.bfr[this.bfr_len + 18] = (byte)((s %= 10) + 48);
        this.bfr[this.bfr_len + 19] = 90;
        this.bfr_len += 20;
        return this;
    }

    public Bry_bfr Add_swap_ws(byte[] src) {
        return this.Add_swap_ws(src, 0, src.length);
    }

    public Bry_bfr Add_swap_ws(byte[] src, int bgn, int end) {
        int len = end - bgn;
        if (this.bfr_len + len * 2 > this.bfr_max) {
            this.Resize((this.bfr_max + len * 2) * 2);
        }
        int i = bgn;
        while (i < end) {
            byte b = src[i];
            switch (b) {
                case 10: {
                    this.bfr[this.bfr_len] = 92;
                    this.bfr[this.bfr_len + 1] = 110;
                    this.bfr_len += 2;
                    break;
                }
                case 9: {
                    this.bfr[this.bfr_len] = 92;
                    this.bfr[this.bfr_len + 1] = 116;
                    this.bfr_len += 2;
                    break;
                }
                case 92: {
                    this.bfr[this.bfr_len] = 92;
                    this.bfr[this.bfr_len + 1] = 92;
                    this.bfr_len += 2;
                    break;
                }
                default: {
                    this.bfr[this.bfr_len] = b;
                    ++this.bfr_len;
                }
            }
            ++i;
        }
        return this;
    }

    public Bry_bfr Add_str_pad_space_bgn(String v, int pad_max) {
        return this.Add_str_pad_space(v, pad_max, false);
    }

    public Bry_bfr Add_str_pad_space_end(String v, int pad_max) {
        return this.Add_str_pad_space(v, pad_max, true);
    }

    Bry_bfr Add_str_pad_space(String v, int pad_max, boolean pad_end) {
        int pad_len;
        byte[] v_bry = Bry_.new_u8(v);
        if (pad_end) {
            this.Add(v_bry);
        }
        if ((pad_len = pad_max - v_bry.length) > 0) {
            this.Add_byte_repeat((byte)32, pad_len);
        }
        if (!pad_end) {
            this.Add(v_bry);
        }
        return this;
    }

    public Bry_bfr Add_obj(Object o) {
        if (o == null) {
            return this;
        }
        Class<?> o_type = o.getClass();
        if (o_type == byte[].class) {
            this.Add((byte[])o);
        } else if (o_type == Integer.class) {
            this.Add_int_variable(Int_.cast(o));
        } else if (o_type == Byte.class) {
            this.Add_byte(Byte_.cast(o));
        } else if (o_type == Long.class) {
            this.Add_long_variable(Long_.cast(o));
        } else if (o_type == String.class) {
            this.Add_str_u8((String)o);
        } else if (o_type == Bry_bfr.class) {
            this.Add_bfr_and_preserve((Bry_bfr)o);
        } else if (o_type == DateAdp.class) {
            this.Add_dte((DateAdp)o);
        } else if (o_type == Io_url.class) {
            this.Add(((Io_url)o).RawBry());
        } else if (o_type == Boolean.class) {
            this.Add_yn(Bool_.Cast(o));
        } else if (o_type == Double.class) {
            this.Add_double(Double_.cast(o));
        } else if (o_type == Float.class) {
            this.Add_float(Float_.cast(o));
        } else {
            ((Bfr_arg)o).Bfr_arg__add(this);
        }
        return this;
    }

    public Bry_bfr Add_obj_strict(Object o) {
        if (o == null) {
            return this;
        }
        Class<?> o_type = o.getClass();
        if (o_type == byte[].class) {
            this.Add((byte[])o);
        } else if (o_type == Integer.class) {
            this.Add_int_variable(Int_.cast(o));
        } else if (o_type == Byte.class) {
            this.Add_byte(Byte_.cast(o));
        } else if (o_type == Long.class) {
            this.Add_long_variable(Long_.cast(o));
        } else if (o_type == String.class) {
            this.Add_str_u8((String)o);
        } else if (o_type == Bry_bfr.class) {
            this.Add_bfr_and_preserve((Bry_bfr)o);
        } else if (o_type == DateAdp.class) {
            this.Add_dte((DateAdp)o);
        } else if (o_type == Io_url.class) {
            this.Add(((Io_url)o).RawBry());
        } else if (o_type == Boolean.class) {
            this.Add_bool(Bool_.Cast(o));
        } else if (o_type == Double.class) {
            this.Add_double(Double_.cast(o));
        } else if (o_type == Float.class) {
            this.Add_float(Float_.cast(o));
        } else {
            ((Bfr_arg)o).Bfr_arg__add(this);
        }
        return this;
    }

    public Bry_bfr Add_yn(boolean v) {
        this.Add_byte(v ? (byte)121 : 110);
        return this;
    }

    public Bry_bfr Add_base85_len_5(int v) {
        return this.Add_base85(v, 5);
    }

    public Bry_bfr Add_base85(int v, int pad) {
        int new_len = this.bfr_len + pad;
        if (new_len > this.bfr_max) {
            this.Resize(new_len * 2);
        }
        Base85_.Set_bry(v, this.bfr, this.bfr_len, pad);
        this.bfr_len = new_len;
        return this;
    }

    public boolean Match_end_byt(byte b) {
        return this.bfr_len == 0 ? false : this.bfr[this.bfr_len - 1] == b;
    }

    public boolean Match_end_byt_nl_or_bos() {
        return this.bfr_len == 0 ? true : this.bfr[this.bfr_len - 1] == 10;
    }

    public boolean Match_end_ary(byte[] ary) {
        return Bry_.Match(this.bfr, this.bfr_len - ary.length, this.bfr_len, ary);
    }

    public Bry_bfr Insert_at(int add_pos, byte[] add_bry) {
        return this.Insert_at(add_pos, add_bry, 0, add_bry.length);
    }

    public Bry_bfr Insert_at(int add_pos, byte[] add_bry, int add_bgn, int add_end) {
        int add_len = add_end - add_bgn;
        int new_max = this.bfr_max + add_len;
        byte[] new_bfr = new byte[new_max];
        if (add_pos > 0) {
            Bry_.Copy_by_pos(this.bfr, 0, add_pos, new_bfr, 0);
        }
        Bry_.Copy_by_pos(add_bry, add_bgn, add_end, new_bfr, add_pos);
        Bry_.Copy_by_pos(this.bfr, add_pos, this.bfr_len, new_bfr, add_pos + add_len);
        this.bfr = new_bfr;
        this.bfr_len += add_len;
        this.bfr_max = new_max;
        return this;
    }

    public Bry_bfr Delete_rng_to_bgn(int pos) {
        return this.Delete_rng(0, pos);
    }

    public Bry_bfr Delete_rng_to_end(int pos) {
        return this.Delete_rng(pos, this.bfr_len);
    }

    public Bry_bfr Delete_rng(int rng_bgn, int rng_end) {
        int rng_len = rng_end - rng_bgn;
        Bry_.Copy_by_pos(this.bfr, rng_end, this.bfr_len, this.bfr, rng_bgn);
        this.bfr_len -= rng_len;
        return this;
    }

    public Bry_bfr Del_by_1() {
        --this.bfr_len;
        this.bfr[this.bfr_len] = 0;
        return this;
    }

    public Bry_bfr Del_by(int count) {
        int new_len = this.bfr_len - count;
        if (new_len > -1) {
            this.bfr_len = new_len;
        }
        return this;
    }

    public Bry_bfr Trim_end(byte trim_byte) {
        if (this.bfr_len == 0) {
            return this;
        }
        int count = 0;
        int i = this.bfr_len - 1;
        while (i > -1) {
            byte b = this.bfr[i];
            if (b != trim_byte) break;
            ++count;
            --i;
        }
        if (count > 0) {
            this.Del_by(count);
        }
        return this;
    }

    public Bry_bfr Trim_end_ws() {
        if (this.bfr_len == 0) {
            return this;
        }
        int count = 0;
        int i = this.bfr_len - 1;
        while (i > -1) {
            byte b = this.bfr[i];
            if (!Trim_end_ws_ary[b]) break;
            ++count;
            --i;
        }
        if (count > 0) {
            this.Del_by(count);
        }
        return this;
    }

    private static boolean[] Trim_end_ws_new() {
        boolean[] rv = new boolean[256];
        rv[32] = true;
        rv[9] = true;
        rv[10] = true;
        rv[13] = true;
        rv[11] = true;
        return rv;
    }

    public Bry_bfr Concat_skip_empty(byte[] dlm, byte[] ... ary) {
        int ary_len = ary.length;
        int i = 0;
        while (i < ary_len) {
            byte[] itm = ary[i];
            boolean itm_has_bytes = Bry_.Len_gt_0(itm);
            if (i != 0 && itm_has_bytes && this.bfr_len > 0) {
                this.Add(dlm);
            }
            if (itm_has_bytes) {
                this.Add(itm);
            }
            ++i;
        }
        return this;
    }

    public boolean Eq(byte b) {
        return this.bfr_len == 1 && this.bfr[0] == b;
    }

    public byte[] To_bry(int bgn, int end) {
        return this.bfr_len == 0 ? Bry_.Empty : Bry_.Mid(this.bfr, bgn, end);
    }

    public byte[] To_bry() {
        return this.bfr_len == 0 ? Bry_.Empty : Bry_.Mid(this.bfr, 0, this.bfr_len);
    }

    public byte[] To_bry_and_clear_and_trim() {
        return this.To_bry_and_clear_and_trim(true, true, Bry_.Trim_ary_ws);
    }

    public byte[] To_bry_and_clear_and_trim(boolean trim_bgn, boolean trim_end, byte[] trim_bry) {
        byte[] rv = Bry_.Trim(this.bfr, 0, this.bfr_len, trim_bgn, trim_end, trim_bry);
        this.Clear();
        return rv;
    }

    public byte[] To_bry_and_clear() {
        byte[] rv = this.To_bry();
        this.Clear();
        if (this.reset > 0) {
            this.Reset_if_gt(this.reset);
        }
        return rv;
    }

    public byte[] To_bry_and_clear_and_rls() {
        byte[] rv = this.To_bry_and_clear();
        this.Mkr_rls();
        return rv;
    }

    public String To_str() {
        return String_.new_u8(this.To_bry());
    }

    public String To_str_by_pos(int bgn, int end) {
        return String_.new_u8(this.To_bry(), bgn, end);
    }

    public String To_str_and_clear() {
        return String_.new_u8(this.To_bry_and_clear());
    }

    public String To_str_and_clear_and_trim() {
        return String_.new_u8(this.To_bry_and_clear_and_trim());
    }

    public int To_int_and_clear(int or) {
        int rv = this.To_int(or);
        this.Clear();
        return rv;
    }

    public int To_int(int or) {
        switch (this.bfr_len) {
            case 0: {
                return or;
            }
            case 1: {
                byte b = this.bfr[0];
                return Byte_ascii.Is_num(b) ? b - 48 : or;
            }
        }
        long rv = 0L;
        long mult = 1L;
        int i = this.bfr_len - 1;
        while (i > -1) {
            byte b = this.bfr[i];
            if (!Byte_ascii.Is_num(b)) {
                return or;
            }
            long dif = (long)(b - 48) * mult;
            long new_val = rv + dif;
            if (new_val > Integer.MAX_VALUE) {
                return or;
            }
            rv = new_val;
            mult *= 10L;
            --i;
        }
        return (int)rv;
    }

    public void Rls() {
        this.bfr = null;
        this.Mkr_rls();
    }

    public byte[][] To_bry_ary_and_clear() {
        if (this.bfr_len == 0) {
            return Bry_.Ary_empty;
        }
        Int_list line_ends = this.Find_all((byte)10);
        int lines_len = line_ends.Len();
        byte[][] rv = new byte[lines_len][];
        int line_bgn = 0;
        int i = 0;
        while (i < lines_len) {
            int line_end = line_ends.Get_at(i);
            rv[i] = Bry_.Mid(this.bfr, line_bgn, line_end);
            line_bgn = line_end + 1;
            ++i;
        }
        this.ClearAndReset();
        return rv;
    }

    public String[] To_str_ary_and_clear() {
        if (this.bfr_len == 0) {
            return String_.Ary_empty;
        }
        Int_list line_ends = this.Find_all((byte)10);
        int lines_len = line_ends.Len();
        String[] rv = new String[lines_len];
        int line_bgn = 0;
        int i = 0;
        while (i < lines_len) {
            int line_end = line_ends.Get_at(i);
            rv[i] = String_.new_u8(this.bfr, line_bgn, line_end);
            line_bgn = line_end + 1;
            ++i;
        }
        this.ClearAndReset();
        return rv;
    }

    private Int_list Find_all(byte find) {
        Int_list rv = new Int_list();
        int line_bgn = 0;
        int line_end = 0;
        while (line_bgn < this.bfr_len) {
            line_end = Bry_find_.Find_fwd(this.bfr, find, line_bgn, this.bfr_len);
            if (line_end == -1) {
                rv.Add(this.bfr_len);
                break;
            }
            rv.Add(line_end);
            line_bgn = line_end + 1;
        }
        return rv;
    }

    public int hashCode() {
        return Bry_obj_ref.CalcHashCode(this.bfr, 0, this.bfr_len);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        Bry_obj_ref comp = (Bry_obj_ref)obj;
        return Bry_.Match(this.bfr, 0, this.bfr_len, comp.Val(), comp.Val_bgn(), comp.Val_end());
    }

    public void Resize(int v) {
        this.bfr_max = v;
        this.bfr = Bry_.Resize(this.bfr, 0, v);
    }

    public int Mkr_idx() {
        return this.mkr_idx;
    }

    public boolean Mkr_idx_is_null() {
        return this.mkr_idx == -1;
    }

    public int Bfr_max() {
        return this.bfr_max;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Bry_bfr Mkr_init(Bry_bfr_mkr_mgr mkr_mgr, int itm) {
        Bry_bfr bry_bfr = this;
        synchronized (bry_bfr) {
            this.mkr_mgr = mkr_mgr;
            this.mkr_idx = itm;
        }
        return this;
    }

    protected Bry_bfr() {
    }

    public Bry_bfr(int bfr_max) {
        this.Init(bfr_max);
    }

    protected void Init(int bfr_max) {
        this.bfr_max = bfr_max;
        this.bfr = new byte[bfr_max];
    }
}

