/*
 * Decompiled with CFR 0.152.
 */
package gplx;

import gplx.Bry_;
import gplx.Bry__fxt;
import gplx.Bry_bfr;
import gplx.Bry_bfr_;
import gplx.Bry_split_;
import gplx.Byte_;
import gplx.Byte_ascii;
import gplx.DateAdp_;
import gplx.Err_;
import gplx.Int_;
import gplx.String_;
import gplx.Tfds;
import gplx.core.primitives.Int_obj_ref;
import org.junit.Test;

public class Bry__tst {
    private final Bry__fxt fxt = new Bry__fxt();

    @Test
    public void new_ascii_() {
        this.fxt.Test_new_a7("a", Bry_.New_by_ints(97));
        this.fxt.Test_new_a7("abc", Bry_.New_by_ints(97, 98, 99));
        this.fxt.Test_new_a7("", Bry_.Empty);
        this.fxt.Test_new_a7("\u00a2\u20ac\ud852\udf62", Bry_.New_by_ints(63, 63, 63, 63));
    }

    @Test
    public void new_u8() {
        this.fxt.Test_new_u8("a", Bry_.New_by_ints(97));
        this.fxt.Test_new_u8("abc", Bry_.New_by_ints(97, 98, 99));
        this.fxt.Test_new_u8("\u00a2", Bry_.New_by_ints(194, 162));
        this.fxt.Test_new_u8("\u20ac", Bry_.New_by_ints(226, 130, 172));
        this.fxt.Test_new_u8("\ud852\udf62", Bry_.New_by_ints(240, 164, 173, 162));
    }

    @Test
    public void Add__bry_plus_byte() {
        this.fxt.Test_add("a", (byte)124, "a|");
        this.fxt.Test_add("", (byte)124, "|");
    }

    @Test
    public void Add__byte_plus_bry() {
        this.fxt.Test_add((byte)124, "a", "|a");
        this.fxt.Test_add((byte)124, "", "|");
    }

    @Test
    public void Add_w_dlm() {
        this.fxt.Test_add_w_dlm((byte)124, String_.Ary("a", "b", "c"), "a|b|c");
        this.fxt.Test_add_w_dlm((byte)124, String_.Ary("a"), "a");
        this.fxt.Test_add_w_dlm((byte)124, String_.Ary("a", null, "c"), "a||c");
    }

    @Test
    public void Add_w_dlm_bry() {
        this.fxt.Test_add_w_dlm("<>", String_.Ary("a", "b", "c"), "a<>b<>c");
    }

    @Test
    public void MidByPos() {
        this.tst_MidByPos("abcba", 0, 1, "a");
        this.tst_MidByPos("abcba", 0, 2, "ab");
        this.tst_MidByPos("abcba", 1, 4, "bcb");
    }

    void tst_MidByPos(String src, int bgn, int end, String expd) {
        Tfds.Eq(expd, String_.new_u8(Bry_.Mid(Bry_.new_u8(src), bgn, end)));
    }

    @Test
    public void Replace_one() {
        this.tst_ReplaceOne("a", "b", "c", "a");
        this.tst_ReplaceOne("b", "b", "c", "c");
        this.tst_ReplaceOne("bb", "b", "c", "cb");
        this.tst_ReplaceOne("abcd", "bc", "", "ad");
        this.tst_ReplaceOne("abcd", "b", "ee", "aeecd");
    }

    void tst_ReplaceOne(String src, String find, String repl, String expd) {
        Tfds.Eq(expd, String_.new_u8(Bry_.Replace_one(Bry_.new_u8(src), Bry_.new_u8(find), Bry_.new_u8(repl))));
    }

    @Test
    public void XtoStrBytesByInt() {
        this.tst_XtoStrBytesByInt(0, 0);
        this.tst_XtoStrBytesByInt(9, 9);
        this.tst_XtoStrBytesByInt(10, 1, 0);
        this.tst_XtoStrBytesByInt(321, 3, 2, 1);
        this.tst_XtoStrBytesByInt(-321, Bry_.Byte_NegSign, 3, 2, 1);
        this.tst_XtoStrBytesByInt(Integer.MAX_VALUE, 2, 1, 4, 7, 4, 8, 3, 6, 4, 7);
    }

    void tst_XtoStrBytesByInt(int val, int ... expdAryAsInt) {
        byte[] expd = new byte[expdAryAsInt.length];
        int i = 0;
        while (i < expd.length) {
            int expdInt = expdAryAsInt[i];
            expd[i] = expdInt == Bry_.Byte_NegSign ? Bry_.Byte_NegSign : Byte_ascii.To_a7_str(expdAryAsInt[i]);
            ++i;
        }
        Tfds.Eq_ary(expd, Bry_.To_a7_bry(val, Int_.DigitCount(val)));
    }

    @Test
    public void Has_at_end() {
        this.tst_HasAtEnd("a|bcd|e", "d", 2, 5, true);
        this.tst_HasAtEnd("a|bcd|e", "bcd", 2, 5, true);
        this.tst_HasAtEnd("a|bcd|e", "|bcd", 2, 5, false);
        this.tst_HasAtEnd("a|bcd|e", "|bc", 2, 5, false);
        this.tst_HasAtEnd("abc", "bc", true);
        this.tst_HasAtEnd("abc", "bd", false);
        this.tst_HasAtEnd("a", "ab", false);
    }

    void tst_HasAtEnd(String src, String find, int bgn, int end, boolean expd) {
        Tfds.Eq(expd, Bry_.Has_at_end(Bry_.new_u8(src), Bry_.new_u8(find), bgn, end));
    }

    void tst_HasAtEnd(String src, String find, boolean expd) {
        Tfds.Eq(expd, Bry_.Has_at_end(Bry_.new_u8(src), Bry_.new_u8(find)));
    }

    @Test
    public void Has_at_bgn() {
        this.tst_HasAtBgn("y_basic", "a|bcd|e", "b", 2, 5, true);
        this.tst_HasAtBgn("y_many", "a|bcd|e", "bcd", 2, 5, true);
        this.tst_HasAtBgn("n_long", "a|bcd|e", "bcde", 2, 5, false);
        this.tst_HasAtBgn("n_pos", "a|bcd|e", "|bc", 2, 5, false);
    }

    void tst_HasAtBgn(String tst, String src, String find, int bgn, int end, boolean expd) {
        Tfds.Eq(expd, Bry_.Has_at_bgn(Bry_.new_u8(src), Bry_.new_u8(find), bgn, end), tst, new Object[0]);
    }

    @Test
    public void Match() {
        this.tst_Match("abc", 0, "abc", true);
        this.tst_Match("abc", 2, "c", true);
        this.tst_Match("abc", 0, "cde", false);
        this.tst_Match("abc", 2, "abc", false);
        this.tst_Match("abc", 0, "abcd", false);
        this.tst_Match("a", 0, "", false);
        this.tst_Match("", 0, "a", false);
        this.tst_Match("", 0, "", true);
        this.tst_Match("ab", 0, "a", false);
    }

    void tst_Match(String src, int srcPos, String find, boolean expd) {
        Tfds.Eq(expd, Bry_.Match(Bry_.new_u8(src), srcPos, Bry_.new_u8(find)));
    }

    @Test
    public void ReadCsvStr() {
        this.tst_ReadCsvStr("a|", "a");
        this.tst_ReadCsvStr("|a|", 1, "a");
        Int_obj_ref bgn = Int_obj_ref.New_zero();
        this.tst_ReadCsvStr("a|b|c|", bgn, "a");
        this.tst_ReadCsvStr("a|b|c|", bgn, "b");
        this.tst_ReadCsvStr("a|b|c|", bgn, "c");
        this.tst_ReadCsvStr("|", "");
        this.tst_ReadCsvStr_err("a");
        this.tst_ReadCsvStr("'a'|", "a");
        this.tst_ReadCsvStr("'a''b'|", "a'b");
        this.tst_ReadCsvStr("'a|b'|", "a|b");
        this.tst_ReadCsvStr("''|", "");
        this.tst_ReadCsvStr_err("''");
        this.tst_ReadCsvStr_err("'a'b'");
        this.tst_ReadCsvStr_err("'a");
        this.tst_ReadCsvStr_err("'a|");
        this.tst_ReadCsvStr_err("'a'");
    }

    @Test
    public void XtoIntBy4Bytes() {
        this.tst_XtoIntBy4Bytes(32, 32);
        this.tst_XtoIntBy4Bytes(8707, 34, 3);
        this.tst_XtoIntBy4Bytes(6382179, 97, 98, 99);
        this.tst_XtoIntBy4Bytes(1633837924, 97, 98, 99, 100);
    }

    @Test
    public void XtoInt() {
        this.tst_XtoInt("1", 1);
        this.tst_XtoInt("123", 123);
        this.tst_XtoInt("a", Integer.MIN_VALUE, Integer.MIN_VALUE);
        this.tst_XtoInt("-1", Integer.MIN_VALUE, -1);
        this.tst_XtoInt("-123", Integer.MIN_VALUE, -123);
        this.tst_XtoInt("123-1", Integer.MIN_VALUE, Integer.MIN_VALUE);
        this.tst_XtoInt("+123", Integer.MIN_VALUE, 123);
        this.tst_XtoInt("", -1);
    }

    void tst_XtoInt(String val, int expd) {
        this.tst_XtoInt(val, -1, expd);
    }

    void tst_XtoInt(String val, int or, int expd) {
        Tfds.Eq(expd, Bry_.To_int_or(Bry_.new_u8(val), or));
    }

    void tst_XtoIntBy4Bytes(int expd, byte ... ary) {
        Tfds.Eq(expd, Bry_.To_int_by_a7(ary), "XtoInt", new Object[0]);
        Tfds.Eq_ary(ary, Bry_.new_by_int(expd), "XbyInt", new Object[0]);
    }

    void tst_ReadCsvStr(String raw, String expd) {
        this.tst_ReadCsvStr(raw, Int_obj_ref.New_zero(), expd);
    }

    void tst_ReadCsvStr(String raw, int bgn, String expd) {
        this.tst_ReadCsvStr(raw, Int_obj_ref.New(bgn), expd);
    }

    void tst_ReadCsvStr(String raw, Int_obj_ref bgnRef, String expd) {
        int bgn = bgnRef.Val();
        boolean rawHasQuotes = String_.CharAt(raw, bgn) == '\'';
        String actl = String_.Replace(Bry_.ReadCsvStr(Bry_.new_u8(String_.Replace(raw, "'", "\"")), bgnRef, (byte)124), "\"", "'");
        Tfds.Eq(expd, actl, "rv", new Object[0]);
        if (rawHasQuotes) {
            int quoteAdj = String_.Count(actl, "'");
            Tfds.Eq(bgn + 1 + String_.Len(actl) + 2 + quoteAdj, bgnRef.Val(), "pos_quote", new Object[0]);
        } else {
            Tfds.Eq(bgn + 1 + String_.Len(actl), bgnRef.Val(), "pos", new Object[0]);
        }
    }

    void tst_ReadCsvStr_err(String raw) {
        try {
            Bry_.ReadCsvStr(Bry_.new_u8(String_.Replace(raw, "'", "\"")), Int_obj_ref.New_zero(), (byte)124);
        }
        catch (Exception e) {
            Err_.Noop(e);
            return;
        }
        Tfds.Fail_expdError();
    }

    @Test
    public void ReadCsvDte() {
        this.tst_ReadCsvDte("20110801 221435.987");
    }

    void tst_ReadCsvDte(String raw) {
        Tfds.Eq_date(DateAdp_.parse_fmt(raw, "yyyyMMdd HHmmss.fff"), Bry_.ReadCsvDte(Bry_.new_u8(String.valueOf(raw) + "|"), Int_obj_ref.New_zero(), (byte)124));
    }

    @Test
    public void ReadCsvInt() {
        this.tst_ReadCsvInt("1234567890");
    }

    void tst_ReadCsvInt(String raw) {
        Tfds.Eq(Int_.parse(raw), Bry_.ReadCsvInt(Bry_.new_u8(String.valueOf(raw) + "|"), Int_obj_ref.New_zero(), (byte)124));
    }

    @Test
    public void Trim() {
        this.Trim_tst("a b c", 1, 4, "b");
        this.Trim_tst("a  c", 1, 3, "");
        this.Trim_tst("  ", 0, 2, "");
    }

    void Trim_tst(String raw, int bgn, int end, String expd) {
        Tfds.Eq(expd, String_.new_u8(Bry_.Trim(Bry_.new_u8(raw), bgn, end)));
    }

    @Test
    public void Xto_int_lax() {
        this.tst_Xto_int_lax("12a", 12);
        this.tst_Xto_int_lax("1", 1);
        this.tst_Xto_int_lax("123", 123);
        this.tst_Xto_int_lax("a", 0);
        this.tst_Xto_int_lax("-1", -1);
    }

    private void tst_Xto_int_lax(String val, int expd) {
        Tfds.Eq(expd, Bry_.To_int_or__lax(Bry_.new_u8(val), 0, String_.Len(val), 0));
    }

    @Test
    public void To_int_or__trim_ws() {
        this.tst_Xto_int_trim("123 ", 123);
        this.tst_Xto_int_trim(" 123", 123);
        this.tst_Xto_int_trim(" 123 ", 123);
        this.tst_Xto_int_trim(" 1 3 ", -1);
    }

    private void tst_Xto_int_trim(String val, int expd) {
        Tfds.Eq(expd, Bry_.To_int_or__trim_ws(Bry_.new_u8(val), 0, String_.Len(val), -1));
    }

    @Test
    public void Compare() {
        this.tst_Compare("abcde", 0, 1, "abcde", 0, 1, 0);
        this.tst_Compare("abcde", 0, 1, "abcde", 1, 2, -1);
        this.tst_Compare("abcde", 1, 2, "abcde", 0, 1, 1);
        this.tst_Compare("abcde", 0, 1, "abcde", 0, 2, -1);
        this.tst_Compare("abcde", 0, 2, "abcde", 0, 1, 1);
        this.tst_Compare("abcde", 2, 3, "ab\u00e7de", 2, 3, -1);
    }

    void tst_Compare(String lhs, int lhs_bgn, int lhs_end, String rhs, int rhs_bgn, int rhs_end, int expd) {
        Tfds.Eq(expd, Bry_.Compare(Bry_.new_u8(lhs), lhs_bgn, lhs_end, Bry_.new_u8(rhs), rhs_bgn, rhs_end));
    }

    @Test
    public void Increment_last() {
        this.tst_IncrementLast(this.ary_(0), this.ary_(1));
        this.tst_IncrementLast(this.ary_(0, 255), this.ary_(1, 0));
        this.tst_IncrementLast(this.ary_(104, 111, 112, 101), this.ary_(104, 111, 112, 102));
    }

    byte[] ary_(int ... ary) {
        byte[] rv = new byte[ary.length];
        int i = 0;
        while (i < ary.length) {
            rv[i] = Byte_.By_int(ary[i]);
            ++i;
        }
        return rv;
    }

    void tst_IncrementLast(byte[] ary, byte[] expd) {
        Tfds.Eq_ary(expd, Bry_.Increment_last(Bry_.Copy(ary)));
    }

    @Test
    public void Replace_between() {
        this.tst_Replace_between("a[0]b", "[", "]", "0", "a0b");
        this.tst_Replace_between("a[0]b[1]c", "[", "]", "0", "a0b0c");
        this.tst_Replace_between("a[0b", "[", "]", "0", "a[0b");
    }

    public void tst_Replace_between(String src, String bgn, String end, String repl, String expd) {
        Tfds.Eq(expd, String_.new_a7(Bry_.Replace_between(Bry_.new_a7(src), Bry_.new_a7(bgn), Bry_.new_a7(end), Bry_.new_a7(repl))));
    }

    @Test
    public void Replace() {
        Bry_bfr tmp_bfr = Bry_bfr_.New();
        this.tst_Replace(tmp_bfr, "a0b", "0", "00", "a00b");
        this.tst_Replace(tmp_bfr, "a0b0c", "0", "00", "a00b00c");
        this.tst_Replace(tmp_bfr, "a00b00c", "00", "0", "a0b0c");
        this.tst_Replace(tmp_bfr, "a0b0", "0", "00", "a00b00");
        this.tst_Replace(tmp_bfr, "a00b00", "00", "0", "a0b0");
        this.tst_Replace(tmp_bfr, "a0b0", "1", "2", "a0b0");
        this.tst_Replace(tmp_bfr, "a0b0", "b1", "b2", "a0b0");
    }

    public void tst_Replace(Bry_bfr tmp_bfr, String src, String bgn, String repl, String expd) {
        Tfds.Eq(expd, String_.new_a7(Bry_.Replace(tmp_bfr, Bry_.new_a7(src), Bry_.new_a7(bgn), Bry_.new_a7(repl))));
    }

    @Test
    public void Split_bry() {
        this.Split_bry_tst("a|b|c|", "|", String_.Ary("a", "b", "c"));
        this.Split_bry_tst("a|", "|", String_.Ary("a"));
    }

    void Split_bry_tst(String src, String dlm, String[] expd) {
        String[] actl = String_.Ary(Bry_split_.Split(Bry_.new_a7(src), Bry_.new_a7(dlm)));
        Tfds.Eq_ary_str(expd, actl);
    }

    @Test
    public void Split_lines() {
        this.Tst_split_lines("a\nb", "a", "b");
        this.Tst_split_lines("a\nb\n", "a", "b");
        this.Tst_split_lines("a\r\nb", "a", "b");
        this.Tst_split_lines("a\rb", "a", "b");
    }

    void Tst_split_lines(String src, String ... expd) {
        Tfds.Eq_ary(expd, this.New_ary(Bry_split_.Split_lines(Bry_.new_a7(src))));
    }

    String[] New_ary(byte[][] lines) {
        int len = lines.length;
        String[] rv = new String[len];
        int i = 0;
        while (i < len) {
            rv[i] = String_.new_u8(lines[i]);
            ++i;
        }
        return rv;
    }

    @Test
    public void Match_bwd_any() {
        this.Tst_match_bwd_any("abc", 2, 0, "c", true);
        this.Tst_match_bwd_any("abc", 2, 0, "b", false);
        this.Tst_match_bwd_any("abc", 2, 0, "bc", true);
        this.Tst_match_bwd_any("abc", 2, 0, "abc", true);
        this.Tst_match_bwd_any("abc", 2, 0, "zabc", false);
        this.Tst_match_bwd_any("abc", 1, 0, "ab", true);
    }

    void Tst_match_bwd_any(String src, int src_end, int src_bgn, String find, boolean expd) {
        Tfds.Eq(expd, Bry_.Match_bwd_any(Bry_.new_a7(src), src_end, src_bgn, Bry_.new_a7(find)));
    }

    @Test
    public void Trim_end() {
        this.fxt.Test_trim_end("a ", (byte)32, "a");
        this.fxt.Test_trim_end("a   ", (byte)32, "a");
        this.fxt.Test_trim_end("a", (byte)32, "a");
        this.fxt.Test_trim_end("", (byte)32, "");
    }

    @Test
    public void Mid_w_trim() {
        this.fxt.Test_Mid_w_trim("abc", "abc");
        this.fxt.Test_Mid_w_trim(" a b c ", "a b c");
        this.fxt.Test_Mid_w_trim("\r\n\t a\r\n\t b \r\n\t ", "a\r\n\t b");
        this.fxt.Test_Mid_w_trim("", "");
        this.fxt.Test_Mid_w_trim("   ", "");
    }

    @Test
    public void New_u8_nl_apos() {
        this.fxt.Test__new_u8_nl_apos(String_.Ary("a"), "a");
        this.fxt.Test__new_u8_nl_apos(String_.Ary("a", "b"), "a\nb");
        this.fxt.Test__new_u8_nl_apos(String_.Ary("a", "b'c", "d"), "a\nb\"c\nd");
    }

    @Test
    public void Repeat_bry() {
        this.fxt.Test__repeat_bry("abc", 3, "abcabcabc");
    }

    @Test
    public void Xcase__build__all() {
        this.fxt.Test__xcase__build__all(false, "abc", "abc");
        this.fxt.Test__xcase__build__all(false, "aBc", "abc");
    }
}

