/*
 * Decompiled with CFR 0.152.
 */
package gplx;

import gplx.Bool_;
import gplx.Bry_bfr;
import gplx.Bry_bfr_;
import gplx.Bry_find_;
import gplx.Byte_ascii;
import gplx.DateAdp;
import gplx.DateAdp_;
import gplx.Decimal_adp;
import gplx.Decimal_adp_;
import gplx.Double_;
import gplx.Err_;
import gplx.Int_;
import gplx.Math_;
import gplx.Object_;
import gplx.String_;
import gplx.Type_adp_;
import gplx.core.primitives.Int_obj_ref;
import gplx.langs.htmls.entitys.Gfh_entity_;

public class Bry_ {
    public static final String Cls_val_name = "byte[]";
    public static final byte[] Empty = new byte[0];
    public static final byte[][] Ary_empty = new byte[0][];
    public static final Class<?> Cls_ref_type = byte[].class;
    public static final byte[] Trim_ary_ws = Bry_.mask_(256, 9, 10, 13, 32);
    public static final byte Dlm_fld = 124;
    public static final byte Dlm_row = 10;
    public static final byte Dlm_quote = 34;
    public static final byte Dlm_null = 0;
    public static final byte Ascii_zero = 48;
    public static final String Fmt_csvDte = "yyyyMMdd HHmmss.fff";
    public static byte Byte_NegSign = (byte)45;

    public static byte[] cast(Object val) {
        return (byte[])val;
    }

    public static byte[] New_by_byte(byte b) {
        return new byte[]{b};
    }

    public static byte[] New_by_ints(int ... ary) {
        int len = ary.length;
        byte[] rv = new byte[len];
        int i = 0;
        while (i < len) {
            rv[i] = (byte)ary[i];
            ++i;
        }
        return rv;
    }

    public static byte[] New_by_objs(Bry_bfr bfr, Object ... ary) {
        int len = ary.length;
        int i = 0;
        while (i < len) {
            Object itm = ary[i];
            Class<?> type = Type_adp_.ClassOf_obj(itm);
            if (Type_adp_.Eq(type, Integer.TYPE)) {
                bfr.Add_byte((byte)Int_.cast(itm));
            } else if (Type_adp_.Eq(type, String.class)) {
                bfr.Add_str_u8((String)itm);
            } else if (Type_adp_.Eq(type, byte[].class)) {
                bfr.Add((byte[])itm);
            } else {
                throw Err_.new_unhandled(Type_adp_.FullNameOf_type(type));
            }
            ++i;
        }
        return bfr.To_bry_and_clear();
    }

    public static byte[] Coalesce_to_empty(byte[] v) {
        return v == null ? Empty : v;
    }

    public static byte[] Coalesce(byte[] v, byte[] or) {
        return v == null ? or : v;
    }

    public static byte[] new_a7(String str) {
        if (str == null) {
            return null;
        }
        int str_len = str.length();
        if (str_len == 0) {
            return Empty;
        }
        byte[] rv = new byte[str_len];
        int i = 0;
        while (i < str_len) {
            int c = str.charAt(i);
            if (c > 128) {
                c = 63;
            }
            rv[i] = (byte)c;
            ++i;
        }
        return rv;
    }

    public static byte[] new_u8_safe(String str) {
        return str == null ? null : Bry_.new_u8(str);
    }

    public static byte[] new_u8(String str) {
        try {
            int str_len = str.length();
            if (str_len == 0) {
                return Empty;
            }
            int bry_len = Bry_.new_u8__by_len(str, str_len);
            byte[] rv = new byte[bry_len];
            Bry_.new_u8__write(str, str_len, rv, 0);
            return rv;
        }
        catch (Exception e) {
            throw Err_.new_exc(e, "core", "invalid UTF-8 sequence", "s", str);
        }
    }

    public static int new_u8__by_len(String s, int s_len) {
        int rv = 0;
        int i = 0;
        while (i < s_len) {
            char c = s.charAt(i);
            int c_len = 0;
            c_len = c < '\u0080' ? 1 : (c < '\u0800' ? 2 : (c > '\ud7ff' && c < '\udc00' ? 4 : 3));
            if (c_len == 4) {
                ++i;
            }
            rv += c_len;
            ++i;
        }
        return rv;
    }

    public static byte[] New_u8_nl_apos(String ... lines) {
        Bry_bfr bfr = Bry_bfr_.Get();
        try {
            Bry_.New_u8_nl_apos(bfr, lines);
            byte[] byArray = bfr.To_bry_and_clear();
            return byArray;
        }
        finally {
            bfr.Mkr_rls();
        }
    }

    public static void New_u8_nl_apos(Bry_bfr bfr, String ... lines) {
        int lines_len = lines.length;
        int i = 0;
        while (i < lines_len) {
            if (i != 0) {
                bfr.Add_byte_nl();
            }
            byte[] line = Bry_.new_u8(lines[i]);
            boolean dirty = false;
            int prv = 0;
            int line_len = line.length;
            int j = 0;
            while (j < line_len) {
                byte b = line[j];
                if (b == 39) {
                    bfr.Add_mid(line, prv, j);
                    bfr.Add_byte((byte)34);
                    dirty = true;
                    prv = j + 1;
                }
                ++j;
            }
            if (dirty) {
                bfr.Add_mid(line, prv, line_len);
            } else {
                bfr.Add(line);
            }
            ++i;
        }
    }

    public static void new_u8__write(String str, int str_len, byte[] bry, int bry_pos) {
        int i = 0;
        while (i < str_len) {
            char c = str.charAt(i);
            if (c < '\u0080') {
                bry[bry_pos++] = (byte)c;
            } else if (c < '\u0800') {
                bry[bry_pos++] = (byte)(0xC0 | c >> 6);
                bry[bry_pos++] = (byte)(0x80 | c & 0x3F);
            } else if (c > '\ud7ff' && c < '\udc00') {
                if (i >= str_len) {
                    throw Err_.new_wo_type("incomplete surrogate pair at end of String", "char", Character.valueOf(c));
                }
                char nxt_char = str.charAt(i + 1);
                int v = 65536 + (c - 55296) * 1024 + (nxt_char - 56320);
                bry[bry_pos++] = (byte)(0xF0 | v >> 18);
                bry[bry_pos++] = (byte)(0x80 | v >> 12 & 0x3F);
                bry[bry_pos++] = (byte)(0x80 | v >> 6 & 0x3F);
                bry[bry_pos++] = (byte)(0x80 | v & 0x3F);
                ++i;
            } else {
                bry[bry_pos++] = (byte)(0xE0 | c >> 12);
                bry[bry_pos++] = (byte)(0x80 | c >> 6 & 0x3F);
                bry[bry_pos++] = (byte)(0x80 | c & 0x3F);
            }
            ++i;
        }
    }

    public static byte[] Copy(byte[] src) {
        int src_len = src.length;
        byte[] trg = new byte[src_len];
        int i = 0;
        while (i < src_len) {
            trg[i] = src[i];
            ++i;
        }
        return trg;
    }

    public static byte[] Resize(byte[] src, int trg_len) {
        return Bry_.Resize(src, 0, trg_len);
    }

    public static byte[] Resize(byte[] src, int src_bgn, int trg_len) {
        byte[] trg = new byte[trg_len];
        int src_len = src.length;
        if (src_len > trg_len) {
            src_len = trg_len;
        }
        Bry_.Copy_by_len(src, src_bgn, src_len, trg, 0);
        return trg;
    }

    public static byte[] Repeat_space(int len) {
        return Bry_.Repeat((byte)32, len);
    }

    public static byte[] Repeat(byte b, int len) {
        byte[] rv = new byte[len];
        int i = 0;
        while (i < len) {
            rv[i] = b;
            ++i;
        }
        return rv;
    }

    public static byte[] Repeat_bry(byte[] bry, int len) {
        int bry_len = bry.length;
        int rv_len = len * bry_len;
        byte[] rv = new byte[rv_len];
        int i = 0;
        while (i < len) {
            int j = 0;
            while (j < bry_len) {
                rv[i * bry_len + j] = bry[j];
                ++j;
            }
            ++i;
        }
        return rv;
    }

    public static byte[] Add(byte[] src, byte b) {
        int src_len = src.length;
        byte[] rv = new byte[src_len + 1];
        Bry_.Copy_by_pos(src, 0, src_len, rv, 0);
        rv[src_len] = b;
        return rv;
    }

    public static byte[] Add(byte b, byte[] src) {
        int src_len = src.length;
        byte[] rv = new byte[src_len + 1];
        Bry_.Copy_by_pos(src, 0, src_len, rv, 1);
        rv[0] = b;
        return rv;
    }

    public static byte[] Add(byte[] ... all) {
        int all_len = all.length;
        int rv_len = 0;
        int i = 0;
        while (i < all_len) {
            byte[] cur = all[i];
            if (cur != null) {
                rv_len += cur.length;
            }
            ++i;
        }
        byte[] rv = new byte[rv_len];
        int rv_idx = 0;
        int i2 = 0;
        while (i2 < all_len) {
            byte[] cur = all[i2];
            if (cur != null) {
                int cur_len = cur.length;
                int j = 0;
                while (j < cur_len) {
                    rv[rv_idx++] = cur[j];
                    ++j;
                }
            }
            ++i2;
        }
        return rv;
    }

    public static byte[] Add_w_dlm(byte[] dlm, byte[] ... ary) {
        int ary_len = ary.length;
        if (ary_len == 0) {
            return Empty;
        }
        int dlm_len = dlm.length;
        int rv_len = dlm_len * (ary_len - 1);
        int i = 0;
        while (i < ary_len) {
            byte[] itm = ary[i];
            if (itm != null) {
                rv_len += itm.length;
            }
            ++i;
        }
        int rv_pos = 0;
        byte[] rv = new byte[rv_len];
        int i2 = 0;
        while (i2 < ary_len) {
            byte[] itm = ary[i2];
            if (i2 != 0) {
                int j = 0;
                while (j < dlm_len) {
                    rv[rv_pos++] = dlm[j];
                    ++j;
                }
            }
            if (itm != null) {
                int itm_len = itm.length;
                int j = 0;
                while (j < itm_len) {
                    rv[rv_pos++] = itm[j];
                    ++j;
                }
            }
            ++i2;
        }
        return rv;
    }

    public static byte[] Add_w_dlm(byte dlm, byte[] ... ary) {
        int ary_len = ary.length;
        if (ary_len == 0) {
            return Empty;
        }
        int rv_len = ary_len - 1;
        int i = 0;
        while (i < ary_len) {
            byte[] itm = ary[i];
            if (itm != null) {
                rv_len += itm.length;
            }
            ++i;
        }
        int rv_pos = 0;
        byte[] rv = new byte[rv_len];
        int i2 = 0;
        while (i2 < ary_len) {
            byte[] itm = ary[i2];
            if (i2 != 0) {
                rv[rv_pos++] = dlm;
            }
            if (itm != null) {
                int itm_len = itm.length;
                int j = 0;
                while (j < itm_len) {
                    rv[rv_pos++] = itm[j];
                    ++j;
                }
            }
            ++i2;
        }
        return rv;
    }

    public static int Len(byte[] v) {
        return v == null ? 0 : v.length;
    }

    public static boolean Len_gt_0(byte[] v) {
        return v != null && v.length > 0;
    }

    public static boolean Len_eq_0(byte[] v) {
        return v == null || v.length == 0;
    }

    public static byte Get_at_end(byte[] bry) {
        return bry[bry.length - 1];
    }

    public static boolean Has_at(byte[] src, int src_len, int pos, byte b) {
        return pos < src_len && src[pos] == b;
    }

    public static boolean Has(byte[] src, byte[] lkp) {
        return Bry_find_.Find_fwd(src, lkp) != -1;
    }

    public static boolean Has(byte[] src, byte lkp) {
        if (src == null) {
            return false;
        }
        int len = src.length;
        int i = 0;
        while (i < len) {
            if (src[i] == lkp) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean Has_at_bgn(byte[] src, byte lkp) {
        return Bry_.Has_at_bgn(src, lkp, 0);
    }

    public static boolean Has_at_bgn(byte[] src, byte lkp, int src_bgn) {
        return src_bgn < src.length ? src[src_bgn] == lkp : false;
    }

    public static boolean Has_at_bgn(byte[] src, byte[] lkp) {
        return Bry_.Has_at_bgn(src, lkp, 0, src.length);
    }

    public static boolean Has_at_bgn(byte[] src, byte[] lkp, int src_bgn, int src_end) {
        int lkp_len = lkp.length;
        if (lkp_len + src_bgn > src_end) {
            return false;
        }
        int i = 0;
        while (i < lkp_len) {
            if (lkp[i] != src[i + src_bgn]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean Has_at_end(byte[] src, byte lkp) {
        if (src == null) {
            return false;
        }
        int src_len = src.length;
        if (src_len == 0) {
            return false;
        }
        return src[src_len - 1] == lkp;
    }

    public static boolean Has_at_end(byte[] src, byte[] lkp) {
        int src_len = src.length;
        return Bry_.Has_at_end(src, lkp, src_len - lkp.length, src_len);
    }

    public static boolean Has_at_end(byte[] src, byte[] lkp, int src_bgn, int src_end) {
        int lkp_len = lkp.length;
        if (src_bgn < 0) {
            return false;
        }
        int pos = src_end - lkp_len;
        if (pos < src_bgn) {
            return false;
        }
        int i = 0;
        while (i < lkp_len) {
            if (lkp[i] != src[i + pos]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static void Set(byte[] src, int bgn, int end, byte[] repl) {
        int repl_len = repl.length;
        int i = 0;
        while (i < repl_len) {
            src[i + bgn] = repl[i];
            ++i;
        }
    }

    public static void Copy_by_pos(byte[] src, int src_bgn, int src_end, byte[] trg, int trg_bgn) {
        int trg_adj = trg_bgn - src_bgn;
        int i = src_bgn;
        while (i < src_end) {
            trg[i + trg_adj] = src[i];
            ++i;
        }
    }

    private static void Copy_by_len(byte[] src, int src_bgn, int src_len, byte[] trg, int trg_bgn) {
        int i = 0;
        while (i < src_len) {
            trg[i + trg_bgn] = src[i + src_bgn];
            ++i;
        }
    }

    public static byte[] Replace_one(byte[] src, byte[] find, byte[] repl) {
        int src_len = src.length;
        int findPos = Bry_find_.Find(src, find, 0, src_len, true);
        if (findPos == -1) {
            return src;
        }
        int findLen = find.length;
        int replLen = repl.length;
        int rvLen = src_len + replLen - findLen;
        byte[] rv = new byte[rvLen];
        Bry_.Copy_by_len(src, 0, findPos, rv, 0);
        Bry_.Copy_by_len(repl, 0, replLen, rv, findPos);
        Bry_.Copy_by_len(src, findPos + findLen, src_len - findPos - findLen, rv, findPos + replLen);
        return rv;
    }

    public static void Replace_all_direct(byte[] src, byte find, byte repl) {
        Bry_.Replace_all_direct(src, find, repl, 0, src.length);
    }

    public static void Replace_all_direct(byte[] src, byte find, byte repl, int bgn, int end) {
        int i = bgn;
        while (i < end) {
            byte b = src[i];
            if (b == find) {
                src[i] = repl;
            }
            ++i;
        }
    }

    public static byte[] Limit(byte[] src, int len) {
        if (src == null) {
            return null;
        }
        int src_len = src.length;
        return len < src_len ? Bry_.Mid(src, 0, len) : src;
    }

    public static byte[] Mid_by_nearby(byte[] src, int pos, int around) {
        int src_len;
        int end;
        int bgn = pos - around;
        if (bgn < 0) {
            bgn = 0;
        }
        if ((end = pos + around) > (src_len = src.length)) {
            end = src_len;
        }
        return Bry_.Mid(src, bgn, end);
    }

    public static byte[] Mid_by_len(byte[] src, int bgn, int len) {
        return Bry_.Mid(src, bgn, bgn + len);
    }

    public static byte[] Mid_by_len_safe(byte[] src, int bgn, int len) {
        int src_len = src.length;
        if (bgn < 0) {
            bgn = 0;
        }
        if (len + bgn > src_len) {
            len = src_len - bgn;
        }
        return Bry_.Mid(src, bgn, bgn + len);
    }

    public static String MidByLenToStr(byte[] src, int bgn, int len) {
        int end = bgn + len;
        end = Int_.BoundEnd(end, src.length);
        byte[] ary = Bry_.Mid(src, bgn, end);
        return String_.new_u8(ary);
    }

    public static byte[] Mid_safe(byte[] src, int bgn, int end) {
        if (src == null) {
            return null;
        }
        int src_len = src.length;
        if (bgn < 0) {
            bgn = 0;
        }
        if (end >= src_len) {
            end = src_len;
        }
        if (bgn > end) {
            bgn = end;
        } else if (end < bgn) {
            end = bgn;
        }
        return Bry_.Mid(src, bgn, end);
    }

    public static byte[] Mid(byte[] src, int bgn) {
        return Bry_.Mid(src, bgn, src.length);
    }

    public static byte[] Mid_or(byte[] src, int bgn, int end, byte[] or) {
        int src_len = src.length;
        if (src == null || bgn < 0 || bgn > src_len || end < 0 || end > src_len || end < bgn) {
            return or;
        }
        return bgn == src_len ? Empty : Bry_.Mid(src, bgn, src_len);
    }

    public static byte[] Mid(byte[] src, int bgn, int end) {
        try {
            int len = end - bgn;
            if (len == 0) {
                return Empty;
            }
            byte[] rv = new byte[len];
            int i = bgn;
            while (i < end) {
                rv[i - bgn] = src[i];
                ++i;
            }
            return rv;
        }
        catch (Exception e) {
            Err_.Noop(e);
            throw Err_.new_("Bry_", "mid failed", "bgn", bgn, "end", end);
        }
    }

    public static byte[] Mid_w_trim(byte[] src, int bgn, int end) {
        int len = end - bgn;
        if (len == 0) {
            return Empty;
        }
        int actl_bgn = bgn;
        int actl_end = end;
        boolean chars_seen = false;
        int i = bgn;
        while (i < end) {
            switch (src[i]) {
                case 9: 
                case 10: 
                case 13: 
                case 32: {
                    break;
                }
                default: {
                    chars_seen = true;
                    actl_bgn = i;
                    i = end;
                }
            }
            ++i;
        }
        if (!chars_seen) {
            return Empty;
        }
        i = end - 1;
        while (i >= actl_bgn) {
            switch (src[i]) {
                case 9: 
                case 10: 
                case 13: 
                case 32: {
                    break;
                }
                default: {
                    actl_end = i + 1;
                    i = -1;
                }
            }
            --i;
        }
        len = actl_end - actl_bgn;
        if (len == 0) {
            return Empty;
        }
        byte[] rv = new byte[len];
        int i2 = actl_bgn;
        while (i2 < actl_end) {
            rv[i2 - actl_bgn] = src[i2];
            ++i2;
        }
        return rv;
    }

    public static byte[] mask_(int len, byte ... itms) {
        byte[] rv = new byte[len];
        int itms_len = itms.length;
        int i = 0;
        while (i < itms_len) {
            byte itm;
            rv[itm & 0xFF] = itm = itms[i];
            ++i;
        }
        return rv;
    }

    public static byte[] Trim(byte[] src) {
        return Bry_.Trim(src, 0, src.length, true, true, Trim_ary_ws);
    }

    public static byte[] Trim(byte[] src, int bgn, int end) {
        return Bry_.Trim(src, bgn, end, true, true, Trim_ary_ws);
    }

    public static byte[] Trim(byte[] src, int bgn, int end, boolean trim_bgn, boolean trim_end, byte[] trim_ary) {
        byte b;
        int i;
        int txt_bgn = bgn;
        int txt_end = end;
        boolean all_ws = true;
        if (trim_bgn) {
            i = bgn;
            while (i < end) {
                b = src[i];
                if (trim_ary[b & 0xFF] == 0) {
                    txt_bgn = i;
                    i = end;
                    all_ws = false;
                }
                ++i;
            }
            if (all_ws) {
                return Empty;
            }
        }
        if (trim_end) {
            i = end - 1;
            while (i > -1) {
                b = src[i];
                if (trim_ary[b & 0xFF] == 0) {
                    txt_end = i + 1;
                    i = -1;
                    all_ws = false;
                }
                --i;
            }
            if (all_ws) {
                return Empty;
            }
        }
        if (bgn == 0 && end == src.length && bgn == txt_bgn && end == txt_end) {
            return src;
        }
        return Bry_.Mid(src, txt_bgn, txt_end);
    }

    public static byte[] Trim_end(byte[] v, byte trim, int end) {
        boolean trimmed = false;
        int pos = end - 1;
        while (pos > -1) {
            if (v[pos] != trim) break;
            trimmed = true;
            --pos;
        }
        return trimmed ? Bry_.Mid(v, 0, pos + 1) : v;
    }

    public static int Compare(byte[] lhs, byte[] rhs) {
        if (lhs == null) {
            return 1;
        }
        if (rhs == null) {
            return -1;
        }
        return Bry_.Compare(lhs, 0, lhs.length, rhs, 0, rhs.length);
    }

    public static int Compare(byte[] lhs, int lhs_bgn, int lhs_end, byte[] rhs, int rhs_bgn, int rhs_end) {
        int lhs_len = lhs_end - lhs_bgn;
        int rhs_len = rhs_end - rhs_bgn;
        int min = lhs_len < rhs_len ? lhs_len : rhs_len;
        int rv = 0;
        int i = 0;
        while (i < min) {
            rv = (lhs[i + lhs_bgn] & 0xFF) - (rhs[i + rhs_bgn] & 0xFF);
            if (rv != 0) {
                return rv > 0 ? 1 : -1;
            }
            ++i;
        }
        return Int_.Compare(lhs_len, rhs_len);
    }

    public static boolean Eq(byte[] src, byte[] val) {
        return Bry_.Eq(src, 0, src == null ? 0 : src.length, val);
    }

    public static boolean Eq(byte[] src, int src_bgn, int src_end, byte[] val) {
        if (src == null && val == null) {
            return true;
        }
        if (src == null || val == null) {
            return false;
        }
        if (src_bgn < 0) {
            return false;
        }
        int val_len = val.length;
        if (val_len != src_end - src_bgn) {
            return false;
        }
        int src_len = src.length;
        int i = 0;
        while (i < val_len) {
            int src_pos = i + src_bgn;
            if (src_pos == src_len) {
                return false;
            }
            if (val[i] != src[src_pos]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean Eq_ci_a7(byte[] lhs, byte[] rhs, int rhs_bgn, int rhs_end) {
        if (lhs == null && rhs == null) {
            return true;
        }
        if (lhs == null || rhs == null) {
            return false;
        }
        int lhs_len = lhs.length;
        int rhs_len = rhs_end - rhs_bgn;
        if (lhs_len != rhs_len) {
            return false;
        }
        int i = 0;
        while (i < lhs_len) {
            byte rhs_b;
            byte lhs_b = lhs[i];
            if (lhs_b > 64 && lhs_b < 91) {
                lhs_b = (byte)(lhs_b + 32);
            }
            if ((rhs_b = rhs[i + rhs_bgn]) > 64 && rhs_b < 91) {
                rhs_b = (byte)(rhs_b + 32);
            }
            if (lhs_b != rhs_b) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean Match(byte[] src, byte[] find) {
        return Bry_.Match(src, 0, src.length, find, 0, find.length);
    }

    public static boolean Match(byte[] src, int src_bgn, byte[] find) {
        return Bry_.Match(src, src_bgn, src.length, find, 0, find.length);
    }

    public static boolean Match(byte[] src, int src_bgn, int src_end, byte[] find) {
        return Bry_.Match(src, src_bgn, src_end, find, 0, find.length);
    }

    public static boolean Match(byte[] src, int src_bgn, int src_end, byte[] find, int find_bgn, int find_end) {
        int find_len;
        if (src_bgn == -1) {
            return false;
        }
        int src_len = src.length;
        if (src_end > src_len) {
            src_end = src_len;
        }
        if ((find_len = find_end - find_bgn) != src_end - src_bgn) {
            return false;
        }
        if (find_len == 0) {
            return src_end - src_bgn == 0;
        }
        int i = 0;
        while (i < find_len) {
            int pos = src_bgn + i;
            if (pos >= src_end) {
                return false;
            }
            if (src[pos] != find[i + find_bgn]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean Match_w_swap(byte[] src, int src_bgn, int src_end, byte[] find, int find_bgn, int find_end, byte swap_src, byte swap_trg) {
        int find_len;
        int src_len = src.length;
        if (src_end > src_len) {
            src_end = src_len;
        }
        if ((find_len = find_end - find_bgn) != src_end - src_bgn) {
            return false;
        }
        if (find_len == 0) {
            return src_end - src_bgn == 0;
        }
        int i = 0;
        while (i < find_len) {
            byte trg_byte;
            int pos = src_bgn + i;
            if (pos >= src_end) {
                return false;
            }
            byte src_byte = src[pos];
            if (src_byte == swap_src) {
                src_byte = swap_trg;
            }
            if ((trg_byte = find[i + find_bgn]) == swap_src) {
                trg_byte = swap_trg;
            }
            if (src_byte != trg_byte) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean Match_bwd_any(byte[] src, int src_end, int src_bgn, byte[] find) {
        int find_len = find.length;
        int i = 0;
        while (i < find_len) {
            int src_pos = src_end - i;
            int find_pos = find_len - i - 1;
            if (src_pos < src_bgn) {
                return false;
            }
            if (src[src_pos] != find[find_pos]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static int To_int_by_a7(byte[] v) {
        int v_len = v.length;
        int mod = 8 * (v_len - 1);
        int rv = 0;
        int i = 0;
        while (i < v_len) {
            rv |= v[i] << mod;
            mod -= 8;
            ++i;
        }
        return rv;
    }

    public static byte[] To_a7_bry(int val, int pad_len) {
        return Bry_.To_a7_bry(val, null, 0, pad_len);
    }

    public static byte[] To_a7_bry(int val, byte[] ary, int aryPos, int pad_len) {
        int neg = 0;
        if (val < 0) {
            val *= -1;
            neg = 1;
        }
        int digits = val == 0 ? 0 : Math_.Log10(val);
        int ary_len = ++digits + neg;
        int aryBgn = aryPos;
        int pad = 0;
        if (ary_len < pad_len) {
            pad = pad_len - ary_len;
            ary_len = pad_len;
        }
        if (ary == null) {
            ary = new byte[ary_len];
        }
        long factor = 1L;
        int i = 0;
        while (i < digits) {
            factor *= 10L;
            ++i;
        }
        if (neg == 1) {
            ary[0] = Byte_NegSign;
        }
        i = 0;
        while (i < pad) {
            ary[i + aryBgn] = Byte_ascii.To_a7_str(0);
            ++i;
        }
        aryBgn += pad;
        i = neg;
        while (i < ary_len - pad) {
            int denominator = (int)(factor / 10L);
            int digit = denominator == 0 ? 0 : (int)((long)val % factor / (long)denominator);
            ary[aryBgn + i] = Byte_ascii.To_a7_str(digit);
            factor /= 10L;
            ++i;
        }
        return ary;
    }

    public static byte[] new_by_int(int v) {
        byte b0 = (byte)(v >> 24);
        byte b1 = (byte)(v >> 16);
        byte b2 = (byte)(v >> 8);
        byte b3 = (byte)v;
        if (b0 != 0) {
            return new byte[]{b0, b1, b2, b3};
        }
        if (b1 != 0) {
            return new byte[]{b1, b2, b3};
        }
        if (b2 != 0) {
            return new byte[]{b2, b3};
        }
        return new byte[]{b3};
    }

    public static boolean To_bool_or(byte[] raw, boolean or) {
        return Bry_.Eq(raw, Bool_.True_bry) ? true : or;
    }

    public static boolean To_bool_by_int(byte[] ary) {
        int rv = Bry_.To_int_or(ary, 0, ary.length, Integer.MIN_VALUE, true, null);
        switch (rv) {
            case 0: {
                return false;
            }
            case 1: {
                return true;
            }
        }
        throw Err_.new_wo_type("could not parse to boolean int", "val", String_.new_u8(ary));
    }

    public static byte To_int_as_byte(byte[] ary, int bgn, int end, byte or) {
        return (byte)Bry_.To_int_or(ary, bgn, end, or);
    }

    public static int To_int(byte[] ary) {
        return Bry_.To_int_or_fail(ary, 0, ary.length);
    }

    public static int To_int_or_fail(byte[] ary, int bgn, int end) {
        int rv = Bry_.To_int_or(ary, bgn, end, Integer.MIN_VALUE, true, null);
        if (rv == Integer.MIN_VALUE) {
            throw Err_.new_wo_type("could not parse to int", "val", String_.new_u8(ary, bgn, end));
        }
        return rv;
    }

    public static int To_int_or_neg1(byte[] ary) {
        return Bry_.To_int_or(ary, 0, ary.length, -1, true, null);
    }

    public static int To_int_or(byte[] ary, int or) {
        return Bry_.To_int_or(ary, 0, ary.length, or, true, null);
    }

    public static int To_int_or(byte[] ary, int bgn, int end, int or) {
        return Bry_.To_int_or(ary, bgn, end, or, true, null);
    }

    public static int To_int_or__strict(byte[] ary, int or) {
        return Bry_.To_int_or(ary, 0, ary.length, or, false, null);
    }

    private static int To_int_or(byte[] ary, int bgn, int end, int or, boolean sign_is_valid, byte[] ignore_ary) {
        if (ary == null || end == bgn) {
            return or;
        }
        int rv = 0;
        int multiple = 1;
        int i = end - 1;
        while (i >= bgn) {
            byte b = ary[i];
            switch (b) {
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: {
                    rv += multiple * (b - 48);
                    multiple *= 10;
                    break;
                }
                case 45: {
                    return i == bgn && sign_is_valid ? rv * -1 : or;
                }
                case 43: {
                    return i == bgn && sign_is_valid ? rv : or;
                }
                default: {
                    boolean invalid = true;
                    if (ignore_ary != null) {
                        int ignore_ary_len = ignore_ary.length;
                        int j = 0;
                        while (j < ignore_ary_len) {
                            if (b == ignore_ary[j]) {
                                invalid = false;
                                break;
                            }
                            ++j;
                        }
                    }
                    if (!invalid) break;
                    return or;
                }
            }
            --i;
        }
        return rv;
    }

    public static int To_int_or__trim_ws(byte[] ary, int bgn, int end, int or) {
        if (end == bgn) {
            return or;
        }
        int rv = 0;
        int multiple = 1;
        boolean numbers_seen = false;
        boolean ws_seen = false;
        int i = end - 1;
        while (i >= bgn) {
            byte b = ary[i];
            switch (b) {
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: {
                    rv += multiple * (b - 48);
                    multiple *= 10;
                    if (ws_seen) {
                        return or;
                    }
                    numbers_seen = true;
                    break;
                }
                case 45: {
                    return i == bgn ? rv * -1 : or;
                }
                case 9: 
                case 10: 
                case 13: 
                case 32: {
                    if (!numbers_seen) break;
                    ws_seen = true;
                    break;
                }
                default: {
                    return or;
                }
            }
            --i;
        }
        return rv;
    }

    public static int To_int_or__lax(byte[] ary, int bgn, int end, int or) {
        if (end == bgn) {
            return or;
        }
        int end_num = end;
        int i = bgn;
        while (i < end) {
            byte b = ary[i];
            switch (b) {
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: {
                    break;
                }
                case 45: {
                    if (i == bgn) break;
                    end_num = i;
                    i = end;
                    break;
                }
                default: {
                    end_num = i;
                    i = end;
                }
            }
            ++i;
        }
        return Bry_.To_int_or(ary, bgn, end_num, or);
    }

    public static long To_long_or(byte[] ary, long or) {
        return Bry_.To_long_or(ary, null, 0, ary.length, or);
    }

    public static long To_long_or(byte[] ary, byte[] ignore_ary, int bgn, int end, long or) {
        if (ary == null || end == bgn) {
            return or;
        }
        long rv = 0L;
        long multiple = 1L;
        int i = end - 1;
        while (i >= bgn) {
            byte b = ary[i];
            switch (b) {
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: {
                    rv += multiple * (long)(b - 48);
                    multiple *= 10L;
                    break;
                }
                case 45: {
                    return i == bgn ? rv * -1L : or;
                }
                case 43: {
                    return i == bgn ? rv : or;
                }
                default: {
                    boolean invalid = true;
                    if (ignore_ary != null) {
                        int ignore_ary_len = ignore_ary.length;
                        int j = 0;
                        while (j < ignore_ary_len) {
                            if (b == ignore_ary[j]) {
                                invalid = false;
                                break;
                            }
                            ++j;
                        }
                    }
                    if (!invalid) break;
                    return or;
                }
            }
            --i;
        }
        return rv;
    }

    public static double To_double(byte[] ary, int bgn, int end) {
        return Double_.parse(String_.new_u8(ary, bgn, end));
    }

    public static double To_double_or(byte[] bry, double or) {
        return Double_.parse_or(String_.new_u8(bry, 0, bry.length), or);
    }

    public static double To_double_or(byte[] ary, int bgn, int end, double or) {
        return Double_.parse_or(String_.new_u8(ary, bgn, end), or);
    }

    public static Decimal_adp To_decimal(byte[] ary, int bgn, int end) {
        return Decimal_adp_.parse(String_.new_u8(ary, bgn, end));
    }

    public static byte[][] Ary_add(byte[][] lhs, byte[][] rhs) {
        int lhs_len = lhs.length;
        int rhs_len = rhs.length;
        if (lhs_len == 0) {
            return rhs;
        }
        if (rhs_len == 0) {
            return lhs;
        }
        byte[][] rv = new byte[lhs_len + rhs_len][];
        int i = 0;
        while (i < lhs_len) {
            rv[i] = lhs[i];
            ++i;
        }
        i = 0;
        while (i < rhs_len) {
            rv[i + lhs_len] = rhs[i];
            ++i;
        }
        return rv;
    }

    public static byte[][] Ary(byte[] ... ary) {
        return ary;
    }

    public static byte[][] Ary(String ... ary) {
        int ary_len = ary.length;
        byte[][] rv = new byte[ary_len][];
        int i = 0;
        while (i < ary_len) {
            String itm = ary[i];
            rv[i] = itm == null ? null : Bry_.new_u8(itm);
            ++i;
        }
        return rv;
    }

    public static byte[][] Ary_obj(Object ... ary) {
        if (ary == null) {
            return Ary_empty;
        }
        int ary_len = ary.length;
        byte[][] rv = new byte[ary_len][];
        int i = 0;
        while (i < ary_len) {
            Object itm = ary[i];
            rv[i] = itm == null ? null : Bry_.new_u8(Object_.Xto_str_strict_or_empty(itm));
            ++i;
        }
        return rv;
    }

    public static boolean Ary_eq(byte[][] lhs, byte[][] rhs) {
        int lhs_len = lhs.length;
        int rhs_len = rhs.length;
        if (lhs_len != rhs_len) {
            return false;
        }
        int i = 0;
        while (i < lhs_len) {
            if (!Bry_.Eq(lhs[i], rhs[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static DateAdp ReadCsvDte(byte[] ary, Int_obj_ref posRef, byte lkp) {
        int y = 0;
        int M = 0;
        int d = 0;
        int H = 0;
        int m = 0;
        int s = 0;
        int f = 0;
        int bgn = posRef.Val();
        y += (ary[bgn + 0] - 48) * 1000;
        y += (ary[bgn + 1] - 48) * 100;
        y += (ary[bgn + 2] - 48) * 10;
        y += ary[bgn + 3] - 48;
        M += (ary[bgn + 4] - 48) * 10;
        M += ary[bgn + 5] - 48;
        d += (ary[bgn + 6] - 48) * 10;
        d += ary[bgn + 7] - 48;
        H += (ary[bgn + 9] - 48) * 10;
        H += ary[bgn + 10] - 48;
        m += (ary[bgn + 11] - 48) * 10;
        m += ary[bgn + 12] - 48;
        s += (ary[bgn + 13] - 48) * 10;
        s += ary[bgn + 14] - 48;
        f += (ary[bgn + 16] - 48) * 100;
        f += (ary[bgn + 17] - 48) * 10;
        f += ary[bgn + 18] - 48;
        if (ary[bgn + 19] != lkp) {
            throw Err_.new_wo_type("csv date is invalid", "txt", String_.new_u8__by_len(ary, bgn, 20));
        }
        posRef.Val_add(20);
        return DateAdp_.new_(y, M, d, H, m, s, f);
    }

    public static String ReadCsvStr(byte[] ary, Int_obj_ref posRef, byte lkp) {
        return String_.new_u8(Bry_.ReadCsvBry(ary, posRef, lkp, true));
    }

    public static byte[] ReadCsvBry(byte[] ary, Int_obj_ref posRef, byte lkp) {
        return Bry_.ReadCsvBry(ary, posRef, lkp, true);
    }

    public static byte[] ReadCsvBry(byte[] ary, Int_obj_ref posRef, byte lkp, boolean make) {
        int bgn = posRef.Val();
        int aryLen = ary.length;
        Bry_bfr bb = null;
        if (aryLen > 0 && ary[0] == 34) {
            int pos = bgn + 1;
            if (make) {
                bb = Bry_bfr_.New();
            }
            while (true) {
                if (pos == aryLen) {
                    throw Err_.new_wo_type("endOfAry reached, but no quote found", "txt", String_.new_u8__by_len(ary, bgn, pos));
                }
                byte b = ary[pos];
                if (b == 34) {
                    if (pos == aryLen - 1) {
                        throw Err_.new_wo_type("endOfAry reached, quote found but lkp not", "txt", String_.new_u8__by_len(ary, bgn, pos));
                    }
                    byte next = ary[pos + 1];
                    if (next == 34) {
                        if (make) {
                            bb.Add_byte(b);
                        }
                        pos += 2;
                        continue;
                    }
                    if (next == lkp) {
                        posRef.Val_(pos + 2);
                        return make ? bb.To_bry() : Empty;
                    }
                    throw Err_.new_wo_type("quote found, but not doubled", "txt", String_.new_u8__by_len(ary, bgn, pos + 1));
                }
                if (make) {
                    bb.Add_byte(b);
                }
                ++pos;
            }
        }
        int i = bgn;
        while (i < aryLen) {
            if (ary[i] == lkp) {
                posRef.Val_(i + 1);
                return make ? Bry_.Mid(ary, bgn, i) : Empty;
            }
            ++i;
        }
        throw Err_.new_wo_type("lkp failed", "lkp", Character.valueOf((char)lkp), "txt", String_.new_u8__by_len(ary, bgn, aryLen));
    }

    public static int ReadCsvInt(byte[] ary, Int_obj_ref posRef, byte lkp) {
        int bgn = posRef.Val();
        int pos = Bry_find_.Find_fwd(ary, lkp, bgn, ary.length);
        if (pos == -1) {
            throw Err_.new_wo_type("lkp failed", "lkp", Character.valueOf((char)lkp), "bgn", bgn);
        }
        int rv = Bry_.To_int_or(ary, posRef.Val(), pos, -1);
        posRef.Val_(pos + 1);
        return rv;
    }

    public static double ReadCsvDouble(byte[] ary, Int_obj_ref posRef, byte lkp) {
        int bgn = posRef.Val();
        int pos = Bry_find_.Find_fwd(ary, lkp, bgn, ary.length);
        if (pos == -1) {
            throw Err_.new_wo_type("lkp failed", "lkp", Character.valueOf((char)lkp), "bgn", bgn);
        }
        double rv = Bry_.To_double(ary, posRef.Val(), pos);
        posRef.Val_(pos + 1);
        return rv;
    }

    public static void ReadCsvNext(byte[] ary, Int_obj_ref posRef, byte lkp) {
        int bgn = posRef.Val();
        int pos = Bry_find_.Find_fwd(ary, lkp, bgn, ary.length);
        posRef.Val_(pos + 1);
    }

    public static byte[] Replace_create(byte[] src, byte find, byte replace) {
        byte[] rv = Bry_.Copy(src);
        Bry_.Replace_reuse(rv, find, replace);
        return rv;
    }

    public static void Replace_reuse(byte[] src, byte find, byte replace) {
        int src_len = src.length;
        int i = 0;
        while (i < src_len) {
            if (src[i] == find) {
                src[i] = replace;
            }
            ++i;
        }
    }

    public static byte[] Replace(byte[] src, byte find, byte replace) {
        return Bry_.Replace(src, 0, src.length, find, replace);
    }

    public static byte[] Replace(byte[] src, int bgn, int end, byte find, byte replace) {
        int src_len = src.length;
        byte[] rv = new byte[src_len];
        int i = bgn;
        while (i < end) {
            byte b = src[i];
            rv[i] = b == find ? replace : b;
            ++i;
        }
        i = end;
        while (i < src_len) {
            rv[i] = src[i];
            ++i;
        }
        return rv;
    }

    public static byte[] Replace_safe(Bry_bfr bfr, byte[] src, byte[] find, byte[] repl) {
        if (src == null || find == null || repl == null) {
            return null;
        }
        return Bry_.Replace(bfr, src, find, repl, 0, src.length);
    }

    public static byte[] Replace(Bry_bfr bfr, byte[] src, byte[] find, byte[] repl) {
        return Bry_.Replace(bfr, src, find, repl, 0, src.length);
    }

    public static byte[] Replace(Bry_bfr bfr, byte[] src, byte[] find, byte[] repl, int src_bgn, int src_end) {
        return Bry_.Replace(bfr, src, find, repl, src_bgn, src_end, Integer.MAX_VALUE);
    }

    public static byte[] Replace(Bry_bfr bfr, byte[] src, byte[] find, byte[] repl, int src_bgn, int src_end, int limit) {
        int pos = src_bgn;
        boolean dirty = false;
        int find_len = find.length;
        int bfr_bgn = pos;
        int replace_count = 0;
        while (pos < src_end) {
            int find_pos = Bry_find_.Find_fwd(src, find, pos);
            if (find_pos == -1) break;
            dirty = true;
            bfr.Add_mid(src, bfr_bgn, find_pos);
            bfr.Add(repl);
            bfr_bgn = pos = find_pos + find_len;
            if (++replace_count == limit) break;
        }
        if (dirty) {
            bfr.Add_mid(src, bfr_bgn, src_end);
        }
        return dirty ? bfr.To_bry_and_clear() : src;
    }

    public static byte[] Replace(byte[] src, byte[] find, byte[] replace) {
        return Bry_.Replace_between(src, find, null, replace);
    }

    public static byte[] Replace_between(byte[] src, byte[] bgn, byte[] end, byte[] replace) {
        Bry_bfr bfr = Bry_bfr_.New();
        boolean replace_all = end == null;
        int src_len = src.length;
        int bgn_len = bgn.length;
        int end_len = replace_all ? 0 : end.length;
        int pos = 0;
        while (pos < src_len) {
            int end_pos;
            int bgn_pos = Bry_find_.Find_fwd(src, bgn, pos);
            if (bgn_pos == -1) {
                bfr.Add_mid(src, pos, src_len);
                break;
            }
            int bgn_rhs = bgn_pos + bgn_len;
            int n = end_pos = replace_all ? bgn_rhs : Bry_find_.Find_fwd(src, end, bgn_rhs);
            if (end_pos == -1) {
                bfr.Add_mid(src, pos, src_len);
                break;
            }
            bfr.Add_mid(src, pos, bgn_pos);
            bfr.Add(replace);
            pos = end_pos + end_len;
        }
        return bfr.To_bry_and_clear();
    }

    public static int Trim_end_pos(byte[] src, int end) {
        int i = end - 1;
        while (i > -1) {
            switch (src[i]) {
                case 9: 
                case 10: 
                case 13: 
                case 32: {
                    break;
                }
                default: {
                    return i + 1;
                }
            }
            --i;
        }
        return 0;
    }

    public static byte[] Increment_last(byte[] ary) {
        return Bry_.Increment_last(ary, ary.length - 1);
    }

    public static byte[] Increment_last(byte[] ary, int end_idx) {
        int i = end_idx;
        while (i > -1) {
            byte end_val_new;
            byte end_val_old = ary[i];
            ary[i] = end_val_new = (byte)(end_val_old + 1);
            if (end_val_new > (end_val_old & 0xFF)) break;
            --i;
        }
        return ary;
    }

    public static byte[] Ucase__all(byte[] src) {
        return Bry_.Xcase__all(true, src, 0, -1);
    }

    public static byte[] Lcase__all(byte[] src) {
        return Bry_.Xcase__all(false, src, 0, -1);
    }

    public static byte[] Lcase__all(byte[] src, int bgn, int end) {
        return Bry_.Xcase__all(false, src, bgn, end);
    }

    private static byte[] Xcase__all(boolean upper, byte[] src, int bgn, int end) {
        int len;
        if (src == null) {
            return null;
        }
        int n = len = end == -1 ? src.length : end - bgn;
        if (len == 0) {
            return src;
        }
        byte[] rv = new byte[len];
        int i = 0;
        while (i < len) {
            byte b = src[i + bgn];
            if (upper) {
                if (b > 96 && b < 123) {
                    b = (byte)(b - 32);
                }
            } else if (b > 64 && b < 91) {
                b = (byte)(b + 32);
            }
            rv[i] = b;
            ++i;
        }
        return rv;
    }

    public static byte[] Xcase__build__all(Bry_bfr tmp, boolean upper, byte[] src) {
        if (src == null) {
            return null;
        }
        int src_bgn = 0;
        int src_end = src.length;
        byte lbound = 96;
        byte ubound = 123;
        if (!upper) {
            lbound = 64;
            ubound = 91;
        }
        boolean dirty = false;
        int i = src_bgn;
        while (i < src_end) {
            byte b = src[i];
            if (b > lbound && b < ubound) {
                if (!dirty) {
                    dirty = true;
                    tmp.Add_mid(src, src_bgn, i);
                }
                b = upper ? (byte)(b - 32) : (byte)(b + 32);
            }
            if (dirty) {
                tmp.Add_byte(b);
            }
            ++i;
        }
        return dirty ? tmp.To_bry_and_clear() : src;
    }

    public static byte[] Ucase__1st(byte[] src) {
        return Bry_.Xcase__1st(true, src);
    }

    public static byte[] Lcase__1st(byte[] src) {
        return Bry_.Xcase__1st(false, src);
    }

    private static byte[] Xcase__1st(boolean upper, byte[] src) {
        if (src == null) {
            return null;
        }
        int len = src.length;
        if (len == 0) {
            return src;
        }
        byte[] rv = new byte[len];
        byte b = src[0];
        if (upper) {
            if (b > 96 && b < 123) {
                b = (byte)(b - 32);
            }
        } else if (b > 64 && b < 91) {
            b = (byte)(b + 32);
        }
        rv[0] = b;
        int i = 1;
        while (i < len) {
            rv[i] = src[i];
            ++i;
        }
        return rv;
    }

    public static byte[] Null_if_empty(byte[] v) {
        return Bry_.Len_eq_0(v) ? null : v;
    }

    public static byte[] Escape_ws(byte[] bry) {
        Bry_bfr bfr = Bry_bfr_.Get();
        byte[] rv = Bry_.Escape_ws(bfr, bry);
        bfr.Mkr_rls();
        return rv;
    }

    public static byte[] Escape_ws(Bry_bfr bfr, byte[] src) {
        boolean dirty = false;
        int len = src.length;
        int i = 0;
        while (i < len) {
            byte b = src[i];
            byte escape = 0;
            switch (b) {
                case 9: {
                    escape = 116;
                    break;
                }
                case 10: {
                    escape = 110;
                    break;
                }
                case 13: {
                    escape = 114;
                    break;
                }
                default: {
                    if (!dirty) break;
                    bfr.Add_byte(b);
                }
            }
            if (escape != 0) {
                if (!dirty) {
                    dirty = true;
                    bfr.Add_mid(src, 0, i);
                }
                bfr.Add_byte_backslash().Add_byte(escape);
            }
            ++i;
        }
        return dirty ? bfr.To_bry_and_clear() : src;
    }

    public static byte[] Resolve_escape(Bry_bfr bfr, byte escape, byte[] raw, int bgn, int end) {
        int pos = bgn;
        boolean dirty = false;
        while (pos < end) {
            byte b = raw[pos];
            if (b == escape) {
                if (!dirty) {
                    dirty = true;
                    bfr.Add_mid(raw, bgn, pos);
                }
                if (++pos >= end) continue;
                bfr.Add_byte(raw[pos]);
                ++pos;
                continue;
            }
            if (dirty) {
                bfr.Add_byte(b);
            }
            ++pos;
        }
        return dirty ? bfr.To_bry_and_clear() : raw;
    }

    public static void Clear(byte[] bry) {
        int len = bry.length;
        int i = 0;
        while (i < len) {
            bry[i] = 0;
            ++i;
        }
    }

    public static byte[] Replace_nl_w_tab(byte[] src, int bgn, int end) {
        return Bry_.Replace(Bry_.Mid(src, bgn, end), (byte)10, (byte)9);
    }

    public static byte[] Escape_html(byte[] src) {
        return Bry_.Escape_html(null, false, src, 0, src.length);
    }

    public static byte[] Escape_html(Bry_bfr bfr, boolean ws, byte[] src, int src_bgn, int src_end) {
        boolean called_by_bry;
        int cur;
        boolean dirty = false;
        int prv = cur = src_bgn;
        boolean bl = called_by_bry = bfr == null;
        while (true) {
            if (cur == src_end) {
                if (!dirty) break;
                bfr.Add_mid(src, prv, src_end);
                break;
            }
            byte b = src[cur];
            byte[] escaped = null;
            switch (b) {
                case 38: {
                    escaped = Gfh_entity_.Amp_bry;
                    break;
                }
                case 34: {
                    escaped = Gfh_entity_.Quote_bry;
                    break;
                }
                case 39: {
                    escaped = Gfh_entity_.Apos_num_bry;
                    break;
                }
                case 60: {
                    escaped = Gfh_entity_.Lt_bry;
                    break;
                }
                case 62: {
                    escaped = Gfh_entity_.Gt_bry;
                    break;
                }
                case 10: {
                    if (!ws) break;
                    escaped = Gfh_entity_.Nl_bry;
                    break;
                }
                case 13: {
                    if (!ws) break;
                    escaped = Gfh_entity_.Cr_bry;
                    break;
                }
                case 9: {
                    if (!ws) break;
                    escaped = Gfh_entity_.Tab_bry;
                }
            }
            if (escaped == null) {
                ++cur;
                continue;
            }
            dirty = true;
            if (bfr == null) {
                bfr = Bry_bfr_.New();
            }
            if (prv < cur) {
                bfr.Add_mid(src, prv, cur);
            }
            bfr.Add(escaped);
            prv = ++cur;
        }
        if (dirty) {
            if (called_by_bry) {
                return bfr.To_bry_and_clear();
            }
            return null;
        }
        if (called_by_bry) {
            if (src_bgn == 0 && src_end == src.length) {
                return src;
            }
            return Bry_.Mid(src, src_bgn, src_end);
        }
        bfr.Add_mid(src, src_bgn, src_end);
        return null;
    }
}

