/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.tidy;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.NumberFormat;
import org.w3c.tidy.AttVal;
import org.w3c.tidy.Attribute;
import org.w3c.tidy.AttributeTable;
import org.w3c.tidy.Configuration;
import org.w3c.tidy.EncodingUtils;
import org.w3c.tidy.EntityTable;
import org.w3c.tidy.Lexer;
import org.w3c.tidy.Node;
import org.w3c.tidy.Out;
import org.w3c.tidy.OutFactory;
import org.w3c.tidy.ParserImpl;
import org.w3c.tidy.TagTable;
import org.w3c.tidy.TidyUtils;

public class PPrint {
    private static final short NORMAL = 0;
    private static final short PREFORMATTED = 1;
    private static final short COMMENT = 2;
    private static final short ATTRIBVALUE = 4;
    private static final short NOWRAP = 8;
    private static final short CDATA = 16;
    private static final String CDATA_START = "<![CDATA[";
    private static final String CDATA_END = "]]>";
    private static final String JS_COMMENT_START = "//";
    private static final String JS_COMMENT_END = "";
    private static final String VB_COMMENT_START = "'";
    private static final String VB_COMMENT_END = "";
    private static final String CSS_COMMENT_START = "/*";
    private static final String CSS_COMMENT_END = "*/";
    private static final String DEFAULT_COMMENT_START = "";
    private static final String DEFAULT_COMMENT_END = "";
    private int[] linebuf;
    private int lbufsize;
    private int linelen;
    private int wraphere;
    private boolean inAttVal;
    private boolean inString;
    private int slide;
    private int count;
    private Node slidecontent;
    private Configuration configuration;
    private static int[] Surrogate_split_tmp = new int[2];

    public PPrint(Configuration configuration) {
        this.configuration = configuration;
    }

    int cWrapLen(int n) {
        if ("zh".equals(this.configuration.language)) {
            return n + (this.configuration.wraplen - n) / 2;
        }
        if ("ja".equals(this.configuration.language)) {
            return n + (this.configuration.wraplen - n) * 7 / 10;
        }
        return this.configuration.wraplen;
    }

    public int get_utf8_xowa(int[] nArray, int n, byte[] byArray, int n2) {
        int n3 = PPrint.Len_of_char_by_1st_byte(n);
        if (n3 == 4) {
            int n4 = PPrint.Decode_to_int(byArray, n2);
            PPrint.Surrogate_split(n4, Surrogate_split_tmp);
            int n5 = Surrogate_split_tmp[0];
            if (n5 > 55295 && n5 < 56320) {
                this.addC(n5, this.linelen++);
                this.addC(Surrogate_split_tmp[1], this.linelen++);
                return 3;
            }
        }
        return PPrint.get_utf8_jtidy(byArray, n2, nArray);
    }

    public static void Surrogate_split(int n, int[] nArray) {
        nArray[0] = (n - 65536) / 1024 + 55296;
        nArray[1] = (n - 65536) % 1024 + 56320;
    }

    public static int Decode_to_int(byte[] byArray, int n) {
        byte by = byArray[n];
        if ((by & 0x80) == 0) {
            return by;
        }
        if ((by & 0xE0) == 192) {
            return (by & 0x1F) << 6 | byArray[n + 1] & 0x3F;
        }
        if ((by & 0xF0) == 224) {
            return (by & 0xF) << 12 | (byArray[n + 1] & 0x3F) << 6 | byArray[n + 2] & 0x3F;
        }
        if ((by & 0xF8) == 240) {
            return (by & 7) << 18 | (byArray[n + 1] & 0x3F) << 12 | (byArray[n + 2] & 0x3F) << 6 | byArray[n + 3] & 0x3F;
        }
        throw new RuntimeException("invalid utf8 byte: byte={0}");
    }

    public static int Len_of_char_by_1st_byte(int n) {
        int n2 = n & 0xFF;
        switch (n2) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 95: 
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 113: 
            case 114: 
            case 115: 
            case 116: 
            case 117: 
            case 118: 
            case 119: 
            case 120: 
            case 121: 
            case 122: 
            case 123: 
            case 124: 
            case 125: 
            case 126: 
            case 127: 
            case 128: 
            case 129: 
            case 130: 
            case 131: 
            case 132: 
            case 133: 
            case 134: 
            case 135: 
            case 136: 
            case 137: 
            case 138: 
            case 139: 
            case 140: 
            case 141: 
            case 142: 
            case 143: 
            case 144: 
            case 145: 
            case 146: 
            case 147: 
            case 148: 
            case 149: 
            case 150: 
            case 151: 
            case 152: 
            case 153: 
            case 154: 
            case 155: 
            case 156: 
            case 157: 
            case 158: 
            case 159: 
            case 160: 
            case 161: 
            case 162: 
            case 163: 
            case 164: 
            case 165: 
            case 166: 
            case 167: 
            case 168: 
            case 169: 
            case 170: 
            case 171: 
            case 172: 
            case 173: 
            case 174: 
            case 175: 
            case 176: 
            case 177: 
            case 178: 
            case 179: 
            case 180: 
            case 181: 
            case 182: 
            case 183: 
            case 184: 
            case 185: 
            case 186: 
            case 187: 
            case 188: 
            case 189: 
            case 190: 
            case 191: {
                return 1;
            }
            case 192: 
            case 193: 
            case 194: 
            case 195: 
            case 196: 
            case 197: 
            case 198: 
            case 199: 
            case 200: 
            case 201: 
            case 202: 
            case 203: 
            case 204: 
            case 205: 
            case 206: 
            case 207: 
            case 208: 
            case 209: 
            case 210: 
            case 211: 
            case 212: 
            case 213: 
            case 214: 
            case 215: 
            case 216: 
            case 217: 
            case 218: 
            case 219: 
            case 220: 
            case 221: 
            case 222: 
            case 223: {
                return 2;
            }
            case 224: 
            case 225: 
            case 226: 
            case 227: 
            case 228: 
            case 229: 
            case 230: 
            case 231: 
            case 232: 
            case 233: 
            case 234: 
            case 235: 
            case 236: 
            case 237: 
            case 238: 
            case 239: {
                return 3;
            }
            case 240: 
            case 241: 
            case 242: 
            case 243: 
            case 244: 
            case 245: 
            case 246: 
            case 247: {
                return 4;
            }
        }
        throw new RuntimeException("invalid initial utf8 byte");
    }

    public static int get_utf8_jtidy(byte[] byArray, int n, int[] nArray) {
        int[] nArray2 = new int[1];
        int[] nArray3 = new int[]{0};
        byte[] byArray2 = byArray;
        boolean bl = EncodingUtils.decodeUTF8BytesToChar(nArray2, TidyUtils.toUnsigned(byArray[n]), byArray2, null, nArray3, n + 1);
        if (bl) {
            nArray2[0] = 65533;
        }
        nArray[0] = nArray2[0];
        return nArray3[0] - 1;
    }

    public static int putUTF8(byte[] byArray, int n, int n2) {
        int[] nArray = new int[]{0};
        boolean bl = EncodingUtils.encodeCharToUTF8Bytes(n2, byArray, null, nArray);
        if (bl) {
            byArray[0] = -17;
            byArray[1] = -65;
            byArray[2] = -67;
            nArray[0] = 3;
        }
        return n += nArray[0];
    }

    private void addC(int n, int n2) {
        if (n2 + 1 >= this.lbufsize) {
            while (n2 + 1 >= this.lbufsize) {
                if (this.lbufsize == 0) {
                    this.lbufsize = 256;
                    continue;
                }
                this.lbufsize *= 2;
            }
            int[] nArray = new int[this.lbufsize];
            if (this.linebuf != null) {
                System.arraycopy(this.linebuf, 0, nArray, 0, n2);
            }
            this.linebuf = nArray;
        }
        this.linebuf[n2] = n;
    }

    private int addAsciiString(String string, int n) {
        int n2 = string.length();
        if (n + n2 >= this.lbufsize) {
            while (n + n2 >= this.lbufsize) {
                if (this.lbufsize == 0) {
                    this.lbufsize = 256;
                    continue;
                }
                this.lbufsize *= 2;
            }
            int[] nArray = new int[this.lbufsize];
            if (this.linebuf != null) {
                System.arraycopy(this.linebuf, 0, nArray, 0, n);
            }
            this.linebuf = nArray;
        }
        for (int i = 0; i < n2; ++i) {
            this.linebuf[n + i] = string.charAt(i);
        }
        return n + n2;
    }

    private void wrapLine(Out out, int n) {
        int n2;
        if (this.wraphere == 0) {
            return;
        }
        for (n2 = 0; n2 < n; ++n2) {
            out.outc(32);
        }
        for (n2 = 0; n2 < this.wraphere; ++n2) {
            out.outc(this.linebuf[n2]);
        }
        if (this.inString) {
            out.outc(32);
            out.outc(92);
        }
        out.newline();
        if (this.linelen > this.wraphere) {
            int n3 = 0;
            if (this.linebuf[this.wraphere] == 32) {
                ++this.wraphere;
            }
            int n4 = this.wraphere;
            this.addC(0, this.linelen);
            while (true) {
                this.linebuf[n3] = this.linebuf[n4];
                if (this.linebuf[n4] == 0) break;
                ++n3;
                ++n4;
            }
            this.linelen -= this.wraphere;
        } else {
            this.linelen = 0;
        }
        this.wraphere = 0;
    }

    private void wrapAttrVal(Out out, int n, boolean bl) {
        int n2;
        for (n2 = 0; n2 < n; ++n2) {
            out.outc(32);
        }
        for (n2 = 0; n2 < this.wraphere; ++n2) {
            out.outc(this.linebuf[n2]);
        }
        out.outc(32);
        if (bl) {
            out.outc(92);
        }
        out.newline();
        if (this.linelen > this.wraphere) {
            int n3 = 0;
            if (this.linebuf[this.wraphere] == 32) {
                ++this.wraphere;
            }
            int n4 = this.wraphere;
            this.addC(0, this.linelen);
            while (true) {
                this.linebuf[n3] = this.linebuf[n4];
                if (this.linebuf[n4] == 0) break;
                ++n3;
                ++n4;
            }
            this.linelen -= this.wraphere;
        } else {
            this.linelen = 0;
        }
        this.wraphere = 0;
    }

    public void flushLine(Out out, int n) {
        if (this.linelen > 0) {
            int n2;
            if (n + this.linelen >= this.configuration.wraplen) {
                this.wrapLine(out, n);
            }
            if (!this.inAttVal || this.configuration.indentAttributes) {
                for (n2 = 0; n2 < n; ++n2) {
                    out.outc(32);
                }
            }
            for (n2 = 0; n2 < this.linelen; ++n2) {
                out.outc(this.linebuf[n2]);
            }
        }
        out.newline();
        this.linelen = 0;
        this.wraphere = 0;
        this.inAttVal = false;
    }

    public void condFlushLine(Out out, int n) {
        if (this.linelen > 0) {
            int n2;
            if (n + this.linelen >= this.configuration.wraplen) {
                this.wrapLine(out, n);
            }
            if (!this.inAttVal || this.configuration.indentAttributes) {
                for (n2 = 0; n2 < n; ++n2) {
                    out.outc(32);
                }
            }
            for (n2 = 0; n2 < this.linelen; ++n2) {
                out.outc(this.linebuf[n2]);
            }
            out.newline();
            this.linelen = 0;
            this.wraphere = 0;
            this.inAttVal = false;
        }
    }

    private void printChar(int n, short s) {
        boolean bl = false;
        if (n == 32 && !TidyUtils.toBoolean(s & 0x17)) {
            if (TidyUtils.toBoolean(s & 8)) {
                String string = "&nbsp;";
                if (this.configuration.numEntities || this.configuration.xmlTags) {
                    string = "&#160;";
                }
                this.linelen = this.addAsciiString(string, this.linelen);
                return;
            }
            this.wraphere = this.linelen;
        }
        if (TidyUtils.toBoolean(s & 0x12)) {
            this.addC(n, this.linelen++);
            return;
        }
        if (!TidyUtils.toBoolean(s & 0x10)) {
            if (n == 60) {
                this.linelen = this.addAsciiString("&lt;", this.linelen);
                return;
            }
            if (n == 62) {
                this.linelen = this.addAsciiString("&gt;", this.linelen);
                return;
            }
            if (n == 38 && this.configuration.quoteAmpersand) {
                this.linelen = this.addAsciiString("&amp;", this.linelen);
                return;
            }
            if (n == 34 && this.configuration.quoteMarks) {
                this.linelen = this.addAsciiString("&quot;", this.linelen);
                return;
            }
            if (n == 39 && this.configuration.quoteMarks) {
                this.linelen = this.addAsciiString("&#39;", this.linelen);
                return;
            }
            if (n == 160 && !this.configuration.rawOut) {
                if (this.configuration.makeBare) {
                    this.addC(32, this.linelen++);
                } else if (this.configuration.quoteNbsp) {
                    this.linelen = this.configuration.numEntities || this.configuration.xmlTags ? this.addAsciiString("&#160;", this.linelen) : this.addAsciiString("&nbsp;", this.linelen);
                } else {
                    this.addC(n, this.linelen++);
                }
                return;
            }
        }
        if ("UTF8".equals(this.configuration.getOutCharEncodingName())) {
            if (n >= 8192 && !TidyUtils.toBoolean(s & 1)) {
                if (n >= 8192 && n <= 8198 || n >= 8200 && n <= 8208 || n >= 8209 && n <= 8262 || n >= 8317 && n <= 8318 || n >= 8333 && n <= 8334 || n >= 9001 && n <= 9002 || n >= 12289 && n <= 12291 || n >= 12296 && n <= 12305 || n >= 12308 && n <= 12319 || n >= 64830 && n <= 64831 || n >= 65072 && n <= 65092 || n >= 65097 && n <= 65106 || n >= 65108 && n <= 65121 || n >= 65130 && n <= 65131 || n >= 65281 && n <= 65283 || n >= 65285 && n <= 65290 || n >= 65292 && n <= 65295 || n >= 65306 && n <= 65307 || n >= 65311 && n <= 65312 || n >= 65339 && n <= 65341 || n >= 65377 && n <= 65381) {
                    this.wraphere = this.linelen + 2;
                    bl = true;
                } else {
                    switch (n) {
                        case 12336: 
                        case 12539: 
                        case 65123: 
                        case 65128: 
                        case 65343: 
                        case 65371: 
                        case 65373: {
                            this.wraphere = this.linelen + 2;
                            bl = true;
                        }
                    }
                }
                if (bl) {
                    if (n >= 8218 && n <= 8220 || n >= 8222 && n <= 8223) {
                        --this.wraphere;
                    } else {
                        switch (n) {
                            case 8216: 
                            case 8249: 
                            case 8261: 
                            case 8317: 
                            case 8333: 
                            case 9001: 
                            case 12296: 
                            case 12298: 
                            case 12300: 
                            case 12302: 
                            case 12304: 
                            case 12308: 
                            case 12310: 
                            case 12312: 
                            case 12314: 
                            case 12317: 
                            case 64830: 
                            case 65077: 
                            case 65079: 
                            case 65081: 
                            case 65083: 
                            case 65085: 
                            case 65087: 
                            case 65089: 
                            case 65091: 
                            case 65113: 
                            case 65115: 
                            case 65117: 
                            case 65288: 
                            case 65339: 
                            case 65371: 
                            case 65378: {
                                --this.wraphere;
                            }
                        }
                    }
                }
            } else {
                if ("BIG5".equals(this.configuration.getOutCharEncodingName())) {
                    this.addC(n, this.linelen++);
                    if ((n & 0xFF00) == 41216 && !TidyUtils.toBoolean(s & 1)) {
                        this.wraphere = this.linelen;
                        if (n > 92 && n < 173 && (n & 1) == 1) {
                            --this.wraphere;
                        }
                    }
                    return;
                }
                if ("SHIFTJIS".equals(this.configuration.getOutCharEncodingName()) || "ISO2022".equals(this.configuration.getOutCharEncodingName())) {
                    this.addC(n, this.linelen++);
                    return;
                }
                if (this.configuration.rawOut) {
                    this.addC(n, this.linelen++);
                    return;
                }
            }
        }
        if (n == 160 && TidyUtils.toBoolean(s & 1)) {
            this.addC(32, this.linelen++);
            return;
        }
        if ((this.configuration.makeClean && this.configuration.asciiChars || this.configuration.makeBare) && n >= 8211 && n <= 8222) {
            switch (n) {
                case 8211: 
                case 8212: {
                    n = 45;
                    break;
                }
                case 8216: 
                case 8217: 
                case 8218: {
                    n = 39;
                    break;
                }
                case 8220: 
                case 8221: 
                case 8222: {
                    n = 34;
                }
            }
        }
        if ("ISO8859_1".equals(this.configuration.getOutCharEncodingName())) {
            if (n > 255) {
                String string;
                string = !this.configuration.numEntities ? ((string = EntityTable.getDefaultEntityTable().entityName((short)n)) != null ? "&" + string + ";" : "&#" + n + ";") : "&#" + n + ";";
                for (int i = 0; i < string.length(); ++i) {
                    this.addC(string.charAt(i), this.linelen++);
                }
                return;
            }
            if (n > 126 && n < 160) {
                String string = "&#" + n + ";";
                for (int i = 0; i < string.length(); ++i) {
                    this.addC(string.charAt(i), this.linelen++);
                }
                return;
            }
            this.addC(n, this.linelen++);
            return;
        }
        if (this.configuration.getOutCharEncodingName().startsWith("UTF")) {
            this.addC(n, this.linelen++);
            return;
        }
        if (this.configuration.xmlTags) {
            if (n > 127 && "ASCII".equals(this.configuration.getOutCharEncodingName())) {
                String string = "&#" + n + ";";
                for (int i = 0; i < string.length(); ++i) {
                    this.addC(string.charAt(i), this.linelen++);
                }
                return;
            }
            this.addC(n, this.linelen++);
            return;
        }
        if ("ASCII".equals(this.configuration.getOutCharEncodingName()) && (n > 126 || n < 32 && n != 9)) {
            String string;
            string = !this.configuration.numEntities ? ((string = EntityTable.getDefaultEntityTable().entityName((short)n)) != null ? "&" + string + ";" : "&#" + n + ";") : "&#" + n + ";";
            for (int i = 0; i < string.length(); ++i) {
                this.addC(string.charAt(i), this.linelen++);
            }
            return;
        }
        this.addC(n, this.linelen++);
    }

    private void printText(Out out, short s, int n, byte[] byArray, int n2, int n3) {
        int[] nArray = new int[1];
        for (int i = n2; i < n3; ++i) {
            int n4;
            if (n + this.linelen >= this.configuration.wraplen) {
                this.wrapLine(out, n);
            }
            if ((n4 = byArray[i] & 0xFF) > 127) {
                i += PPrint.get_utf8_jtidy(byArray, i, nArray);
                n4 = nArray[0];
            }
            if (n4 == 10) {
                this.flushLine(out, n);
                continue;
            }
            this.printChar(n4, s);
        }
    }

    private void printString(String string) {
        for (int i = 0; i < string.length(); ++i) {
            this.addC(string.charAt(i), this.linelen++);
        }
    }

    private void printAttrValue(Out out, int n, String string, int n2, boolean bl) {
        short s;
        int[] nArray = new int[1];
        boolean bl2 = false;
        byte[] byArray = null;
        short s2 = s = bl ? (short)4 : 5;
        if (string != null) {
            byArray = TidyUtils.getBytes(string);
        }
        if (byArray != null && byArray.length >= 5 && byArray[0] == 60 && (byArray[1] == 37 || byArray[1] == 64 || new String(byArray, 0, 5).equals("<?php"))) {
            s = (short)(s | 0x10);
        }
        if (n2 == 0) {
            n2 = 34;
        }
        this.addC(61, this.linelen++);
        if (!this.configuration.xmlOut) {
            if (n + this.linelen < this.configuration.wraplen) {
                this.wraphere = this.linelen;
            }
            if (n + this.linelen >= this.configuration.wraplen) {
                this.wrapLine(out, n);
            }
            if (n + this.linelen < this.configuration.wraplen) {
                this.wraphere = this.linelen;
            } else {
                this.condFlushLine(out, n);
            }
        }
        this.addC(n2, this.linelen++);
        if (string != null) {
            this.inString = false;
            int n3 = 0;
            while (n3 < byArray.length) {
                int n4 = byArray[n3] & 0xFF;
                if (bl && n4 == 32 && n + this.linelen < this.configuration.wraplen) {
                    this.wraphere = this.linelen;
                    bl2 = this.inString;
                }
                if (bl && this.wraphere > 0 && n + this.linelen >= this.configuration.wraplen) {
                    this.wrapAttrVal(out, n, bl2);
                }
                if (n4 == n2) {
                    String string2 = n4 == 34 ? "&quot;" : "&#39;";
                    for (int i = 0; i < string2.length(); ++i) {
                        this.addC(string2.charAt(i), this.linelen++);
                    }
                    ++n3;
                    continue;
                }
                if (n4 == 34) {
                    if (this.configuration.quoteMarks) {
                        this.addC(38, this.linelen++);
                        this.addC(113, this.linelen++);
                        this.addC(117, this.linelen++);
                        this.addC(111, this.linelen++);
                        this.addC(116, this.linelen++);
                        this.addC(59, this.linelen++);
                    } else {
                        this.addC(34, this.linelen++);
                    }
                    if (n2 == 39) {
                        this.inString = !this.inString;
                    }
                    ++n3;
                    continue;
                }
                if (n4 == 39) {
                    if (this.configuration.quoteMarks) {
                        this.addC(38, this.linelen++);
                        this.addC(35, this.linelen++);
                        this.addC(51, this.linelen++);
                        this.addC(57, this.linelen++);
                        this.addC(59, this.linelen++);
                    } else {
                        this.addC(39, this.linelen++);
                    }
                    if (n2 == 34) {
                        this.inString = !this.inString;
                    }
                    ++n3;
                    continue;
                }
                if (n4 > 127) {
                    int n5 = this.get_utf8_xowa(nArray, n4, byArray, n3);
                    if (n5 == 3) {
                        n3 += 4;
                        continue;
                    }
                    n3 += n5;
                    n4 = nArray[0];
                }
                ++n3;
                if (n4 == 10) {
                    this.flushLine(out, n);
                    continue;
                }
                this.printChar(n4, s);
            }
        }
        this.inString = false;
        this.addC(n2, this.linelen++);
    }

    private void printAttribute(Out out, int n, Node node, AttVal attVal) {
        boolean bl = false;
        if (this.configuration.indentAttributes) {
            this.flushLine(out, n);
            n += this.configuration.spaces;
        }
        String string = attVal.attribute;
        if (n + this.linelen >= this.configuration.wraplen) {
            this.wrapLine(out, n);
        }
        if (!this.configuration.xmlTags && !this.configuration.xmlOut && attVal.dict != null) {
            if (AttributeTable.getDefaultAttributeTable().isScript(string)) {
                bl = this.configuration.wrapScriptlets;
            } else if (!attVal.dict.isNowrap() && this.configuration.wrapAttVals) {
                bl = true;
            }
        }
        if (n + this.linelen < this.configuration.wraplen) {
            this.wraphere = this.linelen;
            this.addC(32, this.linelen++);
        } else {
            this.condFlushLine(out, n);
            this.addC(32, this.linelen++);
        }
        for (int i = 0; i < string.length(); ++i) {
            this.addC(TidyUtils.foldCase(string.charAt(i), this.configuration.upperCaseAttrs, this.configuration.xmlTags), this.linelen++);
        }
        if (n + this.linelen >= this.configuration.wraplen) {
            this.wrapLine(out, n);
        }
        if (attVal.value == null) {
            if (this.configuration.xmlTags || this.configuration.xmlOut) {
                this.printAttrValue(out, n, attVal.isBoolAttribute() ? attVal.attribute : "", attVal.delim, true);
            } else if (!attVal.isBoolAttribute() && node != null && !node.isNewNode()) {
                this.printAttrValue(out, n, "", attVal.delim, true);
            } else if (n + this.linelen < this.configuration.wraplen) {
                this.wraphere = this.linelen;
            }
        } else {
            this.printAttrValue(out, n, attVal.value, attVal.delim, bl);
        }
    }

    private void printAttrs(Out out, int n, Node node, AttVal attVal) {
        if (this.configuration.xmlOut && this.configuration.xmlSpace && ParserImpl.XMLPreserveWhiteSpace(node, this.configuration.tt) && node.getAttrByName("xml:space") == null) {
            node.addAttribute("xml:space", "preserve");
            if (attVal != null) {
                attVal = node.attributes;
            }
        }
        if (attVal != null) {
            if (attVal.next != null) {
                this.printAttrs(out, n, node, attVal.next);
            }
            if (attVal.attribute != null) {
                Attribute attribute = attVal.dict;
                if (!this.configuration.dropProprietaryAttributes || attribute != null && !TidyUtils.toBoolean(attribute.getVersions() & 0x1C0)) {
                    this.printAttribute(out, n, node, attVal);
                }
            } else if (attVal.asp != null) {
                this.addC(32, this.linelen++);
                this.printAsp(out, n, attVal.asp);
            } else if (attVal.php != null) {
                this.addC(32, this.linelen++);
                this.printPhp(out, n, attVal.php);
            }
        }
    }

    public static boolean TextNodeEndWithSpace(Lexer lexer, Node node) {
        if (node.type == 4 && node.end > node.start) {
            int n = 0;
            for (int i = node.start; i < node.end; ++i) {
                n = lexer.lexbuf[i];
            }
            if (n == 32 || n == 10) {
                return true;
            }
        }
        return false;
    }

    private static boolean afterSpace(Node node) {
        if (node == null || node.tag == null || !TidyUtils.toBoolean(node.tag.model & 0x10)) {
            return true;
        }
        Node node2 = node.prev;
        if (node2 != null) {
            int n;
            return node2.type == 4 && node2.end > node2.start && ((n = node2.textarray[node2.end - 1] & 0xFF) == 160 || n == 32 || n == 10);
        }
        return PPrint.afterSpace(node.parent);
    }

    private void printTag(Lexer lexer, Out out, short s, int n, Node node) {
        TagTable tagTable = this.configuration.tt;
        this.addC(60, this.linelen++);
        if (node.type == 6) {
            this.addC(47, this.linelen++);
        }
        String string = node.element;
        for (int i = 0; i < string.length(); ++i) {
            this.addC(TidyUtils.foldCase(string.charAt(i), this.configuration.upperCaseTags, this.configuration.xmlTags), this.linelen++);
        }
        this.printAttrs(out, n, node, node.attributes);
        if ((this.configuration.xmlOut || this.configuration.xHTML) && (node.type == 7 || TidyUtils.toBoolean(node.tag.model & 1))) {
            this.addC(32, this.linelen++);
            this.addC(47, this.linelen++);
        }
        this.addC(62, this.linelen++);
        if ((node.type != 7 || this.configuration.xHTML) && !TidyUtils.toBoolean(s & 1)) {
            if (n + this.linelen >= this.configuration.wraplen) {
                this.wrapLine(out, n);
            }
            if (n + this.linelen < this.configuration.wraplen) {
                if (!(TidyUtils.toBoolean(s & 8) || TidyUtils.toBoolean(node.tag.model & 0x10) && node.tag != tagTable.tagBr || !PPrint.afterSpace(node))) {
                    this.wraphere = this.linelen;
                }
            } else if (TidyUtils.toBoolean(s & 8) || node.tag == tagTable.tagBr || PPrint.afterSpace(node)) {
                this.condFlushLine(out, n);
            }
        }
    }

    private void printEndTag(short s, int n, Node node) {
        this.addC(60, this.linelen++);
        this.addC(47, this.linelen++);
        String string = node.element;
        for (int i = 0; i < string.length(); ++i) {
            this.addC(TidyUtils.foldCase(string.charAt(i), this.configuration.upperCaseTags, this.configuration.xmlTags), this.linelen++);
        }
        this.addC(62, this.linelen++);
    }

    private void printComment(Out out, int n, Node node) {
        if (this.configuration.hideComments) {
            return;
        }
        if (n + this.linelen < this.configuration.wraplen) {
            this.wraphere = this.linelen;
        }
        this.addC(60, this.linelen++);
        this.addC(33, this.linelen++);
        this.addC(45, this.linelen++);
        this.addC(45, this.linelen++);
        this.printText(out, (short)2, n, node.textarray, node.start, node.end);
        this.addC(45, this.linelen++);
        this.addC(45, this.linelen++);
        this.addC(62, this.linelen++);
        if (node.linebreak) {
            this.flushLine(out, n);
        }
    }

    private void printDocType(Out out, int n, Lexer lexer, Node node) {
        int n2 = 0;
        short s = 0;
        boolean bl = this.configuration.quoteMarks;
        this.configuration.quoteMarks = false;
        if (n + this.linelen < this.configuration.wraplen) {
            this.wraphere = this.linelen;
        }
        this.condFlushLine(out, n);
        this.addC(60, this.linelen++);
        this.addC(33, this.linelen++);
        this.addC(68, this.linelen++);
        this.addC(79, this.linelen++);
        this.addC(67, this.linelen++);
        this.addC(84, this.linelen++);
        this.addC(89, this.linelen++);
        this.addC(80, this.linelen++);
        this.addC(69, this.linelen++);
        this.addC(32, this.linelen++);
        if (n + this.linelen < this.configuration.wraplen) {
            this.wraphere = this.linelen;
        }
        for (int i = node.start; i < node.end; ++i) {
            if (n + this.linelen >= this.configuration.wraplen) {
                this.wrapLine(out, n);
            }
            n2 = node.textarray[i] & 0xFF;
            if (TidyUtils.toBoolean(s & 0x10)) {
                if (n2 == 93) {
                    s = (short)(s & 0xFFFFFFEF);
                }
            } else if (n2 == 91) {
                s = (short)(s | 0x10);
            }
            int[] nArray = new int[1];
            if (n2 > 127) {
                i += PPrint.get_utf8_jtidy(node.textarray, i, nArray);
                n2 = nArray[0];
            }
            if (n2 == 10) {
                this.flushLine(out, n);
                continue;
            }
            this.printChar(n2, s);
        }
        if (this.linelen < this.configuration.wraplen) {
            this.wraphere = this.linelen;
        }
        this.addC(62, this.linelen++);
        this.configuration.quoteMarks = bl;
        this.condFlushLine(out, n);
    }

    private void printPI(Out out, int n, Node node) {
        if (n + this.linelen < this.configuration.wraplen) {
            this.wraphere = this.linelen;
        }
        this.addC(60, this.linelen++);
        this.addC(63, this.linelen++);
        this.printText(out, (short)16, n, node.textarray, node.start, node.end);
        if (node.end <= 0 || node.textarray[node.end - 1] != 63) {
            this.addC(63, this.linelen++);
        }
        this.addC(62, this.linelen++);
        this.condFlushLine(out, n);
    }

    private void printXmlDecl(Out out, int n, Node node) {
        if (n + this.linelen < this.configuration.wraplen) {
            this.wraphere = this.linelen;
        }
        this.addC(60, this.linelen++);
        this.addC(63, this.linelen++);
        this.addC(120, this.linelen++);
        this.addC(109, this.linelen++);
        this.addC(108, this.linelen++);
        this.printAttrs(out, n, node, node.attributes);
        if (node.end <= 0 || node.textarray[node.end - 1] != 63) {
            this.addC(63, this.linelen++);
        }
        this.addC(62, this.linelen++);
        this.condFlushLine(out, n);
    }

    private void printAsp(Out out, int n, Node node) {
        int n2 = this.configuration.wraplen;
        if (!this.configuration.wrapAsp || !this.configuration.wrapJste) {
            this.configuration.wraplen = 0xFFFFFF;
        }
        this.addC(60, this.linelen++);
        this.addC(37, this.linelen++);
        this.printText(out, this.configuration.wrapAsp ? (short)16 : 2, n, node.textarray, node.start, node.end);
        this.addC(37, this.linelen++);
        this.addC(62, this.linelen++);
        this.configuration.wraplen = n2;
    }

    private void printJste(Out out, int n, Node node) {
        int n2 = this.configuration.wraplen;
        if (!this.configuration.wrapJste) {
            this.configuration.wraplen = 0xFFFFFF;
        }
        this.addC(60, this.linelen++);
        this.addC(35, this.linelen++);
        this.printText(out, this.configuration.wrapJste ? (short)16 : 2, n, node.textarray, node.start, node.end);
        this.addC(35, this.linelen++);
        this.addC(62, this.linelen++);
        this.configuration.wraplen = n2;
    }

    private void printPhp(Out out, int n, Node node) {
        int n2 = this.configuration.wraplen;
        if (!this.configuration.wrapPhp) {
            this.configuration.wraplen = 0xFFFFFF;
        }
        this.addC(60, this.linelen++);
        this.addC(63, this.linelen++);
        this.printText(out, this.configuration.wrapPhp ? (short)16 : 2, n, node.textarray, node.start, node.end);
        this.addC(63, this.linelen++);
        this.addC(62, this.linelen++);
        this.configuration.wraplen = n2;
    }

    private void printCDATA(Out out, int n, Node node) {
        int n2 = this.configuration.wraplen;
        if (!this.configuration.indentCdata) {
            n = 0;
        }
        this.condFlushLine(out, n);
        this.configuration.wraplen = 0xFFFFFF;
        this.addC(60, this.linelen++);
        this.addC(33, this.linelen++);
        this.addC(91, this.linelen++);
        this.addC(67, this.linelen++);
        this.addC(68, this.linelen++);
        this.addC(65, this.linelen++);
        this.addC(84, this.linelen++);
        this.addC(65, this.linelen++);
        this.addC(91, this.linelen++);
        this.printText(out, (short)2, n, node.textarray, node.start, node.end);
        this.addC(93, this.linelen++);
        this.addC(93, this.linelen++);
        this.addC(62, this.linelen++);
        this.condFlushLine(out, n);
        this.configuration.wraplen = n2;
    }

    private void printSection(Out out, int n, Node node) {
        int n2 = this.configuration.wraplen;
        if (!this.configuration.wrapSection) {
            this.configuration.wraplen = 0xFFFFFF;
        }
        this.addC(60, this.linelen++);
        this.addC(33, this.linelen++);
        this.addC(91, this.linelen++);
        this.printText(out, this.configuration.wrapSection ? (short)16 : 2, n, node.textarray, node.start, node.end);
        this.addC(93, this.linelen++);
        this.addC(62, this.linelen++);
        this.configuration.wraplen = n2;
    }

    private boolean insideHead(Node node) {
        if (node.tag == this.configuration.tt.tagHead) {
            return true;
        }
        if (node.parent != null) {
            return this.insideHead(node.parent);
        }
        return false;
    }

    private int textEndsWithNewline(Lexer lexer, Node node) {
        if (node.type == 4 && node.end > node.start) {
            int n;
            int n2;
            for (n2 = node.end - 1; n2 >= node.start && TidyUtils.toBoolean(n = node.textarray[n2] & 0xFF) && (n == 32 || n == 9 || n == 13); --n2) {
            }
            if (n2 >= 0 && node.textarray[n2] == 10) {
                return node.end - n2 - 1;
            }
        }
        return -1;
    }

    static boolean hasCDATA(Lexer lexer, Node node) {
        if (node.type != 4) {
            return false;
        }
        int n = node.end - node.start + 1;
        String string = TidyUtils.getString(node.textarray, node.start, n);
        int n2 = string.indexOf(CDATA_START);
        return n2 > -1 && n2 <= n;
    }

    private void printScriptStyle(Out out, short s, int n, Lexer lexer, Node node) {
        int n2;
        String string = "";
        String string2 = "";
        boolean bl = false;
        int n3 = -1;
        if (this.insideHead(node)) {
            // empty if block
        }
        n = 0;
        this.printTag(lexer, out, s, n, node);
        if (lexer.configuration.xHTML && node.content != null) {
            AttVal attVal = node.getAttrByName("type");
            if (attVal != null) {
                if ("text/javascript".equalsIgnoreCase(attVal.value)) {
                    string = JS_COMMENT_START;
                    string2 = "";
                } else if ("text/css".equalsIgnoreCase(attVal.value)) {
                    string = CSS_COMMENT_START;
                    string2 = CSS_COMMENT_END;
                } else if ("text/vbscript".equalsIgnoreCase(attVal.value)) {
                    string = VB_COMMENT_START;
                    string2 = "";
                }
            }
            if (!(bl = PPrint.hasCDATA(lexer, node.content))) {
                n2 = lexer.configuration.wraplen;
                lexer.configuration.wraplen = 0xFFFFFF;
                this.linelen = this.addAsciiString(string, this.linelen);
                this.linelen = this.addAsciiString(CDATA_START, this.linelen);
                this.linelen = this.addAsciiString(string2, this.linelen);
                this.condFlushLine(out, n);
                lexer.configuration.wraplen = n2;
            }
        }
        Node node2 = node.content;
        while (node2 != null) {
            this.printTree(out, (short)(s | 1 | 8 | 0x10), 0, lexer, node2);
            if (node2.next == null) {
                n3 = this.textEndsWithNewline(lexer, node2);
            }
            node2 = node2.next;
        }
        if (n3 < 0) {
            this.condFlushLine(out, n);
            n3 = 0;
        }
        if (lexer.configuration.xHTML && node.content != null && !bl) {
            n2 = lexer.configuration.wraplen;
            lexer.configuration.wraplen = 0xFFFFFF;
            if (n3 > 0 && this.linelen < n3) {
                this.linelen = n3;
            }
            for (int i = 0; n3 < n && i < n - n3; ++i) {
                this.addC(32, this.linelen++);
            }
            this.linelen = this.addAsciiString(string, this.linelen);
            this.linelen = this.addAsciiString(CDATA_END, this.linelen);
            this.linelen = this.addAsciiString(string2, this.linelen);
            lexer.configuration.wraplen = n2;
            this.condFlushLine(out, 0);
        }
        this.printEndTag(s, n, node);
        if (!(lexer.configuration.indentContent || node.next == null || node.tag != null && TidyUtils.toBoolean(node.tag.model & 0x10) || node.type != 4)) {
            this.flushLine(out, n);
        }
        this.flushLine(out, n);
    }

    private boolean shouldIndent(Node node) {
        TagTable tagTable = this.configuration.tt;
        if (!this.configuration.indentContent) {
            return false;
        }
        if (node.tag == tagTable.tagTextarea) {
            return false;
        }
        if (this.configuration.smartIndent) {
            if (node.content != null && TidyUtils.toBoolean(node.tag.model & 0x40000)) {
                node = node.content;
                while (node != null) {
                    if (node.tag != null && TidyUtils.toBoolean(node.tag.model & 8)) {
                        return true;
                    }
                    node = node.next;
                }
                return false;
            }
            if (TidyUtils.toBoolean(node.tag.model & 0x4000)) {
                return false;
            }
            if (node.tag == tagTable.tagP) {
                return false;
            }
            if (node.tag == tagTable.tagTitle) {
                return false;
            }
        }
        if (TidyUtils.toBoolean(node.tag.model & 0xC00)) {
            return true;
        }
        if (node.tag == tagTable.tagMap) {
            return true;
        }
        return !TidyUtils.toBoolean(node.tag.model & 0x10);
    }

    void printBody(Out out, Lexer lexer, Node node, boolean bl) {
        if (node == null) {
            return;
        }
        Node node2 = node.findBody(lexer.configuration.tt);
        if (node2 != null) {
            Node node3 = node2.content;
            while (node3 != null) {
                if (bl) {
                    this.printXMLTree(out, (short)0, 0, lexer, node3);
                } else {
                    this.printTree(out, (short)0, 0, lexer, node3);
                }
                node3 = node3.next;
            }
        }
    }

    public void printTree(Out out, short s, int n, Lexer lexer, Node node) {
        TagTable tagTable = this.configuration.tt;
        if (node == null) {
            return;
        }
        if (node.type == 4 || node.type == 8 && lexer.configuration.escapeCdata) {
            this.printText(out, s, n, node.textarray, node.start, node.end);
        } else if (node.type == 2) {
            this.printComment(out, n, node);
        } else if (node.type == 0) {
            Node node2 = node.content;
            while (node2 != null) {
                this.printTree(out, s, n, lexer, node2);
                node2 = node2.next;
            }
        } else if (node.type == 1) {
            this.printDocType(out, n, lexer, node);
        } else if (node.type == 3) {
            this.printPI(out, n, node);
        } else if (node.type == 13) {
            this.printXmlDecl(out, n, node);
        } else if (node.type == 8) {
            this.printCDATA(out, n, node);
        } else if (node.type == 9) {
            this.printSection(out, n, node);
        } else if (node.type == 10) {
            this.printAsp(out, n, node);
        } else if (node.type == 11) {
            this.printJste(out, n, node);
        } else if (node.type == 12) {
            this.printPhp(out, n, node);
        } else if (TidyUtils.toBoolean(node.tag.model & 1) || node.type == 7 && !this.configuration.xHTML) {
            if (!TidyUtils.toBoolean(node.tag.model & 0x10)) {
                this.condFlushLine(out, n);
            }
            if (node.tag == tagTable.tagBr && node.prev != null && node.prev.tag != tagTable.tagBr && this.configuration.breakBeforeBR) {
                this.flushLine(out, n);
            }
            if (this.configuration.makeClean && node.tag == tagTable.tagWbr) {
                this.printString(" ");
            } else {
                this.printTag(lexer, out, s, n, node);
            }
            if (node.tag == tagTable.tagParam || node.tag == tagTable.tagArea) {
                this.condFlushLine(out, n);
            } else if (node.tag == tagTable.tagBr || node.tag == tagTable.tagHr) {
                this.flushLine(out, n);
            }
        } else {
            if (node.type == 7) {
                node.type = (short)5;
            }
            if (node.tag != null && (node.tag.getParser() == ParserImpl.PRE || node.tag == tagTable.tagTextarea)) {
                this.condFlushLine(out, n);
                n = 0;
                this.condFlushLine(out, n);
                this.printTag(lexer, out, s, n, node);
                this.flushLine(out, n);
                Node node3 = node.content;
                while (node3 != null) {
                    this.printTree(out, (short)(s | 1 | 8), n, lexer, node3);
                    node3 = node3.next;
                }
                this.condFlushLine(out, n);
                this.printEndTag(s, n, node);
                this.flushLine(out, n);
                if (!this.configuration.indentContent && node.next != null) {
                    this.flushLine(out, n);
                }
            } else if (node.tag == tagTable.tagStyle || node.tag == tagTable.tagScript) {
                this.printScriptStyle(out, (short)(s | 1 | 8 | 0x10), n, lexer, node);
            } else if (TidyUtils.toBoolean(node.tag.model & 0x10)) {
                if (this.configuration.makeClean) {
                    if (node.tag == tagTable.tagFont) {
                        Node node4 = node.content;
                        while (node4 != null) {
                            this.printTree(out, s, n, lexer, node4);
                            node4 = node4.next;
                        }
                        return;
                    }
                    if (node.tag == tagTable.tagNobr) {
                        Node node5 = node.content;
                        while (node5 != null) {
                            this.printTree(out, (short)(s | 8), n, lexer, node5);
                            node5 = node5.next;
                        }
                        return;
                    }
                }
                this.printTag(lexer, out, s, n, node);
                if (this.shouldIndent(node)) {
                    this.condFlushLine(out, n);
                    n += this.configuration.spaces;
                    Node node6 = node.content;
                    while (node6 != null) {
                        this.printTree(out, s, n, lexer, node6);
                        node6 = node6.next;
                    }
                    this.condFlushLine(out, n);
                    this.condFlushLine(out, n -= this.configuration.spaces);
                } else {
                    Node node7 = node.content;
                    while (node7 != null) {
                        this.printTree(out, s, n, lexer, node7);
                        node7 = node7.next;
                    }
                }
                this.printEndTag(s, n, node);
            } else {
                this.condFlushLine(out, n);
                if (this.configuration.smartIndent && node.prev != null) {
                    this.flushLine(out, n);
                }
                if (!this.configuration.hideEndTags || node.tag == null || !TidyUtils.toBoolean(node.tag.model & 0x200000) || node.attributes != null) {
                    this.printTag(lexer, out, s, n, node);
                    if (this.shouldIndent(node)) {
                        this.condFlushLine(out, n);
                    } else if (TidyUtils.toBoolean(node.tag.model & 2) || node.tag == tagTable.tagNoframes || TidyUtils.toBoolean(node.tag.model & 4) && node.tag != tagTable.tagTitle) {
                        this.flushLine(out, n);
                    }
                }
                if (node.tag == tagTable.tagBody && this.configuration.burstSlides) {
                    this.printSlide(out, s, this.configuration.indentContent ? n + this.configuration.spaces : n, lexer);
                } else {
                    Node node8 = null;
                    Node node9 = node.content;
                    while (node9 != null) {
                        if (node8 != null && !this.configuration.indentContent && node8.type == 4 && node9.tag != null && !TidyUtils.toBoolean(node9.tag.model & 0x10)) {
                            this.flushLine(out, n);
                        }
                        this.printTree(out, s, this.shouldIndent(node) ? n + this.configuration.spaces : n, lexer, node9);
                        node8 = node9;
                        node9 = node9.next;
                    }
                }
                if (this.shouldIndent(node) || (TidyUtils.toBoolean(node.tag.model & 2) || node.tag == tagTable.tagNoframes || TidyUtils.toBoolean(node.tag.model & 4) && node.tag != tagTable.tagTitle) && !this.configuration.hideEndTags) {
                    this.condFlushLine(out, this.configuration.indentContent ? n + this.configuration.spaces : n);
                    if (!this.configuration.hideEndTags || !TidyUtils.toBoolean(node.tag.model & 0x8000)) {
                        this.printEndTag(s, n, node);
                        if (!lexer.seenEndHtml) {
                            this.flushLine(out, n);
                        }
                    }
                } else {
                    if (!this.configuration.hideEndTags || !TidyUtils.toBoolean(node.tag.model & 0x8000)) {
                        this.printEndTag(s, n, node);
                    }
                    this.flushLine(out, n);
                }
            }
        }
    }

    public void printXMLTree(Out out, short s, int n, Lexer lexer, Node node) {
        TagTable tagTable = this.configuration.tt;
        if (node == null) {
            return;
        }
        if (node.type == 4 || node.type == 8 && lexer.configuration.escapeCdata) {
            this.printText(out, s, n, node.textarray, node.start, node.end);
        } else if (node.type == 2) {
            this.condFlushLine(out, n);
            this.printComment(out, 0, node);
            this.condFlushLine(out, 0);
        } else if (node.type == 0) {
            Node node2 = node.content;
            while (node2 != null) {
                this.printXMLTree(out, s, n, lexer, node2);
                node2 = node2.next;
            }
        } else if (node.type == 1) {
            this.printDocType(out, n, lexer, node);
        } else if (node.type == 3) {
            this.printPI(out, n, node);
        } else if (node.type == 13) {
            this.printXmlDecl(out, n, node);
        } else if (node.type == 8) {
            this.printCDATA(out, n, node);
        } else if (node.type == 9) {
            this.printSection(out, n, node);
        } else if (node.type == 10) {
            this.printAsp(out, n, node);
        } else if (node.type == 11) {
            this.printJste(out, n, node);
        } else if (node.type == 12) {
            this.printPhp(out, n, node);
        } else if (TidyUtils.toBoolean(node.tag.model & 1) || node.type == 7 && !this.configuration.xHTML) {
            this.condFlushLine(out, n);
            this.printTag(lexer, out, s, n, node);
        } else {
            int n2;
            boolean bl = false;
            Node node3 = node.content;
            while (node3 != null) {
                if (node3.type == 4) {
                    bl = true;
                    break;
                }
                node3 = node3.next;
            }
            this.condFlushLine(out, n);
            if (ParserImpl.XMLPreserveWhiteSpace(node, tagTable)) {
                n = 0;
                n2 = 0;
                bl = false;
            } else {
                n2 = bl ? n : n + this.configuration.spaces;
            }
            this.printTag(lexer, out, s, n, node);
            if (!bl && node.content != null) {
                this.flushLine(out, n);
            }
            node3 = node.content;
            while (node3 != null) {
                this.printXMLTree(out, s, n2, lexer, node3);
                node3 = node3.next;
            }
            if (!bl && node.content != null) {
                this.condFlushLine(out, n2);
            }
            this.printEndTag(s, n, node);
        }
    }

    public int countSlides(Node node) {
        int n = 1;
        TagTable tagTable = this.configuration.tt;
        if (node != null && node.content != null && node.content.tag == tagTable.tagH2) {
            --n;
        }
        if (node != null) {
            node = node.content;
            while (node != null) {
                if (node.tag == tagTable.tagH2) {
                    ++n;
                }
                node = node.next;
            }
        }
        return n;
    }

    private void printNavBar(Out out, int n) {
        String string;
        this.condFlushLine(out, n);
        this.printString("<center><small>");
        NumberFormat numberFormat = NumberFormat.getInstance();
        numberFormat.setMinimumIntegerDigits(3);
        if (this.slide > 1) {
            string = "<a href=\"slide" + numberFormat.format(this.slide - 1) + ".html\">previous</a> | ";
            this.printString(string);
            this.condFlushLine(out, n);
            if (this.slide < this.count) {
                this.printString("<a href=\"slide001.html\">start</a> | ");
            } else {
                this.printString("<a href=\"slide001.html\">start</a>");
            }
            this.condFlushLine(out, n);
        }
        if (this.slide < this.count) {
            string = "<a href=\"slide" + numberFormat.format(this.slide + 1) + ".html\">next</a>";
            this.printString(string);
        }
        this.printString("</small></center>");
        this.condFlushLine(out, n);
    }

    public void printSlide(Out out, short s, int n, Lexer lexer) {
        TagTable tagTable = this.configuration.tt;
        NumberFormat numberFormat = NumberFormat.getInstance();
        numberFormat.setMinimumIntegerDigits(3);
        String string = "<div onclick=\"document.location='slide" + numberFormat.format(this.slide < this.count ? (long)(this.slide + 1) : 1L) + ".html'\">";
        this.printString(string);
        this.condFlushLine(out, n);
        if (this.slidecontent != null && this.slidecontent.tag == tagTable.tagH2) {
            this.printNavBar(out, n);
            this.addC(60, this.linelen++);
            this.addC(TidyUtils.foldCase('h', this.configuration.upperCaseTags, this.configuration.xmlTags), this.linelen++);
            this.addC(TidyUtils.foldCase('r', this.configuration.upperCaseTags, this.configuration.xmlTags), this.linelen++);
            if (this.configuration.xmlOut) {
                this.printString(" />");
            } else {
                this.addC(62, this.linelen++);
            }
            if (this.configuration.indentContent) {
                this.condFlushLine(out, n);
            }
            this.printTree(out, s, this.configuration.indentContent ? n + this.configuration.spaces : n, lexer, this.slidecontent);
            this.slidecontent = this.slidecontent.next;
        }
        Node node = null;
        Node node2 = this.slidecontent;
        while (node2 != null && node2.tag != tagTable.tagH2) {
            if (node != null && !this.configuration.indentContent && node.type == 4 && node2.tag != null && TidyUtils.toBoolean(node2.tag.model & 8)) {
                this.flushLine(out, n);
                this.flushLine(out, n);
            }
            this.printTree(out, s, this.configuration.indentContent ? n + this.configuration.spaces : n, lexer, node2);
            node = node2;
            node2 = node2.next;
        }
        this.slidecontent = node2;
        this.condFlushLine(out, n);
        this.printString("<br clear=\"all\">");
        this.condFlushLine(out, n);
        this.addC(60, this.linelen++);
        this.addC(TidyUtils.foldCase('h', this.configuration.upperCaseTags, this.configuration.xmlTags), this.linelen++);
        this.addC(TidyUtils.foldCase('r', this.configuration.upperCaseTags, this.configuration.xmlTags), this.linelen++);
        if (this.configuration.xmlOut) {
            this.printString(" />");
        } else {
            this.addC(62, this.linelen++);
        }
        if (this.configuration.indentContent) {
            this.condFlushLine(out, n);
        }
        this.printNavBar(out, n);
        this.printString("</div>");
        this.condFlushLine(out, n);
    }

    public void addTransitionEffect(Lexer lexer, Node node, double d) {
        Node node2 = node.findHEAD(lexer.configuration.tt);
        String string = "blendTrans(Duration=" + new Double(d).toString() + ")";
        if (node2 != null) {
            Node node3 = lexer.inferredTag("meta");
            node3.addAttribute("http-equiv", "Page-Enter");
            node3.addAttribute("content", string);
            node2.insertNodeAtStart(node3);
        }
    }

    public void createSlides(Lexer lexer, Node node) {
        NumberFormat numberFormat = NumberFormat.getInstance();
        numberFormat.setMinimumIntegerDigits(3);
        Node node2 = node.findBody(lexer.configuration.tt);
        this.count = this.countSlides(node2);
        this.slidecontent = node2.content;
        this.addTransitionEffect(lexer, node, 3.0);
        this.slide = 1;
        while (this.slide <= this.count) {
            String string = "slide" + numberFormat.format(this.slide) + ".html";
            try {
                FileOutputStream fileOutputStream = new FileOutputStream(string);
                Out out = OutFactory.getOut(this.configuration, fileOutputStream);
                this.printTree(out, (short)0, 0, lexer, node);
                this.flushLine(out, 0);
                fileOutputStream.close();
            }
            catch (IOException iOException) {
                System.err.println(string + iOException.toString());
            }
            ++this.slide;
        }
        while (new File("slide" + numberFormat.format(this.slide) + ".html").delete()) {
            ++this.slide;
        }
    }
}

