/*
 * Decompiled with CFR 0.152.
 */
package org.luaj.vm2.lib.jse;

import java.util.HashMap;
import java.util.Map;
import org.luaj.vm2.LuaDouble;
import org.luaj.vm2.LuaInteger;
import org.luaj.vm2.LuaString;
import org.luaj.vm2.LuaValue;
import org.luaj.vm2.lib.jse.JavaArray;
import org.luaj.vm2.lib.jse.JavaClass;
import org.luaj.vm2.lib.jse.JavaInstance;

public class CoerceJavaToLua {
    static final Map COERCIONS = new HashMap();
    static final Coercion instanceCoercion;
    static final Coercion arrayCoercion;

    public static LuaValue coerce(Object object) {
        if (object == null) {
            return LuaValue.NIL;
        }
        if (object instanceof Class) {
            return JavaClass.forClass((Class)object);
        }
        Class<?> clazz = object.getClass();
        Coercion coercion = (Coercion)COERCIONS.get(clazz);
        if (coercion == null) {
            coercion = clazz.isArray() ? arrayCoercion : instanceCoercion;
            COERCIONS.put(clazz, coercion);
        }
        return coercion.coerce(object);
    }

    static {
        Coercion coercion = new Coercion(){

            public LuaValue coerce(Object object) {
                Boolean bl = (Boolean)object;
                return bl != false ? LuaValue.TRUE : LuaValue.FALSE;
            }
        };
        Coercion coercion2 = new Coercion(){

            public LuaValue coerce(Object object) {
                Number number = (Number)object;
                return LuaInteger.valueOf(number.intValue());
            }
        };
        Coercion coercion3 = new Coercion(){

            public LuaValue coerce(Object object) {
                Character c = (Character)object;
                return LuaInteger.valueOf(c.charValue());
            }
        };
        Coercion coercion4 = new Coercion(){

            public LuaValue coerce(Object object) {
                Number number = (Number)object;
                return LuaDouble.valueOf(number.doubleValue());
            }
        };
        Coercion coercion5 = new Coercion(){

            public LuaValue coerce(Object object) {
                return LuaString.valueOf(object.toString());
            }
        };
        COERCIONS.put(Boolean.class, coercion);
        COERCIONS.put(Byte.class, coercion2);
        COERCIONS.put(Character.class, coercion3);
        COERCIONS.put(Short.class, coercion2);
        COERCIONS.put(Integer.class, coercion2);
        COERCIONS.put(Long.class, coercion4);
        COERCIONS.put(Float.class, coercion4);
        COERCIONS.put(Double.class, coercion4);
        COERCIONS.put(String.class, coercion5);
        instanceCoercion = new Coercion(){

            public LuaValue coerce(Object object) {
                return new JavaInstance(object);
            }
        };
        arrayCoercion = new Coercion(){

            public LuaValue coerce(Object object) {
                return new JavaArray(object);
            }
        };
    }

    static interface Coercion {
        public LuaValue coerce(Object var1);
    }
}

