/*
 * Decompiled with CFR 0.152.
 */
package org.luaj.vm2.lib;

import gplx.objects.strings.char_sources.Char_source;
import org.luaj.vm2.Buffer;
import org.luaj.vm2.LuaError;
import org.luaj.vm2.LuaString;
import org.luaj.vm2.LuaValue;
import org.luaj.vm2.Varargs;
import org.luaj.vm2.lib.Str_char_class_mgr;
import org.luaj.vm2.lib.Str_find_mgr;

public class Match_state {
    private final Str_find_mgr find_mgr;
    private final Str_char_class_mgr char_class_mgr;
    private final Char_source src;
    private final Char_source pat;
    private final int src_len;
    private final int pat_len;
    private final int[] capture_bgns;
    private final int[] capture_lens;
    private int level;
    private static final int NULL = -1;
    private static final int MAX_CAPTURES = 32;
    private static final int CAP_UNFINISHED = -1;
    public static final int CAP_POSITION = -2;

    public Match_state(Str_find_mgr str_find_mgr) {
        this.find_mgr = str_find_mgr;
        this.char_class_mgr = str_find_mgr.Char_class_mgr();
        this.src = str_find_mgr.src;
        this.src_len = str_find_mgr.src_len;
        this.pat = str_find_mgr.pat;
        this.pat_len = str_find_mgr.pat_len;
        this.level = 0;
        this.capture_bgns = new int[32];
        this.capture_lens = new int[32];
    }

    public void reset() {
        this.level = 0;
        this.find_mgr.reset();
    }

    private void add_s(Buffer buffer, LuaString luaString, int n, int n2) {
        int n3 = luaString.length();
        for (int i = 0; i < n3; ++i) {
            byte by = (byte)luaString.Get_data(i);
            if (by != 37) {
                buffer.append(by);
                continue;
            }
            if (++i == n3) {
                buffer.append("%");
                break;
            }
            by = (byte)luaString.Get_data(i);
            if (!Character.isDigit((char)by)) {
                buffer.append(by);
                continue;
            }
            if (by == 48) {
                buffer.append(this.src.Substring(n, n2));
                continue;
            }
            buffer.append(this.push_onecapture(false, by - 49, n, n2).strvalue());
        }
    }

    public void add_value(Buffer buffer, int n, int n2, LuaValue luaValue) {
        switch (luaValue.type()) {
            case 3: 
            case 4: {
                this.add_s(buffer, luaValue.strvalue(), n, n2);
                return;
            }
            case 6: {
                Varargs varargs = this.push_captures(true, n, n2);
                luaValue = luaValue.invoke(varargs).arg1();
                break;
            }
            case 5: {
                luaValue = luaValue.get(this.push_onecapture(false, 0, n, n2));
                break;
            }
            default: {
                LuaValue.error("bad argument: string/function/table expected");
                return;
            }
        }
        if (!luaValue.toboolean()) {
            luaValue = LuaValue.valueOf(this.src.Substring(n, n2));
        } else if (!luaValue.isstring()) {
            LuaValue.error("invalid replacement value (a " + luaValue.typename() + ")");
        }
        buffer.append(luaValue.strvalue());
    }

    private LuaValue push_onecapture(boolean bl, int n, int n2, int n3) {
        if (n >= this.level) {
            if (n == 0) {
                return this.find_mgr.Capture__make__string(bl, n2, n3);
            }
            throw new LuaError("invalid capture index");
        }
        int n4 = this.capture_lens[n];
        if (n4 == -1) {
            throw new LuaError("unfinished capture");
        }
        int n5 = this.capture_bgns[n];
        if (n4 == -2) {
            return this.find_mgr.Capture__make__int(bl, n5 + 1);
        }
        return this.find_mgr.Capture__make__string(bl, n5, n5 + n4);
    }

    public Varargs push_captures(boolean bl, int n, int n2) {
        int n3;
        int n4 = n3 = this.level == 0 && bl ? 1 : this.level;
        if (n3 == 0) {
            return this.find_mgr.Captures__make__none();
        }
        this.find_mgr.Captures__init(n3);
        for (int i = 0; i < n3; ++i) {
            this.push_onecapture(true, i, n, n2);
        }
        return this.find_mgr.Captures__make__many();
    }

    private int check_capture(int n) {
        if ((n -= 49) < 0 || n >= this.level || this.capture_lens[n] == -1) {
            LuaValue.error("invalid capture index");
        }
        return n;
    }

    private int capture_to_close() {
        int n = this.level;
        --n;
        while (n >= 0) {
            if (this.capture_lens[n] == -1) {
                return n;
            }
            --n;
        }
        LuaValue.error("invalid pat capture");
        return 0;
    }

    private int classend(int n) {
        switch (this.pat.Get_data(n++)) {
            case 37: {
                if (n == this.pat_len) {
                    LuaValue.error("malformed pat (ends with %)");
                }
                return n + 1;
            }
            case 91: {
                if (this.pat.Get_data(n) == 94) {
                    ++n;
                }
                do {
                    if (n == this.pat_len) {
                        LuaValue.error("malformed pat (missing])");
                    }
                    if (this.pat.Get_data(n++) != 37 || n == this.pat_len) continue;
                    ++n;
                } while (this.pat.Get_data(n) != 93);
                return n + 1;
            }
        }
        return n;
    }

    private boolean matchbracketclass(int n, int n2, int n3) {
        boolean bl = true;
        if (this.pat.Get_data(n2 + 1) == 94) {
            bl = false;
            ++n2;
        }
        while (++n2 < n3) {
            if (!(this.pat.Get_data(n2) == 37 ? this.char_class_mgr.Match_class(n, this.pat.Get_data(++n2)) : (this.pat.Get_data(n2 + 1) == 45 && n2 + 2 < n3 ? this.pat.Get_data((n2 += 2) - 2) <= n && n <= this.pat.Get_data(n2) : this.pat.Get_data(n2) == n))) continue;
            return bl;
        }
        return !bl;
    }

    private boolean singlematch(int n, int n2, int n3) {
        switch (this.pat.Get_data(n2)) {
            case 46: {
                return true;
            }
            case 37: {
                return this.char_class_mgr.Match_class(n, this.pat.Get_data(n2 + 1));
            }
            case 91: {
                return this.matchbracketclass(n, n2, n3 - 1);
            }
        }
        return this.pat.Get_data(n2) == n;
    }

    private int matchbalance(int n, int n2) {
        if (n2 == this.pat_len || n2 + 1 == this.pat_len) {
            LuaValue.error("unbalanced pat");
        }
        if (n >= this.src.Len_in_data()) {
            return -1;
        }
        if (this.src.Get_data(n) != this.pat.Get_data(n2)) {
            return -1;
        }
        int n3 = this.pat.Get_data(n2);
        int n4 = this.pat.Get_data(n2 + 1);
        int n5 = 1;
        while (++n < this.src_len) {
            if (this.src.Get_data(n) == n4) {
                if (--n5 != 0) continue;
                return n + 1;
            }
            if (this.src.Get_data(n) != n3) continue;
            ++n5;
        }
        return -1;
    }

    private int max_expand(int n, int n2, int n3) {
        int n4 = 0;
        while (n + n4 < this.src_len && this.singlematch(this.src.Get_data(n + n4), n2, n3)) {
            ++n4;
        }
        while (n4 >= 0) {
            int n5 = this.match(n + n4, n3 + 1);
            if (n5 != -1) {
                return n5;
            }
            --n4;
        }
        return -1;
    }

    private int min_expand(int n, int n2, int n3) {
        int n4 = this.src.Len_in_data();
        while (true) {
            int n5;
            if ((n5 = this.match(n, n3 + 1)) != -1) {
                return n5;
            }
            if (n >= n4 || !this.singlematch(this.src.Get_data(n), n2, n3)) break;
            ++n;
        }
        return -1;
    }

    private int start_capture(int n, int n2, int n3) {
        int n4 = this.level;
        if (n4 >= 32) {
            LuaValue.error("too many captures");
        }
        this.capture_bgns[n4] = n;
        this.capture_lens[n4] = n3;
        this.level = n4 + 1;
        int n5 = this.match(n, n2);
        if (n5 == -1) {
            --this.level;
        }
        return n5;
    }

    private int end_capture(int n, int n2) {
        int n3 = this.capture_to_close();
        this.capture_lens[n3] = n - this.capture_bgns[n3];
        int n4 = this.match(n, n2);
        if (n4 == -1) {
            this.capture_lens[n3] = -1;
        }
        return n4;
    }

    private int match_capture(int n, int n2) {
        int n3 = this.capture_lens[n2 = this.check_capture(n2)];
        if (this.src_len - n >= n3 && this.src.Eq(this.capture_bgns[n2], this.src, n, n3)) {
            return n + n3;
        }
        return -1;
    }

    public int match(int n, int n2) {
        block16: while (n2 != this.pat_len) {
            int n3;
            int n4;
            switch (this.pat.Get_data(n2)) {
                case 40: {
                    if (++n2 < this.pat_len && this.pat.Get_data(n2) == 41) {
                        return this.start_capture(n, n2 + 1, -2);
                    }
                    return this.start_capture(n, n2, -1);
                }
                case 41: {
                    return this.end_capture(n, n2 + 1);
                }
                case 37: {
                    if (n2 + 1 == this.pat_len) {
                        LuaValue.error("malformed pat (ends with '%')");
                    }
                    switch (this.pat.Get_data(n2 + 1)) {
                        case 98: {
                            n = this.matchbalance(n, n2 + 2);
                            if (n == -1) {
                                return -1;
                            }
                            n2 += 4;
                            continue block16;
                        }
                        case 102: {
                            if (this.pat.Get_data(n2 += 2) != 91) {
                                LuaValue.error("Missing [after %f in pat");
                            }
                            n4 = this.classend(n2);
                            int n5 = n3 = n == 0 ? -1 : this.src.Get_data(n - 1);
                            if (this.matchbracketclass(n3, n2, n4 - 1) || n < this.src.Len_in_data() && !this.matchbracketclass(this.src.Get_data(n), n2, n4 - 1)) {
                                return -1;
                            }
                            n2 = n4;
                            continue block16;
                        }
                    }
                    n4 = this.pat.Get_data(n2 + 1);
                    if (Character.isDigit((char)n4)) {
                        if ((n = this.match_capture(n, n4)) == -1) {
                            return -1;
                        }
                        return this.match(n, n2 + 2);
                    }
                }
                case 36: {
                    if (n2 + 1 != this.pat_len) break;
                    return n == this.src_len ? n : -1;
                }
            }
            n4 = this.classend(n2);
            n3 = n < this.src_len && this.singlematch(this.src.Get_data(n), n2, n4) ? 1 : 0;
            int n6 = n4 < this.pat_len ? this.pat.Get_data(n4) : 0;
            switch (n6) {
                case 63: {
                    int n7;
                    if (n3 != 0 && (n7 = this.match(n + 1, n4 + 1)) != -1) {
                        return n7;
                    }
                    n2 = n4 + 1;
                    continue block16;
                }
                case 42: {
                    return this.max_expand(n, n2, n4);
                }
                case 43: {
                    return n3 != 0 ? this.max_expand(n + 1, n2, n4) : -1;
                }
                case 45: {
                    return this.min_expand(n, n2, n4);
                }
            }
            if (n3 == 0) {
                return -1;
            }
            ++n;
            n2 = n4;
        }
        return n;
    }
}

