/*
 * Decompiled with CFR 0.152.
 */
package org.luaj.vm2;

import org.junit.Assert;
import org.junit.Test;
import org.luaj.vm2.LuaString;
import org.luaj.vm2.LuaTable;
import org.luaj.vm2.LuaValue;
import org.luaj.vm2.Luaj_script_fxt;

public class LuaTable_tst {
    private final Luaj_script_fxt fxt = new Luaj_script_fxt();

    @Test
    public void set_should_not_autocast_strings_to_int() {
        LuaTable luaTable = new LuaTable();
        luaTable.set("ignore", "a");
        luaTable.set("k", 2);
        luaTable.set("k", "2.");
        Assert.assertEquals((String)"fail", (Object)LuaString.valueOf("2."), (Object)luaTable.get("k"));
    }

    @Test
    public void foreach() {
        this.fxt.Clear();
        this.fxt.Init__script("local tbl =  {['a'] = 1, ['b'] = 2};", "local rv = '';", "table.foreach", "( tbl", ", function (k, v)", "    rv = rv .. k .. '=' .. v .. ';'", "  end", ");", "return rv;");
        this.fxt.Test("a=1;b=2;");
    }

    @Test
    public void foreachi() {
        this.fxt.Clear();
        this.fxt.Init__script("local tbl =  {'a', 'b'};", "local rv = '';", "table.foreachi", "( tbl", ", function (k, v)", "    rv = rv .. k .. '=' .. v .. ';'", "  end", ");", "return rv;");
        this.fxt.Test("1=a;2=b;");
    }

    @Test
    public void remove_on_empty_table_should_return_nil_not_none() {
        LuaTable luaTable = new LuaTable();
        LuaValue luaValue = luaTable.remove(1);
        Assert.assertEquals(LuaValue.NIL.getClass(), luaValue.getClass());
    }
}

