/*
 * Decompiled with CFR 0.152.
 */
package org.luaj.vm2;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.Reader;
import org.luaj.vm2.LuaError;
import org.luaj.vm2.LuaFunction;
import org.luaj.vm2.LuaString;
import org.luaj.vm2.LuaTable;
import org.luaj.vm2.LuaThread;
import org.luaj.vm2.LuaValue;
import org.luaj.vm2.Prototype;
import org.luaj.vm2.Varargs;
import org.luaj.vm2.lib.BaseLib;
import org.luaj.vm2.lib.DebugLib;
import org.luaj.vm2.lib.PackageLib;
import org.luaj.vm2.lib.ResourceFinder;

public class Globals
extends LuaTable {
    public InputStream STDIN = null;
    public PrintStream STDOUT = System.out;
    public PrintStream STDERR = System.err;
    public ResourceFinder FINDER;
    public LuaThread running = new LuaThread(this);
    public BaseLib baselib;
    public PackageLib package_;
    public DebugLib debuglib;
    public Loader loader;
    public Compiler compiler;
    public Undumper undumper;

    public Globals checkglobals() {
        return this;
    }

    public LuaValue loadfile(String string) {
        try {
            return this.load(this.FINDER.findResource(string), "@" + string, "bt", this);
        }
        catch (Exception exception) {
            return Globals.error("load " + string + ": " + exception);
        }
    }

    public LuaValue load(String string, String string2) {
        return this.load(new StrReader(string), string2);
    }

    public LuaValue load(String string) {
        return this.load(new StrReader(string), string);
    }

    public LuaValue load(Reader reader, String string) {
        return this.load(new UTF8Stream(reader), string, "t", this);
    }

    public LuaValue load(InputStream inputStream, String string, String string2, LuaValue luaValue) {
        try {
            Prototype prototype = this.loadPrototype(inputStream, string, string2);
            return this.loader.load(prototype, string, luaValue);
        }
        catch (LuaError luaError) {
            throw luaError;
        }
        catch (Exception exception) {
            return Globals.error("load " + string + ": " + exception);
        }
    }

    public Prototype loadPrototype(InputStream inputStream, String string, String string2) throws IOException {
        if (string2.indexOf(98) >= 0) {
            if (this.undumper == null) {
                Globals.error("No undumper.");
            }
            if (!inputStream.markSupported()) {
                inputStream = new MarkStream(inputStream);
            }
            inputStream.mark(4);
            Prototype prototype = this.undumper.undump(inputStream, string);
            if (prototype != null) {
                return prototype;
            }
            inputStream.reset();
        }
        if (string2.indexOf(116) >= 0) {
            return this.compilePrototype(inputStream, string);
        }
        Globals.error("Failed to load prototype " + string + " using mode '" + string2 + "'");
        return null;
    }

    public Prototype compilePrototype(Reader reader, String string) throws IOException {
        return this.compilePrototype(new UTF8Stream(reader), string);
    }

    public Prototype compilePrototype(InputStream inputStream, String string) throws IOException {
        if (this.compiler == null) {
            Globals.error("No compiler.");
        }
        return this.compiler.compile(inputStream, string);
    }

    public Varargs yield(Varargs varargs) {
        if (this.running == null || this.running.isMainThread()) {
            throw new LuaError("cannot yield main thread");
        }
        LuaThread.State state = this.running.state;
        return state.lua_yield(varargs);
    }

    static class MarkStream
    extends InputStream {
        private int[] b;
        private int i = 0;
        private int j = 0;
        private final InputStream s;

        MarkStream(InputStream inputStream) {
            this.s = inputStream;
        }

        public int read() throws IOException {
            if (this.i < this.j) {
                return this.b[this.i++];
            }
            int n = this.s.read();
            if (n < 0) {
                return -1;
            }
            if (this.j < this.b.length) {
                this.b[this.j++] = n;
                this.i = this.j;
            }
            return n;
        }

        public synchronized void mark(int n) {
            this.b = new int[n];
            this.j = 0;
            this.i = 0;
        }

        public boolean markSupported() {
            return true;
        }

        public synchronized void reset() throws IOException {
            this.i = 0;
        }
    }

    static class UTF8Stream
    extends InputStream {
        final char[] c = new char[32];
        final byte[] b = new byte[96];
        int i = 0;
        int j = 0;
        final Reader r;

        UTF8Stream(Reader reader) {
            this.r = reader;
        }

        public int read() throws IOException {
            if (this.i < this.j) {
                return this.c[this.i++];
            }
            int n = this.r.read(this.c);
            if (n < 0) {
                return -1;
            }
            this.i = 0;
            this.j = LuaString.encodeToUtf8(this.c, n, this.b, 0);
            return this.b[this.i++];
        }
    }

    static class StrReader
    extends Reader {
        final String s;
        int i = 0;
        int n;

        StrReader(String string) {
            this.s = string;
            this.n = string.length();
        }

        public void close() throws IOException {
            this.i = this.n;
        }

        public int read(char[] cArray, int n, int n2) throws IOException {
            int n3 = 0;
            while (n3 < n2 && this.i < this.n) {
                cArray[n + n3] = this.s.charAt(this.i);
                ++n3;
                ++this.i;
            }
            return n3 > 0 || n2 == 0 ? n3 : -1;
        }
    }

    public static interface Undumper {
        public Prototype undump(InputStream var1, String var2) throws IOException;
    }

    public static interface Compiler {
        public Prototype compile(InputStream var1, String var2) throws IOException;
    }

    public static interface Loader {
        public LuaFunction load(Prototype var1, String var2, LuaValue var3) throws IOException;
    }
}

