/*
 * Decompiled with CFR 0.152.
 */
package gplx.objects.strings.unicodes;

import gplx.objects.errs.Err_;
import gplx.objects.strings.char_sources.Char_source;
import gplx.objects.strings.unicodes.Ustring;

class Ustring_codepoints
implements Ustring {
    private final int[] codes;
    private final String src;
    private final int chars_len;
    private final int codes_len;

    public Ustring_codepoints(String string, int n, int n2) {
        this.src = string;
        this.chars_len = n;
        this.codes_len = n2;
        this.codes = new int[n2];
        int n3 = 0;
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c >= '\ud800' && c <= '\udbff') {
                if (++i == n) {
                    throw Err_.New_fmt("invalid surrogate pair found; src={0}", string);
                }
                char c2 = string.charAt(i);
                this.codes[n3++] = 65536 + (c - 55296) * 1024 + (c2 - 56320);
                continue;
            }
            this.codes[n3++] = c;
        }
    }

    public String Src() {
        return this.src;
    }

    public String Substring(int n, int n2) {
        int n3;
        int n4 = 0;
        for (int i = n; i < n2; ++i) {
            n3 = this.codes[i];
            n4 += n3 >= 65536 && n3 <= 0x10FFFF ? 2 : 1;
        }
        char[] cArray = new char[n4];
        n3 = 0;
        for (int i = n; i < n2; ++i) {
            int n5 = this.codes[i];
            if (n5 >= 65536 && n5 <= 0x10FFFF) {
                cArray[n3++] = (char)((n5 - 65536) / 1024 + 55296);
                cArray[n3++] = (char)((n5 - 65536) % 1024 + 56320);
                continue;
            }
            cArray[n3++] = (char)n5;
        }
        return new String(cArray);
    }

    public int Index_of(Char_source char_source, int n) {
        int n2 = char_source.Len_in_data();
        int n3 = this.codes.length;
        for (int i = n; i < this.codes.length; ++i) {
            boolean bl = true;
            for (int j = 0; j < n2; ++j) {
                int n4 = i + j;
                if (n4 >= n3) {
                    bl = false;
                    break;
                }
                if (this.codes[n4] == char_source.Get_data(j)) continue;
                bl = false;
                break;
            }
            if (!bl) continue;
            return i;
        }
        return -1;
    }

    public boolean Eq(int n, Char_source char_source, int n2, int n3) {
        if (this.Len_in_data() < n + n3 || char_source.Len_in_data() < n2 + n3) {
            return false;
        }
        while (--n3 >= 0) {
            if (this.Get_data(n++) == char_source.Get_data(n2++)) continue;
            return false;
        }
        return true;
    }

    public int Len_in_chars() {
        return this.chars_len;
    }

    public int Len_in_data() {
        return this.codes_len;
    }

    public int Get_data(int n) {
        return this.codes[n];
    }

    public int Map_data_to_char(int n) {
        if (n == this.codes_len) {
            return this.chars_len;
        }
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            n2 += this.codes[i] < 65536 ? 1 : 2;
        }
        return n2;
    }

    public int Map_char_to_data(int n) {
        if (n == this.chars_len) {
            return this.codes_len;
        }
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            char c = this.src.charAt(i);
            if (c >= '\ud800' && c <= '\udbff') {
                if (i != n - 1) continue;
                return -1;
            }
            ++n2;
        }
        return n2;
    }
}

