(function (xo) {
  "use strict";
  xo.log = new function() {
    this.enabled          = false;
    this.show_trace       = false;
    this.show_time        = true;
    this.show_elapsed     = false;
    this.prv_time         = 0;
    this.embed_html       = true;
    this.level            = 1;
    this.ctor_obj = {}.constructor;
    this.ctor_ary = [].constructor;
    
    this.add__recv = function(msg) {
      this.add(1, msg);
      return true;
    }
    this.add = function(lvl) {
      this.add_array(lvl, 1, Array.prototype.slice.call(arguments));
    }
    this.add_array = function(lvl, func_args_bgn, func_args) {
      if (!xo.log.enabled) return;
      if (lvl < xo.log.level) return;
      var args = [];

      // get trace
      var trace = null;
      if (xo.log.show_trace) {
        var trace_lines = Error().stack.split("\n");
        var is_firefox = navigator.userAgent.toLowerCase().indexOf("firefox") > -1;
        var trace_line_bgn = is_firefox ? 1 : 3;
        var trace_lines_len = trace_lines.length;
        for (var i = trace_line_bgn; i < trace_lines_len; ++i) {
          var trace_line = trace_lines[i];
          if (!is_firefox) trace_line = trace_line.trim();
          if (i == trace_line_bgn) {
            trace = trace_line;
          }
          else {
            trace += '\n' + trace_line;
          }
        }
        args.push(trace);
      }
      
      // create args
      // calc time
      if (xo.log.show_elapsed) {
        var cur_time = new Date().getTime();
        var elapsed_str;
        var prv_time = xo.log.prv_time;
        if (prv_time === 0) {
          elapsed_str = '&nbsp;&nbsp;&nbsp;&nbsp;-';
        }
        else {
          elapsed_str = xo.log.pad(cur_time - prv_time, 5, '&nbsp;');
        }
        xo.log.prv_time = cur_time;
        args.push(elapsed_str);
      }
      if (xo.log.show_time) {
        var time = new Date();
        var time_str = xo.log.pad(time.getMinutes(), 2, '0') + ':' + xo.log.pad(time.getSeconds(), 2, '0') + '.' + xo.log.pad(time.getMilliseconds(), 3, '0');
        args.push(time_str);
      }
      var arguments_length = func_args.length;
      for (var i = func_args_bgn; i < arguments_length; ++i) {
        args.push(func_args[i]);
      }
      
      // print
      if (xo.log.embed_html) {
        // get log_elem; create if missing
        var log_elem = document.getElementById('xo_dbg');
        if (!log_elem) {
          xo.log.make_panel();
          log_elem = document.getElementById('xo_dbg');
          log_elem.innerHTML = '';
        }
        var log_html = '';
        
        var args_len = args.length;
        for (var i = 0; i < args_len; ++i) {
          var arg = args[i];
          if (arg == null)
            arg = 'NULL';
          else {
            var arg_outer_html = arg.outerHTML;
            if      (arg_outer_html != null)
              arg = arg_outer_html.replace(/</g, '&lt;');
            else if (  arg.constructor === ctor_obj
                    || arg.constructor === ctor_ary)
              arg = JSON.stringify(arg);
          }
          if  (i === 0)
            log_html = arg;
          else
            log_html += '&nbsp;' + arg;
        }
        if (lvl == 9) {
          log_html = "<div style='background-color:red; width:100%'>" + log_html + '</div>'
          var warning_count = parseInt(document.getElementById('xo_log_warnings').value);
          this.warnings_update(warning_count + 1);
        }
        else
          log_html = "<div style='width:100%'>" + log_html + '</div>'

        log_elem.innerHTML += log_html;
        log_elem.scrollTop = log_elem.scrollHeight;
      }
      else {
        console.log.apply(console, args);
      }
    }    
    this.clear = function() {
      document.getElementById('xo_dbg').innerHTML = '';
      document.getElementById('xolog-modal-text').innerHTML = '';
      this.warnings_update(0);
    }
    this.warnings_update = function(val) {
      var warning_box = document.getElementById('xo_log_warnings');
      warning_box.value = val;
      style.backgroundColor = val === 0 ? 'initial' : 'red'; 
    }
    this.level_ = function(val) {
      this.level = val;
    }
    this.make_by_html = function(htmlStr) {
      var frag = document.createDocumentFragment(),
          temp = document.createElement('div');
      temp.innerHTML = htmlStr;
      while (temp.firstChild) {
        frag.appendChild(temp.firstChild);
      }
      return frag;
    }
    this.make_css = function(css) {
      var head = document.head || document.getElementsByTagName('head')[0],
          style = document.createElement('style');

      style.type = 'text/css';
      style.appendChild(document.createTextNode(css));

      head.appendChild(style);      
    }
    this.make_panel = function() {
      var rv = this.make_by_html
      ( "<div id='xolog-toolbar' style='padding:0px; margin:0px; position:absolute; bottom:1px; width:calc(100% - 2px);'>\n"
      + "  <div style='float:right'>\n"
      + "  </div>\n" 
      + "  <div style='clear:both'/>\n"
      + '  <a accesskey="l" id="xolog-modal-show" href="#"><svg style="float:left" height="24" version="1" width="24" viewBox="0 0 128 128" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink"><defs><linearGradient id="ag"><stop offset="0" stop-color="#82e6fb"/><stop offset="1" stop-color="#82e6fb" stop-opacity="0"/></linearGradient><linearGradient id="af"><stop offset="0" stop-color="#a8f1ff"/><stop offset="1" stop-color="#a8f1ff" stop-opacity="0"/></linearGradient><linearGradient id="ae"><stop offset="0" stop-color="#99b7eb"/><stop offset="1" stop-color="#99b7eb" stop-opacity="0"/></linearGradient><linearGradient id="ad"><stop offset="0" stop-color="#caecf3" stop-opacity=".984"/><stop offset="1" stop-color="#0e5268" stop-opacity="0"/></linearGradient><linearGradient id="D"><stop offset="0" stop-color="#363636"/><stop offset="1" stop-color="#b3b3b3"/></linearGradient><linearGradient id="C"><stop offset="0" stop-color="#fff"/><stop offset="1" stop-color="#fff" stop-opacity="0"/></linearGradient><linearGradient id="B"><stop offset="0" stop-color="#fff"/><stop offset="1" stop-color="#fff" stop-opacity="0"/></linearGradient><linearGradient id="A"><stop offset="0" stop-color="#fff" stop-opacity="0"/><stop offset="1" stop-color="#818181"/></linearGradient><linearGradient id="z"><stop offset="0" stop-color="#c9cacc"/><stop offset="1" stop-color="#acaeb1"/></linearGradient><linearGradient id="x"><stop offset="0" stop-color="#a3a5a8"/><stop offset="1" stop-color="#fff"/></linearGradient><linearGradient id="g"><stop offset="0"/><stop offset="1" stop-opacity="0"/></linearGradient><linearGradient id="i"><stop offset="0" stop-color="#fff"/><stop offset="1" stop-color="#fff" stop-opacity="0"/></linearGradient><linearGradient id="j"><stop offset="0" stop-color="#fff"/><stop offset="1" stop-color="#fff" stop-opacity="0"/></linearGradient><linearGradient id="h"><stop offset="0" stop-color="#fff"/><stop offset="1" stop-color="#fff" stop-opacity="0"/></linearGradient><linearGradient id="k"><stop offset="0" stop-color="#fff"/><stop offset="1" stop-color="#fff" stop-opacity="0"/></linearGradient><linearGradient id="o"><stop offset="0" stop-color="#0057ae" stop-opacity="0"/><stop offset=".863" stop-color="#0057ae" stop-opacity="0"/><stop offset="1" stop-color="#0057ae" stop-opacity="0"/></linearGradient><linearGradient id="m"><stop offset="0" stop-color="#fff"/><stop offset="1" stop-color="#fff" stop-opacity="0"/></linearGradient><linearGradient id="n"><stop offset="0" stop-color="#fff"/><stop offset="1" stop-color="#fff" stop-opacity="0"/></linearGradient><linearGradient id="f"><stop offset="0"/><stop offset="1" stop-opacity="0"/></linearGradient><linearGradient id="l"><stop offset="0" stop-color="#fff"/><stop offset="1" stop-color="#aeaeae"/></linearGradient><linearGradient gradientTransform="matrix(.41012 -.0005 .0005 .4097 6.174 75.533)" gradientUnits="userSpaceOnUse" id="u" x1="60.466" x2="69.813" xlink:href="#c" y1="135.66" y2="76.248"/><linearGradient id="c"><stop offset="0" stop-color="#fff"/><stop offset="1" stop-color="#fff" stop-opacity="0"/></linearGradient><linearGradient id="a"><stop offset="0" stop-color="#fff"/><stop offset="1" stop-color="#fff" stop-opacity="0"/></linearGradient><linearGradient id="b"><stop offset="0" stop-color="#fff"/><stop offset="1" stop-color="#fff" stop-opacity="0"/></linearGradient><linearGradient id="e"><stop offset="0" stop-color="#fff" stop-opacity=".536"/><stop offset=".12" stop-color="#fff" stop-opacity=".498"/><stop offset="1" stop-color="#fff" stop-opacity="0"/></linearGradient><linearGradient id="d"><stop offset="0" stop-color="#fff" stop-opacity=".464"/><stop offset="0" stop-color="#fff" stop-opacity=".498"/><stop offset="1" stop-color="#fff" stop-opacity="0"/></linearGradient><linearGradient id="q"><stop offset="0" stop-color="#898989"/><stop offset=".115" stop-color="#a3a3a3"/><stop offset=".126" stop-color="#a8a8a8"/><stop offset=".5" stop-color="#d3d3d3"/><stop offset="1" stop-color="#aeaeae"/></linearGradient><linearGradient id="p"><stop offset="0"/><stop offset="1" stop-color="#838383"/></linearGradient><linearGradient id="r"><stop offset="0" stop-color="#8bb4e6"/><stop offset=".58" stop-color="#89b2e2"/><stop offset="1" stop-color="#c5daf3" stop-opacity=".595"/></linearGradient><linearGradient id="s"><stop offset="0"/><stop offset=".664" stop-opacity=".238"/><stop offset="1" stop-opacity="0"/></linearGradient><linearGradient id="t"><stop offset="0" stop-color="#abc7e9"/><stop offset=".271" stop-color="#c9dce8" stop-opacity=".424"/><stop offset="1" stop-color="#fff"/></linearGradient><linearGradient id="y"><stop offset="0"/><stop offset=".664" stop-opacity=".238"/><stop offset="1" stop-opacity="0"/></linearGradient><linearGradient id="v"><stop offset="0" stop-color="#008c00"/><stop offset="1" stop-color="#008c00" stop-opacity="0"/></linearGradient><linearGradient id="w"><stop offset="0" stop-color="#00bf00"/><stop offset="1" stop-color="#008c00"/></linearGradient><linearGradient gradientUnits="userSpaceOnUse" id="ai" x1="34.842" x2="35.561" xlink:href="#h" y1="-7.142" y2="11.416"/><linearGradient gradientUnits="userSpaceOnUse" id="aj" x1="34.842" x2="35.561" xlink:href="#h" y1="-7.142" y2="11.416"/><linearGradient gradientUnits="userSpaceOnUse" id="ak" x1="34.842" x2="35.561" xlink:href="#h" y1="-7.142" y2="11.416"/><radialGradient cx="53.823" cy="51.796" fx="53.363" fy="53.704" gradientTransform="matrix(1 0 0 .35076 0 33.628)" gradientUnits="userSpaceOnUse" id="aq" r="5.284" xlink:href="#m"/><radialGradient cx="53.823" cy="51.796" fx="53.363" fy="53.704" gradientTransform="matrix(1 0 0 .35076 0 33.628)" gradientUnits="userSpaceOnUse" id="ar" r="5.284" xlink:href="#m"/><linearGradient gradientUnits="userSpaceOnUse" id="aB" x1="13.645" x2="71.473" xlink:href="#x" y1="38.368" y2="38.368"/><linearGradient gradientUnits="userSpaceOnUse" id="ax" x1="28.549" x2="28.549" xlink:href="#z" y1="-10.101" y2="-.854"/><radialGradient cx="28.549" cy="-5.477" fx="28.549" fy="-5.477" gradientTransform="matrix(-5.37943 0 0 29.32146 193.58 200.6)" gradientUnits="userSpaceOnUse" id="ay" r="6.692" xlink:href="#A"/><radialGradient cx="56.257" cy="56.999" fx="56.257" fy="56.999" gradientTransform="matrix(1 0 0 .9253 6 10.26)" gradientUnits="userSpaceOnUse" id="av" r="9.726" xlink:href="#y"/><radialGradient cx="-22.188" cy="69.922" fx="-24.226" fy="69.914" gradientTransform="matrix(-.89207 1.039 -21.23323 -18.23058 1564.274 1389.022)" gradientUnits="userSpaceOnUse" id="au" r="3.313" xlink:href="#c"/><linearGradient gradientTransform="matrix(1.0052 .03707 -.0371 1.00602 4.01 1.548)" gradientUnits="userSpaceOnUse" id="at" x1="67.515" x2="63.402" xlink:href="#g" y1="86.706" y2="61.357"/><linearGradient gradientTransform="matrix(-.3582 .40218 .39682 .35957 71.202 46.71)" gradientUnits="userSpaceOnUse" id="as" spreadMethod="reflect" x1="28.072" x2="40.199" xlink:href="#l" y1="20.205" y2="20.205"/><radialGradient cx="39.036" cy="69.153" fx="36.286" fy="69.153" gradientTransform="matrix(.62685 -.70383 7.60572 6.89156 -430.194 -328.43)" gradientUnits="userSpaceOnUse" id="ap" r="8.333" xlink:href="#n"/><radialGradient cx="49.157" cy="62.381" fx="45.9" fy="62.298" gradientTransform="matrix(.62685 -.70383 7.60572 6.89156 -429.356 -328.15)" gradientUnits="userSpaceOnUse" id="ao" r="8.333" xlink:href="#n"/><radialGradient cx="3.953" cy="74.833" fx=".906" fy="73.296" gradientTransform="matrix(.43597 -.5661 5.6709 5.2337 -328.64 -296.497)" gradientUnits="userSpaceOnUse" id="an" r="6.932" xlink:href="#s"/><radialGradient cx="39.409" cy="9.579" fx="33.484" fy="10.615" gradientTransform="matrix(1 0 0 .76257 0 7.686)" gradientUnits="userSpaceOnUse" id="az" r="31.966" xlink:href="#C"/><filter id="aA"><feGaussianBlur stdDeviation="1.972"/></filter><filter id="am"><feGaussianBlur stdDeviation=".594"/></filter><linearGradient gradientUnits="userSpaceOnUse" id="al" x1="91.894" x2="102.638" xlink:href="#D" y1="98.323" y2="87.578"/><filter id="ah"><feGaussianBlur stdDeviation="1.098"/></filter><linearGradient id="O"><stop offset="0" stop-color="#fff"/><stop offset="1" stop-color="#fff" stop-opacity="0"/></linearGradient><linearGradient id="N"><stop offset="0" stop-color="#fff" stop-opacity="0"/><stop offset=".047" stop-color="#fff" stop-opacity=".32"/><stop offset=".5" stop-color="#fff" stop-opacity=".498"/><stop offset=".887" stop-color="#fff" stop-opacity=".417"/><stop offset="1" stop-color="#fff" stop-opacity="0"/></linearGradient><linearGradient id="L"><stop offset="0" stop-opacity=".583"/><stop offset=".749" stop-opacity=".496"/><stop offset="1" stop-opacity="0"/></linearGradient><linearGradient id="M"><stop offset="0"/><stop offset="1" stop-opacity="0"/></linearGradient><linearGradient id="K"><stop offset="0" stop-color="#414141"/><stop offset=".5" stop-color="#ababab"/><stop offset="1" stop-color="#414141"/></linearGradient><linearGradient gradientTransform="translate(0 170.052)" gradientUnits="userSpaceOnUse" id="P" spreadMethod="reflect" x1="236.174" x2="236.174" xlink:href="#O" y1="62.725" y2="137.192"/><mask id="Q" maskUnits="userSpaceOnUse"><rect height="106.066" rx="8.902" ry="7.448" width="115.813" x="184" y="175.016" fill="url(#P)" stroke-width="10" stroke-linecap="round" stroke-linejoin="round" stroke-dashoffset="1.088"/></mask><linearGradient gradientTransform="translate(177.907 164.05)" gradientUnits="userSpaceOnUse" id="R" x1="17" x2="111" xlink:href="#N" y1="64" y2="64"/><filter id="aD"><feGaussianBlur stdDeviation=".239"/></filter><filter id="aQ"><feGaussianBlur stdDeviation=".605"/></filter><clipPath id="aM"><path d="M549.138-40.48c-19.32 0-35.01 15.69-35.01 35.01s15.69 34.98 35.01 34.98 34.98-15.66 34.98-34.98c0-19.32-15.66-35.01-34.98-35.01z" fill="#aac0ef" stroke-width="3.421" stroke-linecap="round" stroke-linejoin="round" stroke-dashoffset="4.15"/></clipPath><filter id="aO"><feGaussianBlur stdDeviation=".666"/></filter><filter id="aG"><feGaussianBlur stdDeviation=".315"/></filter><filter id="aI"><feGaussianBlur stdDeviation=".297"/></filter><linearGradient gradientUnits="userSpaceOnUse" id="S" x1="22.309" x2="23.761" y1="87.141" y2="64.996"><stop offset=".053" stop-color="#FFF"/><stop offset=".297" stop-color="#FEFEFD"/><stop offset=".44" stop-color="#FBF9F4"/><stop offset=".556" stop-color="#F6F0E6"/><stop offset=".657" stop-color="#EEE5D2"/><stop offset=".75" stop-color="#E5D6B8"/><stop offset=".836" stop-color="#D9C398"/><stop offset=".915" stop-color="#CBAD73"/><stop offset=".935" stop-color="#C7A769"/></linearGradient><radialGradient cx="59.886" cy="94.093" fx="63.829" fy="63.626" gradientTransform="matrix(1 0 0 1.0137 0 -.673)" gradientUnits="userSpaceOnUse" id="T" r="42.17"><stop offset="0" stop-color="#FF0"/><stop offset="1" stop-color="#FC0"/></radialGradient><linearGradient gradientUnits="userSpaceOnUse" id="U" x1="328.357" x2="326.54" xlink:href="#F" y1="33.784" y2="-88.118"/><filter id="V"><feGaussianBlur stdDeviation=".571"/></filter><linearGradient id="W"><stop offset="0" stop-color="#7b4100" stop-opacity="0"/><stop offset=".035" stop-color="#984f00"/><stop offset="1" stop-opacity="0"/></linearGradient><linearGradient id="F"><stop offset="0"/><stop offset="1" stop-opacity="0"/></linearGradient><linearGradient id="Z"><stop offset="0" stop-color="#fff"/><stop offset="1" stop-color="#fff" stop-opacity="0"/></linearGradient><linearGradient id="Y"><stop offset="0"/><stop offset="1" stop-opacity="0"/></linearGradient><linearGradient id="aa"><stop offset="0" stop-color="#fff"/><stop offset="1" stop-color="#fff" stop-opacity="0"/></linearGradient><linearGradient id="X"><stop offset="0" stop-color="#a2f3ff" stop-opacity=".309"/><stop offset=".58" stop-color="#51d2f4" stop-opacity=".465"/><stop offset=".882" stop-color="#388bc9" stop-opacity=".663"/><stop offset="1" stop-color="#1f449e" stop-opacity=".862"/></linearGradient><linearGradient id="H"><stop offset="0" stop-color="#16367a" stop-opacity="0"/><stop offset=".795" stop-color="#16367a" stop-opacity="0"/><stop offset="1" stop-color="#16367a"/></linearGradient><linearGradient id="ab"><stop offset="0" stop-color="#56e4fd" stop-opacity=".687"/><stop offset="1" stop-color="#fff" stop-opacity=".709"/></linearGradient><linearGradient id="ac"><stop offset="0" stop-color="#fff"/><stop offset="1" stop-color="#fff" stop-opacity="0"/></linearGradient><linearGradient id="J"><stop offset="0" stop-color="#fff"/><stop offset="1" stop-color="#fff" stop-opacity="0"/></linearGradient><linearGradient id="I"><stop offset="0" stop-color="#16367a" stop-opacity="0"/><stop offset=".795" stop-color="#7a166f" stop-opacity="0"/><stop offset="1" stop-color="#59104d"/></linearGradient><linearGradient id="G"><stop offset="0" stop-color="#3e6b13" stop-opacity="0"/><stop offset=".795" stop-color="#477a16" stop-opacity="0"/><stop offset="1" stop-color="#426111"/></linearGradient><linearGradient id="E"><stop offset="0" stop-color="#16367a" stop-opacity="0"/><stop offset=".795" stop-color="#7a7a16" stop-opacity="0"/><stop offset="1" stop-color="#43470c"/></linearGradient><radialGradient cx="461.984" cy="-50.078" fx="461.545" fy="-62.784" gradientTransform="matrix(1.9245 0 0 .989 -427.108 -.552)" gradientUnits="userSpaceOnUse" id="aC" r="21.346" xlink:href="#J"/><radialGradient cx="654.536" cy="-20.356" fx="653.773" fy="3.277" gradientTransform="matrix(.6357 0 0 .6357 -387.744 35.51)" gradientUnits="userSpaceOnUse" id="aE" r="38.29" xlink:href="#X"/><linearGradient gradientUnits="userSpaceOnUse" id="aF" x1="529.517" x2="529.131" xlink:href="#Y" y1="-49.408" y2="-2.032"/><linearGradient gradientUnits="userSpaceOnUse" id="aH" x1="425.907" x2="426.27" xlink:href="#Z" y1="7.406" y2="-21.585"/><linearGradient gradientUnits="userSpaceOnUse" id="aJ" x1="425.2" x2="424.856" xlink:href="#Z" y1="35.691" y2="12.002"/><linearGradient gradientUnits="userSpaceOnUse" id="aK" x1="529.517" x2="529.631" xlink:href="#Y" y1="-49.408" y2="-22.282"/><linearGradient gradientTransform="translate(-266.59 35.223) scale(.6517)" gradientUnits="userSpaceOnUse" id="aL" x1="455.339" x2="452.661" xlink:href="#aa" y1="-91.462" y2="-34.052"/><radialGradient cx="549.109" cy="-5.5" fx="549.109" fy="15.369" gradientTransform="matrix(1 0 0 .9995 0 -.002)" gradientUnits="userSpaceOnUse" id="aN" r="34.641" xlink:href="#H"/><radialGradient cx="455.504" cy="-40.35" fx="455.504" fy="-32.883" gradientTransform="matrix(1.4865 0 0 1.8378 -221.596 32.465)" gradientUnits="userSpaceOnUse" id="aP" r="14.103" xlink:href="#ab"/><radialGradient cx="419.656" cy="-24.165" fx="419.656" fy="-24.165" gradientTransform="matrix(.7195 0 0 .6485 -273.745 28.177)" gradientUnits="userSpaceOnUse" id="aR" r="27.473" xlink:href="#ac"/><linearGradient gradientTransform="translate(-118.576 42.734)" gradientUnits="userSpaceOnUse" id="aS" x1="113.425" x2="114.417" xlink:href="#ad" y1="55.402" y2="118.73"/><linearGradient gradientTransform="translate(-120.2 33.338)" gradientUnits="userSpaceOnUse" id="aw" x1="113.918" x2="108.607" xlink:href="#ab" y1="47.036" y2="69.378"/><filter id="aT"><feGaussianBlur stdDeviation=".29"/></filter></defs><path d="M5.407 41c0 19.095 15.498 34.593 34.593 34.593 19.095 0 34.593-15.498 34.593-34.593C74.593 21.905 59.095 6.407 40 6.407 20.905 6.407 5.407 21.905 5.407 41z" transform="matrix(.987 0 0 .9786 .52 .94)" opacity=".755" fill="none" stroke="#000" stroke-width="4.965" stroke-linecap="round" stroke-linejoin="round" filter="url(#ah)"/><path d="M-279.822-252.56v-2.796 2.795zM-301.086-178.554v-1.053 1.053z" fill="#fff" fill-opacity=".757"/><g fill="none"><path d="M9.623 14.273c6.9-8.19 16.725-12.52 27.493-12.52 10.768 0 21.293 5.448 27.298 13.227" stroke="url(#ai)" stroke-width=".414" transform="matrix(-1.031 -.038 .0497 -1.3436 77.793 75.37)"/><path d="M9.623 14.573c6.9-8.19 16.725-12.52 27.493-12.52 10.768 0 21.293 5.448 27.298 13.227" stroke="url(#aj)" stroke-width=".914" transform="matrix(-1.031 -.038 .0497 -1.3436 77.793 75.37)"/><path d="M9.623 14.473c6.9-8.19 16.725-12.52 27.493-12.52 10.768 0 21.293 5.448 27.298 13.227" stroke="url(#ak)" stroke-width=".614" transform="matrix(-1.031 -.038 .0497 -1.3436 77.793 75.37)"/></g><path d="M66.807 75.346c3.938-3.297 7.16-6.92 9.772-10.972 21.4 18.55 33.854 30.312 51.42 45.683-3.3 4.594-7.132 8.364-10.865 11.943-16.84-16.186-23.8-20.932-50.328-46.654z" fill="url(#al)" stroke="#171717" stroke-linecap="round" stroke-linejoin="round" stroke-dashoffset="4" stroke-opacity=".443" filter="url(#am)"/><path d="M74.264 67.636l-3.636 4.117c3.8 6.26 12.265 15.7 24.185 26.913 9.756 9.178 18.663 16.187 25.175 20.39 2.282-2.04 3.627-3.595 5.19-5.394-4.69-6.36-12.768-14.985-22.603-24.236-11.84-11.137-21.968-18.48-28.31-21.79z" fill="url(#an)"/><path d="M67.433 75.072c3.228-2.973 6.34-6.51 9.026-10.135 16.815 14.37 34.367 30.867 50.346 44.925-3.428 4.53-4.628 6.715-9.512 11.083-16.61-15.966-33.9-30.544-49.86-45.873z" opacity=".733" fill="url(#ao)"/><path d="M68.494 75.515l7.87-4.013c16.817 14.37 31.512 25.92 48.778 39.36-2.55 5.222-4.26 5.496-8.686 9.804-16.35-15.824-32-29.82-47.962-45.15z" opacity=".744" fill="url(#ap)"/><path d="M76.426 64.247c-3.938 3.297-7.168 6.927-9.78 10.98l.177.16c3.938-3.298 7.168-6.928 9.78-10.98l-.177-.16z" fill="#5c5c5c"/><path d="M59.107 51.796a5.284 1.854 0 1 1-10.57 0 5.284 1.854 0 1 1 10.57 0z" transform="matrix(.6837 -.792 .189 .164 26.878 102.807)" fill="url(#aq)"/><path d="M59.107 51.796a5.284 1.854 0 1 1-10.57 0 5.284 1.854 0 1 1 10.57 0z" transform="matrix(.6723 -.8018 .192 .1603 77.988 148.37)" opacity=".651" fill="url(#ar)"/><path d="M68.08 60.183c-2.153 2.62-4.136 4.867-6.08 6.863l6.533 6.01c2.42-2.25 4.63-4.398 6.267-6.743l-6.72-6.13z" fill="url(#as)"/><path d="M68.324 61.334c-2.154 2.622-4.006 4.145-5.95 6.14l6.16 5.582c2.418-2.25 4.628-4.398 6.266-6.743l-6.476-4.98z" fill="url(#at)"/><path d="M127.488 109.963c-6.106-5.74-15.95-13.853-27.38-24.185-8.836-7.99-17.238-15.36-23.674-20.12l-4.77 4.603c5.383 5.926 13.524 14.26 22.36 22.248 11.43 10.332 22.06 18.827 28.773 23.244l4.69-5.788z" fill="url(#au)"/><path d="M68.22 60.28c-.97 1.292-2.03 2.53-3.19 3.69-.41.41-.846.825-1.28 1.218-.022.02-.04.042-.063.062-.567.617-1.13 1.208-1.687 1.78l2.28 2.126c2.146-1.355 3.998-3.166 5.376-5.406.292-.474.547-.95.78-1.438l-2.217-2.03z" opacity=".8" fill="url(#av)" fill-rule="evenodd"/><rect height="8.382" rx="0" ry="0" transform="rotate(-48.368 -.974 -1.362)" width="1.652" x="-5.523" y="91.801" opacity=".188" fill="url(#aw)"/><path d="M34.93-5.477a6.382 4.366 0 1 1-12.762 0 6.382 4.366 0 1 1 12.763 0z" transform="matrix(-5.3278 0 0 7.7867 192.105 82.65)" fill="none" stroke="url(#ax)" stroke-width=".621" stroke-linecap="round" stroke-linejoin="round"/><path d="M6 40c0 18.768 15.232 34 34 34s34-15.232 34-34S58.768 6 40 6 6 21.232 6 40z" fill="none" stroke="url(#ay)" stroke-width="4" stroke-linecap="round" stroke-linejoin="round"/><path d="M39.844 8c-.546-.01-1.105.012-1.657.03C20.538 8.647 6.78 23.473 7.47 41.126c.223 5.737 1.95 11.06 4.78 15.625-.018-.274-.02-.537-.03-.813-.69-17.653 13.067-32.48 30.718-33.093 11.914-.415 22.558 5.737 28.437 15.218C70.298 21.352 56.492 8.265 39.845 8z" fill="url(#az)" opacity=".71" filter="url(#aA)"/><path d="M70.61 38.368a28.05 27.244 0 1 1-56.1 0 28.05 27.244 0 1 1 56.1 0z" transform="matrix(.0385 1.1054 1.1383 -.0445 -5.31 -5.338)" fill="none" stroke="url(#aB)" stroke-width="1.728" stroke-linecap="round" stroke-linejoin="round" stroke-dashoffset="4"/><path d="M483.33-50.078a21.346 20.068 0 1 1-42.692 0 21.346 20.068 0 1 1 42.692 0z" transform="matrix(1.1626 0 0 .8025 -496.955 63.21)" opacity=".406" fill="url(#aC)" filter="url(#aD)"/><path d="M28.333-1.77c-13.438 0-24.35 10.914-24.35 24.352 0 13.437 10.912 24.33 24.35 24.33 13.437 0 24.33-10.893 24.33-24.33 0-13.438-10.893-24.35-24.33-24.35z" fill="url(#aE)" transform="translate(4.38 11.395) scale(1.2725)"/><path d="M514.844-41.875c-19.608 0-35.532 15.924-35.532 35.53 0 3.404.48 6.698 1.375 9.814-.684-2.73-1.062-5.592-1.062-8.533 0-19.314 15.685-35 35-35 19.315 0 35 15.686 35 35 0 6.64-1.847 12.835-5.063 18.125 3.653-5.58 5.782-12.24 5.782-19.406 0-19.607-15.893-35.53-35.5-35.53z" transform="matrix(.894 0 0 .894 -419.7 45.02)" opacity=".391" fill="url(#aF)" filter="url(#aG)"/><path d="M385.938-16.094c-1.14 3.502-1.75 7.213-1.75 11.094 0 19.82 16.086 35.906 35.906 35.906S455.97 14.82 455.97-5c0-3.88-.61-7.592-1.75-11.094.883 3.1 1.374 6.368 1.374 9.75 0 19.608-15.893 35.5-35.5 35.5-19.608 0-35.53-15.892-35.53-35.5-.002-3.382.49-6.65 1.373-9.75z" transform="matrix(.894 0 0 .894 -334.848 45.02)" opacity=".57" fill="url(#aH)" filter="url(#aI)"/><path d="M385.938-16.094c-1.14 3.502-1.75 7.213-1.75 11.094 0 19.82 16.086 34.906 35.906 34.906S455.97 14.82 455.97-5c0-3.88-.61-7.592-1.75-11.094.883 3.1 1.374 6.368 1.374 9.75 0 19.608-15.893 35.5-35.5 35.5-19.608 0-35.53-15.892-35.53-35.5-.002-3.382.49-6.65 1.373-9.75z" transform="matrix(.894 0 0 .894 -334.848 45.02)" fill="url(#aJ)" filter="url(#aI)"/><path d="M514.844-40.875c-19.608 0-35.532 14.924-35.532 34.53 0 3.404.48 6.698 1.375 9.814-.684-2.73-1.062-5.592-1.062-8.533 0-19.314 15.685-35 35-35 19.315 0 35 15.686 35 35 0 6.64-1.847 12.835-5.063 18.125 3.653-5.58 5.782-12.24 5.782-19.406 0-19.607-15.893-34.53-35.5-34.53z" transform="matrix(.894 0 0 .894 -419.7 45.02)" fill="url(#aK)" filter="url(#aG)"/><path d="M28.43-3.525C14.457-3.525 3.11 7.702 3.11 21.528c0 5.358 1.71 10.31 4.61 14.382-2.692-3.98-4.258-8.777-4.258-13.943C3.464 8.19 14.652-3 28.43-3 42.205-3 53.372 8.19 53.372 21.968c0 5.166-1.57 9.962-4.26 13.943 2.897-4.07 4.61-9.024 4.61-14.382C53.724 7.702 42.4-3.525 28.43-3.525z" fill="url(#aL)" transform="translate(4.38 11.395) scale(1.2725)"/><path clip-path="url(#aM)" d="M549.125-40.125C530-40.125 514.47-24.593 514.47-5.47c0 17.55 13.1 32.012 30.03 34.282-14.59-2.228-25.78-14.822-25.78-30.03 0-16.783 13.623-30.407 30.405-30.407 16.782 0 30.406 13.624 30.406 30.406 0 15.735-11.958 28.664-27.28 30.22 17.666-1.573 31.5-16.393 31.5-34.47 0-19.123-15.5-34.655-34.625-34.655zM552.25 29c-.51.052-1.045.1-1.563.125.52-.023 1.05-.08 1.563-.125zm-7.75-.188c.512.07 1.013.142 1.53.188-.51-.052-1.027-.11-1.53-.188zm1.53.188c.51.045 1.016.102 1.533.125-.518-.026-1.02-.073-1.532-.125z" transform="matrix(.894 0 0 .894 -450.86 45.02)" fill="url(#aN)" filter="url(#aO)"/><path d="M469.607-34.83a14.103 17.534 0 1 1-28.207 0 14.103 17.534 0 1 1 28.207 0z" transform="matrix(.9382 0 0 .8158 -386.982 54.48)" opacity=".406" fill="url(#aP)" filter="url(#aQ)"/><path d="M29.446.213l.203 4.226c1.674.03 3.307.187 4.878.435-.326-1.376-.65-2.75-.99-4.124-1.31-.296-2.677-.466-4.092-.537zm-3.103.025c-1.358.103-2.68.328-3.935.64-.36 1.458-.71 2.92-1.056 4.38 1.616-.363 3.305-.59 5.06-.716l.2-4.304c-.09.006-.177-.007-.27 0zm9.67 1.23c.415 1.312.826 2.627 1.236 3.945 2.955.725 5.637 1.81 7.89 3.202-1.75-3.145-5.017-5.7-9.128-7.147zm-16.438.307c-4.402 1.766-7.732 4.846-9.06 8.53 2.057-1.708 4.67-3.11 7.644-4.124.468-1.467.937-2.935 1.415-4.405zm10.14 4.073l.316 6.174c2.156.056 4.26.25 6.252.614-.452-2.098-.927-4.2-1.417-6.3-1.655-.28-3.375-.453-5.15-.488zm-3.372.077c-1.862.137-3.646.44-5.35.845-.49 2.1-.945 4.2-1.395 6.302 2.046-.493 4.2-.818 6.453-.974l.293-6.173zM37.72 6.95c.667 2.16 1.333 4.337 1.98 6.506 2.414.685 4.624 1.574 6.588 2.664.163-.738.247-1.48.247-2.254 0-1.13-.195-2.203-.54-3.253-2.31-1.58-5.118-2.838-8.274-3.663zm-20.078.794c-2.985 1.08-5.59 2.567-7.6 4.354-.1.58-.158 1.167-.158 1.768 0 1.032.158 2.03.45 2.997 1.57-.995 3.335-1.868 5.26-2.587.67-2.174 1.356-4.356 2.048-6.532z" opacity=".59" fill="url(#aR)" transform="translate(4.38 11.395) scale(1.2725)"/><rect height="66.294" rx="0" ry="0" transform="rotate(-48.368)" width=".756" x="-2.866" y="101.467" opacity=".457" fill="url(#aS)"/><path d="M20 36h40v8H20v-8z" transform="matrix(1 0 0 -1 0 80)" opacity=".364" fill="#a8f1ff" fill-rule="evenodd" filter="url(#aT)"/></svg></a>'
      + "  <input value='0' style='width:24px; height:24px; border:none; float:right; text-align:center;' id='xo_log_warnings'></input>"
      + "  <div id='xo_dbg' style='float:left; width:calc(100% - 48px);padding:0px; margin:0px; overflow-y: scroll; background-color:#f6f6f6; height:24px; font-size:14px; font-family:Courier New'>\n"
      + "  </div>\n"
      + "</div>\n"
      + "<div id='xolog-modal-back' class='xolog-modal-back'>\n"
      + "  <div class='xolog-modal-face'>\n"
      + "    <div style='float:right'>\n"
      + '      <button class="xolog-btn" onclick="xo.log.clear();"><svg height="24" width="24" viewBox="0 0 48 48"><defs id="defs4"><linearGradient id="linearGradient6019" inkscape:collect="always"><stop id="stop6021" offset="0" style="stop-color:#000000;stop-opacity:1;"/><stop id="stop6023" offset="1" style="stop-color:#000000;stop-opacity:0;"/></linearGradient><linearGradient id="linearGradient5999" inkscape:collect="always"><stop id="stop6001" offset="0" style="stop-color:#c4a000;stop-opacity:1;"/><stop id="stop6003" offset="1" style="stop-color:#c4a000;stop-opacity:0;"/></linearGradient><linearGradient id="linearGradient5987" inkscape:collect="always"><stop id="stop5989" offset="0" style="stop-color:#d7c20f;stop-opacity:1"/><stop id="stop5991" offset="1" style="stop-color:#b6970d;stop-opacity:1"/></linearGradient><linearGradient id="linearGradient5981" inkscape:collect="always"><stop id="stop5983" offset="0" style="stop-color:#ffffff;stop-opacity:1;"/><stop id="stop5985" offset="1" style="stop-color:#ffffff;stop-opacity:0.69411765"/></linearGradient><linearGradient id="linearGradient5996" inkscape:collect="always"><stop id="stop5998" offset="0" style="stop-color:#8f5902;stop-opacity:1;"/><stop id="stop6000" offset="1" style="stop-color:#73521e;stop-opacity:1"/></linearGradient><linearGradient id="linearGradient5984" inkscape:collect="always"><stop id="stop5986" offset="0" style="stop-color:#ffffff;stop-opacity:1;"/><stop id="stop5988" offset="1" style="stop-color:#ffffff;stop-opacity:0.13438736"/></linearGradient><linearGradient id="linearGradient5974" inkscape:collect="always"><stop id="stop5976" offset="0" style="stop-color:#ad7fa8;stop-opacity:1;"/><stop id="stop5978" offset="1" style="stop-color:#dac6d8;stop-opacity:1"/></linearGradient><linearGradient id="linearGradient5966" inkscape:collect="always"><stop id="stop5968" offset="0" style="stop-color:#fdef72;stop-opacity:1"/><stop id="stop5970" offset="1" style="stop-color:#e2cb0b;stop-opacity:1"/></linearGradient><linearGradient id="linearGradient5958" inkscape:collect="always"><stop id="stop5960" offset="0" style="stop-color:#c17d11;stop-opacity:1;"/><stop id="stop5962" offset="1" style="stop-color:#e9b96e;stop-opacity:1"/></linearGradient><linearGradient gradientTransform="translate(-2,0)" gradientUnits="userSpaceOnUse" id="linearGradient5964" inkscape:collect="always" x1="28" x2="26" xlink:href="#linearGradient5958" y1="16" y2="8"/><linearGradient gradientTransform="translate(-2,0)" gradientUnits="userSpaceOnUse" id="linearGradient5972" inkscape:collect="always" x1="20.933708" x2="30.208115" xlink:href="#linearGradient5966" y1="25.060659" y2="30.742676"/><linearGradient gradientTransform="matrix(0.9768193,0,0,1,-1.3746633,0)" gradientUnits="userSpaceOnUse" id="linearGradient5980" inkscape:collect="always" x1="27.651777" x2="21.59099" xlink:href="#linearGradient5974" y1="23.145937" y2="20.618719"/><linearGradient gradientUnits="userSpaceOnUse" id="linearGradient5994" inkscape:collect="always" x1="28" x2="33.447109" xlink:href="#linearGradient5984" y1="8" y2="16.685888"/><linearGradient gradientTransform="translate(-2,0)" gradientUnits="userSpaceOnUse" id="linearGradient6002" inkscape:collect="always" x1="30.324829" x2="34" xlink:href="#linearGradient5996" y1="9.2407961" y2="18"/><linearGradient gradientTransform="translate(-2,0)" gradientUnits="userSpaceOnUse" id="linearGradient5973" inkscape:collect="always" x1="22.319767" x2="18.985712" xlink:href="#linearGradient5981" y1="41.955986" y2="37.029255"/><linearGradient gradientTransform="translate(-2,0)" gradientUnits="userSpaceOnUse" id="linearGradient5993" inkscape:collect="always" x1="17.032078" x2="29.494455" xlink:href="#linearGradient5987" y1="27.446827" y2="37.845814"/><linearGradient gradientTransform="translate(-2,0)" gradientUnits="userSpaceOnUse" id="linearGradient6005" inkscape:collect="always" x1="27.354809" x2="23.489431" xlink:href="#linearGradient5999" y1="36.218422" y2="34.728424"/><radialGradient cx="38" cy="69" fx="28.603323" fy="69" gradientTransform="matrix(1,0,0,0.45,0,37.95)" gradientUnits="userSpaceOnUse" id="radialGradient6025" inkscape:collect="always" r="20" xlink:href="#linearGradient6019"/></defs><g id="layer1" inkscape:groupmode="layer" inkscape:label="Livello 1"><path d="M 58,69 A 20,9 0 1 1 18,69 A 20,9 0 1 1 58,69 z" id="path6017" sodipodi:cx="38" sodipodi:cy="69" sodipodi:rx="20" sodipodi:ry="9" sodipodi:type="arc" style="opacity:0.25;fill:url(#radialGradient6025);fill-opacity:1;stroke:none;stroke-width:0.99999994;stroke-linecap:round;stroke-linejoin:round;stroke-miterlimit:20;stroke-dasharray:none;stroke-opacity:1" transform="matrix(1,0,0,0.6666668,-13.999999,-5.0000087)"/><path d="M 34.59375,2.46875 C 26.390533,2.5744003 25.19695,18.716276 22.84375,21.625 L 26.84375,23.0625 C 29.475623,18.689953 42.599746,4.1545034 35.40625,2.5 C 35.12676,2.4690309 34.85837,2.4653419 34.59375,2.46875 z M 33.5625,4.53125 C 33.756063,4.5125114 33.930486,4.5369694 34.09375,4.625 C 34.746806,4.9771226 34.817405,6.1198771 34.25,7.15625 C 33.682595,8.1926229 32.684304,8.7583725 32.03125,8.40625 C 31.378197,8.0541272 31.307595,6.9113729 31.875,5.875 C 32.300554,5.0977202 32.981812,4.5874659 33.5625,4.53125 z" id="path5371" style="fill:url(#linearGradient5964);fill-opacity:1;fill-rule:evenodd;stroke:url(#linearGradient6002);stroke-width:1px;stroke-linecap:butt;stroke-linejoin:miter;stroke-opacity:1"/><path d="M 36.59375,3.46875 C 34.872132,3.4909229 33.585825,4.3246243 32.40625,5.75 C 31.226675,7.1753757 30.257916,9.1916354 29.46875,11.34375 C 28.679584,13.495865 28.04471,15.77802 27.46875,17.71875 C 27.068859,19.066206 26.698893,20.125198 26.25,21.0625 L 28.4375,21.84375 C 30.056094,19.348126 33.476298,15.252572 35.96875,11.21875 C 37.294589,9.0729934 38.25245,7.0407089 38.46875,5.65625 C 38.5769,4.9640206 38.513818,4.4833206 38.34375,4.1875 C 38.179059,3.9010309 37.880274,3.6629145 37.21875,3.5 C 37.019255,3.4812162 36.817917,3.4658629 36.59375,3.46875 z" id="path5992" inkscape:original="M 36.59375 2.46875 C 28.390533 2.5744003 27.19695 18.716276 24.84375 21.625 L 28.84375 23.0625 C 31.475623 18.689953 44.599746 4.1545034 37.40625 2.5 C 37.12676 2.4690309 36.85837 2.4653419 36.59375 2.46875 z " inkscape:radius="-1.0049498" sodipodi:type="inkscape:offset" style="opacity:0.26666667;fill:none;fill-opacity:1;fill-rule:evenodd;stroke:url(#linearGradient5994);stroke-width:1px;stroke-linecap:butt;stroke-linejoin:miter;stroke-opacity:1" transform="translate(-2,0)"/><path d="M 20.5,16.5 C 21.209506,18.503007 19.958612,20.237831 19.5,21.5 C 14.308433,23.045674 10.713199,31.203726 5.3674175,35.453585 C 6.0352055,36.150983 6.819644,36.897763 7.5,37.5 L 11.5625,33.96875 L 8.494944,38.493399 C 10.704181,40.284382 13,41.5 14.5,42 L 17.25,38.34375 L 15.5,42.5 C 16.951994,43.088882 20.485286,43.982025 22.5,44 L 24.50389,40.597503 L 23.990721,44.0625 C 24.820284,44.220859 26.428886,44.436716 27.5,44.46875 C 30.862186,38.96875 31.5,30 29.5,26 C 29,24 31,21.5 32.5,20.5 C 30,18.5 24.294411,16.196274 20.5,16.5 z" id="path5367" sodipodi:nodetypes="cccccccccccccccc" style="fill:url(#linearGradient5972);fill-opacity:1;fill-rule:evenodd;stroke:url(#linearGradient5993);stroke-width:0.99999994;stroke-linecap:butt;stroke-linejoin:miter;stroke-miterlimit:20;stroke-dasharray:none;stroke-opacity:1"/><path d="M 9,38.5 C 13.816495,33.489105 13.465023,31.296074 19.116117,26.972272 C 16.133675,31.800703 15.650278,34.31233 12,40.5 L 9,38.5 z" id="path5975" sodipodi:nodetypes="cccc" style="opacity:0.26666667;fill:#c4a000;fill-rule:evenodd;stroke:none;stroke-width:1px;stroke-linecap:butt;stroke-linejoin:miter;stroke-opacity:1"/><path d="M 16.149808,42.202452 L 20.495835,32.362305 C 22.160348,29.378578 23.355507,26.392253 25.024808,24.014952 C 23.422854,29.432989 20.134118,36.136745 17.493558,42.639952 L 16.149808,42.202452 z" id="path5979" sodipodi:nodetypes="ccccc" style="opacity:0.41568627;fill:#c4a000;fill-rule:evenodd;stroke:none;stroke-width:1px;stroke-linecap:butt;stroke-linejoin:miter;stroke-opacity:1"/><path d="M 21.625,17.5 C 21.721738,19.415146 20.702057,21.029645 20.40625,21.84375 C 20.302147,22.128459 20.07092,22.348124 19.78125,22.4375 C 14.327852,24.672144 12.151447,31.011538 6.7866116,35.523667 C 6.988254,35.723521 7.2786424,35.940971 7.4811412,36.131898 L 16.5,28.5 L 9.923385,38.310313 C 11.193418,39.337926 12.645586,40.194857 14.150041,40.799478 L 21.144394,31.5 L 16.869501,41.911612 C 18.46507,42.437269 19.967804,42.738908 21.81451,43 L 26.43324,35.3125 L 25.0625,43.219317 L 26.9375,43.445312 C 28.370713,40.909818 29.069882,37.778782 29.46875,34.65625 C 29.892695,31.337404 29.463786,28.115072 28.625,26.4375 C 28.597837,26.377291 28.576895,26.314465 28.5625,26.25 C 28.215642,24.862569 28.731642,23.504373 29.4375,22.375 C 29.864393,21.691971 30.367872,21.084221 30.902459,20.573223 C 29.730977,19.790532 28.315762,19.113157 26.53125,18.46875 C 24.769173,17.832444 23.033252,17.518725 21.625,17.5 z" id="path6014" sodipodi:nodetypes="csccccccccccccsssscsc" style="opacity:0.47843137;fill:none;fill-opacity:1;fill-rule:evenodd;stroke:url(#linearGradient5973);stroke-width:0.99999994px;stroke-linecap:butt;stroke-linejoin:miter;stroke-opacity:1"/><path d="M 18.96875,43 C 21.146316,37.248129 25.364666,32.931057 26.985663,27.064588 C 27.037206,30.726661 27.235383,37.268314 25.09375,43.78125 C 24.773984,43.783025 24.919823,43.670441 24.62387,43.662697 L 25.424662,37.93818 L 22.143176,43.492564 C 19.952368,43.33624 20.848565,43.525163 18.96875,43 z" id="path5977" sodipodi:nodetypes="ccccccc" style="opacity:0.24705882;fill:url(#linearGradient6005);fill-opacity:1;fill-rule:evenodd;stroke:none;stroke-width:1px;stroke-linecap:butt;stroke-linejoin:miter;stroke-opacity:1"/><path d="M 21.003067,22.610447 C 19.751072,23.226826 18.940858,24.137725 18.019961,24.974835 C 19.246448,24.266192 20.398947,23.525841 22.019534,22.986097 L 21.003067,22.610447 z" id="path5995" sodipodi:nodetypes="cccc" style="opacity:0.48235294;fill:#c4a000;fill-rule:evenodd;stroke:none;stroke-width:1px;stroke-linecap:butt;stroke-linejoin:miter;stroke-opacity:1"/><path d="M 23.008698,23.061049 L 21.992233,25.049787 L 24.972946,23.461537 L 23.008698,23.061049 z" id="path5997" sodipodi:nodetypes="cccc" style="opacity:0.48235294;fill:#c4a000;fill-rule:evenodd;stroke:none;stroke-width:1px;stroke-linecap:butt;stroke-linejoin:miter;stroke-opacity:1"/><path d="M 22.939805,17.961399 L 22.044612,19.668421 L 23.610339,20.170505 L 22.939805,17.961399 z" id="path6007" sodipodi:nodetypes="cccc" style="opacity:0.48235294;fill:#c4a000;fill-rule:evenodd;stroke:none;stroke-width:1px;stroke-linecap:butt;stroke-linejoin:miter;stroke-opacity:1"/><path d="M 29.923254,19.88537 L 27.463006,21.720817 L 29.028733,22.222901 L 29.923254,19.88537 z" id="path6009" sodipodi:nodetypes="cccc" style="opacity:0.48235294;fill:#c4a000;fill-rule:evenodd;stroke:none;stroke-width:1px;stroke-linecap:butt;stroke-linejoin:miter;stroke-opacity:1"/><path d="M 26.012925,17.938566 L 24.499014,20.46318 L 26.064741,20.965264 L 26.012925,17.938566 z" id="path6011" sodipodi:nodetypes="cccc" style="opacity:0.48235294;fill:#c4a000;fill-rule:evenodd;stroke:none;stroke-width:1px;stroke-linecap:butt;stroke-linejoin:miter;stroke-opacity:1"/><path d="M 18.967726,22.024699 C 18.400946,19.059215 28.300561,24.177602 30.004548,25.019068 C 29.998066,26.098136 30.004548,27.019068 29.027729,27.019068 C 26.460191,25.626088 22.492474,23.413925 18.967726,22.024699 z" id="path6013" sodipodi:nodetypes="cccc" style="opacity:0.2;fill:#000000;fill-opacity:1;fill-rule:evenodd;stroke:none;stroke-width:1px;stroke-linecap:butt;stroke-linejoin:round;stroke-opacity:1"/><path d="M 18.650133,21.5 C 18.161723,20.5 18.650133,19.5 19.626953,19.5 C 23.618393,20.475417 26.951828,21.706232 30.371965,23.5 C 30.860375,24.5 30.371965,25.5 29.395146,25.5 C 25.861203,23.63558 22.528435,22.425187 18.650133,21.5 z" id="path5373" sodipodi:nodetypes="ccccc" style="fill:url(#linearGradient5980);fill-opacity:1;fill-rule:evenodd;stroke:#5c3566;stroke-width:1px;stroke-linecap:butt;stroke-linejoin:round;stroke-opacity:1"/></g></svg></button>'
      + '      <button class="xolog-btn" id="xo.modal.close"><svg height="24" width="24" viewBox="0 0 48 48"><defs id="defs3841"><linearGradient id="linearGradient3799" inkscape:collect="always"><stop id="stop3801" offset="0" style="stop-color:#555753;stop-opacity:1"/><stop id="stop3803" offset="1" style="stop-color:#555753;stop-opacity:0"/></linearGradient><linearGradient id="linearGradient5154" inkscape:collect="always"><stop id="stop5156" offset="0" style="stop-color:#ffffff;stop-opacity:1;"/><stop id="stop5158" offset="1" style="stop-color:#ffffff;stop-opacity:0;"/></linearGradient><linearGradient id="linearGradient5162"><stop id="stop5166" offset="0" style="stop-color:#9c9e99;stop-opacity:1;"/><stop id="stop5164" offset="1" style="stop-color:#868883;stop-opacity:1;"/></linearGradient><linearGradient id="linearGradient5186"><stop id="stop5188" offset="0" style="stop-color:black;stop-opacity:1;"/><stop id="stop5190" offset="1" style="stop-color:black;stop-opacity:0;"/></linearGradient><radialGradient cx="11.004161" cy="9.3000956" fx="11.004161" fy="9.3000956" gradientTransform="matrix(1.5405641,0,0,1.5392619,-4.0668303,-13.331411)" gradientUnits="userSpaceOnUse" id="radialGradient3884" inkscape:collect="always" r="7.9645054" xlink:href="#linearGradient5162"/><linearGradient gradientUnits="userSpaceOnUse" id="linearGradient3886" inkscape:collect="always" x1="10.364615" x2="10.364615" xlink:href="#linearGradient5154" y1="5.29778" y2="24.067238"/><radialGradient cx="16.502085" cy="8.0548735" fx="16.502085" fy="8.0548735" gradientTransform="matrix(1.1574281,0,0,0.5826333,-2.5978912,8.124026)" gradientUnits="userSpaceOnUse" id="radialGradient3888" inkscape:collect="always" r="10.110913" xlink:href="#linearGradient3799"/><radialGradient cx="10.5625" cy="17.625" fx="10.5625" fy="17.625" gradientTransform="matrix(0.9522895,0,0,0.3336489,0.5039423,11.744441)" gradientUnits="userSpaceOnUse" id="radialGradient2185" inkscape:collect="always" r="8.5625" xlink:href="#linearGradient5186"/><radialGradient cx="10.5625" cy="17.625" fx="10.5625" fy="17.625" gradientTransform="matrix(0.9642909,0,0,0.3378538,0.3771775,11.67033)" gradientUnits="userSpaceOnUse" id="radialGradient2189" inkscape:collect="always" r="8.5625" xlink:href="#linearGradient5186"/><radialGradient cx="10.5625" cy="17.625" fx="10.5625" fy="17.625" gradientTransform="matrix(1,0,0,0.350365,0,11.44982)" gradientUnits="userSpaceOnUse" id="radialGradient2192" inkscape:collect="always" r="8.5625" xlink:href="#linearGradient5186"/></defs><g id="layer1" inkscape:groupmode="layer" inkscape:label="Layer 1"><path d="M 19.125 17.625 A 8.5625 3 0 1 1  2,17.625 A 8.5625 3 0 1 1  19.125 17.625 z" id="path3819" sodipodi:cx="10.5625" sodipodi:cy="17.625" sodipodi:rx="8.5625" sodipodi:ry="3" sodipodi:type="arc" style="opacity:0.09195401;color:#000000;fill:url(#radialGradient2192);fill-opacity:1;fill-rule:nonzero;stroke:none;stroke-width:1;stroke-linecap:round;stroke-linejoin:round;marker:none;marker-start:none;marker-mid:none;marker-end:none;stroke-miterlimit:4;stroke-dasharray:none;stroke-dashoffset:0;stroke-opacity:1;visibility:visible;display:inline;overflow:visible" transform="matrix(2.5841197,0,0,1.3158205,-2.2947635,11.602319)"/><path d="M 19.125 17.625 A 8.5625 3 0 1 1  2,17.625 A 8.5625 3 0 1 1  19.125 17.625 z" id="path2183" sodipodi:cx="10.5625" sodipodi:cy="17.625" sodipodi:rx="8.5625" sodipodi:ry="3" sodipodi:type="arc" style="opacity:0.2030651;color:#000000;fill:url(#radialGradient2185);fill-opacity:1;fill-rule:nonzero;stroke:none;stroke-width:1;stroke-linecap:round;stroke-linejoin:round;marker:none;marker-start:none;marker-mid:none;marker-end:none;stroke-miterlimit:4;stroke-dasharray:none;stroke-dashoffset:0;stroke-opacity:1;visibility:visible;display:inline;overflow:visible" transform="matrix(1.0510949,0,0,1.401731,2.89781,11.499684)"/><path d="M 19.125 17.625 A 8.5625 3 0 1 1  2,17.625 A 8.5625 3 0 1 1  19.125 17.625 z" id="path2187" sodipodi:cx="10.5625" sodipodi:cy="17.625" sodipodi:rx="8.5625" sodipodi:ry="3" sodipodi:type="arc" style="opacity:0.2030651;color:#000000;fill:url(#radialGradient2189);fill-opacity:1;fill-rule:nonzero;stroke:none;stroke-width:1;stroke-linecap:round;stroke-linejoin:round;marker:none;marker-start:none;marker-mid:none;marker-end:none;stroke-miterlimit:4;stroke-dasharray:none;stroke-dashoffset:0;stroke-opacity:1;visibility:visible;display:inline;overflow:visible" transform="matrix(1.0510949,0,0,1.401731,23.89781,11.499684)"/><g id="g3821" transform="matrix(1.2307692,0,0,1.2307692,3.222518,7.3727903)"><g id="g3823" transform="translate(4.5267189,9.405604)"><path d="M 4.3116263,-7.9047834 C 3.1284911,-7.9138208 2.0467982,-7.191319 1.5988112,-6.0962397 C 1.150825,-5.0011613 1.426782,-3.7540848 2.2770152,-2.9312886 L 8.7877699,3.5794713 L 2.2770152,10.090223 C 1.1408453,11.226392 1.1408453,13.068496 2.2770152,14.204665 C 3.413185,15.340834 5.2552803,15.340834 6.39145,14.204665 L 12.902207,7.6939047 L 19.412964,14.204665 C 20.143108,14.95565 21.204196,15.243372 22.2162,14.973295 C 23.228214,14.703219 24.037149,13.908401 24.296024,12.893469 C 24.554902,11.878538 24.241195,10.812032 23.482185,10.090223 L 16.971429,3.5794713 L 23.482185,-2.9312886 C 24.338874,-3.7597417 24.620171,-5.0419757 24.160388,-6.1414534 C 23.700606,-7.2409305 22.593771,-7.9328101 21.402362,-7.9047834 C 20.64653,-7.874935 19.932434,-7.5503435 19.412964,-7.000512 L 12.902207,-0.4897543 L 6.39145,-7.000512 C 5.8500755,-7.572344 5.0990546,-7.8988742 4.3116263,-7.9047834 z " id="path3825" style="opacity:1;color:#000000;fill:url(#radialGradient3884);fill-opacity:1;fill-rule:nonzero;stroke:#555753;stroke-width:0.8125;stroke-linecap:round;stroke-linejoin:round;marker:none;stroke-miterlimit:4;stroke-dasharray:none;stroke-dashoffset:0;stroke-opacity:1;visibility:visible;display:inline;overflow:visible"/></g><path d="M 4.3125,-7.09375 C 3.4703978,-7.1001826 2.6631615,-6.5620336 2.34375,-5.78125 C 2.0245705,-5.0010326 2.2241798,-4.1308267 2.84375,-3.53125 C 2.8541657,-3.5314476 2.8645843,-3.5314476 2.875,-3.53125 L 9.375,3 C 9.5364678,3.1553211 9.6277145,3.3697042 9.6277145,3.59375 C 9.6277145,3.8177958 9.5364678,4.0321789 9.375,4.1875 L 2.875,10.6875 C 2.0554426,11.507057 2.0554426,12.805443 2.875,13.625 C 3.6945578,14.444557 4.9929424,14.444557 5.8125,13.625 L 12.3125,7.09375 C 12.467821,6.9322822 12.682204,6.8410355 12.90625,6.8410355 C 13.130296,6.8410355 13.344679,6.9322822 13.5,7.09375 L 20,13.625 C 20.000198,13.635416 20.000198,13.645834 20,13.65625 C 20.518211,14.189252 21.25952,14.385114 22,14.1875 C 22.734866,13.991386 23.284374,13.410356 23.46875,12.6875 C 23.653949,11.961426 23.450865,11.205422 22.90625,10.6875 C 22.895834,10.687698 22.885416,10.687698 22.875,10.6875 L 16.375,4.1875 C 16.213532,4.0321789 16.122285,3.8177958 16.122285,3.59375 C 16.122285,3.3697042 16.213532,3.1553211 16.375,3 L 22.875,-3.53125 C 22.885416,-3.5314476 22.895834,-3.5314476 22.90625,-3.53125 C 23.522472,-4.1271617 23.729827,-5.0699801 23.40625,-5.84375 C 23.080156,-6.6235373 22.304482,-7.1141449 21.4375,-7.09375 C 20.897652,-7.0724312 20.368639,-6.8276853 20,-6.4375 C 20.000198,-6.4270843 20.000198,-6.4166657 20,-6.40625 L 13.5,0.09375 C 13.344679,0.25521784 13.130296,0.34646454 12.90625,0.34646454 C 12.682204,0.34646454 12.467821,0.25521784 12.3125,0.09375 L 5.8125,-6.40625 C 5.8123024,-6.4166657 5.8123024,-6.4270843 5.8125,-6.4375 C 5.4291815,-6.8423838 4.8748348,-7.08953 4.3125,-7.09375 z " id="path3827" inkscape:href="#path4262" inkscape:original="M 4.3125 -7.90625 C 3.1293647 -7.9152876 2.041737 -7.1888293 1.59375 -6.09375 C 1.1457639 -4.9986717 1.4310168 -3.7602962 2.28125 -2.9375 L 8.78125 3.59375 L 2.28125 10.09375 C 1.1450801 11.229919 1.1450801 13.082581 2.28125 14.21875 C 3.4174198 15.354919 5.2700803 15.354919 6.40625 14.21875 L 12.90625 7.6875 L 19.40625 14.21875 C 20.136394 14.969735 21.206746 15.238827 22.21875 14.96875 C 23.230764 14.698674 24.022375 13.921182 24.28125 12.90625 C 24.540128 11.891319 24.22776 10.815559 23.46875 10.09375 L 16.96875 3.59375 L 23.46875 -2.9375 C 24.325439 -3.765953 24.616033 -5.0567723 24.15625 -6.15625 C 23.696467 -7.2557272 22.597659 -7.9342767 21.40625 -7.90625 C 20.650417 -7.8764018 19.92572 -7.5498315 19.40625 -7 L 12.90625 -0.5 L 6.40625 -7 C 5.8648756 -7.5718319 5.0999283 -7.9003408 4.3125 -7.90625 z " inkscape:radius="-0.8237794" sodipodi:type="inkscape:offset" style="opacity:0.36206898;color:#000000;fill:none;fill-opacity:1;fill-rule:nonzero;stroke:url(#linearGradient3886);stroke-width:0.8125;stroke-linecap:round;stroke-linejoin:round;marker:none;stroke-miterlimit:4;stroke-dasharray:none;stroke-dashoffset:0;stroke-opacity:1;visibility:visible;display:inline;overflow:visible" transform="translate(4.5477906,9.4068256)" xlink:href="#path4262"/><path d="M 14,13 C 18.242641,11.762563 17.154067,13.132583 20.911612,13.132583 L 27.823223,20.044194 L 24,23 L 17.500893,16.443651 L 11,22.779029 L 7.6013979,19.448855 L 14,13 z " id="path3829" sodipodi:nodetypes="cccccccc" style="opacity:0.3;fill:url(#radialGradient3888);fill-opacity:1;fill-rule:evenodd;stroke:none;stroke-width:1px;stroke-linecap:butt;stroke-linejoin:miter;stroke-opacity:1"/></g></g></svg></button>'
      + "    </div>\n"
      + "    <div style='clear:both'>\n"
      + "    <div id='xolog-modal-text'></div>\n"
      + "  </div>\n"
      + "</div>\n"
      );
      document.body.insertBefore(rv, document.body.lastChild);
      this.init_modal();
      return rv;
    }
    this.modal_handler = function(evt) {
      evt = evt || window.event;      
      if (evt.keyCode == 27) {
        var modal = document.getElementById('xolog-modal-back');
        modal.style.display = "none";
        document.body.removeEventListener('keydown', xo.log.modal_handler);
      }      
    }
    this.init_modal = function() {
      // Get the modal
      var modal = document.getElementById('xolog-modal-back');

      // Get the button that opens the modal
      var btn = document.getElementById("xolog-modal-show");

      // Get the <span> element that closes the modal
      var span = document.getElementById("xo.modal.close");

      // When the user clicks on the button, open the modal
      btn.onclick = function() {
          modal.style.display = "block";
          var log_elem = document.getElementById('xo_dbg');
          var modal_elem = document.getElementById('xolog-modal-text');
          modal_elem.innerHTML = log_elem.innerHTML;
          span.focus();
          document.body.addEventListener('keydown', xo.log.modal_handler);
      }

      // When the user clicks on <span> (x), close the modal
      span.onclick = function() {
          modal.style.display = "none";
      }

      // When the user clicks anywhere outside of the modal, close it
      window.onclick = function(event) {
          if (event.target == modal) {
              modal.style.display = "none";
          }
      }
    };
    
    this.pad = function(str, len, pad) {
      str = str.toString();
      var str_len = str.length;
      if (str_len < len) {
        for (var i = str_len; i < len; ++i) {
          str = pad + str;
        }
      }
      return str;
    }    
  };
}(window.xo = window.xo || {}));

var ctor_obj = {}.constructor;
var ctor_ary = [].constructor;
function dbg() {
  // xo.log.add.apply(this, 6, arguments);
  xo.log.add_array(5, 0, Array.prototype.slice.call(arguments));
}
xo.log.add(1, 'xo.log:initialized');