/*
 * Decompiled with CFR 0.152.
 */
package org.luaj.vm2.script;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import javax.script.AbstractScriptEngine;
import javax.script.Bindings;
import javax.script.Compilable;
import javax.script.CompiledScript;
import javax.script.ScriptContext;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineFactory;
import javax.script.ScriptException;
import javax.script.SimpleBindings;
import org.luaj.vm2.Globals;
import org.luaj.vm2.LuaClosure;
import org.luaj.vm2.LuaError;
import org.luaj.vm2.LuaFunction;
import org.luaj.vm2.LuaTable;
import org.luaj.vm2.LuaValue;
import org.luaj.vm2.Varargs;
import org.luaj.vm2.lib.ThreeArgFunction;
import org.luaj.vm2.lib.TwoArgFunction;
import org.luaj.vm2.lib.jse.CoerceJavaToLua;
import org.luaj.vm2.script.LuaScriptEngineFactory;
import org.luaj.vm2.script.LuajContext;

public class LuaScriptEngine
extends AbstractScriptEngine
implements ScriptEngine,
Compilable {
    private static final String __ENGINE_VERSION__ = "Luaj-jse 3.0-beta2";
    private static final String __NAME__ = "Luaj";
    private static final String __SHORT_NAME__ = "Luaj";
    private static final String __LANGUAGE__ = "lua";
    private static final String __LANGUAGE_VERSION__ = "5.2";
    private static final String __ARGV__ = "arg";
    private static final String __FILENAME__ = "?";
    private static final ScriptEngineFactory myFactory = new LuaScriptEngineFactory();
    private LuajContext context = new LuajContext();

    public LuaScriptEngine() {
        this.context.setBindings(this.createBindings(), 100);
        this.setContext(this.context);
        this.put("javax.script.language_version", __LANGUAGE_VERSION__);
        this.put("javax.script.language", __LANGUAGE__);
        this.put("javax.script.engine", "Luaj");
        this.put("javax.script.engine_version", __ENGINE_VERSION__);
        this.put("javax.script.argv", __ARGV__);
        this.put("javax.script.filename", __FILENAME__);
        this.put("javax.script.name", "Luaj");
        this.put("THREADING", null);
    }

    public CompiledScript compile(String string) throws ScriptException {
        return this.compile(new StringReader(string));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public CompiledScript compile(Reader reader) throws ScriptException {
        try {
            Utf8Encoder utf8Encoder = new Utf8Encoder(reader);
            try {
                Globals globals = this.context.globals;
                LuaFunction luaFunction = globals.load(reader, "script").checkfunction();
                LuajCompiledScript luajCompiledScript = new LuajCompiledScript(luaFunction, globals);
                return luajCompiledScript;
            }
            catch (LuaError luaError) {
                throw new ScriptException(luaError.getMessage());
            }
            finally {
                utf8Encoder.close();
            }
        }
        catch (Exception exception) {
            throw new ScriptException("eval threw " + exception.toString());
        }
    }

    public Bindings createBindings() {
        return new SimpleBindings();
    }

    public Object eval(String string, ScriptContext scriptContext) throws ScriptException {
        return this.eval((Reader)new StringReader(string), scriptContext);
    }

    public Object eval(Reader reader, ScriptContext scriptContext) throws ScriptException {
        return this.compile(reader).eval();
    }

    public ScriptEngineFactory getFactory() {
        return myFactory;
    }

    private static LuaValue toLua(Object object) {
        return object == null ? LuaValue.NIL : (object instanceof LuaValue ? (LuaValue)object : CoerceJavaToLua.coerce(object));
    }

    private static Object toJava(LuaValue luaValue) {
        switch (luaValue.type()) {
            case 0: {
                return null;
            }
            case 4: {
                return luaValue.tojstring();
            }
            case 7: {
                return luaValue.checkuserdata(Object.class);
            }
            case 3: {
                return luaValue.isinttype() ? (Number)new Integer(luaValue.toint()) : (Number)new Double(luaValue.todouble());
            }
        }
        return luaValue;
    }

    private static Object toJava(Varargs varargs) {
        int n = varargs.narg();
        switch (n) {
            case 0: {
                return null;
            }
            case 1: {
                return LuaScriptEngine.toJava(varargs.arg1());
            }
        }
        Object[] objectArray = new Object[n];
        for (int i = 0; i < n; ++i) {
            objectArray[i] = LuaScriptEngine.toJava(varargs.arg(i + 1));
        }
        return objectArray;
    }

    static class BindingsMetatable
    extends LuaTable {
        BindingsMetatable(final Bindings bindings) {
            this.rawset(LuaValue.INDEX, (LuaValue)new TwoArgFunction(){

                public LuaValue call(LuaValue luaValue, LuaValue luaValue2) {
                    if (luaValue2.isstring()) {
                        return LuaScriptEngine.toLua(bindings.get(luaValue2.tojstring()));
                    }
                    return this.rawget(luaValue2);
                }
            });
            this.rawset(LuaValue.NEWINDEX, (LuaValue)new ThreeArgFunction(){

                public LuaValue call(LuaValue luaValue, LuaValue luaValue2, LuaValue luaValue3) {
                    if (luaValue2.isstring()) {
                        String string = luaValue2.tojstring();
                        Object object = LuaScriptEngine.toJava(luaValue3);
                        if (object == null) {
                            bindings.remove(string);
                        } else {
                            bindings.put(string, object);
                        }
                    } else {
                        this.rawset(luaValue2, luaValue3);
                    }
                    return LuaValue.NONE;
                }
            });
        }
    }

    private final class Utf8Encoder
    extends InputStream {
        private final Reader r;
        private final int[] buf = new int[2];
        private int n;

        private Utf8Encoder(Reader reader) {
            this.r = reader;
        }

        public int read() throws IOException {
            if (this.n > 0) {
                return this.buf[--this.n];
            }
            int n = this.r.read();
            if (n < 128) {
                return n;
            }
            this.n = 0;
            if (n < 2048) {
                this.buf[this.n++] = 0x80 | n & 0x3F;
                return 0xC0 | n >> 6 & 0x1F;
            }
            this.buf[this.n++] = 0x80 | n & 0x3F;
            this.buf[this.n++] = 0x80 | n >> 6 & 0x3F;
            return 0xE0 | n >> 12 & 0xF;
        }
    }

    class LuajCompiledScript
    extends CompiledScript {
        final LuaFunction function;
        final Globals compiling_globals;

        LuajCompiledScript(LuaFunction luaFunction, Globals globals) {
            this.function = luaFunction;
            this.compiling_globals = globals;
        }

        public ScriptEngine getEngine() {
            return LuaScriptEngine.this;
        }

        public Object eval() throws ScriptException {
            return this.eval(LuaScriptEngine.this.getContext());
        }

        public Object eval(Bindings bindings) throws ScriptException {
            return this.eval(((LuajContext)LuaScriptEngine.this.getContext()).globals, bindings);
        }

        public Object eval(ScriptContext scriptContext) throws ScriptException {
            return this.eval(((LuajContext)scriptContext).globals, scriptContext.getBindings(100));
        }

        private Object eval(Globals globals, Bindings bindings) throws ScriptException {
            globals.setmetatable(new BindingsMetatable(bindings));
            LuaFunction luaFunction = this.function;
            if (luaFunction.isclosure()) {
                luaFunction = new LuaClosure(luaFunction.checkclosure().p, globals);
            } else {
                try {
                    luaFunction = (LuaFunction)luaFunction.getClass().newInstance();
                }
                catch (Exception exception) {
                    throw new ScriptException(exception);
                }
                luaFunction.initupvalue1(globals);
            }
            return LuaScriptEngine.toJava(luaFunction.invoke(LuaValue.NONE));
        }
    }
}

