/*
 * Decompiled with CFR 0.152.
 */
package org.luaj.vm2.luajc;

import org.luaj.vm2.Lua;
import org.luaj.vm2.luajc.BasicBlock;
import org.luaj.vm2.luajc.ProtoInfo;
import org.luaj.vm2.luajc.VarInfo;

public class UpvalInfo {
    ProtoInfo pi;
    int slot;
    int nvars;
    VarInfo[] var;
    boolean rw;

    public UpvalInfo(ProtoInfo protoInfo) {
        this.pi = protoInfo;
        this.slot = 0;
        this.nvars = 1;
        this.var = new VarInfo[]{VarInfo.PARAM(0)};
        this.rw = false;
    }

    public UpvalInfo(ProtoInfo protoInfo, int n, int n2) {
        this.pi = protoInfo;
        this.slot = n2;
        this.nvars = 0;
        this.var = null;
        this.includeVarAndPosteriorVars(protoInfo.vars[n2][n]);
        for (int i = 0; i < this.nvars; ++i) {
            this.var[i].allocupvalue = this.testIsAllocUpvalue(this.var[i]);
        }
        this.rw = this.nvars > 1;
    }

    private boolean includeVarAndPosteriorVars(VarInfo varInfo) {
        if (varInfo == null || varInfo == VarInfo.INVALID) {
            return false;
        }
        if (varInfo.upvalue == this) {
            return true;
        }
        varInfo.upvalue = this;
        this.appendVar(varInfo);
        if (this.isLoopVariable(varInfo)) {
            return false;
        }
        boolean bl = this.includePosteriorVarsCheckLoops(varInfo);
        if (bl) {
            this.includePriorVarsIgnoreLoops(varInfo);
        }
        return bl;
    }

    private boolean isLoopVariable(VarInfo varInfo) {
        if (varInfo.pc >= 0) {
            switch (Lua.GET_OPCODE(this.pi.prototype.code[varInfo.pc])) {
                case 32: 
                case 35: {
                    return true;
                }
            }
        }
        return false;
    }

    private boolean includePosteriorVarsCheckLoops(VarInfo varInfo) {
        boolean bl = false;
        block0: for (BasicBlock basicBlock : this.pi.blocklist) {
            int n;
            VarInfo varInfo2 = this.pi.vars[this.slot][basicBlock.pc1];
            if (varInfo2 == varInfo) {
                int n2;
                int n3 = n2 = basicBlock.next != null ? basicBlock.next.length : 0;
                for (n = 0; n < n2; ++n) {
                    BasicBlock basicBlock2 = basicBlock.next[n];
                    VarInfo varInfo3 = this.pi.vars[this.slot][basicBlock2.pc0];
                    if (varInfo3 == varInfo) continue;
                    bl |= this.includeVarAndPosteriorVars(varInfo3);
                    if (!varInfo3.isPhiVar()) continue;
                    this.includePriorVarsIgnoreLoops(varInfo3);
                }
                continue;
            }
            for (n = basicBlock.pc1 - 1; n >= basicBlock.pc0; --n) {
                if (this.pi.vars[this.slot][n] != varInfo) continue;
                bl |= this.includeVarAndPosteriorVars(this.pi.vars[this.slot][n + 1]);
                continue block0;
            }
        }
        return bl;
    }

    private void includePriorVarsIgnoreLoops(VarInfo varInfo) {
        block0: for (BasicBlock basicBlock : this.pi.blocklist) {
            int n;
            VarInfo varInfo2 = this.pi.vars[this.slot][basicBlock.pc0];
            if (varInfo2 == varInfo) {
                int n2;
                int n3 = n2 = basicBlock.prev != null ? basicBlock.prev.length : 0;
                for (n = 0; n < n2; ++n) {
                    BasicBlock basicBlock2 = basicBlock.prev[n];
                    VarInfo varInfo3 = this.pi.vars[this.slot][basicBlock2.pc1];
                    if (varInfo3 == varInfo) continue;
                    this.includeVarAndPosteriorVars(varInfo3);
                }
                continue;
            }
            for (n = basicBlock.pc0 + 1; n <= basicBlock.pc1; ++n) {
                if (this.pi.vars[this.slot][n] != varInfo) continue;
                this.includeVarAndPosteriorVars(this.pi.vars[this.slot][n - 1]);
                continue block0;
            }
        }
    }

    private void appendVar(VarInfo varInfo) {
        if (this.nvars == 0) {
            this.var = new VarInfo[1];
        } else if (this.nvars + 1 >= this.var.length) {
            VarInfo[] varInfoArray = this.var;
            this.var = new VarInfo[this.nvars * 2 + 1];
            System.arraycopy(varInfoArray, 0, this.var, 0, this.nvars);
        }
        this.var[this.nvars++] = varInfo;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.pi.name);
        for (int i = 0; i < this.nvars; ++i) {
            stringBuffer.append(i > 0 ? "," : " ");
            stringBuffer.append(String.valueOf(this.var[i]));
        }
        if (this.rw) {
            stringBuffer.append("(rw)");
        }
        return stringBuffer.toString();
    }

    private boolean testIsAllocUpvalue(VarInfo varInfo) {
        if (varInfo.pc < 0) {
            return true;
        }
        BasicBlock basicBlock = this.pi.blocks[varInfo.pc];
        if (varInfo.pc > basicBlock.pc0) {
            return this.pi.vars[this.slot][varInfo.pc - 1].upvalue != this;
        }
        if (basicBlock.prev == null) {
            varInfo = this.pi.params[this.slot];
            if (varInfo != null && varInfo.upvalue != this) {
                return true;
            }
        } else {
            int n = basicBlock.prev.length;
            for (int i = 0; i < n; ++i) {
                varInfo = this.pi.vars[this.slot][basicBlock.prev[i].pc1];
                if (varInfo == null || varInfo.upvalue == this) continue;
                return true;
            }
        }
        return false;
    }
}

