/*
 * Decompiled with CFR 0.152.
 */
package org.luaj.vm2.luajc;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import org.apache.bcel.generic.AASTORE;
import org.apache.bcel.generic.ALOAD;
import org.apache.bcel.generic.ANEWARRAY;
import org.apache.bcel.generic.ASTORE;
import org.apache.bcel.generic.ArrayType;
import org.apache.bcel.generic.BranchInstruction;
import org.apache.bcel.generic.ClassGen;
import org.apache.bcel.generic.CompoundInstruction;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.FieldGen;
import org.apache.bcel.generic.GOTO;
import org.apache.bcel.generic.IFEQ;
import org.apache.bcel.generic.IFNE;
import org.apache.bcel.generic.Instruction;
import org.apache.bcel.generic.InstructionConstants;
import org.apache.bcel.generic.InstructionFactory;
import org.apache.bcel.generic.InstructionHandle;
import org.apache.bcel.generic.InstructionList;
import org.apache.bcel.generic.LocalVariableGen;
import org.apache.bcel.generic.MethodGen;
import org.apache.bcel.generic.ObjectType;
import org.apache.bcel.generic.PUSH;
import org.apache.bcel.generic.Type;
import org.luaj.vm2.Buffer;
import org.luaj.vm2.Lua;
import org.luaj.vm2.LuaBoolean;
import org.luaj.vm2.LuaInteger;
import org.luaj.vm2.LuaNumber;
import org.luaj.vm2.LuaString;
import org.luaj.vm2.LuaTable;
import org.luaj.vm2.LuaValue;
import org.luaj.vm2.Prototype;
import org.luaj.vm2.Varargs;
import org.luaj.vm2.lib.OneArgFunction;
import org.luaj.vm2.lib.ThreeArgFunction;
import org.luaj.vm2.lib.TwoArgFunction;
import org.luaj.vm2.lib.VarArgFunction;
import org.luaj.vm2.lib.ZeroArgFunction;
import org.luaj.vm2.luajc.ProtoInfo;

public class JavaBuilder {
    private static final String STR_VARARGS = Varargs.class.getName();
    private static final String STR_LUAVALUE = LuaValue.class.getName();
    private static final String STR_LUASTRING = LuaString.class.getName();
    private static final String STR_LUAINTEGER = LuaInteger.class.getName();
    private static final String STR_LUANUMBER = LuaNumber.class.getName();
    private static final String STR_LUABOOLEAN = LuaBoolean.class.getName();
    private static final String STR_LUATABLE = LuaTable.class.getName();
    private static final String STR_BUFFER = Buffer.class.getName();
    private static final String STR_STRING = String.class.getName();
    private static final String STR_JSEPLATFORM = "org.luaj.vm2.lib.jse.JsePlatform";
    private static final ObjectType TYPE_VARARGS = new ObjectType(STR_VARARGS);
    private static final ObjectType TYPE_LUAVALUE = new ObjectType(STR_LUAVALUE);
    private static final ObjectType TYPE_LUASTRING = new ObjectType(STR_LUASTRING);
    private static final ObjectType TYPE_LUAINTEGER = new ObjectType(STR_LUAINTEGER);
    private static final ObjectType TYPE_LUANUMBER = new ObjectType(STR_LUANUMBER);
    private static final ObjectType TYPE_LUABOOLEAN = new ObjectType(STR_LUABOOLEAN);
    private static final ObjectType TYPE_LUATABLE = new ObjectType(STR_LUATABLE);
    private static final ObjectType TYPE_BUFFER = new ObjectType(STR_BUFFER);
    private static final ObjectType TYPE_STRING = new ObjectType(STR_STRING);
    private static final ArrayType TYPE_LOCALUPVALUE = new ArrayType((Type)TYPE_LUAVALUE, 1);
    private static final ArrayType TYPE_CHARARRAY = new ArrayType((Type)Type.CHAR, 1);
    private static final ArrayType TYPE_STRINGARRAY = new ArrayType((Type)TYPE_STRING, 1);
    private static final String STR_FUNCV = VarArgFunction.class.getName();
    private static final String STR_FUNC0 = ZeroArgFunction.class.getName();
    private static final String STR_FUNC1 = OneArgFunction.class.getName();
    private static final String STR_FUNC2 = TwoArgFunction.class.getName();
    private static final String STR_FUNC3 = ThreeArgFunction.class.getName();
    private static final Type[] ARG_TYPES_NONE = new Type[0];
    private static final Type[] ARG_TYPES_INT = new Type[]{Type.INT};
    private static final Type[] ARG_TYPES_DOUBLE = new Type[]{Type.DOUBLE};
    private static final Type[] ARG_TYPES_STRING = new Type[]{Type.STRING};
    private static final Type[] ARG_TYPES_CHARARRAY = new Type[]{TYPE_CHARARRAY};
    private static final Type[] ARG_TYPES_INT_LUAVALUE = new Type[]{Type.INT, TYPE_LUAVALUE};
    private static final Type[] ARG_TYPES_INT_VARARGS = new Type[]{Type.INT, TYPE_VARARGS};
    private static final Type[] ARG_TYPES_LUAVALUE_VARARGS = new Type[]{TYPE_LUAVALUE, TYPE_VARARGS};
    private static final Type[] ARG_TYPES_LUAVALUE_LUAVALUE_VARARGS = new Type[]{TYPE_LUAVALUE, TYPE_LUAVALUE, TYPE_VARARGS};
    private static final Type[] ARG_TYPES_LUAVALUEARRAY = new Type[]{new ArrayType((Type)TYPE_LUAVALUE, 1)};
    private static final Type[] ARG_TYPES_LUAVALUEARRAY_VARARGS = new Type[]{new ArrayType((Type)TYPE_LUAVALUE, 1), TYPE_VARARGS};
    private static final Type[] ARG_TYPES_LUAVALUE_LUAVALUE_LUAVALUE = new Type[]{TYPE_LUAVALUE, TYPE_LUAVALUE, TYPE_LUAVALUE};
    private static final Type[] ARG_TYPES_VARARGS = new Type[]{TYPE_VARARGS};
    private static final Type[] ARG_TYPES_LUAVALUE_LUAVALUE = new Type[]{TYPE_LUAVALUE, TYPE_LUAVALUE};
    private static final Type[] ARG_TYPES_INT_INT = new Type[]{Type.INT, Type.INT};
    private static final Type[] ARG_TYPES_LUAVALUE = new Type[]{TYPE_LUAVALUE};
    private static final Type[] ARG_TYPES_BUFFER = new Type[]{TYPE_BUFFER};
    private static final Type[] ARG_TYPES_STRINGARRAY = new Type[]{TYPE_STRINGARRAY};
    private static final Type[] ARG_TYPES_LUAVALUE_STRINGARRAY = new Type[]{TYPE_LUAVALUE, TYPE_STRINGARRAY};
    private static final String[] SUPER_NAME_N = new String[]{STR_FUNC0, STR_FUNC1, STR_FUNC2, STR_FUNC3, STR_FUNCV};
    private static final ObjectType[] RETURN_TYPE_N = new ObjectType[]{TYPE_LUAVALUE, TYPE_LUAVALUE, TYPE_LUAVALUE, TYPE_LUAVALUE, TYPE_VARARGS};
    private static final Type[][] ARG_TYPES_N = new Type[][]{ARG_TYPES_NONE, ARG_TYPES_LUAVALUE, ARG_TYPES_LUAVALUE_LUAVALUE, ARG_TYPES_LUAVALUE_LUAVALUE_LUAVALUE, ARG_TYPES_VARARGS};
    private static final String[][] ARG_NAMES_N = new String[][]{new String[0], {"arg"}, {"arg1", "arg2"}, {"arg1", "arg2", "arg3"}, {"args"}};
    private static final String[] METH_NAME_N = new String[]{"call", "call", "call", "call", "onInvoke"};
    private static final String PREFIX_CONSTANT = "k";
    private static final String PREFIX_UPVALUE = "u";
    private static final String PREFIX_PLAIN_SLOT = "s";
    private static final String PREFIX_UPVALUE_SLOT = "a";
    private static final String NAME_VARRESULT = "v";
    private final ProtoInfo pi;
    private final Prototype p;
    private final String classname;
    private final ClassGen cg;
    private final ConstantPoolGen cp;
    private final InstructionFactory factory;
    private final InstructionList init;
    private final InstructionList main;
    private final MethodGen mg;
    private int superclassType;
    private static int SUPERTYPE_VARARGS = 4;
    private final int[] targets;
    private final BranchInstruction[] branches;
    private final InstructionHandle[] branchDestHandles;
    private final InstructionHandle[] lastInstrHandles;
    private InstructionHandle beginningOfLuaInstruction;
    private LocalVariableGen varresult = null;
    private int prev_line = -1;
    private Map plainSlotVars = new HashMap();
    private Map upvalueSlotVars = new HashMap();
    private Map localVarGenBySlot = new HashMap();
    private Map constants = new HashMap();
    public static final int BRANCH_GOTO = 1;
    public static final int BRANCH_IFNE = 2;
    public static final int BRANCH_IFEQ = 3;

    public JavaBuilder(ProtoInfo protoInfo, String string, String string2) {
        int n;
        this.pi = protoInfo;
        this.p = protoInfo.prototype;
        this.classname = string;
        this.superclassType = this.p.numparams;
        if (this.p.is_vararg != 0 || this.superclassType >= SUPERTYPE_VARARGS) {
            this.superclassType = SUPERTYPE_VARARGS;
        }
        int n2 = this.p.code.length;
        for (n = 0; n < n2; ++n) {
            int n3 = this.p.code[n];
            int n4 = Lua.GET_OPCODE(n3);
            if (n4 != 30 && (n4 != 31 || Lua.GETARG_B(n3) >= 1 && Lua.GETARG_B(n3) <= 2)) continue;
            this.superclassType = SUPERTYPE_VARARGS;
            break;
        }
        this.cg = new ClassGen(string, SUPER_NAME_N[this.superclassType], string2, 33, null);
        this.cp = this.cg.getConstantPool();
        this.factory = new InstructionFactory(this.cg);
        this.init = new InstructionList();
        this.main = new InstructionList();
        for (n = 0; n < this.p.upvalues.length; ++n) {
            n2 = protoInfo.isReadWriteUpvalue(protoInfo.upvals[n]) ? 1 : 0;
            ArrayType arrayType = n2 != 0 ? TYPE_LOCALUPVALUE : TYPE_LUAVALUE;
            FieldGen fieldGen = new FieldGen(0, (Type)arrayType, JavaBuilder.upvalueName(n), this.cp);
            this.cg.addField(fieldGen.getField());
        }
        this.mg = new MethodGen(17, (Type)RETURN_TYPE_N[this.superclassType], ARG_TYPES_N[this.superclassType], ARG_NAMES_N[this.superclassType], METH_NAME_N[this.superclassType], STR_LUAVALUE, this.main, this.cp);
        this.initializeSlots();
        n = this.p.code.length;
        this.targets = new int[n];
        this.branches = new BranchInstruction[n];
        this.branchDestHandles = new InstructionHandle[n];
        this.lastInstrHandles = new InstructionHandle[n];
    }

    public void initializeSlots() {
        int n = 0;
        this.createUpvalues(-1, 0, this.p.maxstacksize);
        if (this.superclassType == SUPERTYPE_VARARGS) {
            for (n = 0; n < this.p.numparams; ++n) {
                if (!this.pi.isInitialValueUsed(n)) continue;
                this.append((Instruction)new ALOAD(1));
                this.append((CompoundInstruction)new PUSH(this.cp, n + 1));
                this.append((Instruction)this.factory.createInvoke(STR_VARARGS, "arg", (Type)TYPE_LUAVALUE, ARG_TYPES_INT, (short)182));
                this.storeLocal(-1, n);
            }
            this.append((Instruction)new ALOAD(1));
            this.append((CompoundInstruction)new PUSH(this.cp, 1 + this.p.numparams));
            this.append((Instruction)this.factory.createInvoke(STR_VARARGS, "subargs", (Type)TYPE_VARARGS, ARG_TYPES_INT, (short)182));
            this.append((Instruction)new ASTORE(1));
        } else {
            for (n = 0; n < this.p.numparams; ++n) {
                this.plainSlotVars.put(n, 1 + n);
                if (!this.pi.isUpvalueCreate(-1, n)) continue;
                this.append((Instruction)new ALOAD(1 + n));
                this.storeLocal(-1, n);
            }
        }
        while (n < this.p.maxstacksize) {
            if (this.pi.isInitialValueUsed(n)) {
                this.loadNil();
                this.storeLocal(-1, n);
            }
            ++n;
        }
    }

    public byte[] completeClass(boolean bl) {
        Object object;
        if (!this.init.isEmpty()) {
            object = new MethodGen(8, (Type)Type.VOID, ARG_TYPES_NONE, new String[0], "<clinit>", this.cg.getClassName(), this.init, this.cg.getConstantPool());
            this.init.append((Instruction)InstructionConstants.RETURN);
            object.setMaxStack();
            this.cg.addMethod(object.getMethod());
            this.init.dispose();
        }
        this.cg.addEmptyConstructor(1);
        this.resolveBranches();
        this.mg.setMaxStack();
        this.cg.addMethod(this.mg.getMethod());
        this.main.dispose();
        if (this.p.upvalues.length == 1 && this.superclassType == SUPERTYPE_VARARGS) {
            object = new MethodGen(17, (Type)Type.VOID, ARG_TYPES_LUAVALUE, new String[]{"env"}, "initupvalue1", STR_LUAVALUE, this.main, this.cp);
            boolean bl2 = this.pi.isReadWriteUpvalue(this.pi.upvals[0]);
            this.append((Instruction)InstructionConstants.THIS);
            this.append((Instruction)new ALOAD(1));
            if (bl2) {
                this.append((Instruction)this.factory.createInvoke(this.classname, "newupl", (Type)TYPE_LOCALUPVALUE, ARG_TYPES_LUAVALUE, (short)184));
                this.append((Instruction)this.factory.createFieldAccess(this.classname, JavaBuilder.upvalueName(0), (Type)TYPE_LOCALUPVALUE, (short)181));
            } else {
                this.append((Instruction)this.factory.createFieldAccess(this.classname, JavaBuilder.upvalueName(0), (Type)TYPE_LUAVALUE, (short)181));
            }
            this.append((Instruction)InstructionConstants.RETURN);
            object.setMaxStack();
            this.cg.addMethod(object.getMethod());
            this.main.dispose();
        }
        if (bl) {
            object = new MethodGen(9, (Type)Type.VOID, ARG_TYPES_STRINGARRAY, new String[]{"arg"}, "main", this.classname, this.main, this.cp);
            this.append((Instruction)this.factory.createNew(this.classname));
            this.append((Instruction)InstructionConstants.DUP);
            this.append((Instruction)this.factory.createInvoke(this.classname, "<init>", (Type)Type.VOID, ARG_TYPES_NONE, (short)183));
            this.append((Instruction)new ALOAD(0));
            this.append((Instruction)this.factory.createInvoke(STR_JSEPLATFORM, "luaMain", (Type)Type.VOID, ARG_TYPES_LUAVALUE_STRINGARRAY, (short)184));
            this.append((Instruction)InstructionConstants.RETURN);
            object.setMaxStack();
            this.cg.addMethod(object.getMethod());
            this.main.dispose();
        }
        try {
            object = new ByteArrayOutputStream();
            this.cg.getJavaClass().dump((OutputStream)object);
            return ((ByteArrayOutputStream)object).toByteArray();
        }
        catch (IOException iOException) {
            throw new RuntimeException("JavaClass.dump() threw " + iOException);
        }
    }

    public void dup() {
        this.append((Instruction)InstructionConstants.DUP);
    }

    public void pop() {
        this.append((Instruction)InstructionConstants.POP);
    }

    public void loadNil() {
        this.append((Instruction)this.factory.createFieldAccess(STR_LUAVALUE, "NIL", (Type)TYPE_LUAVALUE, (short)178));
    }

    public void loadNone() {
        this.append((Instruction)this.factory.createFieldAccess(STR_LUAVALUE, "NONE", (Type)TYPE_LUAVALUE, (short)178));
    }

    public void loadBoolean(boolean bl) {
        String string = bl ? "TRUE" : "FALSE";
        this.append((Instruction)this.factory.createFieldAccess(STR_LUAVALUE, string, (Type)TYPE_LUABOOLEAN, (short)178));
    }

    private int findSlot(int n, Map map, String string, Type type2) {
        Integer n2 = n;
        if (map.containsKey(n2)) {
            return (Integer)map.get(n2);
        }
        String string2 = string + n;
        LocalVariableGen localVariableGen = this.mg.addLocalVariable(string2, type2, null, null);
        int n3 = localVariableGen.getIndex();
        map.put(n2, n3);
        this.localVarGenBySlot.put(n2, localVariableGen);
        return n3;
    }

    private int findSlotIndex(int n, boolean bl) {
        return bl ? this.findSlot(n, this.upvalueSlotVars, PREFIX_UPVALUE_SLOT, (Type)TYPE_LOCALUPVALUE) : this.findSlot(n, this.plainSlotVars, PREFIX_PLAIN_SLOT, (Type)TYPE_LUAVALUE);
    }

    public void loadLocal(int n, int n2) {
        boolean bl = this.pi.isUpvalueRefer(n, n2);
        int n3 = this.findSlotIndex(n2, bl);
        this.append((Instruction)new ALOAD(n3));
        if (bl) {
            this.append((CompoundInstruction)new PUSH(this.cp, 0));
            this.append((Instruction)InstructionConstants.AALOAD);
        }
    }

    public void storeLocal(int n, int n2) {
        boolean bl = this.pi.isUpvalueAssign(n, n2);
        int n3 = this.findSlotIndex(n2, bl);
        if (bl) {
            boolean bl2 = this.pi.isUpvalueCreate(n, n2);
            if (bl2) {
                this.append((Instruction)this.factory.createInvoke(this.classname, "newupe", (Type)TYPE_LOCALUPVALUE, ARG_TYPES_NONE, (short)184));
                this.append((Instruction)InstructionConstants.DUP);
                this.append((Instruction)new ASTORE(n3));
            } else {
                this.append((Instruction)new ALOAD(n3));
            }
            this.append((Instruction)InstructionConstants.SWAP);
            this.append((CompoundInstruction)new PUSH(this.cp, 0));
            this.append((Instruction)InstructionConstants.SWAP);
            this.append((Instruction)InstructionConstants.AASTORE);
        } else {
            this.append((Instruction)new ASTORE(n3));
        }
    }

    public void createUpvalues(int n, int n2, int n3) {
        for (int i = 0; i < n3; ++i) {
            int n4 = n2 + i;
            boolean bl = this.pi.isUpvalueCreate(n, n4);
            if (!bl) continue;
            int n5 = this.findSlotIndex(n4, true);
            this.append((Instruction)this.factory.createInvoke(this.classname, "newupn", (Type)TYPE_LOCALUPVALUE, ARG_TYPES_NONE, (short)184));
            this.append((Instruction)new ASTORE(n5));
        }
    }

    public void convertToUpvalue(int n, int n2) {
        boolean bl = this.pi.isUpvalueAssign(n, n2);
        if (bl) {
            int n3 = this.findSlotIndex(n2, false);
            this.append((Instruction)new ALOAD(n3));
            this.append((Instruction)this.factory.createInvoke(this.classname, "newupl", (Type)TYPE_LOCALUPVALUE, ARG_TYPES_LUAVALUE, (short)184));
            int n4 = this.findSlotIndex(n2, true);
            this.append((Instruction)new ASTORE(n4));
        }
    }

    private static String upvalueName(int n) {
        return PREFIX_UPVALUE + n;
    }

    public void loadUpvalue(int n) {
        boolean bl = this.pi.isReadWriteUpvalue(this.pi.upvals[n]);
        this.append((Instruction)InstructionConstants.THIS);
        if (bl) {
            this.append((Instruction)this.factory.createFieldAccess(this.classname, JavaBuilder.upvalueName(n), (Type)TYPE_LOCALUPVALUE, (short)180));
            this.append((CompoundInstruction)new PUSH(this.cp, 0));
            this.append((Instruction)InstructionConstants.AALOAD);
        } else {
            this.append((Instruction)this.factory.createFieldAccess(this.classname, JavaBuilder.upvalueName(n), (Type)TYPE_LUAVALUE, (short)180));
        }
    }

    public void storeUpvalue(int n, int n2, int n3) {
        boolean bl = this.pi.isReadWriteUpvalue(this.pi.upvals[n2]);
        this.append((Instruction)InstructionConstants.THIS);
        if (bl) {
            this.append((Instruction)this.factory.createFieldAccess(this.classname, JavaBuilder.upvalueName(n2), (Type)TYPE_LOCALUPVALUE, (short)180));
            this.append((CompoundInstruction)new PUSH(this.cp, 0));
            this.loadLocal(n, n3);
            this.append((Instruction)InstructionConstants.AASTORE);
        } else {
            this.loadLocal(n, n3);
            this.append((Instruction)this.factory.createFieldAccess(this.classname, JavaBuilder.upvalueName(n2), (Type)TYPE_LUAVALUE, (short)181));
        }
    }

    public void newTable(int n, int n2) {
        this.append((CompoundInstruction)new PUSH(this.cp, n));
        this.append((CompoundInstruction)new PUSH(this.cp, n2));
        this.append((Instruction)this.factory.createInvoke(STR_LUAVALUE, "tableOf", (Type)TYPE_LUATABLE, ARG_TYPES_INT_INT, (short)184));
    }

    public void loadVarargs() {
        this.append((Instruction)new ALOAD(1));
    }

    public void loadVarargs(int n) {
        this.loadVarargs();
        this.arg(n);
    }

    public void arg(int n) {
        if (n == 1) {
            this.append((Instruction)this.factory.createInvoke(STR_VARARGS, "arg1", (Type)TYPE_LUAVALUE, ARG_TYPES_NONE, (short)182));
        } else {
            this.append((CompoundInstruction)new PUSH(this.cp, n));
            this.append((Instruction)this.factory.createInvoke(STR_VARARGS, "arg", (Type)TYPE_LUAVALUE, ARG_TYPES_INT, (short)182));
        }
    }

    private int getVarresultIndex() {
        if (this.varresult == null) {
            this.varresult = this.mg.addLocalVariable(NAME_VARRESULT, (Type)TYPE_VARARGS, null, null);
        }
        return this.varresult.getIndex();
    }

    public void loadVarresult() {
        this.append((Instruction)new ALOAD(this.getVarresultIndex()));
    }

    public void storeVarresult() {
        this.append((Instruction)new ASTORE(this.getVarresultIndex()));
    }

    public void subargs(int n) {
        this.append((CompoundInstruction)new PUSH(this.cp, n));
        this.append((Instruction)this.factory.createInvoke(STR_VARARGS, "subargs", (Type)TYPE_VARARGS, ARG_TYPES_INT, (short)182));
    }

    public void getTable() {
        this.append((Instruction)this.factory.createInvoke(STR_LUAVALUE, "get", (Type)TYPE_LUAVALUE, ARG_TYPES_LUAVALUE, (short)182));
    }

    public void setTable() {
        this.append((Instruction)this.factory.createInvoke(STR_LUAVALUE, "set", (Type)Type.VOID, ARG_TYPES_LUAVALUE_LUAVALUE, (short)182));
    }

    public void unaryop(int n) {
        String string;
        switch (n) {
            default: {
                string = "neg";
                break;
            }
            case 20: {
                string = "not";
                break;
            }
            case 21: {
                string = "len";
            }
        }
        this.append((Instruction)this.factory.createInvoke(STR_LUAVALUE, string, (Type)TYPE_LUAVALUE, Type.NO_ARGS, (short)182));
    }

    public void binaryop(int n) {
        String string;
        switch (n) {
            default: {
                string = "add";
                break;
            }
            case 14: {
                string = "sub";
                break;
            }
            case 15: {
                string = "mul";
                break;
            }
            case 16: {
                string = "div";
                break;
            }
            case 17: {
                string = "mod";
                break;
            }
            case 18: {
                string = "pow";
            }
        }
        this.append((Instruction)this.factory.createInvoke(STR_LUAVALUE, string, (Type)TYPE_LUAVALUE, ARG_TYPES_LUAVALUE, (short)182));
    }

    public void compareop(int n) {
        String string;
        switch (n) {
            default: {
                string = "eq_b";
                break;
            }
            case 25: {
                string = "lt_b";
                break;
            }
            case 26: {
                string = "lteq_b";
            }
        }
        this.append((Instruction)this.factory.createInvoke(STR_LUAVALUE, string, (Type)Type.BOOLEAN, ARG_TYPES_LUAVALUE, (short)182));
    }

    public void areturn() {
        this.append((Instruction)InstructionConstants.ARETURN);
    }

    public void toBoolean() {
        this.append((Instruction)this.factory.createInvoke(STR_LUAVALUE, "toboolean", (Type)Type.BOOLEAN, Type.NO_ARGS, (short)182));
    }

    public void tostring() {
        this.append((Instruction)this.factory.createInvoke(STR_BUFFER, "tostring", (Type)TYPE_LUASTRING, Type.NO_ARGS, (short)182));
    }

    public void isNil() {
        this.append((Instruction)this.factory.createInvoke(STR_LUAVALUE, "isnil", (Type)Type.BOOLEAN, Type.NO_ARGS, (short)182));
    }

    public void testForLoop() {
        this.append((Instruction)this.factory.createInvoke(STR_LUAVALUE, "testfor_b", (Type)Type.BOOLEAN, ARG_TYPES_LUAVALUE_LUAVALUE, (short)182));
    }

    public void loadArrayArgs(int n, int n2, int n3) {
        this.append((CompoundInstruction)new PUSH(this.cp, n3));
        this.append((Instruction)new ANEWARRAY(this.cp.addClass(STR_LUAVALUE)));
        for (int i = 0; i < n3; ++i) {
            this.append((Instruction)InstructionConstants.DUP);
            this.append((CompoundInstruction)new PUSH(this.cp, i));
            this.loadLocal(n, n2++);
            this.append((Instruction)new AASTORE());
        }
    }

    public void newVarargs(int n, int n2, int n3) {
        switch (n3) {
            case 0: {
                this.loadNone();
                break;
            }
            case 1: {
                this.loadLocal(n, n2);
                break;
            }
            case 2: {
                this.loadLocal(n, n2);
                this.loadLocal(n, n2 + 1);
                this.append((Instruction)this.factory.createInvoke(STR_LUAVALUE, "varargsOf", (Type)TYPE_VARARGS, ARG_TYPES_LUAVALUE_VARARGS, (short)184));
                break;
            }
            case 3: {
                this.loadLocal(n, n2);
                this.loadLocal(n, n2 + 1);
                this.loadLocal(n, n2 + 2);
                this.append((Instruction)this.factory.createInvoke(STR_LUAVALUE, "varargsOf", (Type)TYPE_VARARGS, ARG_TYPES_LUAVALUE_LUAVALUE_VARARGS, (short)184));
                break;
            }
            default: {
                this.loadArrayArgs(n, n2, n3);
                this.append((Instruction)this.factory.createInvoke(STR_LUAVALUE, "varargsOf", (Type)TYPE_VARARGS, ARG_TYPES_LUAVALUEARRAY, (short)184));
            }
        }
    }

    public void newVarargsVarresult(int n, int n2, int n3) {
        this.loadArrayArgs(n, n2, n3);
        this.loadVarresult();
        this.append((Instruction)this.factory.createInvoke(STR_LUAVALUE, "varargsOf", (Type)TYPE_VARARGS, ARG_TYPES_LUAVALUEARRAY_VARARGS, (short)184));
    }

    public void call(int n) {
        switch (n) {
            case 0: {
                this.append((Instruction)this.factory.createInvoke(STR_LUAVALUE, "call", (Type)TYPE_LUAVALUE, ARG_TYPES_NONE, (short)182));
                break;
            }
            case 1: {
                this.append((Instruction)this.factory.createInvoke(STR_LUAVALUE, "call", (Type)TYPE_LUAVALUE, ARG_TYPES_LUAVALUE, (short)182));
                break;
            }
            case 2: {
                this.append((Instruction)this.factory.createInvoke(STR_LUAVALUE, "call", (Type)TYPE_LUAVALUE, ARG_TYPES_LUAVALUE_LUAVALUE, (short)182));
                break;
            }
            case 3: {
                this.append((Instruction)this.factory.createInvoke(STR_LUAVALUE, "call", (Type)TYPE_LUAVALUE, ARG_TYPES_LUAVALUE_LUAVALUE_LUAVALUE, (short)182));
                break;
            }
            default: {
                throw new IllegalArgumentException("can't call with " + n + " args");
            }
        }
    }

    public void newTailcallVarargs() {
        this.append((Instruction)this.factory.createInvoke(STR_LUAVALUE, "tailcallOf", (Type)TYPE_VARARGS, ARG_TYPES_LUAVALUE_VARARGS, (short)184));
    }

    public void invoke(int n) {
        switch (n) {
            case -1: {
                this.append((Instruction)this.factory.createInvoke(STR_LUAVALUE, "invoke", (Type)TYPE_VARARGS, ARG_TYPES_VARARGS, (short)182));
                break;
            }
            case 0: {
                this.append((Instruction)this.factory.createInvoke(STR_LUAVALUE, "invoke", (Type)TYPE_VARARGS, ARG_TYPES_NONE, (short)182));
                break;
            }
            case 1: {
                this.append((Instruction)this.factory.createInvoke(STR_LUAVALUE, "invoke", (Type)TYPE_VARARGS, ARG_TYPES_VARARGS, (short)182));
                break;
            }
            case 2: {
                this.append((Instruction)this.factory.createInvoke(STR_LUAVALUE, "invoke", (Type)TYPE_VARARGS, ARG_TYPES_LUAVALUE_VARARGS, (short)182));
                break;
            }
            case 3: {
                this.append((Instruction)this.factory.createInvoke(STR_LUAVALUE, "invoke", (Type)TYPE_VARARGS, ARG_TYPES_LUAVALUE_LUAVALUE_VARARGS, (short)182));
                break;
            }
            default: {
                throw new IllegalArgumentException("can't invoke with " + n + " args");
            }
        }
    }

    public void closureCreate(String string) {
        this.append((Instruction)this.factory.createNew(new ObjectType(string)));
        this.append((Instruction)InstructionConstants.DUP);
        this.append((Instruction)this.factory.createInvoke(string, "<init>", (Type)Type.VOID, Type.NO_ARGS, (short)183));
    }

    public void closureInitUpvalueFromUpvalue(String string, int n, int n2) {
        boolean bl = this.pi.isReadWriteUpvalue(this.pi.upvals[n2]);
        ArrayType arrayType = bl ? TYPE_LOCALUPVALUE : TYPE_LUAVALUE;
        String string2 = JavaBuilder.upvalueName(n2);
        String string3 = JavaBuilder.upvalueName(n);
        this.append((Instruction)InstructionConstants.THIS);
        this.append((Instruction)this.factory.createFieldAccess(this.classname, string2, (Type)arrayType, (short)180));
        this.append((Instruction)this.factory.createFieldAccess(string, string3, (Type)arrayType, (short)181));
    }

    public void closureInitUpvalueFromLocal(String string, int n, int n2, int n3) {
        boolean bl = this.pi.isReadWriteUpvalue(this.pi.vars[n3][n2].upvalue);
        ArrayType arrayType = bl ? TYPE_LOCALUPVALUE : TYPE_LUAVALUE;
        String string2 = JavaBuilder.upvalueName(n);
        int n4 = this.findSlotIndex(n3, bl);
        this.append((Instruction)new ALOAD(n4));
        this.append((Instruction)this.factory.createFieldAccess(string, string2, (Type)arrayType, (short)181));
    }

    public void loadConstant(LuaValue luaValue) {
        switch (luaValue.type()) {
            case 0: {
                this.loadNil();
                break;
            }
            case 1: {
                this.loadBoolean(luaValue.toboolean());
                break;
            }
            case 3: 
            case 4: {
                String string = (String)this.constants.get(luaValue);
                if (string == null) {
                    string = luaValue.type() == 3 ? (luaValue.isinttype() ? this.createLuaIntegerField(luaValue.checkint()) : this.createLuaDoubleField(luaValue.checkdouble())) : this.createLuaStringField(luaValue.checkstring());
                    this.constants.put(luaValue, string);
                }
                this.append((Instruction)this.factory.createGetStatic(this.classname, string, (Type)TYPE_LUAVALUE));
                break;
            }
            default: {
                throw new IllegalArgumentException("bad constant type: " + luaValue.type());
            }
        }
    }

    private String createLuaIntegerField(int n) {
        String string = PREFIX_CONSTANT + this.constants.size();
        FieldGen fieldGen = new FieldGen(24, (Type)TYPE_LUAVALUE, string, this.cp);
        this.cg.addField(fieldGen.getField());
        this.init.append((CompoundInstruction)new PUSH(this.cp, n));
        this.init.append((Instruction)this.factory.createInvoke(STR_LUAVALUE, "valueOf", (Type)TYPE_LUAINTEGER, ARG_TYPES_INT, (short)184));
        this.init.append((Instruction)this.factory.createPutStatic(this.classname, string, (Type)TYPE_LUAVALUE));
        return string;
    }

    private String createLuaDoubleField(double d) {
        String string = PREFIX_CONSTANT + this.constants.size();
        FieldGen fieldGen = new FieldGen(24, (Type)TYPE_LUAVALUE, string, this.cp);
        this.cg.addField(fieldGen.getField());
        this.init.append((CompoundInstruction)new PUSH(this.cp, d));
        this.init.append((Instruction)this.factory.createInvoke(STR_LUAVALUE, "valueOf", (Type)TYPE_LUANUMBER, ARG_TYPES_DOUBLE, (short)184));
        this.init.append((Instruction)this.factory.createPutStatic(this.classname, string, (Type)TYPE_LUAVALUE));
        return string;
    }

    private String createLuaStringField(LuaString luaString) {
        String string = PREFIX_CONSTANT + this.constants.size();
        FieldGen fieldGen = new FieldGen(24, (Type)TYPE_LUAVALUE, string, this.cp);
        this.cg.addField(fieldGen.getField());
        LuaString luaString2 = luaString.checkstring();
        if (luaString2.isValidUtf8()) {
            this.init.append((CompoundInstruction)new PUSH(this.cp, luaString.tojstring()));
            this.init.append((Instruction)this.factory.createInvoke(STR_LUASTRING, "valueOf", (Type)TYPE_LUASTRING, ARG_TYPES_STRING, (short)184));
        } else {
            char[] cArray = new char[luaString2.m_length];
            for (int i = 0; i < luaString2.m_length; ++i) {
                cArray[i] = (char)(0xFF & luaString2.m_bytes[luaString2.m_offset + i]);
            }
            this.init.append((CompoundInstruction)new PUSH(this.cp, new String(cArray)));
            this.init.append((Instruction)this.factory.createInvoke(STR_STRING, "toCharArray", (Type)TYPE_CHARARRAY, Type.NO_ARGS, (short)182));
            this.init.append((Instruction)this.factory.createInvoke(STR_LUASTRING, "valueOf", (Type)TYPE_LUASTRING, ARG_TYPES_CHARARRAY, (short)184));
        }
        this.init.append((Instruction)this.factory.createPutStatic(this.classname, string, (Type)TYPE_LUAVALUE));
        return string;
    }

    public void addBranch(int n, int n2, int n3) {
        switch (n2) {
            default: {
                this.branches[n] = new GOTO(null);
                break;
            }
            case 2: {
                this.branches[n] = new IFNE(null);
                break;
            }
            case 3: {
                this.branches[n] = new IFEQ(null);
            }
        }
        this.targets[n] = n3;
        this.append(this.branches[n]);
    }

    private void append(Instruction instruction) {
        this.conditionalSetBeginningOfLua(this.main.append(instruction));
    }

    private void append(CompoundInstruction compoundInstruction) {
        this.conditionalSetBeginningOfLua(this.main.append(compoundInstruction));
    }

    private void append(BranchInstruction branchInstruction) {
        this.conditionalSetBeginningOfLua((InstructionHandle)this.main.append(branchInstruction));
    }

    private void conditionalSetBeginningOfLua(InstructionHandle instructionHandle) {
        if (this.beginningOfLuaInstruction == null) {
            this.beginningOfLuaInstruction = instructionHandle;
        }
    }

    public void onEndOfLuaInstruction(int n, int n2) {
        this.branchDestHandles[n] = this.beginningOfLuaInstruction;
        this.lastInstrHandles[n] = this.main.getEnd();
        if (n2 != this.prev_line) {
            this.prev_line = n2;
            this.mg.addLineNumber(this.beginningOfLuaInstruction, this.prev_line);
        }
        this.beginningOfLuaInstruction = null;
    }

    public void setVarStartEnd(int n, int n2, int n3, String string) {
        Integer n4 = n;
        if (this.localVarGenBySlot.containsKey(n4)) {
            string = string.replaceAll("[^a-zA-Z0-9]", "_");
            LocalVariableGen localVariableGen = (LocalVariableGen)this.localVarGenBySlot.get(n4);
            localVariableGen.setEnd(this.lastInstrHandles[n3 - 1]);
            if (n2 > 1) {
                localVariableGen.setStart(this.lastInstrHandles[n2 - 2]);
            }
            localVariableGen.setName(string);
        }
    }

    private void resolveBranches() {
        int n = this.p.code.length;
        for (int i = 0; i < n; ++i) {
            int n2;
            if (this.branches[i] == null) continue;
            for (n2 = this.targets[i]; n2 < this.branchDestHandles.length && this.branchDestHandles[n2] == null; ++n2) {
            }
            if (n2 >= this.branchDestHandles.length) {
                throw new IllegalArgumentException("no target at or after " + this.targets[i] + " op=" + Lua.GET_OPCODE(this.p.code[this.targets[i]]));
            }
            this.branches[i].setTarget(this.branchDestHandles[n2]);
        }
    }

    public void setlistStack(int n, int n2, int n3, int n4) {
        for (int i = 0; i < n4; ++i) {
            this.dup();
            this.append((CompoundInstruction)new PUSH(this.cp, n3 + i));
            this.loadLocal(n, n2 + i);
            this.append((Instruction)this.factory.createInvoke(STR_LUAVALUE, "rawset", (Type)Type.VOID, ARG_TYPES_INT_LUAVALUE, (short)182));
        }
    }

    public void setlistVarargs(int n, int n2) {
        this.append((CompoundInstruction)new PUSH(this.cp, n));
        this.loadVarresult();
        this.append((Instruction)this.factory.createInvoke(STR_LUAVALUE, "rawsetlist", (Type)Type.VOID, ARG_TYPES_INT_VARARGS, (short)182));
    }

    public void concatvalue() {
        this.append((Instruction)this.factory.createInvoke(STR_LUAVALUE, "concat", (Type)TYPE_LUAVALUE, ARG_TYPES_LUAVALUE, (short)182));
    }

    public void concatbuffer() {
        this.append((Instruction)this.factory.createInvoke(STR_LUAVALUE, "concat", (Type)TYPE_BUFFER, ARG_TYPES_BUFFER, (short)182));
    }

    public void tobuffer() {
        this.append((Instruction)this.factory.createInvoke(STR_LUAVALUE, "buffer", (Type)TYPE_BUFFER, Type.NO_ARGS, (short)182));
    }

    public void tovalue() {
        this.append((Instruction)this.factory.createInvoke(STR_BUFFER, "value", (Type)TYPE_LUAVALUE, Type.NO_ARGS, (short)182));
    }

    public void closeUpvalue(int n, int n2) {
    }
}

