/*
 * Decompiled with CFR 0.152.
 */
package org.luaj.vm2.lib;

import org.luaj.vm2.LuaString;
import org.luaj.vm2.LuaTable;
import org.luaj.vm2.LuaValue;
import org.luaj.vm2.Varargs;
import org.luaj.vm2.lib.LibFunction;
import org.luaj.vm2.lib.OneArgFunction;
import org.luaj.vm2.lib.TwoArgFunction;
import org.luaj.vm2.lib.VarArgFunction;

public class TableLib
extends TwoArgFunction {
    public LuaValue call(LuaValue luaValue, LuaValue luaValue2) {
        LuaTable luaTable = new LuaTable();
        luaTable.set("concat", (LuaValue)new concat());
        luaTable.set("insert", (LuaValue)new insert());
        luaTable.set("pack", (LuaValue)new pack());
        luaTable.set("remove", (LuaValue)new remove());
        luaTable.set("getn", (LuaValue)new getn());
        luaTable.set("maxn", (LuaValue)new maxn());
        luaTable.set("sort", (LuaValue)new sort());
        luaTable.set("unpack", (LuaValue)new unpack());
        luaValue2.set("table", (LuaValue)luaTable);
        luaValue2.get("package").get("loaded").set("table", (LuaValue)luaTable);
        return NIL;
    }

    static class unpack
    extends VarArgFunction {
        unpack() {
        }

        public Varargs invoke(Varargs varargs) {
            LuaTable luaTable = varargs.checktable(1);
            LuaValue luaValue = varargs.arg(2);
            int n = luaValue.isnil() ? 1 : luaValue.toint();
            LuaValue luaValue2 = varargs.arg(3);
            int n2 = luaValue2.isnil() ? luaTable.maxn() : luaValue2.toint();
            switch (varargs.narg()) {
                case 1: {
                    return luaTable.unpack();
                }
                case 2: {
                    return luaTable.unpack(n);
                }
            }
            return luaTable.unpack(n, n2);
        }
    }

    static class sort
    extends TwoArgFunction {
        sort() {
        }

        public LuaValue call(LuaValue luaValue, LuaValue luaValue2) {
            luaValue.checktable().sort(luaValue2.isnil() ? NIL : luaValue2.checkfunction());
            return NONE;
        }
    }

    static class remove
    extends TableLibFunction {
        remove() {
        }

        public LuaValue call(LuaValue luaValue) {
            return luaValue.checktable().remove(0);
        }

        public LuaValue call(LuaValue luaValue, LuaValue luaValue2) {
            return luaValue.checktable().remove(luaValue2.checkint());
        }
    }

    static class pack
    extends VarArgFunction {
        pack() {
        }

        public Varargs invoke(Varargs varargs) {
            LuaTable luaTable = pack.tableOf(varargs, 1);
            luaTable.set("n", varargs.narg());
            return luaTable;
        }
    }

    static class maxn
    extends OneArgFunction {
        maxn() {
        }

        public LuaValue call(LuaValue luaValue) {
            return luaValue.checktable().len();
        }
    }

    static class getn
    extends OneArgFunction {
        getn() {
        }

        public LuaValue call(LuaValue luaValue) {
            return luaValue.checktable().getn();
        }
    }

    static class insert
    extends TableLibFunction {
        insert() {
        }

        public LuaValue call(LuaValue luaValue) {
            return insert.argerror(2, "value expected");
        }

        public LuaValue call(LuaValue luaValue, LuaValue luaValue2) {
            luaValue.checktable().insert(luaValue.length() + 1, luaValue2);
            return NONE;
        }

        public LuaValue call(LuaValue luaValue, LuaValue luaValue2, LuaValue luaValue3) {
            luaValue.checktable().insert(luaValue2.checkint(), luaValue3);
            return NONE;
        }
    }

    static class concat
    extends TableLibFunction {
        concat() {
        }

        public LuaValue call(LuaValue luaValue) {
            return luaValue.checktable().concat(EMPTYSTRING, 1, luaValue.length());
        }

        public LuaValue call(LuaValue luaValue, LuaValue luaValue2) {
            return luaValue.checktable().concat(concat.Sep(luaValue2), 1, luaValue.length());
        }

        public LuaValue call(LuaValue luaValue, LuaValue luaValue2, LuaValue luaValue3) {
            return luaValue.checktable().concat(concat.Sep(luaValue2), concat.I(luaValue3), luaValue.length());
        }

        public LuaValue call(LuaValue luaValue, LuaValue luaValue2, LuaValue luaValue3, LuaValue luaValue4) {
            int n = luaValue4.isnil() ? luaValue.length() : luaValue4.checkint();
            return luaValue.checktable().concat(concat.Sep(luaValue2), concat.I(luaValue3), n);
        }

        private static LuaString Sep(LuaValue luaValue) {
            return luaValue.isnil() ? EMPTYSTRING : luaValue.checkstring();
        }

        private static int I(LuaValue luaValue) {
            return luaValue.isnil() ? 1 : luaValue.checkint();
        }
    }

    static class TableLibFunction
    extends LibFunction {
        TableLibFunction() {
        }

        public LuaValue call() {
            return TableLibFunction.argerror(1, "table expected, got no value");
        }
    }
}

