/*
 * Decompiled with CFR 0.152.
 */
package org.luaj.vm2.lib;

import java.io.IOException;
import java.io.InputStream;
import org.luaj.vm2.Globals;
import org.luaj.vm2.LuaError;
import org.luaj.vm2.LuaString;
import org.luaj.vm2.LuaTable;
import org.luaj.vm2.LuaValue;
import org.luaj.vm2.Varargs;
import org.luaj.vm2.lib.LibFunction;
import org.luaj.vm2.lib.ResourceFinder;
import org.luaj.vm2.lib.TwoArgFunction;
import org.luaj.vm2.lib.VarArgFunction;

public class BaseLib
extends TwoArgFunction
implements ResourceFinder {
    Globals globals;

    public LuaValue call(LuaValue luaValue, LuaValue luaValue2) {
        this.globals = luaValue2.checkglobals();
        this.globals.FINDER = this;
        this.globals.baselib = this;
        luaValue2.set("_G", luaValue2);
        luaValue2.set("_VERSION", "Luaj-jse 3.0-beta2");
        luaValue2.set("assert", (LuaValue)new _assert());
        luaValue2.set("collectgarbage", (LuaValue)new collectgarbage());
        luaValue2.set("dofile", (LuaValue)new dofile());
        luaValue2.set("error", (LuaValue)new error());
        luaValue2.set("getmetatable", (LuaValue)new getmetatable());
        luaValue2.set("load", (LuaValue)new load());
        luaValue2.set("loadfile", (LuaValue)new loadfile());
        luaValue2.set("pcall", (LuaValue)new pcall());
        luaValue2.set("print", (LuaValue)new print(this));
        luaValue2.set("rawequal", (LuaValue)new rawequal());
        luaValue2.set("rawget", (LuaValue)new rawget());
        luaValue2.set("rawlen", (LuaValue)new rawlen());
        luaValue2.set("rawset", (LuaValue)new rawset());
        luaValue2.set("select", (LuaValue)new select());
        luaValue2.set("setmetatable", (LuaValue)new setmetatable());
        luaValue2.set("tonumber", (LuaValue)new tonumber());
        luaValue2.set("tostring", (LuaValue)new tostring());
        luaValue2.set("type", (LuaValue)new type());
        luaValue2.set("xpcall", (LuaValue)new xpcall());
        next next2 = new next();
        luaValue2.set("next", (LuaValue)next2);
        luaValue2.set("pairs", (LuaValue)new pairs(next2));
        luaValue2.set("ipairs", (LuaValue)new ipairs());
        return luaValue2;
    }

    public InputStream findResource(String string) {
        return this.getClass().getResourceAsStream(string.startsWith("/") ? string : "/" + string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Varargs loadFile(String string, String string2, LuaValue luaValue) {
        InputStream inputStream = this.globals.FINDER.findResource(string);
        if (inputStream == null) {
            return BaseLib.varargsOf(NIL, (Varargs)BaseLib.valueOf("cannot open " + string + ": No such file or directory"));
        }
        try {
            Varargs varargs = this.loadStream(inputStream, "@" + string, string2, luaValue);
            return varargs;
        }
        finally {
            try {
                inputStream.close();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public Varargs loadStream(InputStream inputStream, String string, String string2, LuaValue luaValue) {
        try {
            if (inputStream == null) {
                return BaseLib.varargsOf(NIL, (Varargs)BaseLib.valueOf("not found: " + string));
            }
            return this.globals.load(inputStream, string, string2, luaValue);
        }
        catch (Exception exception) {
            return BaseLib.varargsOf(NIL, (Varargs)BaseLib.valueOf(exception.getMessage()));
        }
    }

    private static class StringInputStream
    extends InputStream {
        final LuaValue func;
        byte[] bytes;
        int offset;
        int remaining = 0;

        StringInputStream(LuaValue luaValue) {
            this.func = luaValue;
        }

        public int read() throws IOException {
            if (this.remaining <= 0) {
                LuaValue luaValue = this.func.call();
                if (luaValue.isnil()) {
                    return -1;
                }
                LuaString luaString = luaValue.strvalue();
                this.bytes = luaString.m_bytes;
                this.offset = luaString.m_offset;
                this.remaining = luaString.m_length;
                if (this.remaining <= 0) {
                    return -1;
                }
            }
            --this.remaining;
            return this.bytes[this.offset++];
        }
    }

    static final class inext
    extends VarArgFunction {
        inext() {
        }

        public Varargs invoke(Varargs varargs) {
            return varargs.checktable(1).inext(varargs.arg(2));
        }
    }

    static final class next
    extends VarArgFunction {
        next() {
        }

        public Varargs invoke(Varargs varargs) {
            return varargs.checktable(1).next(varargs.arg(2));
        }
    }

    static final class ipairs
    extends VarArgFunction {
        inext inext = new inext();

        ipairs() {
        }

        public Varargs invoke(Varargs varargs) {
            return ipairs.varargsOf(this.inext, varargs.checktable(1), ZERO);
        }
    }

    static final class pairs
    extends VarArgFunction {
        final next next;

        pairs(next next2) {
            this.next = next2;
        }

        public Varargs invoke(Varargs varargs) {
            return pairs.varargsOf(this.next, varargs.checktable(1), NIL);
        }
    }

    final class xpcall
    extends VarArgFunction {
        xpcall() {
        }

        /*
         * Exception decompiling
         */
        public Varargs invoke(Varargs var1_1) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }
    }

    static final class type
    extends LibFunction {
        type() {
        }

        public LuaValue call(LuaValue luaValue) {
            return type.valueOf(luaValue.typename());
        }
    }

    static final class tostring
    extends LibFunction {
        tostring() {
        }

        public LuaValue call(LuaValue luaValue) {
            LuaValue luaValue2 = luaValue.metatag(TOSTRING);
            if (!luaValue2.isnil()) {
                return luaValue2.call(luaValue);
            }
            LuaValue luaValue3 = luaValue.tostring();
            if (!luaValue3.isnil()) {
                return luaValue3;
            }
            return tostring.valueOf(luaValue.tojstring());
        }
    }

    static final class tonumber
    extends LibFunction {
        tonumber() {
        }

        public LuaValue call(LuaValue luaValue) {
            return luaValue.tonumber();
        }

        public LuaValue call(LuaValue luaValue, LuaValue luaValue2) {
            int n = luaValue2.checkint();
            if (luaValue2.isnil() || n == 10) {
                return luaValue.tonumber();
            }
            if (n < 2 || n > 36) {
                tonumber.argerror(2, "base out of range");
            }
            return luaValue.checkstring().tonumber(n);
        }
    }

    static final class setmetatable
    extends LibFunction {
        setmetatable() {
        }

        public LuaValue call(LuaValue luaValue) {
            return setmetatable.argerror(2, "value");
        }

        public LuaValue call(LuaValue luaValue, LuaValue luaValue2) {
            LuaValue luaValue3 = luaValue.getmetatable();
            if (luaValue3 != null && !luaValue3.rawget(METATABLE).isnil()) {
                setmetatable.error("cannot change a protected metatable");
            }
            return luaValue.setmetatable(luaValue2.isnil() ? null : luaValue2.checktable());
        }
    }

    static final class select
    extends VarArgFunction {
        select() {
        }

        public Varargs invoke(Varargs varargs) {
            int n = varargs.narg() - 1;
            if (varargs.arg1().equals(select.valueOf("#"))) {
                return select.valueOf(n);
            }
            int n2 = varargs.checkint(1);
            if (n2 == 0 || n2 < -n) {
                select.argerror(1, "index out of range");
            }
            return varargs.subargs(n2 < 0 ? n + n2 + 2 : n2 + 1);
        }
    }

    static final class rawset
    extends LibFunction {
        rawset() {
        }

        public LuaValue call(LuaValue luaValue) {
            return rawset.argerror(2, "value");
        }

        public LuaValue call(LuaValue luaValue, LuaValue luaValue2) {
            return rawset.argerror(3, "value");
        }

        public LuaValue call(LuaValue luaValue, LuaValue luaValue2, LuaValue luaValue3) {
            LuaTable luaTable = luaValue.checktable();
            luaTable.rawset(luaValue2.checknotnil(), luaValue3);
            return luaTable;
        }
    }

    static final class rawlen
    extends LibFunction {
        rawlen() {
        }

        public LuaValue call(LuaValue luaValue) {
            return rawlen.valueOf(luaValue.rawlen());
        }
    }

    static final class rawget
    extends LibFunction {
        rawget() {
        }

        public LuaValue call() {
            return rawget.argerror(1, "value");
        }

        public LuaValue call(LuaValue luaValue) {
            return rawget.argerror(2, "value");
        }

        public LuaValue call(LuaValue luaValue, LuaValue luaValue2) {
            return luaValue.checktable().rawget(luaValue2);
        }
    }

    static final class rawequal
    extends LibFunction {
        rawequal() {
        }

        public LuaValue call() {
            return rawequal.argerror(1, "value");
        }

        public LuaValue call(LuaValue luaValue) {
            return rawequal.argerror(2, "value");
        }

        public LuaValue call(LuaValue luaValue, LuaValue luaValue2) {
            return rawequal.valueOf(luaValue.raweq(luaValue2));
        }
    }

    final class print
    extends VarArgFunction {
        final BaseLib baselib;

        print(BaseLib baseLib2) {
            this.baselib = baseLib2;
        }

        public Varargs invoke(Varargs varargs) {
            LuaValue luaValue = BaseLib.this.globals.get("tostring");
            int n = varargs.narg();
            for (int i = 1; i <= n; ++i) {
                if (i > 1) {
                    BaseLib.this.globals.STDOUT.print('\t');
                }
                LuaString luaString = luaValue.call(varargs.arg(i)).strvalue();
                BaseLib.this.globals.STDOUT.print(luaString.tojstring());
            }
            BaseLib.this.globals.STDOUT.println();
            return NONE;
        }
    }

    final class pcall
    extends VarArgFunction {
        pcall() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Varargs invoke(Varargs varargs) {
            LuaValue luaValue = varargs.checkvalue(1);
            if (BaseLib.this.globals != null && BaseLib.this.globals.debuglib != null) {
                BaseLib.this.globals.debuglib.onCall(this);
            }
            try {
                Varargs varargs2 = pcall.varargsOf(TRUE, luaValue.invoke(varargs.subargs(2)));
                return varargs2;
            }
            catch (LuaError luaError) {
                String string = luaError.getMessage();
                Varargs varargs3 = pcall.varargsOf(FALSE, (Varargs)(string != null ? pcall.valueOf(string) : NIL));
                return varargs3;
            }
            catch (Exception exception) {
                String string = exception.getMessage();
                Varargs varargs4 = pcall.varargsOf(FALSE, (Varargs)pcall.valueOf(string != null ? string : exception.toString()));
                return varargs4;
            }
            finally {
                if (BaseLib.this.globals != null && BaseLib.this.globals.debuglib != null) {
                    BaseLib.this.globals.debuglib.onReturn();
                }
            }
        }
    }

    final class loadfile
    extends VarArgFunction {
        loadfile() {
        }

        public Varargs invoke(Varargs varargs) {
            varargs.argcheck(varargs.isstring(1) || varargs.isnil(1), 1, "filename must be string or nil");
            String string = varargs.isstring(1) ? varargs.tojstring(1) : null;
            String string2 = varargs.optjstring(2, "bt");
            LuaValue luaValue = varargs.optvalue(3, BaseLib.this.globals);
            return string == null ? BaseLib.this.loadStream(BaseLib.this.globals.STDIN, "=stdin", string2, luaValue) : BaseLib.this.loadFile(string, string2, luaValue);
        }
    }

    final class load
    extends VarArgFunction {
        load() {
        }

        public Varargs invoke(Varargs varargs) {
            LuaValue luaValue = varargs.arg1();
            varargs.argcheck(luaValue.isstring() || luaValue.isfunction(), 1, "ld must be string or function");
            String string = varargs.optjstring(2, luaValue.isstring() ? luaValue.tojstring() : "=(load)");
            String string2 = varargs.optjstring(3, "bt");
            LuaValue luaValue2 = varargs.optvalue(4, BaseLib.this.globals);
            return BaseLib.this.loadStream(luaValue.isstring() ? luaValue.strvalue().toInputStream() : new StringInputStream(luaValue.checkfunction()), string, string2, luaValue2);
        }
    }

    static final class getmetatable
    extends LibFunction {
        getmetatable() {
        }

        public LuaValue call() {
            return getmetatable.argerror(1, "value");
        }

        public LuaValue call(LuaValue luaValue) {
            LuaValue luaValue2 = luaValue.getmetatable();
            return luaValue2 != null ? luaValue2.rawget(METATABLE).optvalue(luaValue2) : NIL;
        }
    }

    static final class error
    extends TwoArgFunction {
        error() {
        }

        public LuaValue call(LuaValue luaValue, LuaValue luaValue2) {
            throw new LuaError(luaValue.isnil() ? null : luaValue.tojstring(), luaValue2.optint(1));
        }
    }

    final class dofile
    extends VarArgFunction {
        dofile() {
        }

        public Varargs invoke(Varargs varargs) {
            varargs.argcheck(varargs.isstring(1) || varargs.isnil(1), 1, "filename must be string or nil");
            String string = varargs.isstring(1) ? varargs.tojstring(1) : null;
            Varargs varargs2 = string == null ? BaseLib.this.loadStream(BaseLib.this.globals.STDIN, "=stdin", "bt", BaseLib.this.globals) : BaseLib.this.loadFile(varargs.checkjstring(1), "bt", BaseLib.this.globals);
            return varargs2.isnil(1) ? dofile.error(varargs2.tojstring(2)) : varargs2.arg1().invoke();
        }
    }

    static final class collectgarbage
    extends VarArgFunction {
        collectgarbage() {
        }

        public Varargs invoke(Varargs varargs) {
            String string = varargs.checkjstring(1);
            if ("collect".equals(string)) {
                System.gc();
                return ZERO;
            }
            if ("count".equals(string)) {
                Runtime runtime = Runtime.getRuntime();
                long l = runtime.totalMemory() - runtime.freeMemory();
                return collectgarbage.varargsOf(collectgarbage.valueOf((double)l / 1024.0), (Varargs)collectgarbage.valueOf(l % 1024L));
            }
            if ("step".equals(string)) {
                System.gc();
                return LuaValue.TRUE;
            }
            this.argerror("gc op");
            return NIL;
        }
    }

    static final class _assert
    extends VarArgFunction {
        _assert() {
        }

        public Varargs invoke(Varargs varargs) {
            if (!varargs.arg1().toboolean()) {
                _assert.error(varargs.narg() > 1 ? varargs.optjstring(2, "assertion failed!") : "assertion failed!");
            }
            return varargs;
        }
    }
}

