/*
 * Decompiled with CFR 0.152.
 */
package org.luaj.vm2;

import java.io.ByteArrayInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.nio.charset.Charset;
import org.luaj.vm2.Buffer;
import org.luaj.vm2.LuaDouble;
import org.luaj.vm2.LuaInteger;
import org.luaj.vm2.LuaNumber;
import org.luaj.vm2.LuaValue;
import org.luaj.vm2.lib.MathLib;
import org.luaj.vm2.lib.StringLib;

public class LuaString
extends LuaValue {
    public static final int RECENT_STRINGS_CACHE_SIZE = 128;
    public static final int RECENT_STRINGS_MAX_LENGTH = 32;
    public static LuaValue s_metatable;
    public final byte[] m_bytes;
    public final int m_offset;
    public final int m_length;
    private static final Utf16_char lhs_tmp;
    private static final Utf16_char rhs_tmp;

    public static LuaString valueOf(String string) {
        char[] cArray = string.toCharArray();
        byte[] byArray = new byte[LuaString.lengthAsUtf8(cArray)];
        LuaString.encodeToUtf8(cArray, cArray.length, byArray, 0);
        return LuaString.valueOf(byArray, 0, byArray.length);
    }

    public static LuaString valueOf(byte[] byArray, int n, int n2) {
        if (byArray.length < 32) {
            LuaString luaString = new LuaString(byArray, n, n2);
            return Cache.instance.get(luaString);
        }
        if (n2 >= byArray.length / 2) {
            return new LuaString(byArray, n, n2);
        }
        byte[] byArray2 = new byte[n2];
        System.arraycopy(byArray, n, byArray2, 0, n2);
        return LuaString.valueOf(byArray2, 0, n2);
    }

    public static LuaString valueOf(char[] cArray) {
        return LuaString.valueOf(cArray, 0, cArray.length);
    }

    public static LuaString valueOf(char[] cArray, int n, int n2) {
        int n3;
        int n4;
        int n5 = 0;
        for (int i = 0; i < n2; ++i) {
            n4 = LuaString.Utf16_Len_by_char(cArray[i + n]);
            if (n4 == 4) {
                ++i;
            }
            n5 += n4;
        }
        byte[] byArray = new byte[n5];
        n4 = 0;
        for (int i = 0; i < n2; i += n3 == 4 ? 2 : 1) {
            char c = cArray[i + n];
            n3 = LuaString.Utf16_Encode_char(c, cArray, i + n, byArray, n4);
            n4 += n3;
        }
        return LuaString.valueOf(byArray, 0, n5);
    }

    public static LuaString valueOf(byte[] byArray) {
        return LuaString.valueOf(byArray, 0, byArray.length);
    }

    private LuaString(byte[] byArray, int n, int n2) {
        this.m_bytes = byArray;
        this.m_offset = n;
        this.m_length = n2;
    }

    public boolean isstring() {
        return true;
    }

    public LuaValue getmetatable() {
        return s_metatable;
    }

    public int type() {
        return 4;
    }

    public String typename() {
        return "string";
    }

    public String tojstring() {
        return LuaString.decodeAsUtf8(this.m_bytes, this.m_offset, this.m_length);
    }

    public LuaValue get(LuaValue luaValue) {
        return s_metatable != null ? LuaString.gettable(this, luaValue) : StringLib.instance.get(luaValue);
    }

    public LuaValue neg() {
        double d = this.scannumber();
        return Double.isNaN(d) ? super.neg() : LuaString.valueOf(-d);
    }

    public LuaValue add(LuaValue luaValue) {
        double d = this.scannumber();
        return Double.isNaN(d) ? this.arithmt(ADD, luaValue) : luaValue.add(d);
    }

    public LuaValue add(double d) {
        return LuaString.valueOf(this.checkarith() + d);
    }

    public LuaValue add(int n) {
        return LuaString.valueOf(this.checkarith() + (double)n);
    }

    public LuaValue sub(LuaValue luaValue) {
        double d = this.scannumber();
        return Double.isNaN(d) ? this.arithmt(SUB, luaValue) : luaValue.subFrom(d);
    }

    public LuaValue sub(double d) {
        return LuaString.valueOf(this.checkarith() - d);
    }

    public LuaValue sub(int n) {
        return LuaString.valueOf(this.checkarith() - (double)n);
    }

    public LuaValue subFrom(double d) {
        return LuaString.valueOf(d - this.checkarith());
    }

    public LuaValue mul(LuaValue luaValue) {
        double d = this.scannumber();
        return Double.isNaN(d) ? this.arithmt(MUL, luaValue) : luaValue.mul(d);
    }

    public LuaValue mul(double d) {
        return LuaString.valueOf(this.checkarith() * d);
    }

    public LuaValue mul(int n) {
        return LuaString.valueOf(this.checkarith() * (double)n);
    }

    public LuaValue pow(LuaValue luaValue) {
        double d = this.scannumber();
        return Double.isNaN(d) ? this.arithmt(POW, luaValue) : luaValue.powWith(d);
    }

    public LuaValue pow(double d) {
        return MathLib.dpow(this.checkarith(), d);
    }

    public LuaValue pow(int n) {
        return MathLib.dpow(this.checkarith(), n);
    }

    public LuaValue powWith(double d) {
        return MathLib.dpow(d, this.checkarith());
    }

    public LuaValue powWith(int n) {
        return MathLib.dpow(n, this.checkarith());
    }

    public LuaValue div(LuaValue luaValue) {
        double d = this.scannumber();
        return Double.isNaN(d) ? this.arithmt(DIV, luaValue) : luaValue.divInto(d);
    }

    public LuaValue div(double d) {
        return LuaDouble.ddiv(this.checkarith(), d);
    }

    public LuaValue div(int n) {
        return LuaDouble.ddiv(this.checkarith(), n);
    }

    public LuaValue divInto(double d) {
        return LuaDouble.ddiv(d, this.checkarith());
    }

    public LuaValue mod(LuaValue luaValue) {
        double d = this.scannumber();
        return Double.isNaN(d) ? this.arithmt(MOD, luaValue) : luaValue.modFrom(d);
    }

    public LuaValue mod(double d) {
        return LuaDouble.dmod(this.checkarith(), d);
    }

    public LuaValue mod(int n) {
        return LuaDouble.dmod(this.checkarith(), n);
    }

    public LuaValue modFrom(double d) {
        return LuaDouble.dmod(d, this.checkarith());
    }

    public LuaValue lt(LuaValue luaValue) {
        return luaValue.strcmp(this) > 0 ? LuaValue.TRUE : FALSE;
    }

    public boolean lt_b(LuaValue luaValue) {
        return luaValue.strcmp(this) > 0;
    }

    public boolean lt_b(int n) {
        this.typerror("attempt to compare string with number");
        return false;
    }

    public boolean lt_b(double d) {
        this.typerror("attempt to compare string with number");
        return false;
    }

    public LuaValue lteq(LuaValue luaValue) {
        return luaValue.strcmp(this) >= 0 ? LuaValue.TRUE : FALSE;
    }

    public boolean lteq_b(LuaValue luaValue) {
        return luaValue.strcmp(this) >= 0;
    }

    public boolean lteq_b(int n) {
        this.typerror("attempt to compare string with number");
        return false;
    }

    public boolean lteq_b(double d) {
        this.typerror("attempt to compare string with number");
        return false;
    }

    public LuaValue gt(LuaValue luaValue) {
        return luaValue.strcmp(this) < 0 ? LuaValue.TRUE : FALSE;
    }

    public boolean gt_b(LuaValue luaValue) {
        return luaValue.strcmp(this) < 0;
    }

    public boolean gt_b(int n) {
        this.typerror("attempt to compare string with number");
        return false;
    }

    public boolean gt_b(double d) {
        this.typerror("attempt to compare string with number");
        return false;
    }

    public LuaValue gteq(LuaValue luaValue) {
        return luaValue.strcmp(this) <= 0 ? LuaValue.TRUE : FALSE;
    }

    public boolean gteq_b(LuaValue luaValue) {
        return luaValue.strcmp(this) <= 0;
    }

    public boolean gteq_b(int n) {
        this.typerror("attempt to compare string with number");
        return false;
    }

    public boolean gteq_b(double d) {
        this.typerror("attempt to compare string with number");
        return false;
    }

    public LuaValue concat(LuaValue luaValue) {
        return luaValue.concatTo(this);
    }

    public Buffer concat(Buffer buffer) {
        return buffer.concatTo(this);
    }

    public LuaValue concatTo(LuaNumber luaNumber) {
        return this.concatTo(luaNumber.strvalue());
    }

    public LuaValue concatTo(LuaString luaString) {
        byte[] byArray = new byte[luaString.m_length + this.m_length];
        System.arraycopy(luaString.m_bytes, luaString.m_offset, byArray, 0, luaString.m_length);
        System.arraycopy(this.m_bytes, this.m_offset, byArray, luaString.m_length, this.m_length);
        return LuaString.valueOf(byArray, 0, byArray.length);
    }

    public int strcmp(LuaValue luaValue) {
        return -luaValue.strcmp(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int strcmp(LuaString luaString) {
        int n = 0;
        for (int i = 0; n < this.m_length && i < luaString.m_length; n += LuaString.lhs_tmp.Len, i += LuaString.rhs_tmp.Len) {
            Utf16_char utf16_char = lhs_tmp;
            synchronized (utf16_char) {
                LuaString.Utf16_Decode_to_int(this.m_bytes, this.m_offset + n, lhs_tmp);
                LuaString.Utf16_Decode_to_int(luaString.m_bytes, luaString.m_offset + i, rhs_tmp);
                int n2 = LuaString.lhs_tmp.Codepoint - LuaString.rhs_tmp.Codepoint;
                if (n2 != 0) {
                    return n2;
                }
                continue;
            }
        }
        return this.m_length - luaString.m_length;
    }

    private double checkarith() {
        double d = this.scannumber();
        if (Double.isNaN(d)) {
            this.aritherror();
        }
        return d;
    }

    public int checkint() {
        return (int)this.checkdouble();
    }

    public LuaInteger checkinteger() {
        return LuaString.valueOf(this.checkint());
    }

    public long checklong() {
        return (long)this.checkdouble();
    }

    public double checkdouble() {
        double d = this.scannumber();
        if (Double.isNaN(d)) {
            this.argerror("number");
        }
        return d;
    }

    public LuaNumber checknumber() {
        return LuaString.valueOf(this.checkdouble());
    }

    public LuaNumber checknumber(String string) {
        double d = this.scannumber();
        if (Double.isNaN(d)) {
            LuaString.error(string);
        }
        return LuaString.valueOf(d);
    }

    public boolean isnumber() {
        double d = this.scannumber();
        return !Double.isNaN(d);
    }

    public boolean isint() {
        double d = this.scannumber();
        if (Double.isNaN(d)) {
            return false;
        }
        int n = (int)d;
        return (double)n == d;
    }

    public boolean islong() {
        double d = this.scannumber();
        if (Double.isNaN(d)) {
            return false;
        }
        long l = (long)d;
        return (double)l == d;
    }

    public byte tobyte() {
        return (byte)this.toint();
    }

    public char tochar() {
        return (char)this.toint();
    }

    public double todouble() {
        double d = this.scannumber();
        return Double.isNaN(d) ? 0.0 : d;
    }

    public float tofloat() {
        return (float)this.todouble();
    }

    public int toint() {
        return (int)this.tolong();
    }

    public long tolong() {
        return (long)this.todouble();
    }

    public short toshort() {
        return (short)this.toint();
    }

    public double optdouble(double d) {
        return this.checknumber().checkdouble();
    }

    public int optint(int n) {
        return this.checknumber().checkint();
    }

    public LuaInteger optinteger(LuaInteger luaInteger) {
        return this.checknumber().checkinteger();
    }

    public long optlong(long l) {
        return this.checknumber().checklong();
    }

    public LuaNumber optnumber(LuaNumber luaNumber) {
        return this.checknumber().checknumber();
    }

    public LuaString optstring(LuaString luaString) {
        return this;
    }

    public LuaValue tostring() {
        return this;
    }

    public String optjstring(String string) {
        return this.tojstring();
    }

    public LuaString strvalue() {
        return this;
    }

    public LuaString substring(int n, int n2) {
        return LuaString.valueOf(this.m_bytes, this.m_offset + n, n2 - n);
    }

    public int hashCode() {
        int n = this.m_length;
        int n2 = (this.m_length >> 5) + 1;
        for (int i = this.m_length; i >= n2; i -= n2) {
            n ^= (n << 5) + (n >> 2) + (this.m_bytes[this.m_offset + i - 1] & 0xFF);
        }
        return n;
    }

    public boolean equals(Object object) {
        if (object instanceof LuaString) {
            return this.raweq((LuaString)object);
        }
        return false;
    }

    public LuaValue eq(LuaValue luaValue) {
        return luaValue.raweq(this) ? TRUE : FALSE;
    }

    public boolean eq_b(LuaValue luaValue) {
        return luaValue.raweq(this);
    }

    public boolean raweq(LuaValue luaValue) {
        return luaValue.raweq(this);
    }

    public boolean raweq(LuaString luaString) {
        if (this == luaString) {
            return true;
        }
        if (luaString.m_length != this.m_length) {
            return false;
        }
        if (luaString.m_bytes == this.m_bytes && luaString.m_offset == this.m_offset) {
            return true;
        }
        byte[] byArray = luaString.m_bytes;
        int n = luaString.m_offset;
        for (int i = 0; i < this.m_length; ++i) {
            if (byArray[n + i] == this.m_bytes[this.m_offset + i]) continue;
            return false;
        }
        return true;
    }

    public static boolean equals(LuaString luaString, int n, LuaString luaString2, int n2, int n3) {
        return LuaString.equals(luaString.m_bytes, luaString.m_offset + n, luaString2.m_bytes, luaString2.m_offset + n2, n3);
    }

    public static boolean equals(byte[] byArray, int n, byte[] byArray2, int n2, int n3) {
        if (byArray.length < n + n3 || byArray2.length < n2 + n3) {
            return false;
        }
        while (--n3 >= 0) {
            if (byArray[n++] == byArray2[n2++]) continue;
            return false;
        }
        return true;
    }

    public void write(DataOutputStream dataOutputStream, int n, int n2) throws IOException {
        dataOutputStream.write(this.m_bytes, this.m_offset + n, n2);
    }

    public LuaValue len() {
        return LuaInteger.valueOf(this.m_length);
    }

    public int length() {
        return this.m_length;
    }

    public int rawlen() {
        return this.m_length;
    }

    public int luaByte(int n) {
        return this.m_bytes[this.m_offset + n] & 0xFF;
    }

    public int charAt(int n) {
        if (n < 0 || n >= this.m_length) {
            throw new IndexOutOfBoundsException();
        }
        return this.luaByte(n);
    }

    public String checkjstring() {
        return this.tojstring();
    }

    public LuaString checkstring() {
        return this;
    }

    public InputStream toInputStream() {
        return new ByteArrayInputStream(this.m_bytes, this.m_offset, this.m_length);
    }

    public void copyInto(int n, byte[] byArray, int n2, int n3) {
        System.arraycopy(this.m_bytes, this.m_offset + n, byArray, n2, n3);
    }

    public int indexOfAny(LuaString luaString) {
        int n = this.m_offset + this.m_length;
        int n2 = luaString.m_offset + luaString.m_length;
        for (int i = this.m_offset; i < n; ++i) {
            for (int j = luaString.m_offset; j < n2; ++j) {
                if (this.m_bytes[i] != luaString.m_bytes[j]) continue;
                return i - this.m_offset;
            }
        }
        return -1;
    }

    public int indexOf(byte by, int n) {
        for (int i = n; i < this.m_length; ++i) {
            if (this.m_bytes[this.m_offset + i] != by) continue;
            return i;
        }
        return -1;
    }

    public int indexOf(LuaString luaString, int n) {
        int n2 = luaString.length();
        int n3 = this.m_length - n2;
        for (int i = n; i <= n3; ++i) {
            if (!LuaString.equals(this.m_bytes, this.m_offset + i, luaString.m_bytes, luaString.m_offset, n2)) continue;
            return i;
        }
        return -1;
    }

    public int lastIndexOf(LuaString luaString) {
        int n;
        int n2 = luaString.length();
        for (int i = n = this.m_length - n2; i >= 0; --i) {
            if (!LuaString.equals(this.m_bytes, this.m_offset + i, luaString.m_bytes, luaString.m_offset, n2)) continue;
            return i;
        }
        return -1;
    }

    public static String decodeAsUtf8(byte[] byArray, int n, int n2) {
        return new String(byArray, n, n2, Charset.forName("UTF-8"));
    }

    public static int lengthAsUtf8(char[] cArray) {
        int n = cArray.length;
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            char c = cArray[i];
            if (c > '\uffffffff' && c < '\u0080') {
                ++n2;
                continue;
            }
            if (c < '\u0800') {
                n2 += 2;
                continue;
            }
            if (c > '\ud7ff' && c < '\udc00') {
                n2 += 4;
                ++i;
                continue;
            }
            if (c >= '\u10000') continue;
            n2 += 3;
        }
        return n2;
    }

    public static int encodeToUtf8(char[] cArray, int n, byte[] byArray, int n2) {
        int n3 = n2;
        int n4 = 0;
        while (n4 < n) {
            char c = cArray[n4];
            if (c > '\uffffffff' && c < '\u0080') {
                byArray[n3++] = (byte)c;
                ++n4;
                continue;
            }
            if (c < '\u0800') {
                byArray[n3++] = (byte)(0xC0 | c >> 6);
                byArray[n3++] = (byte)(0x80 | c & 0x3F);
                ++n4;
                continue;
            }
            if (c > '\ud7ff' && c < '\udc00') {
                if (n4 >= n) {
                    throw new RuntimeException("incomplete surrogate pair at end of string; char=" + c);
                }
                char c2 = cArray[n4 + 1];
                int n5 = LuaString.Utf16_Surrogate_merge(c, c2);
                byArray[n3++] = (byte)(0xF0 | n5 >> 18);
                byArray[n3++] = (byte)(0x80 | n5 >> 12 & 0x3F);
                byArray[n3++] = (byte)(0x80 | n5 >> 6 & 0x3F);
                byArray[n3++] = (byte)(0x80 | n5 & 0x3F);
                n4 += 2;
                continue;
            }
            byArray[n3++] = (byte)(0xE0 | c >> 12);
            byArray[n3++] = (byte)(0x80 | c >> 6 & 0x3F);
            byArray[n3++] = (byte)(0x80 | c & 0x3F);
            ++n4;
        }
        return n;
    }

    public boolean isValidUtf8() {
        int n = 0;
        int n2 = this.m_offset;
        int n3 = this.m_offset + this.m_length;
        n = 0;
        while (n2 < n3) {
            byte by;
            if (!((by = this.m_bytes[n2++]) >= 0 || (by & 0xE0) == 192 && n2 < n3 && (this.m_bytes[n2++] & 0xC0) == 128 || (by & 0xF0) == 224 && n2 + 1 < n3 && (this.m_bytes[n2++] & 0xC0) == 128 && (this.m_bytes[n2++] & 0xC0) == 128)) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public LuaValue tonumber() {
        double d = this.scannumber();
        return Double.isNaN(d) ? NIL : LuaString.valueOf(d);
    }

    public LuaValue tonumber(int n) {
        double d = this.scannumber(n);
        return Double.isNaN(d) ? NIL : LuaString.valueOf(d);
    }

    public double scannumber() {
        byte by;
        int n = this.m_offset;
        int n2 = this.m_offset + this.m_length;
        int n3 = n;
        block6: while (n3 < n2) {
            switch (this.m_bytes[n3]) {
                case 9: 
                case 10: 
                case 13: 
                case 32: {
                    n = ++n3;
                    continue block6;
                }
            }
            n3 = n2;
        }
        n3 = n2 - 1;
        block7: while (n3 >= n) {
            switch (this.m_bytes[n3]) {
                case 9: 
                case 10: 
                case 13: 
                case 32: {
                    n2 = n3--;
                    continue block7;
                }
            }
            n3 = n - 1;
        }
        if (n >= n2) {
            return Double.NaN;
        }
        if (n + 1 < n2 && this.m_bytes[n] == 48 && ((by = this.m_bytes[n + 1]) == 120 || by == 88)) {
            return n + 2 < n2 ? this.scanlong(16, n + 2, n2) : Double.NaN;
        }
        double d = this.scanlong(10, n, n2);
        return Double.isNaN(d) ? this.scandouble(n, n2) : d;
    }

    public double scannumber(int n) {
        int n2;
        if (n < 2 || n > 36) {
            return Double.NaN;
        }
        int n3 = this.m_offset + this.m_length;
        for (n2 = this.m_offset; n2 < n3 && this.m_bytes[n2] == 32; ++n2) {
        }
        while (n2 < n3 && this.m_bytes[n3 - 1] == 32) {
            --n3;
        }
        if (n2 >= n3) {
            return Double.NaN;
        }
        return this.scanlong(n, n2, n3);
    }

    private double scanlong(int n, int n2, int n3) {
        int n4;
        long l = 0L;
        boolean bl = this.m_bytes[n2] == 45;
        int n5 = n4 = bl ? n2 + 1 : n2;
        if (bl && n4 == n3) {
            return Double.NaN;
        }
        for (int i = n4; i < n3; ++i) {
            int n6 = this.m_bytes[i] - (n <= 10 || this.m_bytes[i] >= 48 && this.m_bytes[i] <= 57 ? 48 : (this.m_bytes[i] >= 65 && this.m_bytes[i] <= 90 ? 55 : 87));
            if (n6 < 0 || n6 >= n) {
                return Double.NaN;
            }
            if ((l = l * (long)n + (long)n6) >= 0L) continue;
            return Double.NaN;
        }
        return bl ? (double)(-l) : (double)l;
    }

    private double scandouble(int n, int n2) {
        if (n2 > n + 64) {
            n2 = n + 64;
        }
        block5: for (int i = n; i < n2; ++i) {
            switch (this.m_bytes[i]) {
                case 43: 
                case 45: 
                case 46: 
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: 
                case 69: 
                case 101: {
                    continue block5;
                }
                default: {
                    return Double.NaN;
                }
            }
        }
        char[] cArray = new char[n2 - n];
        for (int i = n; i < n2; ++i) {
            cArray[i - n] = (char)this.m_bytes[i];
        }
        try {
            return Double.parseDouble(new String(cArray));
        }
        catch (Exception exception) {
            return Double.NaN;
        }
    }

    public void printToStream(PrintStream printStream) {
        int n = this.m_length;
        for (int i = 0; i < n; ++i) {
            byte by = this.m_bytes[this.m_offset + i];
            printStream.print((char)by);
        }
    }

    private static int Utf16_Len_by_char(int n) {
        if (n > -1 && n < 128) {
            return 1;
        }
        if (n < 2048) {
            return 2;
        }
        if (n > 55295 && n < 56320) {
            return 4;
        }
        if (n < 65536) {
            return 3;
        }
        throw new RuntimeException("UTF-16 int must be between 0 and 2097152; char=" + n);
    }

    public static int Utf16_Len_by_int(int n) {
        if (n > -1 && n < 128) {
            return 1;
        }
        if (n < 2048) {
            return 2;
        }
        if (n < 65536) {
            return 3;
        }
        if (n < 0x200000) {
            return 4;
        }
        throw new RuntimeException("UTF-16 int must be between 0 and 2097152; char=" + n);
    }

    public static int Utf8_Len_of_char_by_1st_byte(byte by) {
        int n = by & 0xFF;
        switch (n) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 95: 
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 113: 
            case 114: 
            case 115: 
            case 116: 
            case 117: 
            case 118: 
            case 119: 
            case 120: 
            case 121: 
            case 122: 
            case 123: 
            case 124: 
            case 125: 
            case 126: 
            case 127: 
            case 128: 
            case 129: 
            case 130: 
            case 131: 
            case 132: 
            case 133: 
            case 134: 
            case 135: 
            case 136: 
            case 137: 
            case 138: 
            case 139: 
            case 140: 
            case 141: 
            case 142: 
            case 143: 
            case 144: 
            case 145: 
            case 146: 
            case 147: 
            case 148: 
            case 149: 
            case 150: 
            case 151: 
            case 152: 
            case 153: 
            case 154: 
            case 155: 
            case 156: 
            case 157: 
            case 158: 
            case 159: 
            case 160: 
            case 161: 
            case 162: 
            case 163: 
            case 164: 
            case 165: 
            case 166: 
            case 167: 
            case 168: 
            case 169: 
            case 170: 
            case 171: 
            case 172: 
            case 173: 
            case 174: 
            case 175: 
            case 176: 
            case 177: 
            case 178: 
            case 179: 
            case 180: 
            case 181: 
            case 182: 
            case 183: 
            case 184: 
            case 185: 
            case 186: 
            case 187: 
            case 188: 
            case 189: 
            case 190: 
            case 191: {
                return 1;
            }
            case 192: 
            case 193: 
            case 194: 
            case 195: 
            case 196: 
            case 197: 
            case 198: 
            case 199: 
            case 200: 
            case 201: 
            case 202: 
            case 203: 
            case 204: 
            case 205: 
            case 206: 
            case 207: 
            case 208: 
            case 209: 
            case 210: 
            case 211: 
            case 212: 
            case 213: 
            case 214: 
            case 215: 
            case 216: 
            case 217: 
            case 218: 
            case 219: 
            case 220: 
            case 221: 
            case 222: 
            case 223: {
                return 2;
            }
            case 224: 
            case 225: 
            case 226: 
            case 227: 
            case 228: 
            case 229: 
            case 230: 
            case 231: 
            case 232: 
            case 233: 
            case 234: 
            case 235: 
            case 236: 
            case 237: 
            case 238: 
            case 239: {
                return 3;
            }
            case 240: 
            case 241: 
            case 242: 
            case 243: 
            case 244: 
            case 245: 
            case 246: 
            case 247: {
                return 4;
            }
        }
        throw new RuntimeException("invalid initial utf8 byte; byte=" + by);
    }

    public static void Utf16_Decode_to_int(byte[] byArray, int n, Utf16_char utf16_char) {
        int n2 = byArray[n];
        if ((n2 & 0x80) == 0) {
            utf16_char.Len = 1;
            utf16_char.Codepoint = n2;
        } else if ((n2 & 0xE0) == 192) {
            utf16_char.Len = 2;
            utf16_char.Codepoint = (n2 & 0x1F) << 6 | byArray[n + 1] & 0x3F;
        } else if ((n2 & 0xF0) == 224) {
            utf16_char.Len = 3;
            utf16_char.Codepoint = (n2 & 0xF) << 12 | (byArray[n + 1] & 0x3F) << 6 | byArray[n + 2] & 0x3F;
        } else if ((n2 & 0xF8) == 240) {
            utf16_char.Len = 4;
            utf16_char.Codepoint = (n2 & 7) << 18 | (byArray[n + 1] & 0x3F) << 12 | (byArray[n + 2] & 0x3F) << 6 | byArray[n + 3] & 0x3F;
        } else {
            throw new RuntimeException("invalid utf8 byte: byte=" + n2);
        }
    }

    public static int Utf16_Decode_to_int(byte[] byArray, int n) {
        byte by = byArray[n];
        if ((by & 0x80) == 0) {
            return by;
        }
        if ((by & 0xE0) == 192) {
            return (by & 0x1F) << 6 | byArray[n + 1] & 0x3F;
        }
        if ((by & 0xF0) == 224) {
            return (by & 0xF) << 12 | (byArray[n + 1] & 0x3F) << 6 | byArray[n + 2] & 0x3F;
        }
        if ((by & 0xF8) == 240) {
            return (by & 7) << 18 | (byArray[n + 1] & 0x3F) << 12 | (byArray[n + 2] & 0x3F) << 6 | byArray[n + 3] & 0x3F;
        }
        throw new RuntimeException("invalid utf8 byte: byte=" + by);
    }

    public static int Utf16_Encode_int(int n, byte[] byArray, int n2) {
        if (n > -1 && n < 128) {
            byArray[n2] = (byte)n;
            return 1;
        }
        if (n < 2048) {
            byArray[n2] = (byte)(0xC0 | n >> 6);
            byArray[++n2] = (byte)(0x80 | n & 0x3F);
            return 2;
        }
        if (n < 65536) {
            byArray[n2] = (byte)(0xE0 | n >> 12);
            byArray[++n2] = (byte)(0x80 | n >> 6 & 0x3F);
            byArray[++n2] = (byte)(0x80 | n & 0x3F);
            return 3;
        }
        if (n < 0x200000) {
            byArray[n2] = (byte)(0xF0 | n >> 18);
            byArray[++n2] = (byte)(0x80 | n >> 12 & 0x3F);
            byArray[++n2] = (byte)(0x80 | n >> 6 & 0x3F);
            byArray[++n2] = (byte)(0x80 | n & 0x3F);
            return 4;
        }
        throw new RuntimeException("UTF-16 int must be between 0 and 2097152; char=" + n);
    }

    public static int Utf16_Encode_char(int n, char[] cArray, int n2, byte[] byArray, int n3) {
        if (n > -1 && n < 128) {
            byArray[n3] = (byte)n;
            return 1;
        }
        if (n < 2048) {
            byArray[n3] = (byte)(0xC0 | n >> 6);
            byArray[++n3] = (byte)(0x80 | n & 0x3F);
            return 2;
        }
        if (n > 55295 && n < 56320) {
            if (n2 >= cArray.length) {
                throw new RuntimeException("incomplete surrogate pair at end of string; char=" + n);
            }
            char c = cArray[n2 + 1];
            int n4 = LuaString.Utf16_Surrogate_merge(n, c);
            byArray[n3] = (byte)(0xF0 | n4 >> 18);
            byArray[++n3] = (byte)(0x80 | n4 >> 12 & 0x3F);
            byArray[++n3] = (byte)(0x80 | n4 >> 6 & 0x3F);
            byArray[++n3] = (byte)(0x80 | n4 & 0x3F);
            return 4;
        }
        byArray[n3] = (byte)(0xE0 | n >> 12);
        byArray[++n3] = (byte)(0x80 | n >> 6 & 0x3F);
        byArray[++n3] = (byte)(0x80 | n & 0x3F);
        return 3;
    }

    public static int Utf16_Encode_char_ascii_skip(int n, char[] cArray, int n2, byte[] byArray, int n3) {
        if (n < 2048) {
            byArray[n3] = (byte)(0xC0 | n >> 6);
            byArray[++n3] = (byte)(0x80 | n & 0x3F);
            return 2;
        }
        if (n > 55295 && n < 56320) {
            if (n2 >= cArray.length) {
                throw new RuntimeException("incomplete surrogate pair at end of string; char=" + n);
            }
            char c = cArray[n2 + 1];
            int n4 = LuaString.Utf16_Surrogate_merge(n, c);
            byArray[n3] = (byte)(0xF0 | n4 >> 18);
            byArray[++n3] = (byte)(0x80 | n4 >> 12 & 0x3F);
            byArray[++n3] = (byte)(0x80 | n4 >> 6 & 0x3F);
            byArray[++n3] = (byte)(0x80 | n4 & 0x3F);
            return 4;
        }
        byArray[n3] = (byte)(0xE0 | n >> 12);
        byArray[++n3] = (byte)(0x80 | n >> 6 & 0x3F);
        byArray[++n3] = (byte)(0x80 | n & 0x3F);
        return 3;
    }

    private static int Utf16_Surrogate_merge(int n, int n2) {
        return 65536 + (n - 55296) * 1024 + (n2 - 56320);
    }

    public static void Utf16_Surrogate_split(int n, int[] nArray) {
        nArray[0] = (n - 65536) / 1024 + 55296;
        nArray[1] = (n - 65536) % 1024 + 56320;
    }

    static {
        lhs_tmp = new Utf16_char();
        rhs_tmp = new Utf16_char();
    }

    static class Utf16_char {
        public int Codepoint;
        public int Len;

        Utf16_char() {
        }
    }

    private static class Cache {
        public final LuaString[] recent_short_strings = new LuaString[128];
        static final Cache instance = new Cache();

        private Cache() {
        }

        public LuaString get(LuaString luaString) {
            int n = luaString.hashCode() & 0x7F;
            LuaString luaString2 = this.recent_short_strings[n];
            if (luaString2 != null && luaString.raweq(luaString2)) {
                return luaString2;
            }
            this.recent_short_strings[n] = luaString;
            return luaString;
        }
    }
}

