/*
 * Decompiled with CFR 0.152.
 */
package org.lukhnos.portmobile.file;

import java.io.File;
import java.io.IOException;

public class Path {
    File file;

    Path(String path) {
        this.file = new File(path);
    }

    Path(File file) {
        this.file = file;
    }

    public File toFile() {
        return this.file;
    }

    public Path toRealPath() throws IOException {
        return this;
    }

    public Path getFileName() {
        return new Path(this.file.getName());
    }

    public String toString() {
        return this.file.toString();
    }

    public Path resolve(String other) {
        if (other.isEmpty()) {
            return this;
        }
        File otherFile = new File(other);
        if (otherFile.isAbsolute()) {
            return new Path(otherFile);
        }
        return new Path(new File(this.file, other));
    }

    public boolean isAbsolute() {
        return this.file.isAbsolute();
    }

    public Path toAbsolutePath() {
        return new Path(this.file.getAbsoluteFile());
    }

    public Path getParent() {
        return new Path(this.file.getParent());
    }
}

