/*
 * Decompiled with CFR 0.152.
 */
package org.lukhnos.portmobile.file;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.channels.FileChannel;
import java.nio.channels.SeekableByteChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.nio.charset.Charset;
import java.util.ArrayList;
import org.lukhnos.portmobile.channels.utils.FileChannelUtils;
import org.lukhnos.portmobile.file.DirectoryStream;
import org.lukhnos.portmobile.file.FileVisitor;
import org.lukhnos.portmobile.file.NoSuchFileException;
import org.lukhnos.portmobile.file.Path;
import org.lukhnos.portmobile.file.StandardCopyOption;
import org.lukhnos.portmobile.file.StandardOpenOption;
import org.lukhnos.portmobile.file.attribute.BasicFileAttributes;

public class Files {
    public static Path createDirectories(Path dir) throws IOException {
        if (Files.exists(dir)) {
            if (Files.isDirectory(dir)) {
                return dir;
            }
            throw new IOException("Path is not a directory: " + dir);
        }
        Files.createDirectories(dir.getParent());
        if (dir.toFile().mkdir()) {
            return dir;
        }
        throw new IOException("Failed creating directory: " + dir);
    }

    public static SeekableByteChannel newByteChannel(Path path, StandardOpenOption mustBeReadOnly) throws IOException {
        return FileChannelUtils.open(path, mustBeReadOnly);
    }

    public static Path createFile(Path path) throws IOException {
        if (!path.toFile().createNewFile()) {
            throw new IOException("File cannot be created: " + path);
        }
        return path;
    }

    public static long size(Path path) throws IOException {
        return path.toFile().length();
    }

    public static boolean exists(Path path) {
        return path.file.exists();
    }

    public static boolean notExists(Path path) {
        return !Files.exists(path);
    }

    public static boolean isDirectory(Path path) {
        return path.file.isDirectory();
    }

    public static boolean isWritable(Path path) {
        return path.file.canWrite();
    }

    public static FileOutputStream newOutputStream(Path path) throws IOException {
        return new FileOutputStream(path.toFile());
    }

    public static FileInputStream newInputStream(Path path) throws IOException {
        return new FileInputStream(path.toFile());
    }

    public static BufferedReader newBufferedReader(Path path, Charset charset) throws IOException {
        return new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(path.toFile()), charset));
    }

    public static DirectoryStream<Path> newDirectoryStream(Path dir) throws IOException {
        File[] files;
        if (!Files.isDirectory(dir)) {
            throw new IOException("Not a directory: " + dir);
        }
        ArrayList<Path> paths = new ArrayList<Path>();
        for (File file : files = dir.toFile().listFiles()) {
            paths.add(new Path(file));
        }
        return new DirectoryStream.SimpleDirectoryStream<Path>(paths);
    }

    public static boolean deleteIfExists(Path path) throws IOException {
        if (Files.exists(path)) {
            if (!path.toFile().delete()) {
                throw new IOException("Could not delete path: " + path);
            }
            return true;
        }
        return false;
    }

    public static Path createTempFile(Path dir, String prefix, String suffix) throws IOException {
        return new Path(File.createTempFile(prefix, suffix, dir.toFile()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Path copy(Path source, Path target, StandardCopyOption ... ignored) throws IOException {
        if (Files.isDirectory(source)) {
            throw new UnsupportedOperationException("Directory copy not supported in this implementation");
        }
        FileChannel srcChannel = null;
        AbstractInterruptibleChannel dstChannnel = null;
        try {
            srcChannel = Files.newInputStream(source).getChannel();
            dstChannnel = Files.newOutputStream(target).getChannel();
            long size = srcChannel.size();
            for (long alreadyRead = 0L; alreadyRead < size; alreadyRead += ((FileChannel)dstChannnel).transferFrom(srcChannel, alreadyRead, size - alreadyRead)) {
            }
        }
        finally {
            srcChannel.close();
            dstChannnel.close();
        }
        return target;
    }

    public static void delete(Path path) throws IOException {
        path.toFile().delete();
    }

    public static Path move(Path source, Path target, StandardCopyOption ... ignored) throws IOException {
        if (source.toFile().renameTo(target.toFile())) {
            return target;
        }
        throw new IOException("Move from " + source + " to " + target + " failed");
    }

    public static Path walkFileTree(Path start, FileVisitor<? super Path> visitor) throws IOException {
        if (Files.isDirectory(start)) {
            visitor.preVisitDirectory(start, null);
            for (File child : start.toFile().listFiles()) {
                Files.walkFileTree(new Path(child), visitor);
            }
            visitor.postVisitDirectory(start, null);
        } else {
            visitor.visitFile(start, null);
        }
        return start;
    }

    public static Path createTempDirectory(String prefix) throws IOException {
        File tmpFile = File.createTempFile(prefix, "");
        tmpFile.delete();
        tmpFile.mkdir();
        return new Path(tmpFile);
    }

    public static Path createTempDirectory(Path path, String prefix) throws IOException {
        File tmpFile = File.createTempFile(prefix, "", path.toFile());
        tmpFile.delete();
        tmpFile.mkdir();
        return new Path(tmpFile);
    }

    public static BasicFileAttributes readAttributes(Path path, Class<?> clz) throws NoSuchFileException {
        if (Files.exists(path)) {
            return new BasicFileAttributes(path.toFile());
        }
        throw new NoSuchFileException();
    }
}

