/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.spans;

import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.index.IndexReaderContext;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.PostingsEnum;
import org.apache.lucene.index.ReaderUtil;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermContext;
import org.apache.lucene.index.TermState;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.spans.SpanQuery;
import org.apache.lucene.search.spans.SpanWeight;
import org.apache.lucene.search.spans.Spans;
import org.apache.lucene.search.spans.TermSpans;
import org.apache.lucene.util.ToStringUtils;
import org.lukhnos.portmobile.util.Objects;

public class SpanTermQuery
extends SpanQuery {
    protected final Term term;
    protected final TermContext termContext;

    public SpanTermQuery(Term term) {
        this.term = Objects.requireNonNull(term);
        this.termContext = null;
    }

    public SpanTermQuery(Term term, TermContext context) {
        this.term = Objects.requireNonNull(term);
        this.termContext = context;
    }

    public Term getTerm() {
        return this.term;
    }

    @Override
    public String getField() {
        return this.term.field();
    }

    @Override
    public SpanWeight createWeight(IndexSearcher searcher, boolean needsScores) throws IOException {
        IndexReaderContext topContext = searcher.getTopReaderContext();
        TermContext context = this.termContext == null || this.termContext.topReaderContext != topContext ? TermContext.build(topContext, this.term) : this.termContext;
        return new SpanTermWeight(context, searcher, needsScores ? Collections.singletonMap(this.term, context) : null);
    }

    @Override
    public String toString(String field) {
        StringBuilder buffer = new StringBuilder();
        if (this.term.field().equals(field)) {
            buffer.append(this.term.text());
        } else {
            buffer.append(this.term.toString());
        }
        buffer.append(ToStringUtils.boost(this.getBoost()));
        return buffer.toString();
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + this.term.hashCode();
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        SpanTermQuery other = (SpanTermQuery)obj;
        return this.term.equals(other.term);
    }

    public class SpanTermWeight
    extends SpanWeight {
        final TermContext termContext;

        public SpanTermWeight(TermContext termContext, IndexSearcher searcher, Map<Term, TermContext> terms) throws IOException {
            super(SpanTermQuery.this, searcher, terms);
            this.termContext = termContext;
            assert (termContext != null) : "TermContext must not be null";
        }

        @Override
        public void extractTerms(Set<Term> terms) {
            terms.add(SpanTermQuery.this.term);
        }

        @Override
        public void extractTermContexts(Map<Term, TermContext> contexts) {
            contexts.put(SpanTermQuery.this.term, this.termContext);
        }

        @Override
        public Spans getSpans(LeafReaderContext context, SpanWeight.Postings requiredPostings) throws IOException {
            assert (this.termContext.topReaderContext == ReaderUtil.getTopLevelContext(context)) : "The top-reader used to create Weight (" + this.termContext.topReaderContext + ") is not the same as the current reader's top-reader (" + ReaderUtil.getTopLevelContext(context);
            TermState state = this.termContext.get(context.ord);
            if (state == null) {
                assert (context.reader().docFreq(SpanTermQuery.this.term) == 0) : "no termstate found but term exists in reader term=" + SpanTermQuery.this.term;
                return null;
            }
            Terms terms = context.reader().terms(SpanTermQuery.this.term.field());
            if (terms == null) {
                return null;
            }
            if (!terms.hasPositions()) {
                throw new IllegalStateException("field \"" + SpanTermQuery.this.term.field() + "\" was indexed without position data; cannot run SpanTermQuery (term=" + SpanTermQuery.this.term.text() + ")");
            }
            TermsEnum termsEnum = terms.iterator();
            termsEnum.seekExact(SpanTermQuery.this.term.bytes(), state);
            PostingsEnum postings = termsEnum.postings(null, requiredPostings.getRequiredPostings());
            return new TermSpans(postings, SpanTermQuery.this.term);
        }
    }
}

