/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.spans;

import java.io.IOException;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.TwoPhaseIterator;
import org.apache.lucene.search.similarities.Similarity;
import org.apache.lucene.search.spans.SpanWeight;
import org.apache.lucene.search.spans.Spans;
import org.lukhnos.portmobile.util.Objects;

public class SpanScorer
extends Scorer {
    protected final Spans spans;
    protected final Similarity.SimScorer docScorer;
    protected float freq;
    protected int numMatches;
    private int lastScoredDoc = -1;

    public SpanScorer(Spans spans, SpanWeight weight, Similarity.SimScorer docScorer) throws IOException {
        super(weight);
        this.docScorer = docScorer;
        this.spans = Objects.requireNonNull(spans);
    }

    @Override
    public final int nextDoc() throws IOException {
        return this.spans.nextDoc();
    }

    @Override
    public final int advance(int target) throws IOException {
        return this.spans.advance(target);
    }

    private final void ensureFreq() throws IOException {
        int currentDoc = this.spans.docID();
        if (this.lastScoredDoc != currentDoc) {
            this.setFreqCurrentDoc();
            this.lastScoredDoc = currentDoc;
        }
    }

    protected final void setFreqCurrentDoc() throws IOException {
        this.freq = 0.0f;
        this.numMatches = 0;
        this.doStartCurrentDoc();
        assert (this.spans.startPosition() == -1) : "incorrect initial start position, spans=" + this.spans;
        assert (this.spans.endPosition() == -1) : "incorrect initial end position, spans=" + this.spans;
        int prevStartPos = -1;
        int prevEndPos = -1;
        int startPos = this.spans.nextStartPosition();
        assert (startPos != Integer.MAX_VALUE) : "initial startPos NO_MORE_POSITIONS, spans=" + this.spans;
        do {
            assert (startPos >= prevStartPos);
            int endPos = this.spans.endPosition();
            assert (endPos != Integer.MAX_VALUE);
            assert (startPos != prevStartPos || endPos >= prevEndPos) : "decreased endPos=" + endPos;
            ++this.numMatches;
            if (this.docScorer == null) {
                this.freq = 1.0f;
                return;
            }
            this.freq += this.docScorer.computeSlopFactor(this.spans.width());
            this.doCurrentSpans();
            prevStartPos = startPos;
            prevEndPos = endPos;
        } while ((startPos = this.spans.nextStartPosition()) != Integer.MAX_VALUE);
        assert (this.spans.startPosition() == Integer.MAX_VALUE) : "incorrect final start position, spans=" + this.spans;
        assert (this.spans.endPosition() == Integer.MAX_VALUE) : "incorrect final end position, spans=" + this.spans;
    }

    protected void doStartCurrentDoc() throws IOException {
    }

    protected void doCurrentSpans() throws IOException {
    }

    protected float scoreCurrentDoc() throws IOException {
        return this.docScorer.score(this.spans.docID(), this.freq);
    }

    @Override
    public final int docID() {
        return this.spans.docID();
    }

    @Override
    public final float score() throws IOException {
        this.ensureFreq();
        return this.scoreCurrentDoc();
    }

    @Override
    public final int freq() throws IOException {
        this.ensureFreq();
        return this.numMatches;
    }

    public final float sloppyFreq() throws IOException {
        this.ensureFreq();
        return this.freq;
    }

    @Override
    public final long cost() {
        return this.spans.cost();
    }

    @Override
    public final TwoPhaseIterator asTwoPhaseIterator() {
        return this.spans.asTwoPhaseIterator();
    }
}

