/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import java.util.Set;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.ConstantScoreScorer;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.TwoPhaseIterator;
import org.apache.lucene.search.Weight;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.ToStringUtils;
import org.lukhnos.portmobile.util.Objects;

@Deprecated
public class FilteredQuery
extends Query {
    private final Query query;
    private final Filter filter;
    private final FilterStrategy strategy;
    public static final FilterStrategy RANDOM_ACCESS_FILTER_STRATEGY = new RandomAccessFilterStrategy();
    public static final FilterStrategy LEAP_FROG_FILTER_FIRST_STRATEGY;
    public static final FilterStrategy LEAP_FROG_QUERY_FIRST_STRATEGY;
    public static final FilterStrategy QUERY_FIRST_FILTER_STRATEGY;

    public FilteredQuery(Query query, Filter filter) {
        this(query, filter, RANDOM_ACCESS_FILTER_STRATEGY);
    }

    public FilteredQuery(Query query, Filter filter, FilterStrategy strategy) {
        this.strategy = Objects.requireNonNull(strategy, "FilterStrategy must not be null");
        this.query = Objects.requireNonNull(query, "Query must not be null");
        this.filter = Objects.requireNonNull(filter, "Filter must not be null");
    }

    @Override
    public Query rewrite(IndexReader reader) throws IOException {
        BooleanQuery.Builder builder = new BooleanQuery.Builder();
        builder.add(this.query, BooleanClause.Occur.MUST);
        builder.add(this.strategy.rewrite(this.filter), BooleanClause.Occur.FILTER);
        BooleanQuery rewritten = builder.build();
        rewritten.setBoost(this.getBoost());
        return rewritten;
    }

    public final Query getQuery() {
        return this.query;
    }

    public final Filter getFilter() {
        return this.filter;
    }

    public FilterStrategy getFilterStrategy() {
        return this.strategy;
    }

    @Override
    public String toString(String s) {
        StringBuilder buffer = new StringBuilder();
        buffer.append("filtered(");
        buffer.append(this.query.toString(s));
        buffer.append(")->");
        buffer.append(this.filter);
        buffer.append(ToStringUtils.boost(this.getBoost()));
        return buffer.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!super.equals(o)) {
            return false;
        }
        assert (o instanceof FilteredQuery);
        FilteredQuery fq = (FilteredQuery)o;
        return fq.query.equals(this.query) && fq.filter.equals(this.filter) && fq.strategy.equals(this.strategy);
    }

    @Override
    public int hashCode() {
        int hash = super.hashCode();
        hash = hash * 31 + this.strategy.hashCode();
        hash = hash * 31 + this.query.hashCode();
        hash = hash * 31 + this.filter.hashCode();
        return hash;
    }

    static {
        LEAP_FROG_QUERY_FIRST_STRATEGY = LEAP_FROG_FILTER_FIRST_STRATEGY = new RandomAccessFilterStrategy(){

            @Override
            protected boolean useRandomAccess(Bits bits, long filterCost) {
                return false;
            }
        };
        QUERY_FIRST_FILTER_STRATEGY = new RandomAccessFilterStrategy(){

            @Override
            boolean alwaysUseRandomAccess() {
                return true;
            }
        };
    }

    private static class RandomAccessFilterWrapperQuery
    extends Query {
        final Filter filter;
        final RandomAccessFilterStrategy strategy;

        private RandomAccessFilterWrapperQuery(Filter filter, RandomAccessFilterStrategy strategy) {
            this.filter = Objects.requireNonNull(filter);
            this.strategy = Objects.requireNonNull(strategy);
        }

        @Override
        public boolean equals(Object obj) {
            if (!super.equals(obj)) {
                return false;
            }
            RandomAccessFilterWrapperQuery that = (RandomAccessFilterWrapperQuery)obj;
            return this.filter.equals(that.filter) && this.strategy.equals(that.strategy);
        }

        @Override
        public int hashCode() {
            return 31 * super.hashCode() + Objects.hash(this.filter, this.strategy);
        }

        @Override
        public String toString(String field) {
            return this.filter.toString(field);
        }

        @Override
        public Weight createWeight(IndexSearcher searcher, boolean needsScores) throws IOException {
            return new Weight(this){

                @Override
                public void extractTerms(Set<Term> terms) {
                }

                @Override
                public float getValueForNormalization() throws IOException {
                    return 0.0f;
                }

                @Override
                public void normalize(float norm, float topLevelBoost) {
                }

                @Override
                public Explanation explain(LeafReaderContext context, int doc) throws IOException {
                    boolean match;
                    Scorer s = this.scorer(context);
                    if (s == null) {
                        match = false;
                    } else {
                        TwoPhaseIterator twoPhase = s.asTwoPhaseIterator();
                        if (twoPhase == null) {
                            match = s.advance(doc) == doc;
                        } else {
                            boolean bl = match = twoPhase.approximation().advance(doc) == doc && twoPhase.matches();
                        }
                    }
                    if (match) {
                        assert (s.score() == 0.0f);
                        return Explanation.match(0.0f, "Match on id " + doc, new Explanation[0]);
                    }
                    return Explanation.match(0.0f, "No match on id " + doc, new Explanation[0]);
                }

                @Override
                public Scorer scorer(LeafReaderContext context) throws IOException {
                    DocIdSetIterator iterator;
                    boolean useRandomAccess;
                    DocIdSet set = RandomAccessFilterWrapperQuery.this.filter.getDocIdSet(context, null);
                    if (set == null) {
                        return null;
                    }
                    final Bits bits = set.bits();
                    boolean bl = useRandomAccess = bits != null && RandomAccessFilterWrapperQuery.this.strategy.alwaysUseRandomAccess();
                    if (useRandomAccess) {
                        iterator = null;
                    } else {
                        iterator = set.iterator();
                        if (iterator == null) {
                            return null;
                        }
                        if (bits != null) {
                            useRandomAccess = RandomAccessFilterWrapperQuery.this.strategy.useRandomAccess(bits, iterator.cost());
                        }
                    }
                    if (useRandomAccess) {
                        DocIdSetIterator approximation = DocIdSetIterator.all(context.reader().maxDoc());
                        TwoPhaseIterator twoPhase = new TwoPhaseIterator(approximation){

                            @Override
                            public boolean matches() throws IOException {
                                int doc = this.approximation.docID();
                                return bits.get(doc);
                            }
                        };
                        return new ConstantScoreScorer((Weight)this, 0.0f, twoPhase);
                    }
                    return new ConstantScoreScorer((Weight)this, 0.0f, iterator);
                }
            };
        }
    }

    public static class RandomAccessFilterStrategy
    extends FilterStrategy {
        @Override
        public Query rewrite(Filter filter) {
            return new RandomAccessFilterWrapperQuery(filter, this);
        }

        protected boolean useRandomAccess(Bits bits, long filterCost) {
            return filterCost * 100L > (long)bits.length();
        }

        boolean alwaysUseRandomAccess() {
            return false;
        }
    }

    public static abstract class FilterStrategy {
        public abstract Query rewrite(Filter var1);
    }
}

