/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.lukhnos.portmobile.util.Objects;

public final class Explanation {
    private final boolean match;
    private final float value;
    private final String description;
    private final List<Explanation> details;

    public static Explanation match(float value, String description, Collection<Explanation> details) {
        return new Explanation(true, value, description, details);
    }

    public static Explanation match(float value, String description, Explanation ... details) {
        return new Explanation(true, value, description, Arrays.asList(details));
    }

    public static Explanation noMatch(String description, Collection<Explanation> details) {
        return new Explanation(false, 0.0f, description, details);
    }

    public static Explanation noMatch(String description, Explanation ... details) {
        return new Explanation(false, 0.0f, description, Arrays.asList(details));
    }

    private Explanation(boolean match, float value, String description, Collection<Explanation> details) {
        this.match = match;
        this.value = value;
        this.description = Objects.requireNonNull(description);
        this.details = Collections.unmodifiableList(new ArrayList<Explanation>(details));
        for (Explanation detail : details) {
            Objects.requireNonNull(detail);
        }
    }

    public boolean isMatch() {
        return this.match;
    }

    public float getValue() {
        return this.value;
    }

    public String getDescription() {
        return this.description;
    }

    private String getSummary() {
        return this.getValue() + " = " + this.getDescription();
    }

    public Explanation[] getDetails() {
        return this.details.toArray(new Explanation[0]);
    }

    public String toString() {
        return this.toString(0);
    }

    private String toString(int depth) {
        StringBuilder buffer = new StringBuilder();
        for (int i = 0; i < depth; ++i) {
            buffer.append("  ");
        }
        buffer.append(this.getSummary());
        buffer.append("\n");
        Explanation[] details = this.getDetails();
        for (int i = 0; i < details.length; ++i) {
            buffer.append(details[i].toString(depth + 1));
        }
        return buffer.toString();
    }

    public String toHtml() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("<ul>\n");
        buffer.append("<li>");
        buffer.append(this.getSummary());
        buffer.append("<br />\n");
        Explanation[] details = this.getDetails();
        for (int i = 0; i < details.length; ++i) {
            buffer.append(details[i].toHtml());
        }
        buffer.append("</li>\n");
        buffer.append("</ul>\n");
        return buffer.toString();
    }
}

