/*
 * Decompiled with CFR 0.152.
 */
package gplx.xowa;

import gplx.xowa.Xowa_tcp_receiver;
import gplx.xowa.Xowa_tcp_sender;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;

public class Xowa_tcp_console {
    private int server_send_port;
    private int server_recv_port;
    private String wiki_domain;
    private int max_length;
    private Xowa_tcp_sender sender;

    public static void main(String[] args) {
        Xowa_tcp_console console = new Xowa_tcp_console();
        console.Run(args);
    }

    public void Run(String[] args) {
        Xowa_tcp_console.Print_message_line("XOWA TCP client v0.0.0.0");
        if (!this.Parse_args(args)) {
            Xowa_tcp_console.Print_message_line("XOWA console requires 4 args: server_send_port, server_recv_port, wiki_domain, max_length.");
            Xowa_tcp_console.Print_message_line("For example, use '55000 55001 simple.wikipedia.org 1000'");
            return;
        }
        this.sender = new Xowa_tcp_sender(this.server_send_port);
        BufferedReader input = new BufferedReader(new InputStreamReader(System.in));
        Xowa_tcp_console.Print_message_line("Enter page name. For example 'Earth'. Press Ctrl+C to exit. Enter '|server_stop' to stop server or '|exit' to exit.");
        Xowa_tcp_console.Print_message("> ");
        try {
            String page;
            while ((page = Xowa_tcp_console.Read_string(input)) != null && !"|exit".equals(page)) {
                if ("|server_stop".equals(page)) {
                    this.Send_message_server_stop();
                    continue;
                }
                this.Send_message_fetch_page(page);
            }
        }
        catch (Exception e) {
            Xowa_tcp_console.Print_error(e);
        }
    }

    private void Send_message_fetch_page(String page) {
        Xowa_tcp_console.Print_message_line("Sending request for " + page);
        String command = String.format("app.shell.fetch_page('%s/wiki/%s', 'wiki');", this.wiki_domain, page);
        this.Send_message(command);
    }

    private void Send_message_server_stop() {
        Xowa_tcp_console.Print_message_line("Sending request to stop server");
        this.Send_message("app.server.stop;");
    }

    private void Send_message(String command) {
        String id = "id_is_for_client_usage";
        String time = "time_is_for_client_usage";
        String body = String.format("xowa.cmd.exec|%s|xowa_tcp_console|xowa_server|%s|%s", id, time, command);
        int body_len = body.length();
        int cksum = body_len * 2 + 1;
        String msg = String.format("0|%s|%s|%s", String.format("%010d", body_len), String.format("%010d", cksum), body);
        Xowa_tcp_receiver receiver = new Xowa_tcp_receiver(this.server_recv_port, this.max_length);
        new Thread(receiver).start();
        this.sender.Send_command(msg);
    }

    private boolean Parse_args(String[] args) {
        if (args.length != 4) {
            Xowa_tcp_console.Print_message_line("4 arguments must be supplied: " + args.length);
            return false;
        }
        this.server_send_port = Xowa_tcp_console.Parse_int(args[0]);
        if (this.server_send_port == -1) {
            return false;
        }
        this.server_recv_port = Xowa_tcp_console.Parse_int(args[1]);
        if (this.server_recv_port == -1) {
            return false;
        }
        this.wiki_domain = args[2];
        this.max_length = Xowa_tcp_console.Parse_int(args[3]);
        return this.max_length != -1;
    }

    private static int Parse_int(String raw) {
        try {
            return Integer.parseInt(raw);
        }
        catch (Exception e) {
            Xowa_tcp_console.Print_message_line("argument must be numeric: " + raw);
            return -1;
        }
    }

    private static String Read_string(BufferedReader input) {
        try {
            return input.readLine();
        }
        catch (IOException e) {
            return null;
        }
    }

    public static void Print_message_line(String msg) {
        System.out.println(msg);
    }

    public static void Print_message(String msg) {
        System.out.print(msg);
    }

    public static void Print_error(Exception e) {
        System.err.println(e.getMessage());
    }

    public static void Sleep(long millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException e) {
            Xowa_tcp_console.Print_error(e);
        }
    }
}

