/*
 * Decompiled with CFR 0.152.
 */
package gplx.xowa.xtns.wbases.claims.itms;

import gplx.Bry_;
import gplx.Bry_bfr;
import gplx.Err_;
import gplx.Gfo_usr_dlg_;
import gplx.String_;
import gplx.core.brys.fmtrs.Bry_fmtr;
import gplx.xowa.Xoa_app_;
import gplx.xowa.xtns.wbases.claims.Wbase_claim_visitor;
import gplx.xowa.xtns.wbases.claims.enums.Wbase_claim_type_;
import gplx.xowa.xtns.wbases.claims.enums.Wbase_claim_value_type_;
import gplx.xowa.xtns.wbases.claims.itms.Wbase_claim_base;
import gplx.xowa.xtns.wbases.claims.itms.times.Wbase_date;
import gplx.xowa.xtns.wbases.claims.itms.times.Wbase_date_;
import gplx.xowa.xtns.wbases.hwtrs.Wdata_hwtr_msgs;

public class Wbase_claim_time
extends Wbase_claim_base {
    private final byte[] time;
    private final byte[] before;
    private final byte[] after;
    private final byte[] precision;
    private final byte[] calendar;
    private byte[] calendar_ttl;
    private Wbase_date time_as_date;
    private int precision_int = Integer.MIN_VALUE;
    private int before_int = Integer.MIN_VALUE;
    private int after_int = Integer.MIN_VALUE;
    public static final byte[] Calendar_julian = Bry_.new_a7("http://www.wikidata.org/entity/Q1985786");

    public Wbase_claim_time(int n, byte by, byte[] byArray, byte[] byArray2, byte[] byArray3, byte[] byArray4, byte[] byArray5, byte[] byArray6) {
        super(n, by);
        this.time = byArray;
        this.before = byArray3;
        this.after = byArray4;
        this.precision = byArray5;
        this.calendar = byArray6;
    }

    @Override
    public byte Val_tid() {
        return 4;
    }

    public byte[] Time() {
        return this.time;
    }

    public byte[] Before() {
        return this.before;
    }

    public byte[] After() {
        return this.after;
    }

    public byte[] Precision() {
        return this.precision;
    }

    public byte[] Calendar() {
        return this.calendar;
    }

    public byte[] Calendar_ttl() {
        return this.calendar_ttl;
    }

    public boolean Calendar_is_julian() {
        return Bry_.Eq(this.calendar, Calendar_julian);
    }

    public void Calendar_ttl_(byte[] byArray) {
        this.calendar_ttl = byArray;
    }

    public Wbase_date Time_as_date() {
        if (this.time_as_date == null) {
            this.time_as_date = Wbase_date_.Parse(this.time, this.Precision_int(), this.Before_int(), this.After_int(), this.Calendar_is_julian());
        }
        return this.time_as_date;
    }

    public int Precision_int() {
        if (this.precision_int == Integer.MIN_VALUE) {
            this.precision_int = Bry_.To_int_or(this.precision, -1);
            if (this.precision_int == -1) {
                this.precision_int = 14;
                Gfo_usr_dlg_.Instance.Warn_many("", "", "unknown precision: ~{0}", String_.new_u8(this.precision));
            }
        }
        return this.precision_int;
    }

    public int Before_int() {
        if (this.before_int == Integer.MIN_VALUE) {
            this.before_int = Bry_.To_int_or(this.before, -1);
            if (this.before_int == -1) {
                this.before_int = 0;
                Gfo_usr_dlg_.Instance.Warn_many("", "", "unknown before: ~{0}", String_.new_u8(this.before));
            }
        }
        return this.before_int;
    }

    public int After_int() {
        if (this.after_int == Integer.MIN_VALUE) {
            this.after_int = Bry_.To_int_or(this.after, -1);
            if (this.after_int == -1) {
                this.after_int = 0;
                Gfo_usr_dlg_.Instance.Warn_many("", "", "unknown after: ~{0}", String_.new_u8(this.after));
            }
        }
        return this.after_int;
    }

    public void Write_to_bfr(Bry_bfr bry_bfr, Bry_bfr bry_bfr2, Bry_fmtr bry_fmtr, Wdata_hwtr_msgs wdata_hwtr_msgs, byte[] byArray) {
        try {
            Wbase_date wbase_date = this.Time_as_date();
            Wbase_date_.To_bfr(bry_bfr, bry_fmtr, bry_bfr2, wdata_hwtr_msgs, wbase_date);
        }
        catch (Exception exception) {
            Xoa_app_.Usr_dlg().Warn_many("", "", "failed to write time; ttl=~{0} pid=~{1} err=~{2}", byArray, this.Pid(), Err_.Message_gplx_log(exception));
        }
    }

    public static void Write_to_bfr(Bry_bfr bry_bfr, Bry_bfr bry_bfr2, Bry_fmtr bry_fmtr, Wdata_hwtr_msgs wdata_hwtr_msgs, byte[] byArray, byte[] byArray2, Wbase_date wbase_date, boolean bl) {
        try {
            Wbase_date_.To_bfr(bry_bfr, bry_fmtr, bry_bfr2, wdata_hwtr_msgs, wbase_date);
        }
        catch (Exception exception) {
            Xoa_app_.Usr_dlg().Warn_many("", "", "failed to write time; ttl=~{0} pid=~{1} err=~{2}", byArray, byArray2, Err_.Message_gplx_log(exception));
        }
    }

    @Override
    public void Welcome(Wbase_claim_visitor wbase_claim_visitor) {
        wbase_claim_visitor.Visit_time(this);
    }

    public String toString() {
        return String_.Concat_with_str("|", Wbase_claim_value_type_.Reg.Get_str_or_fail(this.Snak_tid()), Wbase_claim_type_.Reg.Get_str_or_fail(this.Val_tid()), String_.new_u8(this.time), String_.new_u8(this.before), String_.new_u8(this.after), String_.new_u8(this.precision), String_.new_u8(this.calendar));
    }
}

