/*
 * Decompiled with CFR 0.152.
 */
package gplx.xowa.xtns.scribunto.libs;

import gplx.Bool_;
import gplx.Bry_;
import gplx.Bry_bfr;
import gplx.Bry_find_;
import gplx.DateAdp;
import gplx.Datetime_now;
import gplx.Err_;
import gplx.Io_url;
import gplx.Keyval;
import gplx.Keyval_;
import gplx.String_;
import gplx.xowa.Xoa_ttl;
import gplx.xowa.Xowe_wiki;
import gplx.xowa.langs.Xol_lang_itm;
import gplx.xowa.langs.Xol_lang_itm_;
import gplx.xowa.langs.Xol_lang_stub;
import gplx.xowa.langs.Xol_lang_stub_;
import gplx.xowa.langs.durations.Xol_duration_itm;
import gplx.xowa.langs.durations.Xol_duration_itm_;
import gplx.xowa.langs.durations.Xol_interval_itm;
import gplx.xowa.xtns.pfuncs.times.Pft_fmt_itm;
import gplx.xowa.xtns.pfuncs.times.Pft_fmt_itm_;
import gplx.xowa.xtns.pfuncs.times.Pft_func_time;
import gplx.xowa.xtns.scribunto.Scrib_core;
import gplx.xowa.xtns.scribunto.Scrib_lib;
import gplx.xowa.xtns.scribunto.Scrib_lua_mod;
import gplx.xowa.xtns.scribunto.Scrib_lua_proc;
import gplx.xowa.xtns.scribunto.procs.Scrib_proc_args;
import gplx.xowa.xtns.scribunto.procs.Scrib_proc_mgr;
import gplx.xowa.xtns.scribunto.procs.Scrib_proc_rslt;

public class Scrib_lib_language
implements Scrib_lib {
    private Scrib_core core;
    private Scrib_lua_mod mod;
    private Scrib_lua_proc notify_lang_changed_fnc;
    private Scrib_proc_mgr procs = new Scrib_proc_mgr();
    private static final int Proc_getContLangCode = 0;
    private static final int Proc_isSupportedLanguage = 1;
    private static final int Proc_isKnownLanguageTag = 2;
    private static final int Proc_isValidCode = 3;
    private static final int Proc_isValidBuiltInCode = 4;
    private static final int Proc_fetchLanguageName = 5;
    private static final int Proc_fetchLanguageNames = 6;
    private static final int Proc_getFallbacksFor = 7;
    private static final int Proc_lcfirst = 8;
    private static final int Proc_ucfirst = 9;
    private static final int Proc_lc = 10;
    private static final int Proc_uc = 11;
    private static final int Proc_caseFold = 12;
    private static final int Proc_formatNum = 13;
    private static final int Proc_formatDate = 14;
    private static final int Proc_formatDuration = 15;
    private static final int Proc_getDurationIntervals = 16;
    private static final int Proc_parseFormattedNumber = 17;
    private static final int Proc_convertPlural = 18;
    private static final int Proc_convertGrammar = 19;
    private static final int Proc_gender = 20;
    private static final int Proc_isRTL = 21;
    public static final String Invk_getContLangCode = "getContLangCode";
    public static final String Invk_isSupportedLanguage = "isSupportedLanguage";
    public static final String Invk_isKnownLanguageTag = "isKnownLanguageTag";
    public static final String Invk_isValidCode = "isValidCode";
    public static final String Invk_isValidBuiltInCode = "isValidBuiltInCode";
    public static final String Invk_fetchLanguageName = "fetchLanguageName";
    public static final String Invk_fetchLanguageNames = "fetchLanguageNames";
    public static final String Invk_getFallbacksFor = "getFallbacksFor";
    public static final String Invk_lcfirst = "lcfirst";
    public static final String Invk_ucfirst = "ucfirst";
    public static final String Invk_lc = "lc";
    public static final String Invk_uc = "uc";
    public static final String Invk_caseFold = "caseFold";
    public static final String Invk_formatNum = "formatNum";
    public static final String Invk_formatDate = "formatDate";
    public static final String Invk_formatDuration = "formatDuration";
    public static final String Invk_getDurationIntervals = "getDurationIntervals";
    public static final String Invk_parseFormattedNumber = "parseFormattedNumber";
    public static final String Invk_convertPlural = "convertPlural";
    public static final String Invk_convertGrammar = "convertGrammar";
    public static final String Invk_gender = "gender";
    public static final String Invk_isRTL = "isRTL";
    private static final String[] Proc_names = String_.Ary("getContLangCode", "isSupportedLanguage", "isKnownLanguageTag", "isValidCode", "isValidBuiltInCode", "fetchLanguageName", "fetchLanguageNames", "getFallbacksFor", "lcfirst", "ucfirst", "lc", "uc", "caseFold", "formatNum", "formatDate", "formatDuration", "getDurationIntervals", "parseFormattedNumber", "convertPlural", "convertGrammar", "gender", "isRTL");

    public Scrib_lib_language(Scrib_core scrib_core) {
        this.core = scrib_core;
    }

    public Scrib_lua_mod Mod() {
        return this.mod;
    }

    @Override
    public Scrib_lib Init() {
        this.procs.Init_by_lib(this, Proc_names);
        return this;
    }

    @Override
    public Scrib_lib Clone_lib(Scrib_core scrib_core) {
        return new Scrib_lib_language(scrib_core);
    }

    @Override
    public Scrib_lua_mod Register(Scrib_core scrib_core, Io_url io_url) {
        this.Init();
        this.mod = scrib_core.RegisterInterface(this, io_url.GenSubFil("mw.language.lua"), new Keyval[0]);
        this.notify_lang_changed_fnc = this.mod.Fncs_get_by_key("notify_lang_changed");
        return this.mod;
    }

    @Override
    public Scrib_proc_mgr Procs() {
        return this.procs;
    }

    @Override
    public boolean Procs_exec(int n, Scrib_proc_args scrib_proc_args, Scrib_proc_rslt scrib_proc_rslt) {
        switch (n) {
            case 0: {
                return this.GetContLangCode(scrib_proc_args, scrib_proc_rslt);
            }
            case 1: {
                return this.IsSupportedLanguage(scrib_proc_args, scrib_proc_rslt);
            }
            case 2: {
                return this.IsKnownLanguageTag(scrib_proc_args, scrib_proc_rslt);
            }
            case 3: {
                return this.IsValidCode(scrib_proc_args, scrib_proc_rslt);
            }
            case 4: {
                return this.IsValidBuiltInCode(scrib_proc_args, scrib_proc_rslt);
            }
            case 5: {
                return this.FetchLanguageName(scrib_proc_args, scrib_proc_rslt);
            }
            case 6: {
                return this.FetchLanguageNames(scrib_proc_args, scrib_proc_rslt);
            }
            case 7: {
                return this.GetFallbacksFor(scrib_proc_args, scrib_proc_rslt);
            }
            case 8: {
                return this.Lcfirst(scrib_proc_args, scrib_proc_rslt);
            }
            case 9: {
                return this.Ucfirst(scrib_proc_args, scrib_proc_rslt);
            }
            case 10: {
                return this.Lc(scrib_proc_args, scrib_proc_rslt);
            }
            case 11: {
                return this.Uc(scrib_proc_args, scrib_proc_rslt);
            }
            case 12: {
                return this.CaseFold(scrib_proc_args, scrib_proc_rslt);
            }
            case 13: {
                return this.FormatNum(scrib_proc_args, scrib_proc_rslt);
            }
            case 14: {
                return this.FormatDate(scrib_proc_args, scrib_proc_rslt);
            }
            case 15: {
                return this.FormatDuration(scrib_proc_args, scrib_proc_rslt);
            }
            case 16: {
                return this.GetDurationIntervals(scrib_proc_args, scrib_proc_rslt);
            }
            case 17: {
                return this.ParseFormattedNumber(scrib_proc_args, scrib_proc_rslt);
            }
            case 18: {
                return this.ConvertPlural(scrib_proc_args, scrib_proc_rslt);
            }
            case 19: {
                return this.ConvertGrammar(scrib_proc_args, scrib_proc_rslt);
            }
            case 20: {
                return this.gender(scrib_proc_args, scrib_proc_rslt);
            }
            case 21: {
                return this.IsRTL(scrib_proc_args, scrib_proc_rslt);
            }
        }
        throw Err_.new_unhandled(n);
    }

    public void Notify_lang_changed() {
        if (this.notify_lang_changed_fnc != null) {
            this.core.Interpreter().CallFunction(this.notify_lang_changed_fnc.Id(), Keyval_.Ary_empty);
        }
    }

    public boolean GetContLangCode(Scrib_proc_args scrib_proc_args, Scrib_proc_rslt scrib_proc_rslt) {
        return scrib_proc_rslt.Init_obj(this.core.Ctx().Lang().Key_str());
    }

    public boolean IsSupportedLanguage(Scrib_proc_args scrib_proc_args, Scrib_proc_rslt scrib_proc_rslt) {
        return this.IsKnownLanguageTag(scrib_proc_args, scrib_proc_rslt);
    }

    public boolean IsKnownLanguageTag(Scrib_proc_args scrib_proc_args, Scrib_proc_rslt scrib_proc_rslt) {
        String string = scrib_proc_args.Cast_str_or_null(0);
        boolean bl = false;
        if (string != null && String_.Eq(string, String_.Lower(string)) && Xol_lang_stub_.Exists(Bry_.new_a7(string))) {
            bl = true;
        }
        return scrib_proc_rslt.Init_obj(bl);
    }

    public boolean IsValidCode(Scrib_proc_args scrib_proc_args, Scrib_proc_rslt scrib_proc_rslt) {
        boolean bl;
        byte[] byArray = scrib_proc_args.Pull_bry(0);
        boolean bl2 = bl = Xoa_ttl.Parse(this.core.Wiki(), byArray) != null;
        if (bl) {
            int n = byArray.length;
            for (int i = 0; i < n; ++i) {
                byte by = byArray[i];
                switch (by) {
                    case 0: 
                    case 34: 
                    case 38: 
                    case 39: 
                    case 47: 
                    case 58: 
                    case 60: 
                    case 62: 
                    case 92: {
                        bl = false;
                        i = n;
                    }
                }
            }
        }
        return scrib_proc_rslt.Init_obj(bl);
    }

    public boolean IsValidBuiltInCode(Scrib_proc_args scrib_proc_args, Scrib_proc_rslt scrib_proc_rslt) {
        byte[] byArray = scrib_proc_args.Pull_bry(0);
        int n = byArray.length;
        boolean bl = true;
        block3: for (int i = 0; i < n; ++i) {
            byte by = byArray[i];
            if (by == 45) continue;
            byte by2 = Xol_lang_itm_.Char_tid(by);
            switch (by2) {
                case 0: 
                case 1: 
                case 2: {
                    continue block3;
                }
                default: {
                    bl = false;
                    i = n;
                }
            }
        }
        return scrib_proc_rslt.Init_obj(bl);
    }

    public boolean FetchLanguageName(Scrib_proc_args scrib_proc_args, Scrib_proc_rslt scrib_proc_rslt) {
        byte[] byArray = scrib_proc_args.Pull_bry(0);
        Xol_lang_stub xol_lang_stub = Xol_lang_stub_.Get_by_key_or_null(byArray);
        String string = null;
        if (xol_lang_stub == null) {
            int n = byArray.length;
            int n2 = n < 3 ? n : 3;
            string = String_.new_u8(Bry_.Mid(byArray, 0, n2));
        } else {
            string = String_.new_u8(xol_lang_stub.Canonical_name());
        }
        return scrib_proc_rslt.Init_obj(string);
    }

    public boolean FetchLanguageNames(Scrib_proc_args scrib_proc_args, Scrib_proc_rslt scrib_proc_rslt) {
        return scrib_proc_rslt.Init_obj(this.core.Wiki().Cache_mgr().Scrib_lang_names());
    }

    public boolean GetFallbacksFor(Scrib_proc_args scrib_proc_args, Scrib_proc_rslt scrib_proc_rslt) {
        byte[] byArray = scrib_proc_args.Pull_bry(0);
        Xol_lang_itm xol_lang_itm = this.core.App().Lang_mgr().Get_by(byArray);
        if (xol_lang_itm == null) {
            return scrib_proc_rslt.Init_many_empty();
        }
        return scrib_proc_rslt.Init_bry_ary(xol_lang_itm.Fallback_bry_ary());
    }

    public boolean Lcfirst(Scrib_proc_args scrib_proc_args, Scrib_proc_rslt scrib_proc_rslt) {
        return this.Case_1st(scrib_proc_args, scrib_proc_rslt, false);
    }

    public boolean Ucfirst(Scrib_proc_args scrib_proc_args, Scrib_proc_rslt scrib_proc_rslt) {
        return this.Case_1st(scrib_proc_args, scrib_proc_rslt, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean Case_1st(Scrib_proc_args scrib_proc_args, Scrib_proc_rslt scrib_proc_rslt, boolean bl) {
        Xol_lang_itm xol_lang_itm = this.lang_(scrib_proc_args);
        byte[] byArray = scrib_proc_args.Pull_bry(1);
        Bry_bfr bry_bfr = this.core.Wiki().Utl__bfr_mkr().Get_b128();
        try {
            boolean bl2 = scrib_proc_rslt.Init_obj(xol_lang_itm.Case_mgr().Case_build_1st(bry_bfr, bl, byArray, 0, byArray.length));
            return bl2;
        }
        finally {
            bry_bfr.Mkr_rls();
        }
    }

    public boolean Lc(Scrib_proc_args scrib_proc_args, Scrib_proc_rslt scrib_proc_rslt) {
        return this.Case_all(scrib_proc_args, scrib_proc_rslt, false);
    }

    public boolean Uc(Scrib_proc_args scrib_proc_args, Scrib_proc_rslt scrib_proc_rslt) {
        return this.Case_all(scrib_proc_args, scrib_proc_rslt, true);
    }

    private boolean Case_all(Scrib_proc_args scrib_proc_args, Scrib_proc_rslt scrib_proc_rslt, boolean bl) {
        Xol_lang_itm xol_lang_itm = this.lang_(scrib_proc_args);
        byte[] byArray = scrib_proc_args.Pull_bry(1);
        return scrib_proc_rslt.Init_obj(xol_lang_itm.Case_mgr().Case_build(bl, byArray, 0, byArray.length));
    }

    public boolean CaseFold(Scrib_proc_args scrib_proc_args, Scrib_proc_rslt scrib_proc_rslt) {
        return this.Uc(scrib_proc_args, scrib_proc_rslt);
    }

    public boolean FormatNum(Scrib_proc_args scrib_proc_args, Scrib_proc_rslt scrib_proc_rslt) {
        Object object;
        Keyval[] keyvalArray;
        Xol_lang_itm xol_lang_itm = this.lang_(scrib_proc_args);
        byte[] byArray = scrib_proc_args.Xstr_bry_or_null(1);
        boolean bl = false;
        if (byArray != null && (keyvalArray = scrib_proc_args.Cast_kv_ary_or_null(2)) != null && (object = Keyval_.Ary_get_by_key_or_null(keyvalArray, "noCommafy")) != null) {
            bl = Bool_.Cast(object);
        }
        keyvalArray = (Keyval[])xol_lang_itm.Num_mgr().Format_num(byArray, bl);
        return scrib_proc_rslt.Init_obj(keyvalArray);
    }

    public boolean FormatDate(Scrib_proc_args scrib_proc_args, Scrib_proc_rslt scrib_proc_rslt) {
        Xol_lang_itm xol_lang_itm = this.lang_(scrib_proc_args);
        byte[] byArray = scrib_proc_args.Pull_bry(1);
        byte[] byArray2 = scrib_proc_args.Cast_bry_or_empty(2);
        boolean bl = scrib_proc_args.Cast_bool_or_n(3);
        Xowe_wiki xowe_wiki = this.core.Wiki();
        Bry_bfr bry_bfr = xowe_wiki.Utl__bfr_mkr().Get_b512();
        Pft_fmt_itm[] pft_fmt_itmArray = Pft_fmt_itm_.Parse(this.core.Ctx(), byArray);
        DateAdp dateAdp = null;
        if (Bry_.Len_eq_0(byArray2)) {
            dateAdp = Datetime_now.Get();
        } else {
            int n;
            if (byArray2[0] == 43 && byArray2[(n = byArray2.length) - 1] == 90 && byArray2[n - 10] == 84) {
                int n2 = Bry_find_.Find_fwd_while(byArray2, 1, n, (byte)48);
                byArray2 = Bry_.Mid(byArray2, n2);
            }
            dateAdp = Pft_func_time.ParseDate(byArray2, bl, bry_bfr);
        }
        if (dateAdp == null || bry_bfr.Len() > 0) {
            bry_bfr.Mkr_rls();
            return scrib_proc_rslt.Init_fail("bad argument #2 to 'formatDate' (not a valid timestamp)");
        }
        xowe_wiki.Parser_mgr().Date_fmt_bldr().Format(bry_bfr, xowe_wiki, xol_lang_itm, dateAdp, pft_fmt_itmArray);
        byte[] byArray3 = bry_bfr.To_bry_and_rls();
        return scrib_proc_rslt.Init_obj(byArray3);
    }

    public boolean ParseFormattedNumber(Scrib_proc_args scrib_proc_args, Scrib_proc_rslt scrib_proc_rslt) {
        Xol_lang_itm xol_lang_itm = this.lang_(scrib_proc_args);
        byte[] byArray = scrib_proc_args.Xstr_bry_or_null(1);
        if (byArray == null) {
            return scrib_proc_rslt.Init_null();
        }
        byte[] byArray2 = xol_lang_itm.Num_mgr().Raw(byArray);
        return scrib_proc_rslt.Init_obj(byArray2);
    }

    public boolean FormatDuration(Scrib_proc_args scrib_proc_args, Scrib_proc_rslt scrib_proc_rslt) {
        Xol_lang_itm xol_lang_itm = this.lang_(scrib_proc_args);
        long l = scrib_proc_args.Pull_long(1);
        Keyval[] keyvalArray = scrib_proc_args.Cast_kv_ary_or_null(2);
        Xol_duration_itm[] xol_duration_itmArray = Xol_duration_itm_.Xto_itm_ary(keyvalArray);
        byte[] byArray = xol_lang_itm.Duration_mgr().Format_durations(this.core.Ctx(), l, xol_duration_itmArray);
        return scrib_proc_rslt.Init_obj(byArray);
    }

    public boolean GetDurationIntervals(Scrib_proc_args scrib_proc_args, Scrib_proc_rslt scrib_proc_rslt) {
        Xol_lang_itm xol_lang_itm = this.lang_(scrib_proc_args);
        long l = scrib_proc_args.Pull_long(1);
        Keyval[] keyvalArray = scrib_proc_args.Cast_kv_ary_or_null(2);
        Xol_duration_itm[] xol_duration_itmArray = Xol_duration_itm_.Xto_itm_ary(keyvalArray);
        Xol_interval_itm[] xol_interval_itmArray = xol_lang_itm.Duration_mgr().Get_duration_intervals(l, xol_duration_itmArray);
        return scrib_proc_rslt.Init_obj(Xol_interval_itm.Xto_kv_ary(xol_interval_itmArray));
    }

    public boolean ConvertPlural(Scrib_proc_args scrib_proc_args, Scrib_proc_rslt scrib_proc_rslt) {
        Xol_lang_itm xol_lang_itm = this.lang_(scrib_proc_args);
        int n = scrib_proc_args.Pull_int(1);
        byte[][] byArray = scrib_proc_args.Cast_params_as_bry_ary_or_rest_of_ary(2);
        byte[] byArray2 = xol_lang_itm.Plural().Plural_eval(xol_lang_itm, n, byArray);
        return scrib_proc_rslt.Init_obj(byArray2);
    }

    public boolean ConvertGrammar(Scrib_proc_args scrib_proc_args, Scrib_proc_rslt scrib_proc_rslt) {
        Xol_lang_itm xol_lang_itm = this.lang_(scrib_proc_args);
        byte[] byArray = scrib_proc_args.Pull_bry(1);
        byte[] byArray2 = scrib_proc_args.Pull_bry(2);
        Bry_bfr bry_bfr = this.core.Wiki().Utl__bfr_mkr().Get_b512();
        xol_lang_itm.Grammar().Grammar_eval(bry_bfr, xol_lang_itm, byArray, byArray2);
        return scrib_proc_rslt.Init_obj(bry_bfr.To_str_and_rls());
    }

    public boolean gender(Scrib_proc_args scrib_proc_args, Scrib_proc_rslt scrib_proc_rslt) {
        throw Err_.new_unimplemented();
    }

    public boolean IsRTL(Scrib_proc_args scrib_proc_args, Scrib_proc_rslt scrib_proc_rslt) {
        Xol_lang_itm xol_lang_itm = this.lang_(scrib_proc_args);
        return scrib_proc_rslt.Init_obj(!xol_lang_itm.Dir_ltr());
    }

    private Xol_lang_itm lang_(Scrib_proc_args scrib_proc_args) {
        Xol_lang_itm xol_lang_itm;
        byte[] byArray = scrib_proc_args.Cast_bry_or_null(0);
        Xol_lang_itm xol_lang_itm2 = xol_lang_itm = byArray == null ? null : this.core.App().Lang_mgr().Get_by_or_load(byArray);
        if (xol_lang_itm == null) {
            throw Err_.new_wo_type("lang_code is not valid", "lang_code", String_.new_u8(byArray));
        }
        return xol_lang_itm;
    }
}

