/*
 * Decompiled with CFR 0.152.
 */
package gplx.xowa.xtns.math.bldrs;

import gplx.Bry_;
import gplx.Bry_bfr;
import gplx.Bry_bfr_;
import gplx.Bry_find_;
import gplx.Byte_ascii;
import gplx.Err_;
import gplx.Gfo_usr_dlg_;
import gplx.dbs.Db_conn;
import gplx.dbs.Db_rdr;
import gplx.xowa.Xowe_wiki;
import gplx.xowa.bldrs.Xob_db_file;
import gplx.xowa.parsers.logs.Xop_log_basic_tbl;
import gplx.xowa.xtns.math.texvcs.Texvc_checker;
import gplx.xowa.xtns.math.texvcs.Texvc_ctx;
import gplx.xowa.xtns.math.texvcs.Texvc_parser;
import gplx.xowa.xtns.math.texvcs.tkns.Texvc_root;

class Xomath_check_mgr {
    private int count_total;
    private int count_xnde_invalid;
    private int count_xnde_w_atrs;
    private int count_texvc_invalid;
    private int count_texvc_adjusted;
    private final byte[] math_lhs_bry = Bry_.new_a7("<math");
    private final byte[] math_rhs_bry = Bry_.new_a7("</math>");
    private final byte[] nl_repl_bry = Bry_.new_a7("    ");
    private final Texvc_parser parser = new Texvc_parser();
    private final Texvc_checker checker = new Texvc_checker();
    private final Texvc_ctx ctx = new Texvc_ctx();
    private final Bry_bfr tmp_bfr = Bry_bfr_.New();

    Xomath_check_mgr() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void Exec(Xowe_wiki xowe_wiki) {
        Xob_db_file xob_db_file = Xob_db_file.New__file_make(xowe_wiki.Fsys_mgr().Root_dir());
        Db_conn db_conn = xob_db_file.Conn();
        Xop_log_basic_tbl xop_log_basic_tbl = new Xop_log_basic_tbl(db_conn);
        Db_rdr db_rdr = db_conn.Stmt_select_all(xop_log_basic_tbl.Tbl_name(), xop_log_basic_tbl.flds).Exec_select__rls_auto();
        try {
            while (db_rdr.Move_next()) {
                int n = db_rdr.Read_int(xop_log_basic_tbl.fld__page_id);
                byte[] byArray = db_rdr.Read_bry_by_str(xop_log_basic_tbl.fld__src_str);
                ++this.count_total;
                if ((byArray = this.Assert_flanking_math_ndes(n, byArray)) == null) {
                    ++this.count_xnde_invalid;
                    continue;
                }
                this.Check_texvc(n, byArray);
            }
        }
        finally {
            db_rdr.Rls();
        }
        Gfo_usr_dlg_.Instance.Note_many("", "", "done: total=~{0}, xnde_invalid=~{1} xnde_w_atrs=~{2} texvc_invalid=~{3} texvc_adjusted=~{4}", this.count_total, this.count_xnde_invalid, this.count_xnde_w_atrs, this.count_texvc_invalid, this.count_texvc_adjusted);
    }

    private byte[] Assert_flanking_math_ndes(int n, byte[] byArray) {
        if (!Bry_.Has_at_bgn(byArray, this.math_lhs_bry)) {
            Gfo_usr_dlg_.Instance.Warn_many("", "", "math.check:xnde_invalid b/c '<math' is not at beginning; page_id=~{0}, src=~{1}", n, Bry_.Replace(byArray, Byte_ascii.Nl_bry, this.nl_repl_bry));
            return null;
        }
        if (!Bry_.Has_at_end(byArray, this.math_rhs_bry)) {
            Gfo_usr_dlg_.Instance.Warn_many("", "", "math.check:xnde_invalid b/c '</math>' is not at end; page_id=~{0}, src=~{1}", n, Bry_.Replace(byArray, Byte_ascii.Nl_bry, this.nl_repl_bry));
            return null;
        }
        int n2 = Bry_find_.Find_fwd(byArray, Byte_ascii.Gt_bry, this.math_lhs_bry.length);
        if (n2 != this.math_lhs_bry.length) {
            ++this.count_xnde_w_atrs;
            Gfo_usr_dlg_.Instance.Log_many("", "", "math.check:xnde_w_atrs; page_id=~{0}, src=~{1}", n, Bry_.Replace(byArray, Byte_ascii.Nl_bry, this.nl_repl_bry));
        }
        return Bry_.Mid(byArray, n2 + 1, byArray.length - this.math_rhs_bry.length);
    }

    private void Check_texvc(int n, byte[] byArray) {
        try {
            Texvc_root texvc_root = new Texvc_root();
            this.ctx.Clear();
            this.parser.Parse(this.ctx, texvc_root, byArray);
            this.checker.Check(byArray, texvc_root);
            this.tmp_bfr.Clear();
            texvc_root.Print_tex_bry(this.tmp_bfr, byArray, 0);
            byte[] byArray2 = this.tmp_bfr.To_bry_and_clear();
            if (!Bry_.Eq(byArray, byArray2)) {
                ++this.count_texvc_adjusted;
                Gfo_usr_dlg_.Instance.Log_many("", "", "math.check:texvc_adjusted; page_id=~{0}, src=~{1} texvc=~{2}", n, Bry_.Replace(byArray, Byte_ascii.Nl_bry, this.nl_repl_bry), Bry_.Replace(byArray2, Byte_ascii.Nl_bry, this.nl_repl_bry));
            }
        }
        catch (Exception exception) {
            ++this.count_texvc_invalid;
            Gfo_usr_dlg_.Instance.Warn_many("", "", "math.check:texvc_invalid; page_id=~{0}, src=~{1} err=~{2}", n, Bry_.Replace(byArray, Byte_ascii.Nl_bry, this.nl_repl_bry), Err_.Message_gplx_log(exception));
        }
    }
}

