/*
 * Decompiled with CFR 0.152.
 */
package gplx.xowa.wikis.data.tbls;

import gplx.Err_;
import gplx.Guid_adp;
import gplx.Guid_adp_;
import gplx.Io_url;
import gplx.List_adp;
import gplx.List_adp_;
import gplx.String_;
import gplx.dbs.Db_conn;
import gplx.dbs.Db_rdr;
import gplx.dbs.Db_stmt;
import gplx.dbs.Db_stmt_bldr;
import gplx.dbs.Db_tbl;
import gplx.dbs.Db_tbl_owner;
import gplx.dbs.Dbmeta_fld_itm;
import gplx.dbs.Dbmeta_fld_list;
import gplx.dbs.Dbmeta_idx_itm;
import gplx.dbs.Dbmeta_tbl_itm;
import gplx.dbs.utls.Db_tbl__crud_;
import gplx.xowa.wikis.data.Xow_db_file;
import gplx.xowa.wikis.data.Xow_db_mgr;
import gplx.xowa.wikis.data.Xowd_core_db_props;
import gplx.xowa.wikis.data.tbls.Xow_db_file_sorter__id;

public class Xowd_xowa_db_tbl
implements Db_tbl {
    public static final String Fld_id = "db_id";
    public static final String Fld_type = "db_type";
    public static final String Fld_url = "db_url";
    private final Dbmeta_fld_list flds = new Dbmeta_fld_list();
    private final String fld_id;
    private final String fld_type;
    private final String fld_url;
    private final String fld_ns_ids;
    private final String fld_part_id;
    private final String fld_guid;
    private boolean schema_is_1;
    private final Db_conn conn;
    private final Db_stmt_bldr stmt_bldr = new Db_stmt_bldr();
    private final String tbl_name;
    public static final String TBL_NAME = "xowa_db";

    public Xowd_xowa_db_tbl(Db_conn db_conn, boolean bl) {
        this.conn = db_conn;
        this.schema_is_1 = bl;
        this.tbl_name = TBL_NAME;
        this.fld_id = this.flds.Add_int_pkey(Fld_id);
        this.fld_type = this.flds.Add_byte(Fld_type);
        this.fld_url = this.flds.Add_str(Fld_url, 512);
        if (bl) {
            this.fld_part_id = this.fld_guid = Dbmeta_fld_itm.Key_null;
            this.fld_ns_ids = this.fld_guid;
        } else {
            this.fld_ns_ids = this.flds.Add_str("db_ns_ids", 255);
            this.fld_part_id = this.flds.Add_int("db_part_id");
            this.fld_guid = this.flds.Add_str("db_guid", 36);
        }
        this.stmt_bldr.Conn_(db_conn, this.tbl_name, this.flds, this.fld_id);
    }

    @Override
    public String Tbl_name() {
        return this.tbl_name;
    }

    @Override
    public void Create_tbl() {
        this.conn.Meta_tbl_create(Dbmeta_tbl_itm.New(this.tbl_name, this.flds, new Dbmeta_idx_itm[0]));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Xow_db_file[] Select_all(Xowd_core_db_props xowd_core_db_props, Io_url io_url) {
        List_adp list_adp = List_adp_.New();
        Db_rdr db_rdr = this.conn.Stmt_select(this.tbl_name, this.flds, new String[0]).Exec_select__rls_auto();
        try {
            while (db_rdr.Move_next()) {
                String string = "";
                int n = -1;
                Guid_adp guid_adp = Guid_adp_.Empty;
                if (!this.schema_is_1) {
                    string = db_rdr.Read_str(this.fld_ns_ids);
                    n = db_rdr.Read_int(this.fld_part_id);
                    guid_adp = Guid_adp_.Parse(db_rdr.Read_str(this.fld_guid));
                }
                int n2 = db_rdr.Read_int(this.fld_id);
                Xow_db_file xow_db_file = Xow_db_file.Load(xowd_core_db_props, n2, db_rdr.Read_byte(this.fld_type), io_url.GenSubFil(db_rdr.Read_str(this.fld_url)), string, n, guid_adp);
                list_adp.Add(xow_db_file);
            }
        }
        finally {
            db_rdr.Rls();
        }
        list_adp.Sort_by(Xow_db_file_sorter__id.Instance);
        return (Xow_db_file[])list_adp.To_ary_and_clear(Xow_db_file.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void Commit_all(Xow_db_mgr xow_db_mgr) {
        this.stmt_bldr.Batch_bgn();
        try {
            int n = xow_db_mgr.Dbs__len();
            for (int i = 0; i < n; ++i) {
                this.Commit_itm(xow_db_mgr.Dbs__get_at(i));
            }
        }
        finally {
            this.stmt_bldr.Batch_end();
        }
    }

    public void Upsert(int n, byte by, String string, String string2, int n2, String string3) {
        Db_tbl__crud_.Upsert(this.conn, this.tbl_name, this.flds, String_.Ary(this.fld_id), n, by, string, string2, n2, string3);
    }

    private void Commit_itm(Xow_db_file xow_db_file) {
        Db_stmt db_stmt = this.stmt_bldr.Get(xow_db_file.Cmd_mode());
        switch (xow_db_file.Cmd_mode()) {
            case 1: {
                db_stmt.Clear().Val_int(this.fld_id, xow_db_file.Id());
                this.Commit_itm_vals(db_stmt, xow_db_file);
                db_stmt.Exec_insert();
                break;
            }
            case 2: {
                db_stmt.Clear();
                this.Commit_itm_vals(db_stmt, xow_db_file);
                db_stmt.Crt_int(this.fld_id, xow_db_file.Id()).Exec_update();
                break;
            }
            case 3: {
                db_stmt.Clear().Crt_int(this.fld_id, xow_db_file.Id()).Exec_delete();
                break;
            }
            case 4: {
                break;
            }
            default: {
                throw Err_.new_unhandled(xow_db_file.Cmd_mode());
            }
        }
        xow_db_file.Cmd_mode_((byte)4);
    }

    private void Commit_itm_vals(Db_stmt db_stmt, Xow_db_file xow_db_file) {
        db_stmt.Val_byte(this.fld_type, xow_db_file.Tid()).Val_str(this.fld_url, xow_db_file.Url_rel()).Val_str(this.fld_ns_ids, xow_db_file.Ns_ids()).Val_int(this.fld_part_id, xow_db_file.Part_id()).Val_str(this.fld_guid, xow_db_file.Guid().To_str());
    }

    @Override
    public void Rls() {
    }

    public static Xowd_xowa_db_tbl Get_by_key(Db_tbl_owner db_tbl_owner) {
        return (Xowd_xowa_db_tbl)db_tbl_owner.Tbls__get_by_key(TBL_NAME);
    }
}

