/*
 * Decompiled with CFR 0.152.
 */
package gplx.xowa.parsers.vnts;

import gplx.Bry_;
import gplx.Bry_bfr;
import gplx.Bry_bfr_;
import gplx.Bry_find_;
import gplx.Err_;
import gplx.core.btries.Btrie_fast_mgr;
import gplx.core.primitives.Byte_obj_val;
import gplx.dbs.Db_conn;
import gplx.xowa.langs.vnts.Xol_vnt_itm;
import gplx.xowa.langs.vnts.Xol_vnt_regy;
import gplx.xowa.langs.vnts.converts.Xol_convert_mgr;
import gplx.xowa.langs.vnts.converts.Xol_convert_wkr;
import gplx.xowa.parsers.htmls.Mwh_doc_parser;
import gplx.xowa.parsers.vnts.Vnt_convert_rule;
import gplx.xowa.parsers.vnts.Vnt_html_doc_wkr;
import gplx.xowa.parsers.vnts.Vnt_log_mgr;
import gplx.xowa.parsers.vnts.Vnt_rule_undi_grp;
import gplx.xowa.parsers.vnts.Vnt_rule_undi_itm;
import gplx.xowa.parsers.vnts.Vnt_rule_undi_mgr;

public class Vnt_convert_lang {
    private final Xol_convert_mgr convert_mgr;
    private final Xol_vnt_regy vnt_regy;
    private final Vnt_convert_rule converter_rule;
    private final Vnt_html_doc_wkr html_convert_wkr;
    private final Mwh_doc_parser doc_parser = new Mwh_doc_parser();
    private final Bry_bfr bfr = Bry_bfr_.New_w_size(255);
    private final Bry_bfr tmp_frame_bfr = Bry_bfr_.New_w_size(255);
    private final Bry_bfr tmp_convert_bfr = Bry_bfr_.New_w_size(255);
    private byte[] src;
    private int src_len;
    private int pos;
    private Vnt_log_mgr log_mgr;
    private int tag_bgn;
    private int tag_end;
    private byte[] converted_title;
    private static final byte Tid__curly_bgn = 1;
    private static final byte Tid__curly_end = 2;
    private static final byte[] Bry__curly_bgn = Bry_.new_a7("-{");
    private static final byte[] Bry__curly_end = Bry_.new_a7("}-");
    private static final Btrie_fast_mgr trie = Btrie_fast_mgr.cs().Add_bry_byte(Bry__curly_bgn, (byte)1).Add_bry_byte(Bry__curly_end, (byte)2);
    private static final int max_depth = 32;

    public Vnt_convert_lang(Xol_convert_mgr xol_convert_mgr, Xol_vnt_regy xol_vnt_regy) {
        this.convert_mgr = xol_convert_mgr;
        this.vnt_regy = xol_vnt_regy;
        this.html_convert_wkr = new Vnt_html_doc_wkr(xol_convert_mgr, xol_vnt_regy);
        this.converter_rule = new Vnt_convert_rule(this, xol_vnt_regy, this.log_mgr);
    }

    public byte[] Converted_title() {
        return this.converted_title;
    }

    public void Log__init(Db_conn db_conn) {
        this.log_mgr = new Vnt_log_mgr();
        this.log_mgr.Init_by_db(db_conn, this.vnt_regy);
    }

    public byte[] Parse_page(Xol_vnt_itm xol_vnt_itm, int n, byte[] byArray) {
        if (this.log_mgr != null) {
            this.log_mgr.Init_by_page(n);
        }
        this.converted_title = null;
        return this.Parse_bry(xol_vnt_itm, byArray);
    }

    public byte[] Parse_bry(Xol_vnt_itm xol_vnt_itm, byte[] byArray) {
        boolean bl = true;
        this.pos = 0;
        this.src = byArray;
        this.src_len = byArray.length;
        while (this.pos < this.src_len) {
            int n = Bry_find_.Find_fwd(byArray, Bry__curly_bgn, this.pos, this.src_len);
            if (n == -1) {
                this.Add_output(xol_vnt_itm, bl, byArray, this.pos, this.src_len);
                return this.bfr.To_bry_and_clear();
            }
            boolean bl2 = this.Is_inside_tag(this.pos, n);
            if (bl2) {
                this.Add_output(xol_vnt_itm, bl, byArray, this.pos, this.tag_bgn);
                this.Auto_convert(this.bfr, xol_vnt_itm, byArray, this.tag_bgn, this.tag_end);
                this.pos = this.tag_end;
                continue;
            }
            this.Add_output(xol_vnt_itm, bl, byArray, this.pos, n);
            this.pos = n;
            this.bfr.Add(this.Parse_recursive(this.tmp_frame_bfr, xol_vnt_itm, 1));
        }
        return this.bfr.To_bry_and_clear();
    }

    private boolean Is_inside_tag(int n, int n2) {
        byte by;
        if (n2 == 0 || n2 == n) {
            return false;
        }
        int n3 = n2 - 1;
        this.tag_end = -1;
        this.tag_bgn = -1;
        boolean bl = true;
        while (bl) {
            by = this.src[n3];
            switch (by) {
                case 60: {
                    this.tag_bgn = n3;
                    bl = false;
                    break;
                }
                case 62: {
                    return false;
                }
                default: {
                    --n3;
                }
            }
            if (n3 != n - 1) continue;
            break;
        }
        if (this.tag_bgn == -1) {
            return false;
        }
        bl = true;
        n3 = n2 + 1;
        while (bl) {
            by = this.src[n3];
            switch (by) {
                case 60: {
                    return false;
                }
                case 62: {
                    this.tag_end = n3 + 1;
                    return true;
                }
            }
            if (++n3 != this.src_len) continue;
            break;
        }
        return false;
    }

    private byte[] Parse_recursive(Bry_bfr bry_bfr, Xol_vnt_itm xol_vnt_itm, int n) {
        this.pos += 2;
        boolean bl = false;
        boolean bl2 = false;
        int n2 = this.pos;
        block4: while (this.pos < this.src_len) {
            byte by = this.src[this.pos];
            Object object = trie.Match_bgn_w_byte(by, this.src, this.pos, this.src_len);
            if (object == null) {
                ++this.pos;
                continue;
            }
            switch (((Byte_obj_val)object).Val()) {
                case 1: {
                    bry_bfr.Add_mid(this.src, n2, this.pos);
                    bl2 = true;
                    if (n >= 32) {
                        this.pos += 2;
                        bry_bfr.Add(Bry__curly_bgn);
                        if (bl) continue block4;
                        bry_bfr.Add_str_a7("<span class=\"error\">max depth");
                        bry_bfr.Add_str_a7("</span>");
                        bl = true;
                        continue block4;
                    }
                    bry_bfr.Add(this.Parse_recursive(Bry_bfr_.New_w_size(16), xol_vnt_itm, n + 1));
                    n2 = this.pos;
                    continue block4;
                }
                case 2: {
                    if (bl2) {
                        bry_bfr.Add_mid(this.src, n2, this.pos);
                        byte[] byArray = bry_bfr.To_bry_and_clear();
                        this.converter_rule.Parse(xol_vnt_itm, byArray, 0, byArray.length);
                    } else {
                        this.converter_rule.Parse(xol_vnt_itm, this.src, n2, this.pos);
                    }
                    this.Apply_manual_conv(this.converter_rule);
                    this.pos += 2;
                    return this.converter_rule.Display();
                }
            }
            throw Err_.new_unhandled(-1);
        }
        this.Auto_convert(bry_bfr, xol_vnt_itm, this.src, n2, this.src_len);
        this.pos = this.src_len;
        return Bry_.Add(Bry__curly_bgn, bry_bfr.To_bry_and_clear());
    }

    private void Add_output(Xol_vnt_itm xol_vnt_itm, boolean bl, byte[] byArray, int n, int n2) {
        if (n2 - n == 0) {
            return;
        }
        if (bl) {
            this.Auto_convert(this.bfr, xol_vnt_itm, byArray, n, n2);
        } else {
            this.bfr.Add_mid(byArray, n, n2);
        }
    }

    public byte[] Auto_convert(Xol_vnt_itm xol_vnt_itm, byte[] byArray) {
        this.Auto_convert(this.tmp_convert_bfr, xol_vnt_itm, byArray, 0, byArray.length);
        return this.tmp_convert_bfr.To_bry_and_clear();
    }

    private void Auto_convert(Bry_bfr bry_bfr, Xol_vnt_itm xol_vnt_itm, byte[] byArray, int n, int n2) {
        this.html_convert_wkr.Init(bry_bfr, xol_vnt_itm);
        this.doc_parser.Parse(this.html_convert_wkr, byArray, n, n2);
    }

    private void Apply_manual_conv(Vnt_convert_rule vnt_convert_rule) {
        this.converted_title = vnt_convert_rule.Title();
        byte by = vnt_convert_rule.Action();
        Vnt_rule_undi_mgr vnt_rule_undi_mgr = vnt_convert_rule.Cnv_tbl();
        int n = vnt_rule_undi_mgr.Len();
        for (int i = 0; i < n; ++i) {
            Vnt_rule_undi_grp vnt_rule_undi_grp = vnt_rule_undi_mgr.Get_at(i);
            byte[] byArray = vnt_rule_undi_grp.Vnt();
            Xol_vnt_itm xol_vnt_itm = this.vnt_regy.Get_by(byArray);
            if (xol_vnt_itm == null) continue;
            int n2 = vnt_rule_undi_grp.Len();
            Xol_convert_wkr xol_convert_wkr = this.convert_mgr.Converter_ary()[xol_vnt_itm.Idx()];
            for (int j = 0; j < n2; ++j) {
                Vnt_rule_undi_itm vnt_rule_undi_itm = vnt_rule_undi_grp.Get_at(j);
                if (by == 43) {
                    xol_convert_wkr.Add(vnt_rule_undi_itm.Src(), vnt_rule_undi_itm.Trg());
                    continue;
                }
                if (by != 45) continue;
                xol_convert_wkr.Del(vnt_rule_undi_itm.Src());
            }
        }
    }
}

