/*
 * Decompiled with CFR 0.152.
 */
package gplx.xowa.langs.lnki_trails;

import gplx.Bry_;
import gplx.Err_;
import gplx.GfoMsg;
import gplx.Gfo_invk;
import gplx.Gfo_invk_;
import gplx.GfsCtx;
import gplx.Keyval;
import gplx.String_;
import gplx.core.btries.Btrie_slim_mgr;
import gplx.core.intls.Utf8_;
import gplx.xowa.langs.Xol_lang_itm;

public class Xol_lnki_trail_mgr
implements Gfo_invk {
    private final Btrie_slim_mgr trie = Btrie_slim_mgr.cs();
    private static final String Invk_add_many = "add_many";
    private static final String Invk_add_range = "add_range";
    private static final String Invk_add_bulk = "add_bulk";
    private static final String Invk_clear = "clear";

    public Xol_lnki_trail_mgr(Xol_lang_itm xol_lang_itm) {
    }

    public void Clear() {
        this.trie.Clear();
    }

    public int Count() {
        return this.trie.Count();
    }

    public Btrie_slim_mgr Trie() {
        return this.trie;
    }

    public void Add(byte[] byArray) {
        this.trie.Add_obj(byArray, (Object)byArray);
    }

    public void Del(byte[] byArray) {
        this.trie.Del(byArray);
    }

    private void Add(String ... stringArray) {
        for (String string : stringArray) {
            byte[] byArray = Bry_.new_u8(string);
            this.trie.Add_obj(byArray, (Object)byArray);
        }
    }

    @Override
    public Object Invk(GfsCtx gfsCtx, int n, String string, GfoMsg gfoMsg) {
        if (gfsCtx.Match(string, Invk_add_range)) {
            this.Add_range(gfoMsg);
        } else if (gfsCtx.Match(string, Invk_add_many)) {
            this.Add_many(gfoMsg);
        } else if (gfsCtx.Match(string, Invk_add_bulk)) {
            this.Add_bulk(gfoMsg);
        } else if (gfsCtx.Match(string, Invk_clear)) {
            this.Clear();
        } else {
            return Gfo_invk_.Rv_unhandled;
        }
        return this;
    }

    private void Add_bulk(GfoMsg gfoMsg) {
        byte[] byArray = gfoMsg.ReadBry("bulk");
        this.Add_bulk(byArray);
    }

    public void Add_bulk(byte[] byArray) {
        byte[] byArray2;
        int n = 0;
        int n2 = byArray.length;
        do {
            byArray2 = Utf8_.Get_char_at_pos_as_bry(byArray, n);
            this.Add(byArray2);
        } while ((n += byArray2.length) < n2);
    }

    private void Add_many(GfoMsg gfoMsg) {
        int n = gfoMsg.Args_count();
        for (int i = 0; i < n; ++i) {
            Keyval keyval = gfoMsg.Args_getAt(i);
            this.Add(keyval.Val_to_str_or_empty());
        }
    }

    private void Add_range(GfoMsg gfoMsg) {
        byte by = this.Add_rng_extract(gfoMsg, "bgn");
        byte by2 = this.Add_rng_extract(gfoMsg, "end");
        for (byte by3 = by; by3 <= by2; by3 = (byte)(by3 + 1)) {
            this.Add(new byte[]{by3});
        }
    }

    public void Add_range(byte by, byte by2) {
        for (byte by3 = by; by3 <= by2; by3 = (byte)(by3 + 1)) {
            this.Add(new byte[]{by3});
        }
    }

    byte Add_rng_extract(GfoMsg gfoMsg, String string) {
        byte[] byArray = gfoMsg.ReadBry(string);
        if (byArray.length != 1) {
            throw Err_.new_wo_type("argument must be ascii character", "key", string, "bry", String_.new_u8(byArray));
        }
        return byArray[0];
    }
}

