/*
 * Decompiled with CFR 0.152.
 */
package gplx.xowa.files;

import gplx.Bry_;
import gplx.Err_;
import gplx.Gfo_usr_dlg;
import gplx.Gfo_usr_dlg_;
import gplx.Io_mgr;
import gplx.Io_url;
import gplx.List_adp;
import gplx.core.ios.IoItmFil;
import gplx.core.ios.Io_download_fmt;
import gplx.core.ios.streams.Io_stream_rdr;
import gplx.core.ios.streams.Io_stream_rdr_;
import gplx.core.ios.streams.Io_stream_wtr_;
import gplx.core.threads.Gfo_thread_wkr;
import gplx.fsdb.meta.Fsm_atr_fil;
import gplx.fsdb.meta.Fsm_bin_fil;
import gplx.fsdb.meta.Fsm_mnt_itm;
import gplx.fsdb.meta.Fsm_mnt_mgr;
import gplx.xowa.Xoa_app_;
import gplx.xowa.Xoa_page;
import gplx.xowa.files.Xof_bin_updater;
import gplx.xowa.files.Xof_fsdb_itm;
import gplx.xowa.files.Xof_img_size;
import gplx.xowa.files.Xof_url_bldr;
import gplx.xowa.files.bins.Xof_bin_mgr;
import gplx.xowa.files.bins.Xof_bin_wkr__fsdb_sql;
import gplx.xowa.files.caches.Xou_cache_mgr;
import gplx.xowa.files.imgs.Xof_img_mode_;
import gplx.xowa.files.origs.Xof_orig_itm;
import gplx.xowa.files.origs.Xof_orig_mgr;
import gplx.xowa.files.repos.Xof_repo_itm;
import gplx.xowa.files.repos.Xow_repo_mgr;
import gplx.xowa.guis.cbks.js.Js_img_mgr;
import gplx.xowa.guis.cbks.js.Xog_js_wkr;

public class Xof_file_wkr
implements Gfo_thread_wkr {
    private final Xof_orig_mgr orig_mgr;
    private final Xof_bin_mgr bin_mgr;
    private final Fsm_mnt_mgr mnt_mgr;
    private final Xou_cache_mgr cache_mgr;
    private final Gfo_usr_dlg usr_dlg;
    private final Xow_repo_mgr repo_mgr;
    private final Xog_js_wkr js_wkr;
    private final Xof_url_bldr url_bldr = Xof_url_bldr.new_v2();
    private final Xof_img_size img_size = new Xof_img_size();
    private final Xoa_page hpg;
    private final List_adp imgs;

    public Xof_file_wkr(Xof_orig_mgr xof_orig_mgr, Xof_bin_mgr xof_bin_mgr, Fsm_mnt_mgr fsm_mnt_mgr, Xou_cache_mgr xou_cache_mgr, Xow_repo_mgr xow_repo_mgr, Xog_js_wkr xog_js_wkr, Xoa_page xoa_page, List_adp list_adp) {
        this.orig_mgr = xof_orig_mgr;
        this.bin_mgr = xof_bin_mgr;
        this.mnt_mgr = fsm_mnt_mgr;
        this.cache_mgr = xou_cache_mgr;
        this.usr_dlg = Gfo_usr_dlg_.Instance;
        this.repo_mgr = xow_repo_mgr;
        this.js_wkr = xog_js_wkr;
        this.hpg = xoa_page;
        this.imgs = list_adp;
    }

    @Override
    public String Thread__name() {
        return "xowa.load_imgs";
    }

    @Override
    public boolean Thread__resume() {
        return true;
    }

    @Override
    public void Thread__exec() {
        int n = this.imgs.Count();
        for (int i = 0; i < n; ++i) {
            this.Exec_by_fsdb((Xof_fsdb_itm)this.imgs.Get_at(i));
        }
        Xoa_app_.Usr_dlg().Prog_none("", "", "");
    }

    private void Exec_by_fsdb(Xof_fsdb_itm xof_fsdb_itm) {
        try {
            if (xof_fsdb_itm.File_exists_in_cache()) {
                return;
            }
            xof_fsdb_itm.Orig_exists_n_();
            Xof_orig_itm xof_orig_itm = this.orig_mgr.Find_by_ttl_or_null(xof_fsdb_itm.Lnki_ttl());
            if (xof_orig_itm == Xof_orig_itm.Null) {
                return;
            }
            Xof_file_wkr.Eval_orig(xof_orig_itm, xof_fsdb_itm, this.url_bldr, this.repo_mgr, this.img_size);
            Xof_file_wkr.Show_img(xof_fsdb_itm, this.usr_dlg, this.bin_mgr, this.mnt_mgr, this.cache_mgr, this.repo_mgr, this.js_wkr, this.img_size, this.url_bldr, this.hpg);
        }
        catch (Exception exception) {
            this.usr_dlg.Warn_many("", "", "file.unknown: err=~{0}", Err_.Message_gplx_full(exception));
        }
    }

    public static boolean Show_img(Xof_fsdb_itm xof_fsdb_itm, Gfo_usr_dlg gfo_usr_dlg, Xof_bin_mgr xof_bin_mgr, Fsm_mnt_mgr fsm_mnt_mgr, Xou_cache_mgr xou_cache_mgr, Xow_repo_mgr xow_repo_mgr, Xog_js_wkr xog_js_wkr, Xof_img_size xof_img_size, Xof_url_bldr xof_url_bldr, Xoa_page xoa_page) {
        try {
            gfo_usr_dlg.Log_many("", "", "file.get: file=~{0} width=~{1} page=~{2}", xof_fsdb_itm.Orig_ttl(), xof_fsdb_itm.Lnki_w(), xoa_page.Ttl().Full_db());
            if (xof_fsdb_itm.Orig_ext() == null) {
                gfo_usr_dlg.Warn_many("", "", "file.missing.ext: file=~{0} width=~{1} page=~{2}", xof_fsdb_itm.Orig_ttl(), xof_fsdb_itm.Lnki_w(), xoa_page.Ttl().Full_db());
                return false;
            }
            Xof_repo_itm xof_repo_itm = xow_repo_mgr.Get_trg_by_id_or_null(xof_fsdb_itm.Orig_repo_id(), xof_fsdb_itm.Orig_ttl(), xoa_page.Url_bry_safe());
            if (xof_repo_itm == null) {
                return false;
            }
            if (xof_fsdb_itm.Hdump_mode() == 0) {
                xof_fsdb_itm.Init_at_html(xof_fsdb_itm.Lnki_exec_tid(), xof_img_size, xof_repo_itm, xof_url_bldr);
            }
            if (xof_fsdb_itm.Orig_ext().Is_not_viewable(xof_fsdb_itm.Lnki_exec_tid())) {
                return false;
            }
            IoItmFil ioItmFil = Io_mgr.Instance.QueryFil(xof_fsdb_itm.Html_view_url());
            if (!ioItmFil.Exists()) {
                if (xof_bin_mgr.Find_to_url_as_bool(xof_fsdb_itm.Lnki_exec_tid(), xof_fsdb_itm)) {
                    if (xof_fsdb_itm.Fsdb_insert()) {
                        Xof_file_wkr.Save_bin(xof_fsdb_itm, fsm_mnt_mgr, xof_fsdb_itm.Html_view_url());
                    }
                } else {
                    boolean bl = false;
                    if (xof_fsdb_itm.Lnki_exec_tid() == 2) {
                        bl = Xof_file_wkr.Show_img_near(xof_fsdb_itm, xof_bin_mgr, xow_repo_mgr, xoa_page, xof_img_size, xof_url_bldr, xog_js_wkr);
                    }
                    if (!bl) {
                        gfo_usr_dlg.Warn_many("", "", "file.missing.bin: file=~{0} width=~{1} page=~{2}", xof_fsdb_itm.Orig_ttl(), xof_fsdb_itm.Lnki_w(), xoa_page.Ttl().Full_db());
                        xof_fsdb_itm.File_exists_n_();
                        return false;
                    }
                }
            } else {
                xof_fsdb_itm.File_exists_y_();
                xof_fsdb_itm.File_size_(ioItmFil.Size());
            }
            Js_img_mgr.Update_img(xoa_page, xog_js_wkr, xof_fsdb_itm);
            if (xou_cache_mgr != null) {
                xou_cache_mgr.Update(xof_fsdb_itm);
            }
            return true;
        }
        catch (Exception exception) {
            gfo_usr_dlg.Warn_many("", "", "file.unknown: err=~{0}", Err_.Message_gplx_full(exception));
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean Show_img_near(Xof_fsdb_itm xof_fsdb_itm, Xof_bin_mgr xof_bin_mgr, Xow_repo_mgr xow_repo_mgr, Xoa_page xoa_page, Xof_img_size xof_img_size, Xof_url_bldr xof_url_bldr, Xog_js_wkr xog_js_wkr) {
        Xof_bin_wkr__fsdb_sql xof_bin_wkr__fsdb_sql = (Xof_bin_wkr__fsdb_sql)xof_bin_mgr.Wkrs__get_or_null("xowa.fsdb.wiki");
        if (xof_bin_wkr__fsdb_sql != null) {
            Io_stream_rdr io_stream_rdr = xof_bin_wkr__fsdb_sql.Get_to_fsys_near(xof_fsdb_itm, xof_fsdb_itm.Orig_repo_name(), xof_fsdb_itm.Orig_ttl(), xof_fsdb_itm.Orig_ext(), xof_fsdb_itm.Lnki_time(), xof_fsdb_itm.Lnki_page());
            try {
                if (io_stream_rdr != Io_stream_rdr_.Noop) {
                    Xof_repo_itm xof_repo_itm = xow_repo_mgr.Get_trg_by_id_or_null(xof_fsdb_itm.Orig_repo_id(), xof_fsdb_itm.Lnki_ttl(), xoa_page.Url_bry_safe());
                    Io_url io_url = xof_url_bldr.Init_for_trg_file(xof_repo_itm, Xof_img_mode_.By_bool(!xof_fsdb_itm.File_is_orig()), xof_fsdb_itm.Orig_ttl(), xof_fsdb_itm.Orig_ttl_md5(), xof_fsdb_itm.Orig_ext(), xof_fsdb_itm.File_w(), xof_fsdb_itm.Lnki_time(), xof_fsdb_itm.Lnki_page()).Xto_url();
                    Io_stream_wtr_.Save_rdr(io_url, io_stream_rdr, Io_download_fmt.Null);
                    xof_fsdb_itm.File_size_(io_stream_rdr.Len());
                    xof_fsdb_itm.Init_at_lnki_by_near(xof_fsdb_itm.File_w());
                    xof_fsdb_itm.Init_at_html(xof_fsdb_itm.Lnki_exec_tid(), xof_img_size, xof_repo_itm, xof_url_bldr);
                    boolean bl = true;
                    return bl;
                }
            }
            finally {
                io_stream_rdr.Rls();
            }
        }
        return false;
    }

    public static void Eval_orig(Xof_orig_itm xof_orig_itm, Xof_fsdb_itm xof_fsdb_itm, Xof_url_bldr xof_url_bldr, Xow_repo_mgr xow_repo_mgr, Xof_img_size xof_img_size) {
        xof_fsdb_itm.Orig_exists_y_();
        byte by = xof_orig_itm.Repo();
        Xof_repo_itm xof_repo_itm = xow_repo_mgr.Get_trg_by_id_or_null(by, xof_fsdb_itm.Lnki_ttl(), Bry_.Empty);
        if (xof_repo_itm == null) {
            return;
        }
        xof_fsdb_itm.Init_at_orig(by, xof_repo_itm.Wiki_domain(), xof_orig_itm.Ttl(), xof_orig_itm.Ext(), xof_orig_itm.W(), xof_orig_itm.H(), xof_orig_itm.Redirect());
        xof_fsdb_itm.Init_at_html(xof_fsdb_itm.Lnki_exec_tid(), xof_img_size, xof_repo_itm, xof_url_bldr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void Save_bin(Xof_fsdb_itm xof_fsdb_itm, Fsm_mnt_mgr fsm_mnt_mgr, Io_url io_url) {
        long l = Io_mgr.Instance.QueryFil(io_url).Size();
        Io_stream_rdr io_stream_rdr = Io_stream_rdr_.New__raw(io_url);
        try {
            io_stream_rdr.Open();
            Fsm_mnt_itm fsm_mnt_itm = fsm_mnt_mgr.Mnts__get_insert();
            Fsm_atr_fil fsm_atr_fil = fsm_mnt_itm.Atr_mgr().Db__core();
            Fsm_bin_fil fsm_bin_fil = fsm_mnt_itm.Bin_mgr().Dbs__get_nth();
            Xof_bin_updater xof_bin_updater = new Xof_bin_updater();
            xof_bin_updater.Save_bin(fsm_mnt_itm, fsm_atr_fil, fsm_bin_fil, xof_fsdb_itm, io_stream_rdr, l);
        }
        catch (Exception exception) {
            Xoa_app_.Usr_dlg().Warn_many("", "", "failed to save file: ttl=~{0} url=~{1} err=~{2}", xof_fsdb_itm.Orig_ttl(), io_url.Raw(), Err_.Message_gplx_full(exception));
        }
        finally {
            io_stream_rdr.Rls();
        }
    }
}

