/*
 * Decompiled with CFR 0.152.
 */
package gplx.xowa.bldrs.wms.sites;

import gplx.Err_;
import gplx.Gfo_usr_dlg;
import gplx.Io_mgr;
import gplx.Io_url;
import gplx.core.net.Gfo_inet_conn;
import gplx.dbs.cfgs.Db_cfg_tbl;
import gplx.xowa.Xoa_app;
import gplx.xowa.Xow_wiki;
import gplx.xowa.bldrs.wms.Xowm_api_mgr;

class Site_json_fetcher {
    private Gfo_usr_dlg usr_dlg;
    private Gfo_inet_conn inet_conn;
    private String domain_str;
    private Db_cfg_tbl cfg_tbl;
    private Io_url default_url;
    private static final String Cfg_grp__xowa_bldr_api = "xowa.bldr.api";
    private static final String Cfg_key__xowa_bldr_api__data = "data";

    Site_json_fetcher() {
    }

    public void Init(Gfo_usr_dlg gfo_usr_dlg, Gfo_inet_conn gfo_inet_conn, String string, Db_cfg_tbl db_cfg_tbl, Io_url io_url) {
        this.usr_dlg = gfo_usr_dlg;
        this.inet_conn = gfo_inet_conn;
        this.domain_str = string;
        this.cfg_tbl = db_cfg_tbl;
        this.default_url = io_url;
    }

    public void Init_by_wiki(Xow_wiki xow_wiki) {
        Xoa_app xoa_app = xow_wiki.App();
        this.usr_dlg = xoa_app.Usr_dlg();
        this.inet_conn = xoa_app.Utl__inet_conn();
        this.domain_str = xow_wiki.Domain_str();
        this.cfg_tbl = xow_wiki.Data__core_mgr().Tbl__cfg();
        this.default_url = xoa_app.Fsys_mgr().Bin_xowa_dir().GenSubFil_nest("cfg", "wiki", "api", "xowa_default.json");
    }

    public byte[] Get_json(Io_url io_url) {
        byte[] byArray = null;
        int n = 0;
        while (true) {
            switch (n) {
                case 0: {
                    byArray = this.Get_json_from_fs(io_url);
                    break;
                }
                case 1: {
                    byArray = this.Get_json_from_db(this.cfg_tbl);
                    break;
                }
                case 2: {
                    byArray = this.Get_json_from_wm(this.usr_dlg, this.inet_conn, this.domain_str, this.cfg_tbl);
                    break;
                }
                case 3: {
                    byArray = this.Get_json_from_fs(this.default_url);
                    break;
                }
                default: {
                    throw Err_.new_("api.site", "could not find site json", "wiki", this.domain_str);
                }
            }
            if (byArray != null) break;
            ++n;
        }
        return byArray;
    }

    private byte[] Get_json_from_fs(Io_url io_url) {
        return io_url == null ? null : Io_mgr.Instance.LoadFilBryOrNull(io_url);
    }

    private byte[] Get_json_from_db(Db_cfg_tbl db_cfg_tbl) {
        return db_cfg_tbl.Select_bry(Cfg_grp__xowa_bldr_api, Cfg_key__xowa_bldr_api__data);
    }

    private byte[] Get_json_from_wm(Gfo_usr_dlg gfo_usr_dlg, Gfo_inet_conn gfo_inet_conn, String string, Db_cfg_tbl db_cfg_tbl) {
        String string2 = "action=query&format=json&meta=siteinfo&siprop=general|namespaces|statistics|interwikimap|namespacealiases|specialpagealiases|libraries|extensions|skins|magicwords|functionhooks|showhooks|extensiontags|protocols|defaultoptions|languages";
        byte[] byArray = Xowm_api_mgr.Call_by_qarg(gfo_usr_dlg, gfo_inet_conn, string, string2);
        if (byArray != null) {
            db_cfg_tbl.Assert_bry(Cfg_grp__xowa_bldr_api, Cfg_key__xowa_bldr_api__data, byArray);
        }
        return byArray;
    }
}

