/*
 * Decompiled with CFR 0.152.
 */
package gplx.xowa.bldrs.filters.dansguardians;

import gplx.Gfo_usr_dlg_;
import gplx.Internal;
import gplx.Io_url;
import gplx.Ordered_hash;
import gplx.Ordered_hash_;
import gplx.core.btries.Btrie_slim_mgr;
import gplx.xowa.Xoa_app;
import gplx.xowa.Xow_wiki;
import gplx.xowa.addons.apps.cfgs.Xocfg_mgr;
import gplx.xowa.bldrs.filters.core.Xob_ttl_filter_mgr;
import gplx.xowa.bldrs.filters.dansguardians.Dg_file;
import gplx.xowa.bldrs.filters.dansguardians.Dg_log_mgr;
import gplx.xowa.bldrs.filters.dansguardians.Dg_ns_skip_mgr;
import gplx.xowa.bldrs.filters.dansguardians.Dg_parser;
import gplx.xowa.bldrs.filters.dansguardians.Dg_rule;
import gplx.xowa.bldrs.filters.dansguardians.Dg_rule_group;
import gplx.xowa.bldrs.filters.dansguardians.Dg_rule_tally;
import gplx.xowa.bldrs.filters.dansguardians.Dg_word;
import gplx.xowa.langs.Xol_lang_itm;

public class Dg_match_mgr {
    private int score_init;
    private int score_fail;
    private boolean log_enabled;
    private boolean case_match;
    private final Btrie_slim_mgr btrie = Btrie_slim_mgr.cs();
    private final Ordered_hash rules = Ordered_hash_.New_bry();
    private final Ordered_hash rule_group_hash = Ordered_hash_.New_bry();
    private final Ordered_hash rule_tally_hash = Ordered_hash_.New_bry();
    private final Dg_parser parser = new Dg_parser();
    private final Xob_ttl_filter_mgr ttl_filter_mgr = new Xob_ttl_filter_mgr();
    private final Dg_ns_skip_mgr ns_skip_mgr = new Dg_ns_skip_mgr();
    private final Dg_log_mgr log_mgr = new Dg_log_mgr();
    public static final String Cfg__enabled = "xowa.bldr.dansguardian.enabled";
    private static final String Cfg__root_dir = "xowa.bldr.dansguardian.root_dir";

    public Dg_match_mgr(Io_url io_url, int n, int n2, boolean bl, boolean bl2, Io_url io_url2) {
        this.score_init = n;
        this.score_fail = n2;
        this.case_match = bl;
        this.log_enabled = bl2;
        if (bl2) {
            this.log_mgr.Init(io_url2);
        }
        this.ttl_filter_mgr.Load(false, io_url.GenSubFil("xowa.title.include.txt"));
        this.ttl_filter_mgr.Load(true, io_url.GenSubFil("xowa.title.exclude.txt"));
        this.ns_skip_mgr.Load(io_url.GenSubFil("xowa.ns.skip.txt"));
        Io_url io_url3 = io_url.GenSubDir("dansguardian");
        Dg_file[] dg_fileArray = this.parser.Parse_dir(io_url3);
        Gfo_usr_dlg_.Instance.Plog_many("", "", "import.dg.rules: url=~{0} files=~{1}", io_url3, dg_fileArray.length);
        this.Init_by_files(dg_fileArray);
        if (bl2) {
            this.log_mgr.Commit();
        }
    }

    public void Clear() {
        this.btrie.Clear();
        this.rules.Clear();
        this.rule_group_hash.Clear();
        this.rule_tally_hash.Clear();
    }

    private void Init_by_files(Dg_file[] dg_fileArray) {
        for (Dg_file dg_file : dg_fileArray) {
            Dg_rule[] dg_ruleArray = dg_file.Lines();
            if (this.log_enabled) {
                this.log_mgr.Insert_file(dg_file);
            }
            for (Dg_rule dg_rule : dg_ruleArray) {
                this.Init_by_rule(dg_rule);
            }
        }
    }

    @Internal
    protected void Init_by_rule(Dg_rule dg_rule) {
        Dg_word[] dg_wordArray;
        if (dg_rule.Tid() != 0) {
            return;
        }
        if (this.log_enabled) {
            this.log_mgr.Insert_rule(dg_rule);
        }
        for (Dg_word dg_word : dg_wordArray = dg_rule.Words()) {
            Dg_rule_group dg_rule_group = this.Get_rule_group_or_new(dg_word.Raw());
            dg_rule_group.Rules_list().Add(dg_rule);
            this.btrie.Add_obj(dg_word.Raw(), (Object)dg_rule_group);
        }
    }

    private Dg_rule_group Get_rule_group_or_new(byte[] byArray) {
        Dg_rule_group dg_rule_group = (Dg_rule_group)this.rule_group_hash.Get_by(byArray);
        if (dg_rule_group == null) {
            dg_rule_group = new Dg_rule_group(byArray);
            this.rule_group_hash.Add(byArray, dg_rule_group);
        }
        return dg_rule_group;
    }

    private Dg_rule_tally Get_rule_tally_or_new(byte[] byArray, Dg_rule dg_rule) {
        Dg_rule_tally dg_rule_tally = (Dg_rule_tally)this.rule_tally_hash.Get_by(byArray);
        if (dg_rule_tally == null) {
            dg_rule_tally = new Dg_rule_tally(dg_rule);
            this.rule_tally_hash.Add(byArray, dg_rule_tally);
        }
        return dg_rule_tally;
    }

    public boolean Match(int n, int n2, int n3, byte[] byArray, byte[] byArray2, Xol_lang_itm xol_lang_itm, byte[] byArray3) {
        int n4;
        if (this.ns_skip_mgr.Has(n3)) {
            return false;
        }
        int n5 = byArray3.length;
        int n6 = 0;
        if (this.ttl_filter_mgr.Match_include(byArray2)) {
            n6 = -1;
        } else if (this.ttl_filter_mgr.Match_exclude(byArray2)) {
            n6 = 1;
        }
        if (n6 != 0) {
            this.log_mgr.Insert_page_score(n, n2, n3, byArray, n5, 0, 0, n6);
            return n6 == 1;
        }
        if (!this.case_match) {
            byArray3 = xol_lang_itm.Case_mgr().Case_build_lower(byArray3);
            n5 = byArray3.length;
        }
        this.rules.Clear();
        this.rule_tally_hash.Clear();
        int n7 = 0;
        int n8 = this.score_init;
        while (n7 < n5) {
            Object object = this.btrie.Match_bgn(byArray3, n7, n5);
            if (object == null) {
                ++n7;
                continue;
            }
            Dg_rule_group dg_rule_group = (Dg_rule_group)object;
            Dg_rule[] dg_ruleArray = dg_rule_group.Rules_ary();
            for (Dg_rule dg_rule : dg_ruleArray) {
                Dg_rule_tally dg_rule_tally = this.Get_rule_tally_or_new(dg_rule.Key(), dg_rule);
                dg_rule_tally.Process(dg_rule_group.Word());
            }
            ++n7;
        }
        int n9 = this.rule_tally_hash.Count();
        if (n9 == 0) {
            return false;
        }
        int n10 = 0;
        for (n4 = 0; n4 < n9; ++n4) {
            Dg_rule_tally dg_rule_tally = (Dg_rule_tally)this.rule_tally_hash.Get_at(n4);
            int n11 = dg_rule_tally.Results_pass_count();
            if (n11 <= 0) continue;
            int n12 = dg_rule_tally.Rule().Score();
            int n13 = n12 * n11;
            if (this.log_enabled) {
                this.log_mgr.Insert_page_rule(n, n2, dg_rule_tally.Rule().Id(), n13);
            }
            if (n12 == 0) {
                n8 = Integer.MAX_VALUE;
                break;
            }
            n8 += n13;
            ++n10;
        }
        int n14 = n4 = n8 > this.score_fail ? 1 : 0;
        if (n4 != 0 && this.log_enabled) {
            this.log_mgr.Insert_page_score(n, n2, n3, byArray, n5, n8, n10, 0);
        }
        return n4 != 0;
    }

    public void Rls() {
        this.log_mgr.Rls();
    }

    public void Commit() {
        if (this.log_enabled) {
            this.log_mgr.Commit();
        }
    }

    public static void Cfg__reg(Xoa_app xoa_app) {
        xoa_app.Cfg().Dflt_mgr().Add(Cfg__root_dir, xoa_app.Fsys_mgr().Bin_xowa_dir().GenSubDir_nest("cfg", "bldr", "filter").Raw());
    }

    public static Dg_match_mgr New_mgr(Xoa_app xoa_app, Xow_wiki xow_wiki) {
        Xocfg_mgr xocfg_mgr = xoa_app.Cfg();
        if (!xocfg_mgr.Get_bool_wiki_or(xow_wiki, Cfg__enabled, false)) {
            return null;
        }
        String string = xocfg_mgr.To_ctx(xow_wiki);
        return new Dg_match_mgr(xocfg_mgr.Get_url_or(string, Cfg__root_dir, xoa_app.Fsys_mgr().Bin_xowa_dir().GenSubDir_nest("cfg", "bldr", "filter")).GenSubDir(xow_wiki.Domain_str()), xocfg_mgr.Get_int_or(string, "xowa.bldr.dansguardian.score_init", 0), xocfg_mgr.Get_int_or(string, "xowa.bldr.dansguardian.score_fail", 0), xocfg_mgr.Get_bool_or(string, "xowa.bldr.dansguardian.case_match", false), xocfg_mgr.Get_bool_or(string, "xowa.bldr.dansguardian.log_enabled", true), xow_wiki.Fsys_mgr().Root_dir().GenSubFil("dansguardian_log.sqlite3"));
    }
}

