/*
 * Decompiled with CFR 0.152.
 */
package gplx.xowa.bldrs.cmds.utils;

import gplx.Datetime_now;
import gplx.Err_;
import gplx.GfoMsg;
import gplx.Gfo_invk_;
import gplx.GfsCtx;
import gplx.Io_mgr;
import gplx.Io_url;
import gplx.String_;
import gplx.core.ios.IoEngine_system;
import gplx.core.ios.IoEngine_xrg_downloadFil;
import gplx.core.ios.IoItmHash;
import gplx.core.ios.IoItm_base;
import gplx.xowa.Xowe_wiki;
import gplx.xowa.bldrs.Xob_bldr;
import gplx.xowa.bldrs.cmds.utils.Xob_unzip_wkr;
import gplx.xowa.bldrs.installs.Xoi_dump_mgr;
import gplx.xowa.bldrs.wkrs.Xob_cmd;
import gplx.xowa.bldrs.wkrs.Xob_cmd__base;
import gplx.xowa.bldrs.wms.dumps.Xowm_dump_file;

public class Xob_download_cmd
extends Xob_cmd__base
implements Xob_cmd {
    private String dump_date = "latest";
    private String dump_type = null;
    private String dump_src = null;
    private Io_url dump_trg_zip = null;
    private Io_url dump_trg_bin = null;
    private boolean unzip = true;
    private static final String Invk_dump_date_ = "dump_date_";
    private static final String Invk_dump_type_ = "dump_type_";
    private static final String Invk_unzip_ = "unzip_";
    private static final String Invk_dump_src_ = "dump_src_";
    private static final String Invk_dump_trg_zip_ = "dump_trg_zip_";
    private static final String Invk_dump_trg_bin_ = "dump_trg_bin_";

    public Xob_download_cmd(Xob_bldr xob_bldr, Xowe_wiki xowe_wiki) {
        super(xob_bldr, xowe_wiki);
    }

    public Xob_download_cmd Dump_type_(String string) {
        this.dump_type = string;
        return this;
    }

    @Override
    public String Cmd_key() {
        return "util.download";
    }

    @Override
    public void Cmd_run() {
        if (this.dump_type == null) {
            throw Err_.new_("bldr", "dump_type must be specified", new Object[0]);
        }
        if (!IoEngine_system.Web_access_enabled) {
            return;
        }
        Xowm_dump_file xowm_dump_file = new Xowm_dump_file(this.wiki.Domain_str(), this.dump_date, this.dump_type);
        if (this.dump_src == null) {
            xowm_dump_file.Server_url_(Xoi_dump_mgr.Server_urls(this.app)[0]);
            this.dump_src = xowm_dump_file.File_url();
        }
        if (this.dump_trg_zip == null) {
            this.dump_trg_zip = this.wiki.Fsys_mgr().Root_dir().GenSubFil(xowm_dump_file.File_name());
        }
        if (this.dump_trg_bin == null && this.unzip) {
            this.dump_trg_bin = this.dump_trg_zip.GenNewNameAndExt(this.dump_trg_zip.NameOnly());
        }
        this.usr_dlg.Note_many("", "", "downloading file: now=~{0} src=~{1} trg=~{2}", Datetime_now.Get().XtoStr_fmt_yyyyMMdd_HHmmss(), this.dump_src, this.dump_trg_zip.OwnerDir());
        IoEngine_xrg_downloadFil ioEngine_xrg_downloadFil = this.app.Wmf_mgr().Download_wkr().Download_xrg();
        ioEngine_xrg_downloadFil.Src_last_modified_query_(false).Init(this.dump_src, this.dump_trg_zip);
        if (!ioEngine_xrg_downloadFil.Exec()) {
            this.usr_dlg.Warn_many("", "", "download failed: src=~{0} trg=~{1} err=~{2}", this.dump_src, this.dump_trg_zip.Raw(), Err_.Message_gplx_full(ioEngine_xrg_downloadFil.Rslt_err()));
        }
        if (this.unzip) {
            this.usr_dlg.Note_many("", "", "unzipping file: now=~{0} trg=~{1}", Datetime_now.Get().XtoStr_fmt_yyyyMMdd_HHmmss(), this.dump_trg_bin.Raw());
            Xob_unzip_wkr xob_unzip_wkr = new Xob_unzip_wkr().Init(this.app).Process_run_mode_((byte)1);
            xob_unzip_wkr.Decompress(this.dump_trg_zip, this.dump_trg_bin);
        }
    }

    @Override
    public Object Invk(GfsCtx gfsCtx, int n, String string, GfoMsg gfoMsg) {
        if (String_.Eq(string, Invk_dump_date_)) {
            this.dump_date = gfoMsg.ReadStr("v");
        } else if (String_.Eq(string, Invk_dump_type_)) {
            this.dump_type = gfoMsg.ReadStr("v");
        } else if (String_.Eq(string, Invk_dump_src_)) {
            this.dump_src = gfoMsg.ReadStr("v");
        } else if (String_.Eq(string, Invk_dump_trg_zip_)) {
            this.dump_trg_zip = gfoMsg.ReadIoUrl("v");
        } else if (String_.Eq(string, Invk_dump_trg_bin_)) {
            this.dump_trg_bin = gfoMsg.ReadIoUrl("v");
        } else if (String_.Eq(string, Invk_unzip_)) {
            this.unzip = gfoMsg.ReadYn("v");
        } else {
            return Gfo_invk_.Rv_unhandled;
        }
        return this;
    }

    public static void Add_if_not_found_many(Xob_bldr xob_bldr, Xowe_wiki xowe_wiki, String ... stringArray) {
        IoItmHash ioItmHash = Io_mgr.Instance.QueryDir_args(xowe_wiki.Fsys_mgr().Root_dir()).ExecAsItmHash();
        for (String string : stringArray) {
            Xob_download_cmd.Add_if_not_found(xob_bldr, xowe_wiki, ioItmHash, string);
        }
    }

    private static void Add_if_not_found(Xob_bldr xob_bldr, Xowe_wiki xowe_wiki, IoItmHash ioItmHash, String string) {
        if (!Xob_download_cmd.Found(ioItmHash, string)) {
            xob_bldr.Cmd_mgr().Add(new Xob_download_cmd(xob_bldr, xowe_wiki).Dump_type_(string));
        }
    }

    private static boolean Found(IoItmHash ioItmHash, String string) {
        String string2 = String_.Format("{0}.sql", string);
        int n = ioItmHash.Count();
        for (int i = 0; i < n; ++i) {
            IoItm_base ioItm_base = ioItmHash.Get_at(i);
            if (!String_.Has(ioItm_base.Url().NameAndExt(), string2)) continue;
            return true;
        }
        return false;
    }
}

