/*
 * Decompiled with CFR 0.152.
 */
package gplx.xowa.bldrs.cmds.texts.sqls;

import gplx.DateAdp;
import gplx.DateAdp_;
import gplx.Err_;
import gplx.GfoMsg;
import gplx.Gfo_invk;
import gplx.GfsCtx;
import gplx.core.ios.Io_stream_zip_mgr;
import gplx.langs.htmls.encoders.Gfo_url_encoder_;
import gplx.xowa.Xoa_ttl;
import gplx.xowa.Xoae_app;
import gplx.xowa.Xowe_wiki;
import gplx.xowa.addons.bldrs.files.dbs.Xob_redirect_tbl;
import gplx.xowa.bldrs.Db_idx_mode;
import gplx.xowa.bldrs.Xob_bldr;
import gplx.xowa.bldrs.Xob_ns_to_db_mgr;
import gplx.xowa.bldrs.Xobldr_cfg;
import gplx.xowa.bldrs.cmds.Xob_ns_file_itm;
import gplx.xowa.bldrs.cmds.texts.sqls.Xob_ns_to_db_wkr__text;
import gplx.xowa.bldrs.filters.dansguardians.Dg_match_mgr;
import gplx.xowa.bldrs.wkrs.Xob_itm_basic_base;
import gplx.xowa.bldrs.wkrs.Xob_page_wkr;
import gplx.xowa.parsers.utils.Xop_redirect_mgr;
import gplx.xowa.wikis.data.Xow_db_file;
import gplx.xowa.wikis.data.Xow_db_mgr;
import gplx.xowa.wikis.data.tbls.Xowd_page_itm;
import gplx.xowa.wikis.data.tbls.Xowd_page_tbl;
import gplx.xowa.wikis.nss.Xow_ns;
import gplx.xowa.wikis.nss.Xow_ns_mgr;
import gplx.xowa.wikis.nss.Xow_ns_mgr_;

public class Xob_page_cmd
extends Xob_itm_basic_base
implements Xob_page_wkr,
Gfo_invk {
    private Xow_db_mgr db_mgr;
    private Db_idx_mode idx_mode = Db_idx_mode.Itm_end;
    private Xowd_page_tbl page_core_tbl;
    private Io_stream_zip_mgr text_zip_mgr;
    private byte text_zip_tid;
    private Xop_redirect_mgr redirect_mgr;
    private Xob_redirect_tbl redirect_tbl;
    private boolean redirect_id_enabled;
    private DateAdp modified_latest = DateAdp_.MinValue;
    private int page_count_all;
    private int page_count_main = 0;
    private int commit_interval = 100000;
    private Dg_match_mgr dg_match_mgr;
    private Xob_ns_to_db_mgr ns_to_db_mgr;
    private static final String Invk_commit_interval_ = "commit_interval_";
    private static final String Invk_idx_mode_ = "idx_mode_";
    private static final String Invk_redirect_id_enabled_ = "redirect_id_enabled_";

    public Xob_page_cmd(Xob_bldr xob_bldr, Xowe_wiki xowe_wiki) {
        this.Cmd_ctor(xob_bldr, xowe_wiki);
    }

    @Override
    public String Page_wkr__key() {
        return "text.page";
    }

    @Override
    public void Page_wkr__bgn() {
        Xoae_app xoae_app = this.wiki.Appe();
        this.redirect_mgr = this.wiki.Redirect_mgr();
        this.db_mgr = this.wiki.Db_mgr_as_sql().Core_data_mgr();
        this.page_core_tbl = this.db_mgr.Tbl__page();
        this.text_zip_mgr = this.wiki.Utl__zip_mgr();
        this.text_zip_tid = Xobldr_cfg.Zip_mode__text(xoae_app);
        Xow_ns_mgr_.rebuild_(this.wiki.Lang(), this.wiki.Ns_mgr());
        this.ns_to_db_mgr = new Xob_ns_to_db_mgr(new Xob_ns_to_db_wkr__text(), this.db_mgr, Xobldr_cfg.Max_size__text(xoae_app));
        this.dg_match_mgr = Dg_match_mgr.New_mgr(xoae_app, this.wiki);
        if (this.dg_match_mgr != null) {
            this.redirect_id_enabled = true;
        }
        if (this.redirect_id_enabled) {
            this.redirect_tbl = new Xob_redirect_tbl(this.wiki.Fsys_mgr().Root_dir(), Gfo_url_encoder_.Http_url_ttl).Create_table();
            this.redirect_tbl.Conn().Txn_bgn("bldr__page__redirect");
        }
        xoae_app.Bldr().Dump_parser().Trie_tab_del_();
        byte[] byArray = Xobldr_cfg.New_ns_file_map(xoae_app, this.wiki.Import_cfg().Src_rdr_len());
        Xob_ns_file_itm.Init_ns_bldr_data((byte)2, this.wiki.Ns_mgr(), byArray);
        if (this.idx_mode.Tid_is_bgn()) {
            this.page_core_tbl.Create_idx();
        }
        this.page_core_tbl.Insert_bgn();
        this.usr_dlg.Prog_many("", "", "import.page.bgn", new Object[0]);
    }

    @Override
    public void Page_wkr__run(Xowd_page_itm xowd_page_itm) {
        int n;
        byte[] byArray;
        Xoa_ttl xoa_ttl;
        int n2 = xowd_page_itm.Id();
        DateAdp dateAdp = xowd_page_itm.Modified_on();
        if (dateAdp.compareTo(this.modified_latest) == 1) {
            this.modified_latest = dateAdp;
        }
        boolean bl = (xoa_ttl = this.redirect_mgr.Extract_redirect(byArray = xowd_page_itm.Text(), n = xowd_page_itm.Text_len())) != null;
        xowd_page_itm.Redirected_(bl);
        Xow_ns xow_ns = xowd_page_itm.Ns();
        int n3 = xow_ns.Count() + 1;
        xow_ns.Count_(n3);
        if (this.dg_match_mgr != null && this.dg_match_mgr.Match(1, n2, xow_ns.Id(), xowd_page_itm.Ttl_page_db(), xowd_page_itm.Ttl_full_db(), this.wiki.Lang(), byArray)) {
            return;
        }
        byte[] byArray2 = this.text_zip_mgr.Zip(this.text_zip_tid, byArray);
        Xow_db_file xow_db_file = this.ns_to_db_mgr.Get_by_ns(xow_ns.Bldr_data(), byArray2.length);
        try {
            this.db_mgr.Create_page(this.page_core_tbl, xow_db_file.Tbl__text(), n2, xowd_page_itm.Ns_id(), xowd_page_itm.Ttl_page_db(), bl, dateAdp, byArray2, n, n3, xow_db_file.Id(), -1);
        }
        catch (Exception exception) {
            throw Err_.new_exc(exception, "bldr", "create page in db failed; skipping page", "id", n2, "ns", xowd_page_itm.Ns_id(), "name", xowd_page_itm.Ttl_page_db(), "redirect", bl, "modified", dateAdp, "text_len", n, "text_db_id", xow_db_file.Id());
        }
        if (bl && this.redirect_id_enabled) {
            this.redirect_tbl.Insert(n2, xowd_page_itm.Ttl_page_db(), xoa_ttl);
        }
        ++this.page_count_all;
        if (xow_ns.Id_is_main() && !xowd_page_itm.Redirected()) {
            ++this.page_count_main;
        }
        if (this.page_count_all % this.commit_interval == 0) {
            this.page_core_tbl.Conn().Txn_sav();
            xow_db_file.Conn().Txn_sav();
            if (this.redirect_id_enabled) {
                this.redirect_tbl.Conn().Txn_sav();
            }
            if (this.dg_match_mgr != null) {
                this.dg_match_mgr.Commit();
            }
        }
    }

    @Override
    public void Page_wkr__run_cleanup() {
        this.usr_dlg.Log_many("", "", "import.page: insert done; committing pages; pages=~{0}", this.page_count_all);
        this.ns_to_db_mgr.Rls_all();
        this.page_core_tbl.Insert_end();
    }

    @Override
    public void Page_wkr__end() {
        if (this.dg_match_mgr != null) {
            this.dg_match_mgr.Rls();
        }
        this.usr_dlg.Log_many("", "", "import.page: updating core stats", new Object[0]);
        Xow_ns_mgr xow_ns_mgr = this.wiki.Ns_mgr();
        Xow_db_file xow_db_file = this.db_mgr.Db__core();
        xow_db_file.Tbl__site_stats().Update(this.page_count_main, this.page_count_all, xow_ns_mgr.Ns_file().Count());
        xow_db_file.Tbl__ns().Insert(xow_ns_mgr);
        if (this.idx_mode.Tid_is_end()) {
            this.page_core_tbl.Create_idx();
        }
        if (this.redirect_id_enabled) {
            this.redirect_tbl.Conn().Txn_end();
            this.redirect_tbl.Update_trg_redirect_id(xow_db_file.Url(), 1);
            this.redirect_tbl.Update_src_redirect_id(xow_db_file.Url(), this.page_core_tbl.Conn());
        }
    }

    @Override
    public Object Invk(GfsCtx gfsCtx, int n, String string, GfoMsg gfoMsg) {
        if (gfsCtx.Match(string, Invk_commit_interval_)) {
            this.commit_interval = gfoMsg.ReadInt("v");
        } else if (gfsCtx.Match(string, Invk_idx_mode_)) {
            this.idx_mode = Db_idx_mode.Xto_itm(gfoMsg.ReadStr("v"));
        } else if (gfsCtx.Match(string, Invk_redirect_id_enabled_)) {
            this.redirect_id_enabled = gfoMsg.ReadYn("v");
        } else {
            return super.Invk(gfsCtx, n, string, gfoMsg);
        }
        return this;
    }
}

