/*
 * Decompiled with CFR 0.152.
 */
package gplx.xowa.bldrs;

import gplx.Decimal_adp_;
import gplx.Err_;
import gplx.GfoMsg;
import gplx.Gfo_invk;
import gplx.Gfo_invk_;
import gplx.Gfo_usr_dlg;
import gplx.GfsCtx;
import gplx.String_;
import gplx.Time_span_;
import gplx.core.consoles.Console_adp__sys;
import gplx.core.envs.Env_;
import gplx.core.envs.System_;
import gplx.core.ios.Io_size_;
import gplx.core.threads.Thread_adp_;
import gplx.langs.jsons.Json_ary;
import gplx.langs.jsons.Json_doc;
import gplx.langs.jsons.Json_kv;
import gplx.langs.jsons.Json_nde;
import gplx.langs.jsons.Json_parser;
import gplx.xowa.Xoa_app_;
import gplx.xowa.Xoae_app;
import gplx.xowa.Xowe_wiki;
import gplx.xowa.addons.bldrs.app_cfgs.Xob_wiki_cfg_bldr;
import gplx.xowa.bldrs.Xob_cmd_mgr;
import gplx.xowa.bldrs.Xob_cmd_regy;
import gplx.xowa.bldrs.wkrs.Xob_cmd;
import gplx.xowa.bldrs.xmls.Xob_import_marker;
import gplx.xowa.bldrs.xmls.Xob_xml_parser;

public class Xob_bldr
implements Gfo_invk {
    private boolean pause_at_end = false;
    private long prv_prog_time;
    private Xob_xml_parser dump_parser;
    private final Xoae_app app;
    private final Xob_cmd_regy cmd_regy = new Xob_cmd_regy();
    private final Xob_cmd_mgr cmd_mgr;
    private int sort_mem_len = 0x1000000;
    private int dump_fil_len = 0x100000;
    private int make_fil_len = 65536;
    private Xob_import_marker import_marker;
    private Xob_wiki_cfg_bldr wiki_cfg_bldr;
    private static final String Invk_cmds = "cmds";
    private static final String Invk_wiki_cfg_bldr = "wiki_cfg_bldr";
    private static final String Invk_pause_at_end_ = "pause_at_end_";
    private static final String Invk_sort_mem_len_ = "sort_mem_len_";
    private static final String Invk_dump_fil_len_ = "dump_fil_len_";
    private static final String Invk_make_fil_len_ = "make_fil_len_";
    private static final String Invk_cancel = "cancel";
    private static final String Invk_run_by_kit = "run_by_kit";
    public static final String Invk_run = "run";

    public Xob_bldr(Xoae_app xoae_app) {
        this.app = xoae_app;
        this.cmd_mgr = new Xob_cmd_mgr(this, this.cmd_regy);
        this.import_marker = new Xob_import_marker();
        this.wiki_cfg_bldr = new Xob_wiki_cfg_bldr(this);
    }

    public Xoae_app App() {
        return this.app;
    }

    public Xob_cmd_regy Cmd_regy() {
        return this.cmd_regy;
    }

    public Xob_cmd_mgr Cmd_mgr() {
        return this.cmd_mgr;
    }

    public Gfo_usr_dlg Usr_dlg() {
        return this.app.Usr_dlg();
    }

    public int Sort_mem_len() {
        return this.sort_mem_len;
    }

    public Xob_bldr Sort_mem_len_(int n) {
        this.sort_mem_len = n;
        return this;
    }

    public int Dump_fil_len() {
        return this.dump_fil_len;
    }

    public Xob_bldr Dump_fil_len_(int n) {
        this.dump_fil_len = n;
        return this;
    }

    public int Make_fil_len() {
        return this.make_fil_len;
    }

    public Xob_bldr Make_fil_len_(int n) {
        this.make_fil_len = n;
        return this;
    }

    public Xob_xml_parser Dump_parser() {
        if (this.dump_parser == null) {
            this.dump_parser = new Xob_xml_parser();
        }
        return this.dump_parser;
    }

    public Xob_import_marker Import_marker() {
        return this.import_marker;
    }

    public Xob_wiki_cfg_bldr Wiki_cfg_bldr() {
        return this.wiki_cfg_bldr;
    }

    public void Pause_at_end_(boolean bl) {
        this.pause_at_end = bl;
    }

    public void Print_prog_msg(long l, long l2, int n, String string, Object ... objectArray) {
        long l3 = System_.Ticks();
        if (l3 - this.prv_prog_time < 100L) {
            return;
        }
        this.prv_prog_time = l3;
        if (n > -1) {
            objectArray[n] = Decimal_adp_.CalcPctStr(l, l2, "00.00");
        }
        this.app.Usr_dlg().Prog_many("", "", string, objectArray);
    }

    public Xob_bldr Exec_json(String string) {
        try {
            this.cmd_mgr.Clear();
            Json_parser json_parser = new Json_parser();
            Json_doc json_doc = json_parser.Parse(string);
            Json_ary json_ary = json_doc.Root_ary();
            int n = json_ary.Len();
            for (int i = 0; i < n; ++i) {
                Json_nde json_nde = json_ary.Get_at_as_nde(i);
                byte[] byArray = json_nde.Get_bry_or_null("key");
                Xob_cmd xob_cmd = this.cmd_regy.Get_or_null(String_.new_u8(byArray));
                if (xob_cmd == null) {
                    throw Err_.new_("bldr", "bldr.cmd does not exists: cmd={0}", new Object[]{byArray});
                }
                byte[] byArray2 = json_nde.Get_bry_or_null("wiki");
                Xowe_wiki xowe_wiki = byArray2 == null ? this.app.Usere().Wiki() : this.app.Wiki_mgr().Get_by_or_make(byArray2);
                Xob_cmd xob_cmd2 = xob_cmd.Cmd_clone(this, xowe_wiki);
                int n2 = json_nde.Len();
                for (int j = 0; j < n2; ++j) {
                    Json_kv json_kv = json_nde.Get_at_as_kv(j);
                    String string2 = json_kv.Key_as_str();
                    if (String_.Eq(string2, "key") || String_.Eq(string2, "wiki")) continue;
                    byte[] byArray3 = json_kv.Val_as_bry();
                    Gfo_invk_.Invk_by_val(xob_cmd2, string2 + "_", String_.new_u8(byArray3));
                }
                this.cmd_mgr.Add(xob_cmd2);
            }
            Thread_adp_.Start_by_key("bldr_by_json", this, Invk_run_by_kit);
        }
        catch (Exception exception) {
            this.app.Gui_mgr().Kit().Ask_ok("", "", "error: ~{0}", Err_.Message_gplx_log(exception));
        }
        return this;
    }

    private void Run_by_kit() {
        try {
            this.Run();
        }
        catch (Exception exception) {
            String string = Err_.Message_gplx_log(exception);
            Xoa_app_.Usr_dlg().Log_many("", "", string, new Object[0]);
            this.app.Gui_mgr().Kit().Ask_ok("", "", "error: ~{0}", Err_.Message_gplx_full(exception));
        }
    }

    public void Run() {
        try {
            Xob_cmd xob_cmd;
            int n;
            this.app.Bldr__running_(true);
            this.app.Launch();
            long l = System_.Ticks();
            int n2 = this.cmd_mgr.Len();
            for (n = 0; n < n2; ++n) {
                xob_cmd = this.cmd_mgr.Get_at(n);
                xob_cmd.Cmd_init(this);
            }
            n2 = this.cmd_mgr.Len();
            for (n = 0; n < n2; ++n) {
                xob_cmd = this.cmd_mgr.Get_at(n);
                this.app.Usr_dlg().Note_many("", "", "cmd bgn: ~{0}", xob_cmd.Cmd_key());
                long l2 = System_.Ticks();
                try {
                    xob_cmd.Cmd_bgn(this);
                    xob_cmd.Cmd_run();
                    xob_cmd.Cmd_end();
                }
                catch (Exception exception) {
                    throw Err_.new_exc(exception, "bldr", "unknown error", "key", xob_cmd.Cmd_key());
                }
                System_.Garbage_collect();
                this.app.Usr_dlg().Note_many("", "", "cmd end: ~{0} ~{1}", xob_cmd.Cmd_key(), Time_span_.from_(l2).XtoStrUiAbbrv());
            }
            for (n = 0; n < n2; ++n) {
                xob_cmd = this.cmd_mgr.Get_at(n);
                xob_cmd.Cmd_term();
            }
            this.app.Usr_dlg().Note_many("", "", "bldr done: ~{0}", Time_span_.from_(l).XtoStrUiAbbrv());
            this.cmd_mgr.Clear();
            if (this.pause_at_end && !Env_.Mode_testing()) {
                Console_adp__sys.Instance.Read_line("press enter to continue");
            }
        }
        catch (Exception exception) {
            this.app.Bldr__running_(false);
            throw Err_.new_exc(exception, "bldr", "unknown error", new Object[0]);
        }
    }

    private void Cancel() {
        int n = this.cmd_mgr.Len();
        for (int i = 0; i < n; ++i) {
            Xob_cmd xob_cmd = this.cmd_mgr.Get_at(i);
            xob_cmd.Cmd_end();
        }
    }

    @Override
    public Object Invk(GfsCtx gfsCtx, int n, String string, GfoMsg gfoMsg) {
        if (gfsCtx.Match(string, Invk_pause_at_end_)) {
            this.pause_at_end = gfoMsg.ReadBoolOrTrue("val");
        } else {
            if (gfsCtx.Match(string, Invk_cmds)) {
                return this.cmd_mgr;
            }
            if (gfsCtx.Match(string, Invk_wiki_cfg_bldr)) {
                return this.wiki_cfg_bldr;
            }
            if (gfsCtx.Match(string, Invk_sort_mem_len_)) {
                this.sort_mem_len = Io_size_.Load_int_(gfoMsg);
            } else if (gfsCtx.Match(string, Invk_dump_fil_len_)) {
                this.dump_fil_len = Io_size_.Load_int_(gfoMsg);
            } else if (gfsCtx.Match(string, Invk_make_fil_len_)) {
                this.make_fil_len = Io_size_.Load_int_(gfoMsg);
            } else if (gfsCtx.Match(string, Invk_run)) {
                this.Run();
            } else if (gfsCtx.Match(string, Invk_run_by_kit)) {
                this.Run_by_kit();
            } else if (gfsCtx.Match(string, Invk_cancel)) {
                this.Cancel();
            } else {
                return Gfo_invk_.Rv_unhandled;
            }
        }
        return this;
    }
}

